/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment.cache;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.metadata.segment.cache.DatasourceSegmentCache;

public interface SegmentMetadataCache {
    public void start();

    public void stop();

    public void becomeLeader();

    public void stopBeingLeader();

    public boolean isEnabled();

    public boolean isSyncedForRead();

    public void awaitNextSync(long var1);

    public DataSourcesSnapshot getDataSourcesSnapshot();

    public <T> T readCacheForDataSource(String var1, Action<T> var2);

    public <T> T writeCacheForDataSource(String var1, Action<T> var2);

    public static enum UsageMode {
        ALWAYS("always"),
        NEVER("never"),
        IF_SYNCED("ifSynced");

        private final String name;

        private UsageMode(String name) {
            this.name = name;
        }

        @JsonCreator
        public static UsageMode fromString(String value) {
            for (UsageMode mode : UsageMode.values()) {
                if (!mode.toString().equals(value)) continue;
                return mode;
            }
            throw InvalidInput.exception((String)"No such cache usage mode[%s]", (Object[])new Object[]{value});
        }

        public String toString() {
            return this.name;
        }
    }

    @FunctionalInterface
    public static interface Action<T> {
        public T perform(DatasourceSegmentCache var1) throws Exception;
    }
}

