/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="WorkerRpcFailed")
public class WorkerRpcFailedFault
extends BaseMSQFault {
    public static final String CODE = "WorkerRpcFailed";
    private final String workerTaskId;
    private final String errorMsg;

    @JsonCreator
    public WorkerRpcFailedFault(@JsonProperty(value="workerTaskId") String workerTaskId, @JsonProperty(value="errorMsg") @Nullable String errorMsg) {
        super(CODE, "RPC to worker[%s] failed%s", workerTaskId, errorMsg != null ? ": " + errorMsg : "");
        this.workerTaskId = workerTaskId;
        this.errorMsg = errorMsg;
    }

    @JsonProperty
    public String getWorkerTaskId() {
        return this.workerTaskId;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WorkerRpcFailedFault that = (WorkerRpcFailedFault)o;
        return Objects.equals(this.workerTaskId, that.workerTaskId) && Objects.equals(this.errorMsg, that.errorMsg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.workerTaskId, this.errorMsg);
    }
}

