/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.app.WebApplication;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageOutcome;
import org.apache.empire.jsf2.utils.HtmlUtils;
import org.apache.empire.jsf2.utils.ParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacesUtils {
    private static final Logger log = LoggerFactory.getLogger(FacesUtils.class);
    public static final String SKIP_INPUT_VALIDATION_PARAM = "empire.jsf.input.skipValidation";
    public static final String PARAMETER_MAP_ATTRIBUTE = "PARAMETER_MAP";
    public static final String PARAMETER_MAP_CLASS_ATTRIBUTE = "PARAMETER_MAP_CLASS";
    public static final String PAGE_RESOURCE_MAP_ATTRIBUTE = "pageResources";

    public static boolean isDevelopmentStage(FacesContext fc) {
        return fc.getApplication().getProjectStage() == ProjectStage.Development;
    }

    public static WebApplication getWebApplication() {
        return WebApplication.getInstance();
    }

    public static FacesImplementation getFacesImplementation() {
        return FacesUtils.getWebApplication().getFacesImplementation();
    }

    public static FacesContext getContext() {
        return FacesContext.getCurrentInstance();
    }

    public static Locale getContextLocale(FacesContext fc) {
        return FacesUtils.getWebApplication().getContextLocale(fc);
    }

    public static Map<String, Object> getSessionMap(FacesContext fc) {
        return fc.getExternalContext().getSessionMap();
    }

    public static HttpServletRequest getHttpRequest(FacesContext fc) {
        return (HttpServletRequest)fc.getExternalContext().getRequest();
    }

    public static String getRequestUri(FacesContext context) {
        Object req;
        ExternalContext ec = context.getExternalContext();
        Object object = req = ec != null ? ec.getRequest() : null;
        if (req instanceof HttpServletRequest) {
            HttpServletRequest hr = (HttpServletRequest)req;
            return hr.getRequestURI();
        }
        return "{No HttpServletRequest}";
    }

    public static String getRequestUserAgent(FacesContext context) {
        Object req;
        ExternalContext ec = context.getExternalContext();
        Object object = req = ec != null ? ec.getRequest() : null;
        if (req instanceof HttpServletRequest) {
            String agent = ((HttpServletRequest)req).getHeader("user-agent");
            return agent;
        }
        return "{No HttpServletRequest}";
    }

    public static Object getRequestAttribute(String key) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getRequestAttribute(fc, key);
    }

    public static Object getRequestAttribute(FacesContext fc, String key) {
        return FacesUtils.getHttpRequest(fc).getAttribute(key);
    }

    public static <T> T getRequestAttribute(FacesContext fc, String key, Class<T> clazz) {
        Object requestValue = FacesUtils.getRequestAttribute(fc, key);
        return (T)(requestValue != null ? ObjectUtils.convert(clazz, (Object)requestValue) : null);
    }

    public static void setRequestAttribute(String key, Object value) {
        FacesContext fc = FacesUtils.getContext();
        FacesUtils.setRequestAttribute(fc, key, value);
    }

    public static void setRequestAttribute(FacesContext fc, String key, Object value) {
        if (value != null) {
            FacesUtils.getHttpRequest(fc).setAttribute(key, value);
        } else {
            FacesUtils.getHttpRequest(fc).removeAttribute(key);
        }
    }

    public static String getRequestParam(FacesContext context, String param) {
        return (String)context.getExternalContext().getRequestParameterMap().get(param);
    }

    public static String getRequestParam(String key) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getRequestParam(fc, key);
    }

    public static boolean isSkipInputValidation(FacesContext fc) {
        String val = FacesUtils.getRequestParam(fc, SKIP_INPUT_VALIDATION_PARAM);
        return val != null && ObjectUtils.getBoolean((Object)val);
    }

    public static boolean isSkipInputValidation() {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.isSkipInputValidation(fc);
    }

    public static <T> T getComponentAttribute(UIComponent component, String name, Class<T> clazz) {
        Object item = component.getAttributes().get(name);
        return (T)ObjectUtils.convert(clazz, item);
    }

    public static <T> T getActionEventAttribute(ActionEvent ae, String name, Class<T> clazz) {
        return FacesUtils.getComponentAttribute(ae.getComponent(), name, clazz);
    }

    public static void redirectDirectly(FacesContext fc, PageOutcome outcome) {
        FacesUtils.getWebApplication().redirectDirectly(fc, outcome.toString());
    }

    public static void redirectDirectly(FacesContext fc, PageDefinition page) {
        FacesUtils.redirectDirectly(fc, page.getOutcome());
    }

    public static <T extends Page> T getPage(FacesContext fc) {
        UIViewRoot vr = fc.getViewRoot();
        if (vr == null) {
            throw new ItemNotFoundException((Object)"ViewRoot");
        }
        Page page = (Page)vr.getViewMap().get("page");
        if (page == null) {
            throw new ItemNotFoundException((Object)"page");
        }
        return (T)page;
    }

    public static void setParameterMapClass(FacesContext fc, Class<? extends ParameterMap> clazz) {
        Map am = fc.getExternalContext().getApplicationMap();
        am.put(PARAMETER_MAP_CLASS_ATTRIBUTE, clazz);
    }

    public static ParameterMap getParameterMap(FacesContext fc) {
        Map sm = fc.getExternalContext().getSessionMap();
        ParameterMap pm = (ParameterMap)sm.get(PARAMETER_MAP_ATTRIBUTE);
        if (pm == null) {
            try {
                Map am = fc.getExternalContext().getApplicationMap();
                Object pmClass = am.get(PARAMETER_MAP_CLASS_ATTRIBUTE);
                pm = pmClass instanceof Class ? (ParameterMap)((Class)pmClass).newInstance() : (pmClass instanceof String ? (ParameterMap)Class.forName((String)pmClass).newInstance() : new ParameterMap());
            }
            catch (ClassNotFoundException e) {
                throw new InternalException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new InternalException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InternalException((Throwable)e);
            }
            sm.put(PARAMETER_MAP_ATTRIBUTE, pm);
        }
        return pm;
    }

    public static ParameterMap getParameterMap() {
        return FacesUtils.getParameterMap(FacesUtils.getContext());
    }

    public static Map<String, Object> getPageResourceMap(FacesContext fc) {
        Map sm = fc.getExternalContext().getSessionMap();
        HashMap rm = (HashMap)sm.get(PAGE_RESOURCE_MAP_ATTRIBUTE);
        if (rm == null) {
            rm = new HashMap();
            sm.put(PAGE_RESOURCE_MAP_ATTRIBUTE, rm);
        }
        return rm;
    }

    public static Map<String, Object> getPageResourceMap() {
        return FacesUtils.getPageResourceMap(FacesUtils.getContext());
    }

    public static Object getManagedBean(FacesContext fc, String name) {
        if (fc == null) {
            throw new NullPointerException("context must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        return FacesUtils.getWebApplication().getFacesImplementation().getManagedBean(name, fc);
    }

    public static <T> T getManagedBean(FacesContext fc, Class<T> cls, String name) {
        Object bean = FacesUtils.getManagedBean(fc, name);
        if (bean == null) {
            log.warn("Managed Bean {} ist not available.", (Object)name);
            throw new ItemNotFoundException((Object)name);
        }
        return (T)bean;
    }

    public static <T> T getManagedBean(FacesContext fc, Class<T> cls) {
        String name = cls.getName();
        int i = name.lastIndexOf(46) + 1;
        name = name.substring(i, i + 1).toLowerCase() + name.substring(i + 1);
        return FacesUtils.getManagedBean(fc, cls, name);
    }

    public static <T> T getManagedBean(Class<T> cls) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getManagedBean(fc, cls);
    }

    public static String getRealPath(FacesContext fc, String path) {
        return ((ServletContext)fc.getExternalContext().getContext()).getRealPath(path);
    }

    public static String getFilePath(FacesContext fc, String path, String file) {
        String realPath = FacesUtils.getRealPath(fc, path);
        return realPath.endsWith(File.separator) ? realPath + file : realPath + File.separator + file;
    }

    public static TextResolver getTextResolver(FacesContext fc) {
        return FacesUtils.getWebApplication().getTextResolver(fc);
    }

    public static String resolveText(FacesContext fc, String text) {
        return FacesUtils.getTextResolver(fc).resolveText(text);
    }

    public static String resolveText(String text) {
        return FacesUtils.getTextResolver(FacesUtils.getContext()).resolveText(text);
    }

    public static String getMessage(FacesContext fc, String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new InvalidArgumentException("key", (Object)key);
        }
        TextResolver tr = FacesUtils.getTextResolver(fc);
        return key.startsWith("!") ? tr.resolveText(key) : tr.resolveKey(key);
    }

    public static String getMessage(String messageKey) {
        return FacesUtils.getMessage(FacesUtils.getContext(), messageKey);
    }

    public static String formatMessage(FacesContext fc, String msgKey, Object ... params) {
        String pattern = FacesUtils.getMessage(fc, msgKey);
        return MessageFormat.format(pattern, params);
    }

    public static String formatMessage(String msgKey, Object ... params) {
        return FacesUtils.formatMessage(FacesUtils.getContext(), msgKey, params);
    }

    public static String escapeHtml(String text) {
        return HtmlUtils.getInstance().escapeText(text);
    }

    public static void addFacesMessage(FacesContext fc, UIComponent comp, FacesMessage facesMsg) {
        if (facesMsg == null) {
            return;
        }
        String clientId = comp != null ? comp.getClientId() : null;
        fc.addMessage(clientId, facesMsg);
    }

    public static void addFacesMessage(UIComponent comp, FacesMessage.Severity severity, String message, Object ... params) {
        FacesContext fc = FacesUtils.getContext();
        FacesUtils.addFacesMessage(fc, comp, FacesUtils.getWebApplication().getFacesMessage(fc, severity, message, params));
    }

    public static void addInfoMessage(String msg, Object ... params) {
        FacesUtils.addFacesMessage(null, FacesMessage.SEVERITY_INFO, msg, params);
    }

    public static void addWarnMessage(String msg, Object ... params) {
        FacesUtils.addFacesMessage(null, FacesMessage.SEVERITY_WARN, msg, params);
    }

    public static void addErrorMessage(String msg, Object ... params) {
        FacesUtils.addFacesMessage(null, FacesMessage.SEVERITY_ERROR, msg, params);
    }

    public static void addErrorMessage(UIComponent comp, Throwable t) {
        FacesContext fc = FacesUtils.getContext();
        FacesUtils.addFacesMessage(fc, comp, FacesUtils.getFacesErrorMessage(fc, t));
    }

    public static void addErrorMessage(Throwable t) {
        FacesUtils.addErrorMessage(null, t);
    }

    public static FacesMessage getFacesErrorMessage(FacesContext fc, Throwable t) {
        return FacesUtils.getWebApplication().getFacesErrorMessage(fc, null, t);
    }

    public static void redirectFromError(Page page, FacesMessage errorMsg) {
        PageOutcome pageTarget = page.getPageDefinition().getOutcome();
        FacesContext fc = FacesUtils.getContext();
        boolean committed = fc.getExternalContext().isResponseCommitted();
        if (committed) {
            log.warn("Cannot redirect to {} from an already committed response! Error is {}.", (Object)pageTarget, (Object)errorMsg.getSummary());
            return;
        }
        if (errorMsg != null) {
            ExternalContext ec = fc.getExternalContext();
            ec.getSessionMap().put("PAGE_SESSION_MESSAGE", errorMsg);
        }
        FacesUtils.redirectDirectly(fc, pageTarget);
    }

    public static void redirectFromError(Page page, Throwable t) {
        FacesContext fc = FacesUtils.getContext();
        FacesMessage facesMsg = FacesUtils.getFacesErrorMessage(fc, t);
        FacesUtils.redirectFromError(page, facesMsg);
    }

    public static UIInput findInputComponent(UIComponent parent, Column column) {
        Iterator children = parent.getFacetsAndChildren();
        while (children.hasNext()) {
            UIComponent nextChild = (UIComponent)children.next();
            log.info("Checking child {}", (Object)nextChild.getClass().getName());
            if (nextChild instanceof UIInput) {
                Object col = nextChild.getAttributes().get("column");
                if (col == null) {
                    ValueExpression ve = nextChild.getValueExpression("column");
                    if (ve == null) continue;
                    log.warn("TODO: evaluate Value Expression!");
                    continue;
                }
                if (!column.equals(col)) continue;
                return (UIInput)nextChild;
            }
            UIInput input = FacesUtils.findInputComponent(nextChild, column);
            if (input == null) continue;
            return input;
        }
        return null;
    }

    public static UIInput findInputComponent(FacesContext fc, String formId, Column column) {
        UIViewRoot parent = fc.getViewRoot();
        if (StringUtils.isNotEmpty((String)formId) && (parent = WebApplication.findChildComponent((UIComponent)parent, formId)) == null) {
            return null;
        }
        return FacesUtils.findInputComponent((UIComponent)parent, column);
    }
}

