/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.journalentry.data.ChargePaymentDTO;
import org.apache.fineract.accounting.journalentry.data.GLAccountBalanceHolder;
import org.apache.fineract.accounting.journalentry.data.LoanDTO;
import org.apache.fineract.accounting.journalentry.data.LoanTransactionDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForLoan;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorHelper;
import org.apache.fineract.accounting.journalentry.service.JournalAmountHolder;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionEnumData;
import org.springframework.stereotype.Component;

@Component
public class CashBasedAccountingProcessorForLoan
implements AccountingProcessorForLoan {
    private final AccountingProcessorHelper helper;
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;

    public void createJournalEntriesForLoan(LoanDTO loanDTO) {
        Long officeId = loanDTO.getOfficeId();
        GLClosure latestGLClosure = this.helper.getLatestClosureByBranch(officeId.longValue());
        Long loanProductId = loanDTO.getLoanProductId();
        String currencyCode = loanDTO.getCurrencyCode();
        Office office = this.helper.getOfficeById(officeId.longValue());
        for (LoanTransactionDTO loanTransactionDTO : loanDTO.getNewLoanTransactions()) {
            LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
            String transactionId = loanTransactionDTO.getTransactionId();
            Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
            Long loanId = loanDTO.getLoanId();
            LoanTransactionEnumData transactionType = loanTransactionDTO.getTransactionType();
            this.helper.checkForBranchClosures(latestGLClosure, transactionDate);
            if (loanTransactionDTO.isReversed()) {
                this.journalEntryWritePlatformService.createJournalEntryForReversedLoanTransaction(transactionDate, transactionId, officeId);
                continue;
            }
            if (transactionType.isDisbursement()) {
                this.createJournalEntriesForDisbursements(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isRepaymentType() && !transactionType.isChargeAdjustment() || transactionType.isRepaymentAtDisbursement() || transactionType.isChargePayment()) {
                this.createJournalEntriesForRepayments(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isRecoveryRepayment()) {
                this.createJournalEntriesForRecoveryRepayments(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isRefund()) {
                this.createJournalEntriesForRefund(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isCreditBalanceRefund()) {
                this.createJournalEntriesForCreditBalanceRefund(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isWriteOff()) {
                BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
                if (principalAmount == null || principalAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOSSES_WRITTEN_OFF.getValue(), AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalAmount);
                continue;
            }
            if (transactionType.isInitiateTransfer() || transactionType.isApproveTransfer() || transactionType.isWithdrawTransfer()) {
                this.createJournalEntriesForTransfers(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isRefundForActiveLoans()) {
                this.createJournalEntriesForRefundForActiveLoan(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isChargeback()) {
                this.createJournalEntriesForChargeback(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (transactionType.isChargeAdjustment()) {
                this.createJournalEntriesForChargeAdjustment(loanDTO, loanTransactionDTO, office);
                continue;
            }
            if (!transactionType.isChargeoff()) continue;
            this.createJournalEntriesForChargeOff(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForChargeOff(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            if (isMarkedFraud) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), glAccountBalanceHolder);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), glAccountBalanceHolder);
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), glAccountBalanceHolder);
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), glAccountBalanceHolder);
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
        }
    }

    private void populateCreditDebitMaps(Long loanProductId, BigDecimal transactionPartAmount, Long paymentTypeId, Integer creditAccountType, Integer debitAccountType, GLAccountBalanceHolder glAccountBalanceHolder) {
        GLAccount accountCredit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, creditAccountType.intValue(), paymentTypeId);
        glAccountBalanceHolder.addToCredit(accountCredit, transactionPartAmount);
        GLAccount accountDebit = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, debitAccountType.intValue(), paymentTypeId);
        glAccountBalanceHolder.addToDebit(accountDebit, transactionPartAmount);
    }

    private Integer returnExistingDebitAccountInMapMatchingGLAccount(Long loanProductId, Long paymentTypeId, Integer accountType, Map<Integer, BigDecimal> accountMap) {
        GLAccount glAccount = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, accountType.intValue(), paymentTypeId);
        Integer accountEntry = accountMap.entrySet().stream().filter(account -> this.helper.getLinkedGLAccountForLoanProduct(loanProductId, ((Integer)account.getKey()).intValue(), paymentTypeId).getGlCode().equals(glAccount.getGlCode())).map(Map.Entry::getKey).findFirst().orElse(accountType);
        return accountEntry;
    }

    private void createJournalEntriesForChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedAsChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedAsChargeOff) {
            this.createJournalEntriesForChargeOffLoanChargeAdjustment(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanChargeAdjustment(loanDTO, loanTransactionDTO, office);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJournalEntriesForChargeOffLoanChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<GLAccount, BigDecimal> accountMap = new LinkedHashMap<GLAccount, BigDecimal>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), (GLAccount)entry.getKey());
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0) {
            void var18_29;
            Long chargeId = loanTransactionDTO.getLoanChargeData().getChargeId();
            if (loanTransactionDTO.getLoanChargeData().isPenalty()) {
                Integer n = AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue();
            } else {
                Integer n = AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue();
            }
            this.helper.createDebitJournalEntryForLoanCharges(office, currencyCode, var18_29.intValue(), loanProductId, chargeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJournalEntriesForLoanChargeAdjustment(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount account;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap<GLAccount, BigDecimal> accountMap = new LinkedHashMap<GLAccount, BigDecimal>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), paymentTypeId);
            accountMap.put(account, principalAmount);
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(interestAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, interestAmount);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(feesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, feesAmount);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(penaltiesAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, penaltiesAmount);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            account = this.helper.getLinkedGLAccountForLoanProduct(loanProductId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue().intValue(), paymentTypeId);
            if (accountMap.containsKey(account)) {
                BigDecimal bigDecimal = ((BigDecimal)accountMap.get(account)).add(overPaymentAmount);
                accountMap.put(account, bigDecimal);
            } else {
                accountMap.put(account, overPaymentAmount);
            }
        }
        for (Map.Entry entry : accountMap.entrySet()) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)entry.getValue(), (GLAccount)entry.getKey());
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0) {
            void var18_29;
            Long chargeId = loanTransactionDTO.getLoanChargeData().getChargeId();
            if (loanTransactionDTO.getLoanChargeData().isPenalty()) {
                Integer n = AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue();
            } else {
                Integer n = AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue();
            }
            this.helper.createDebitJournalEntryForLoanCharges(office, currencyCode, var18_29.intValue(), loanProductId, chargeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    private void createJournalEntriesForChargeback(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
    }

    private void createJournalEntriesForDisbursements(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal overpaymentPortion = loanTransactionDTO.getOverPayment() != null ? loanTransactionDTO.getOverPayment() : BigDecimal.ZERO;
        BigDecimal principalPortion = loanTransactionDTO.getAmount().subtract(overpaymentPortion);
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (MathUtil.isGreaterThanZero((BigDecimal)principalPortion)) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalPortion);
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)overpaymentPortion)) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overpaymentPortion);
        }
        if (loanTransactionDTO.isLoanToLoanTransfer()) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount());
        } else if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount());
        } else {
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, loanTransactionDTO.getAmount());
        }
    }

    private void createJournalEntriesForRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal refundAmount = loanTransactionDTO.getAmount();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, refundAmount);
        } else {
            this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, refundAmount);
        }
    }

    private void createJournalEntriesForRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        boolean isMarkedChargeOff = loanDTO.isMarkedAsChargeOff();
        if (isMarkedChargeOff) {
            this.createJournalEntriesForChargeOffLoanRepayments(loanDTO, loanTransactionDTO, office);
        } else {
            this.createJournalEntriesForLoanRepayments(loanDTO, loanTransactionDTO, office);
        }
    }

    private void createJournalEntriesForChargeOffLoanRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        GLAccount glAccount;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        boolean isMarkedFraud = loanDTO.isMarkedAsFraud();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        GLAccountBalanceHolder glAccountBalanceHolder = new GLAccountBalanceHolder();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                if (isMarkedFraud) {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                } else {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                }
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                if (isMarkedFraud) {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_FRAUD_EXPENSE.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                } else {
                    this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.CHARGE_OFF_EXPENSE.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
                }
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, principalAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_INTEREST.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, interestAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_FEES.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, feesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_CHARGE_OFF_PENALTY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isRepayment()) {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, penaltiesAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            if (loanTransactionDTO.getTransactionType().isMerchantIssuedRefund()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isPayoutRefund()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue(), glAccountBalanceHolder);
            } else {
                this.populateCreditDebitMaps(loanProductId, overPaymentAmount, paymentTypeId, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), glAccountBalanceHolder);
            }
        }
        for (Map.Entry creditEntry : glAccountBalanceHolder.getCreditBalances().entrySet()) {
            glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(creditEntry.getKey());
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)creditEntry.getValue(), glAccount);
        }
        if (loanTransactionDTO.isLoanToLoanTransfer()) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        } else if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        } else {
            for (Map.Entry debitEntry : glAccountBalanceHolder.getDebitBalances().entrySet()) {
                glAccount = (GLAccount)glAccountBalanceHolder.getGlAccountMap().get(debitEntry.getKey());
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue(), glAccount);
            }
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0 && loanTransactionDTO.getTransactionType().isChargeRefund()) {
            Integer incomeAccount = this.helper.getValueForFeeOrPenaltyIncomeAccount(loanTransactionDTO.getChargeRefundChargeType());
            this.helper.createJournalEntriesForLoan(office, currencyCode, incomeAccount, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    private void createJournalEntriesForLoanRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        LinkedHashMap debitAccountMapForGoodwillCredit = new LinkedHashMap();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalAmount);
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, principalAmount, AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount);
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, interestAmount, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_INTEREST.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            this.helper.createCreditJournalEntryForLoanCharges(office, currencyCode, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, loanTransactionDTO.getFeePayments());
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, feesAmount, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_FEES.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            this.helper.createCreditJournalEntryForLoanCharges(office, currencyCode, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, loanTransactionDTO.getPenaltyPayments());
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, penaltiesAmount, AccountingConstants.CashAccountsForLoan.INCOME_FROM_GOODWILL_CREDIT_PENALTY.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT, loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overPaymentAmount);
            if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
                this.populateDebitAccountEntry(loanProductId, overPaymentAmount, AccountingConstants.CashAccountsForLoan.GOODWILL_CREDIT.getValue(), debitAccountMapForGoodwillCredit, paymentTypeId);
            }
        }
        if (loanTransactionDTO.isLoanToLoanTransfer()) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.ASSET_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        } else if (loanTransactionDTO.isAccountTransfer()) {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.FinancialActivity.LIABILITY_TRANSFER.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        } else if (loanTransactionDTO.getTransactionType().isGoodwillCredit()) {
            for (Map.Entry debitEntry : debitAccountMapForGoodwillCredit.entrySet()) {
                this.helper.createDebitJournalEntryForLoan(office, currencyCode, ((Integer)debitEntry.getKey()).intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, (BigDecimal)debitEntry.getValue());
            }
        } else {
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
        if (totalDebitAmount.compareTo(BigDecimal.ZERO) > 0 && loanTransactionDTO.getTransactionType().isChargeRefund()) {
            Integer incomeAccount = this.helper.getValueForFeeOrPenaltyIncomeAccount(loanTransactionDTO.getChargeRefundChargeType());
            this.helper.createJournalEntriesForLoan(office, currencyCode, incomeAccount, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
        }
    }

    private void populateDebitAccountEntry(Long loanProductId, BigDecimal transactionPartAmount, Integer debitAccountType, Map<Integer, BigDecimal> accountMapForDebit, Long paymentTypeId) {
        Integer accountDebit = this.returnExistingDebitAccountInMapMatchingGLAccount(loanProductId, paymentTypeId, debitAccountType, accountMapForDebit);
        if (accountMapForDebit.containsKey(accountDebit)) {
            BigDecimal amount = accountMapForDebit.get(accountDebit).add(transactionPartAmount);
            accountMapForDebit.put(accountDebit, amount);
        } else {
            accountMapForDebit.put(accountDebit, transactionPartAmount);
        }
    }

    private void createJournalEntriesForRecoveryRepayments(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal amount = loanTransactionDTO.getAmount();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), AccountingConstants.CashAccountsForLoan.INCOME_FROM_RECOVERY.getValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, amount);
    }

    private void createJournalEntriesForTransfers(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        if (loanTransactionDTO.getTransactionType().isInitiateTransfer()) {
            this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.TRANSFERS_SUSPENSE.getValue(), AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), loanProductId, null, loanId, transactionId, transactionDate, principalAmount);
        } else if (loanTransactionDTO.getTransactionType().isApproveTransfer() || loanTransactionDTO.getTransactionType().isWithdrawTransfer()) {
            this.helper.createJournalEntriesForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), AccountingConstants.CashAccountsForLoan.TRANSFERS_SUSPENSE.getValue(), loanProductId, null, loanId, transactionId, transactionDate, principalAmount);
        }
    }

    private void createJournalEntriesForCreditBalanceRefund(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal overpaymentAmount = loanTransactionDTO.getOverPayment();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList<JournalAmountHolder> journalAmountHolders = new ArrayList<JournalAmountHolder>();
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalAmount = totalAmount.add(principalAmount);
            journalAmountHolders.add(new JournalAmountHolder(AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue(), principalAmount));
        }
        if (overpaymentAmount != null && overpaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalAmount = totalAmount.add(overpaymentAmount);
            journalAmountHolders.add(new JournalAmountHolder(AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue(), overpaymentAmount));
        }
        JournalAmountHolder totalAmountHolder = new JournalAmountHolder(AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue(), totalAmount);
        this.helper.createSplitJournalEntriesForLoan(office, currencyCode, journalAmountHolders, totalAmountHolder, loanProductId, paymentTypeId, loanId, transactionId, transactionDate);
    }

    private void createJournalEntriesForRefundForActiveLoan(LoanDTO loanDTO, LoanTransactionDTO loanTransactionDTO, Office office) {
        ArrayList<ChargePaymentDTO> chargePaymentDTOs;
        Long loanProductId = loanDTO.getLoanProductId();
        Long loanId = loanDTO.getLoanId();
        String currencyCode = loanDTO.getCurrencyCode();
        String transactionId = loanTransactionDTO.getTransactionId();
        LocalDate transactionDate = loanTransactionDTO.getTransactionDate();
        BigDecimal principalAmount = loanTransactionDTO.getPrincipal();
        BigDecimal interestAmount = loanTransactionDTO.getInterest();
        BigDecimal feesAmount = loanTransactionDTO.getFees();
        BigDecimal penaltiesAmount = loanTransactionDTO.getPenalties();
        BigDecimal overPaymentAmount = loanTransactionDTO.getOverPayment();
        Long paymentTypeId = loanTransactionDTO.getPaymentTypeId();
        BigDecimal totalDebitAmount = new BigDecimal(0);
        if (principalAmount != null && principalAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(principalAmount);
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.LOAN_PORTFOLIO.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, principalAmount);
        }
        if (interestAmount != null && interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(interestAmount);
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.INTEREST_ON_LOANS.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, interestAmount);
        }
        if (feesAmount != null && feesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(feesAmount);
            chargePaymentDTOs = new ArrayList<ChargePaymentDTO>();
            for (ChargePaymentDTO chargePaymentDTO : loanTransactionDTO.getFeePayments()) {
                chargePaymentDTOs.add(new ChargePaymentDTO(chargePaymentDTO.getChargeId(), chargePaymentDTO.getAmount().floatValue() < 0.0f ? chargePaymentDTO.getAmount().multiply(new BigDecimal(-1)) : chargePaymentDTO.getAmount(), chargePaymentDTO.getLoanChargeId()));
            }
            this.helper.createDebitJournalEntryForLoanCharges(office, currencyCode, AccountingConstants.CashAccountsForLoan.INCOME_FROM_FEES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, feesAmount, chargePaymentDTOs);
        }
        if (penaltiesAmount != null && penaltiesAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(penaltiesAmount);
            chargePaymentDTOs = new ArrayList();
            for (ChargePaymentDTO chargePaymentDTO : loanTransactionDTO.getPenaltyPayments()) {
                chargePaymentDTOs.add(new ChargePaymentDTO(chargePaymentDTO.getChargeId(), chargePaymentDTO.getAmount().floatValue() < 0.0f ? chargePaymentDTO.getAmount().multiply(new BigDecimal(-1)) : chargePaymentDTO.getAmount(), chargePaymentDTO.getLoanChargeId()));
            }
            this.helper.createDebitJournalEntryForLoanCharges(office, currencyCode, AccountingConstants.CashAccountsForLoan.INCOME_FROM_PENALTIES.getValue().intValue(), loanProductId, loanId, transactionId, transactionDate, penaltiesAmount, chargePaymentDTOs);
        }
        if (overPaymentAmount != null && overPaymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            totalDebitAmount = totalDebitAmount.add(overPaymentAmount);
            this.helper.createDebitJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.OVERPAYMENT.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, overPaymentAmount);
        }
        this.helper.createCreditJournalEntryForLoan(office, currencyCode, AccountingConstants.CashAccountsForLoan.FUND_SOURCE.getValue().intValue(), loanProductId, paymentTypeId, loanId, transactionId, transactionDate, totalDebitAmount);
    }

    @Generated
    public CashBasedAccountingProcessorForLoan(AccountingProcessorHelper helper, JournalEntryWritePlatformService journalEntryWritePlatformService) {
        this.helper = helper;
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
    }
}

