/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ClientSheetPopulator
extends AbstractWorkbookPopulator {
    private List<ClientData> allClients;
    private List<OfficeData> officesDataList;
    private Map<String, ArrayList<String>> officeToClients;
    private Map<Integer, Integer[]> officeNameToBeginEndIndexesOfClients;
    private Map<String, Long> clientNameToClientId;
    private Map<String, Long> clientNameToSavingsAccountIds;
    private static final int OFFICE_NAME_COL = 0;
    private static final int CLIENT_NAME_COL = 1;
    private static final int CLIENT_ID_COL = 2;

    public ClientSheetPopulator(List<ClientData> clients, List<OfficeData> Offices) {
        this.allClients = clients;
        this.officesDataList = Offices;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet clientSheet = workbook.createSheet("Clients");
        this.setLayout(clientSheet);
        this.setOfficeToClientsMap();
        this.setClientNameToClientIdMap();
        this.populateClientsByOfficeName(clientSheet);
        clientSheet.protectSheet("");
        this.setClientNameToSavingsAccountsIdsMap();
    }

    private void setClientNameToClientIdMap() {
        this.clientNameToClientId = new HashMap();
        for (ClientData clientData : this.allClients) {
            this.clientNameToClientId.put(clientData.getDisplayName().trim() + "(" + clientData.getId() + ")", clientData.getId());
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 6000);
        for (int colIndex = 1; colIndex <= 10; ++colIndex) {
            worksheet.setColumnWidth(colIndex, 6000);
        }
        this.writeString(0, rowHeader, "Office Names");
        this.writeString(1, rowHeader, "Client Names");
        this.writeString(2, rowHeader, "Client ID");
    }

    private void setOfficeToClientsMap() {
        this.officeToClients = new HashMap();
        for (ClientData person : this.allClients) {
            this.addToOfficeClientMap(person.getOfficeName().trim().replaceAll("[ )(]", "_"), person.getDisplayName().trim() + "(" + person.getId() + ")");
        }
    }

    private void setClientNameToSavingsAccountsIdsMap() {
        this.clientNameToSavingsAccountIds = new HashMap();
        for (ClientData client : this.allClients) {
            this.clientNameToSavingsAccountIds.put(client.getDisplayName().trim() + "(" + client.getId() + ")", client.getSavingsAccountId());
        }
    }

    private void addToOfficeClientMap(String key, String value) {
        ArrayList<String> values = (ArrayList<String>)this.officeToClients.get(key);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.officeToClients.put(key, values);
    }

    private void populateClientsByOfficeName(Sheet clientSheet) {
        int rowIndex = 1;
        int startIndex = 1;
        int officeIndex = 0;
        this.officeNameToBeginEndIndexesOfClients = new HashMap();
        Row row = clientSheet.createRow(rowIndex);
        for (OfficeData office : this.officesDataList) {
            startIndex = rowIndex + 1;
            this.writeString(0, row, office.getName());
            ArrayList clientList = new ArrayList();
            if (this.officeToClients.containsKey(office.getName().trim().replaceAll("[ )(]", "_"))) {
                clientList = (ArrayList)this.officeToClients.get(office.getName().trim().replaceAll("[ )(]", "_"));
            }
            if (!clientList.isEmpty()) {
                for (String clientName : clientList) {
                    this.writeString(1, row, clientName);
                    this.writeLong(2, row, ((Long)this.clientNameToClientId.get(clientName)).longValue());
                    row = clientSheet.createRow(++rowIndex);
                }
                this.officeNameToBeginEndIndexesOfClients.put(officeIndex++, new Integer[]{startIndex, rowIndex});
                continue;
            }
            ++officeIndex;
        }
    }

    public List<ClientData> getClients() {
        return this.allClients;
    }

    public Integer getClientsSize() {
        return this.allClients.size();
    }

    public Map<Integer, Integer[]> getOfficeNameToBeginEndIndexesOfClients() {
        return this.officeNameToBeginEndIndexesOfClients;
    }

    public Map<String, Long> getClientNameToSavingsAccountIds() {
        return this.clientNameToSavingsAccountIds;
    }
}

