/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_entity_datatable_check")
public class EntityDatatableChecks
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="application_table_name", nullable=false)
    private String entity;
    @Column(name="x_registered_table_name", nullable=false)
    private String datatableName;
    @Column(name="status_enum", nullable=false)
    private Integer status;
    @Column(name="system_defined")
    private boolean systemDefined;
    @Column(name="product_id", nullable=true)
    private Long productId;
    static final long serialVersionUID = -7810897805576355130L;

    public static EntityDatatableChecks fromJson(JsonCommand command) {
        String entity = command.stringValueOfParameterNamed("entity");
        Integer status = command.integerValueSansLocaleOfParameterNamed("status");
        String datatableName = command.stringValueOfParameterNamed("datatableName");
        boolean systemDefined = command.booleanPrimitiveValueOfParameterNamed("systemDefined");
        Long productId = null;
        if (command.parameterExists("productId")) {
            productId = command.longValueOfParameterNamed("productId");
        }
        return new EntityDatatableChecks(entity, datatableName, status, systemDefined, productId);
    }

    public boolean isSystemDefined() {
        return this._persistence_get_systemDefined();
    }

    @Generated
    public EntityDatatableChecks(String entity, String datatableName, Integer status, boolean systemDefined, Long productId) {
        this.systemDefined = false;
        this.entity = entity;
        this.datatableName = datatableName;
        this.status = status;
        this.systemDefined = systemDefined;
        this.productId = productId;
    }

    @Generated
    public EntityDatatableChecks() {
        this.systemDefined = false;
    }

    @Generated
    public String getEntity() {
        return this._persistence_get_entity();
    }

    @Generated
    public String getDatatableName() {
        return this._persistence_get_datatableName();
    }

    @Generated
    public Integer getStatus() {
        return this._persistence_get_status();
    }

    @Generated
    public Long getProductId() {
        return this._persistence_get_productId();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityDatatableChecks(persistenceObject);
    }

    public EntityDatatableChecks(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "productId") {
            return this.productId;
        }
        if (string == "datatableName") {
            return this.datatableName;
        }
        if (string == "systemDefined") {
            return this.systemDefined;
        }
        if (string == "entity") {
            return this.entity;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "productId") {
            this.productId = (Long)object;
            return;
        }
        if (string == "datatableName") {
            this.datatableName = (String)object;
            return;
        }
        if (string == "systemDefined") {
            this.systemDefined = (Boolean)object;
            return;
        }
        if (string == "entity") {
            this.entity = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Long _persistence_get_productId() {
        this._persistence_checkFetched("productId");
        return this.productId;
    }

    public void _persistence_set_productId(Long l) {
        this._persistence_checkFetchedForSet("productId");
        this._persistence_propertyChange("productId", (Object)this.productId, (Object)l);
        this.productId = l;
    }

    public String _persistence_get_datatableName() {
        this._persistence_checkFetched("datatableName");
        return this.datatableName;
    }

    public void _persistence_set_datatableName(String string) {
        this._persistence_checkFetchedForSet("datatableName");
        this._persistence_propertyChange("datatableName", (Object)this.datatableName, (Object)string);
        this.datatableName = string;
    }

    public boolean _persistence_get_systemDefined() {
        this._persistence_checkFetched("systemDefined");
        return this.systemDefined;
    }

    public void _persistence_set_systemDefined(boolean bl) {
        this._persistence_checkFetchedForSet("systemDefined");
        this._persistence_propertyChange("systemDefined", (Object)new Boolean(this.systemDefined), (Object)new Boolean(bl));
        this.systemDefined = bl;
    }

    public String _persistence_get_entity() {
        this._persistence_checkFetched("entity");
        return this.entity;
    }

    public void _persistence_set_entity(String string) {
        this._persistence_checkFetchedForSet("entity");
        this._persistence_propertyChange("entity", (Object)this.entity, (Object)string);
        this.entity = string;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", (Object)this.status, (Object)n);
        this.status = n;
    }
}

