/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.config;

import java.util.HashMap;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
@ConditionalOnProperty(value={"fineract.events.external.producer.kafka.enabled"}, havingValue="true")
public class ExternalEventKafkaConfiguration {
    @Autowired
    private FineractProperties fineractProperties;

    @Bean
    public ProducerFactory<Long, byte[]> externalEventsProducerFactory() {
        FineractProperties.FineractExternalEventsProducerKafkaProperties kafkaProp = this.fineractProperties.getEvents().getExternal().getProducer().getKafka();
        HashMap<String, Object> props = new HashMap<String, Object>(kafkaProp.getProducer().getExtraPropertiesMap());
        props.put("bootstrap.servers", kafkaProp.getBootstrapServers());
        props.put("key.serializer", LongSerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        return new DefaultKafkaProducerFactory(props);
    }

    @Bean
    public KafkaTemplate<Long, byte[]> externalEventsKafkaTemplate(ProducerFactory<Long, byte[]> externalEventsProducerFactory) {
        return new KafkaTemplate(externalEventsProducerFactory);
    }
}

