/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.processor;

import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.hooks.domain.Hook;
import org.apache.fineract.infrastructure.hooks.domain.HookConfiguration;
import org.apache.fineract.infrastructure.hooks.processor.HookProcessor;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.scheduler.SmsMessageScheduledJobService;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.template.domain.Template;
import org.apache.fineract.template.domain.TemplateRepository;
import org.apache.fineract.template.service.TemplateMergeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MessageGatewayHookProcessor
implements HookProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageGatewayHookProcessor.class);
    private final ClientRepositoryWrapper clientRepository;
    private final TemplateRepository templateRepository;
    private final TemplateMergeService templateMergeService;
    private final SmsMessageRepository smsMessageRepository;
    private final SmsMessageScheduledJobService smsMessageScheduledJobService;

    public void process(Hook hook, String payload, String entityName, String actionName, FineractContext context) throws IOException {
        Set config = hook.getConfig();
        Integer SMSProviderId = null;
        for (HookConfiguration conf : config) {
            String fieldName = conf.getFieldName();
            if (!fieldName.equals("SMS Provider Id")) continue;
            SMSProviderId = Integer.parseInt(conf.getFieldValue());
        }
        String templateName = entityName + "_" + actionName;
        List templates = this.templateRepository.findByTemplateMapper("SMS_template_Key", templateName);
        Template template = templates.isEmpty() ? hook.getUgdTemplate() : (Template)templates.get(0);
        if (template == null) {
            log.error("Error : {} with name {}", (Object)"Template not found", (Object)templateName);
            throw new GeneralPlatformDomainRuleException("error.msg.templates.not.found", "Template not found", new Object[]{templateName});
        }
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        Map reqMap = (Map)new Gson().fromJson(payload, type);
        if (reqMap.get("clientId") != null) {
            Long clientId = (Long)reqMap.get("clientId");
            Client client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            reqMap.put("clientName", client.getDisplayName());
            String smsText = this.templateMergeService.compile(template, reqMap);
            SmsMessage smsMessage = SmsMessage.pendingSms(null, null, (Client)client, null, (String)smsText, (String)client.mobileNo(), null, (boolean)false);
            this.smsMessageRepository.save((Object)smsMessage);
            this.smsMessageScheduledJobService.sendTriggeredMessage(Collections.singleton(smsMessage), (long)SMSProviderId.intValue());
        }
    }

    @Generated
    public MessageGatewayHookProcessor(ClientRepositoryWrapper clientRepository, TemplateRepository templateRepository, TemplateMergeService templateMergeService, SmsMessageRepository smsMessageRepository, SmsMessageScheduledJobService smsMessageScheduledJobService) {
        this.clientRepository = clientRepository;
        this.templateRepository = templateRepository;
        this.templateMergeService = templateMergeService;
        this.smsMessageRepository = smsMessageRepository;
        this.smsMessageScheduledJobService = smsMessageScheduledJobService;
    }
}

