/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.service;

import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.apache.fineract.infrastructure.security.exception.EscapeSqlLiteralException;
import org.apache.fineract.infrastructure.security.service.SqlInjectionPreventerService;
import org.postgresql.core.Utils;
import org.springframework.stereotype.Service;

@Service
public class SqlInjectionPreventerServiceImpl
implements SqlInjectionPreventerService {
    private final DatabaseTypeResolver databaseTypeResolver;

    public SqlInjectionPreventerServiceImpl(DatabaseTypeResolver databaseTypeResolver) {
        this.databaseTypeResolver = databaseTypeResolver;
    }

    public String encodeSql(String literal) {
        if (literal == null) {
            return "NULL";
        }
        if (this.databaseTypeResolver.isMySQL()) {
            return this.escapeMySQLLiteral(literal);
        }
        if (this.databaseTypeResolver.isPostgreSQL()) {
            try {
                return Utils.escapeLiteral(null, (String)literal, (boolean)true).toString();
            }
            catch (SQLException e) {
                throw new EscapeSqlLiteralException("Failed to escape SQL literal", e);
            }
        }
        return literal;
    }

    private String escapeMySQLLiteral(String literal) {
        StringBuilder escaped = new StringBuilder(literal.length() * 2);
        block10: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (c) {
                case '\u0000': {
                    escaped.append("\\0");
                    continue block10;
                }
                case '\'': {
                    escaped.append("\\'");
                    continue block10;
                }
                case '\"': {
                    escaped.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block10;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block10;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block10;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block10;
                }
                case '\u001a': {
                    escaped.append("\\Z");
                    continue block10;
                }
                default: {
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    public String quoteIdentifier(String identifier, Set<String> allowedValues) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            throw new IllegalArgumentException("Identifier cannot be null or empty");
        }
        if (allowedValues != null && !allowedValues.contains(identifier.toLowerCase())) {
            throw new IllegalArgumentException("Identifier not in whitelist: " + identifier);
        }
        return this.quoteIdentifier(identifier);
    }

    public String quoteIdentifier(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            throw new IllegalArgumentException("Identifier cannot be null or empty");
        }
        if (!identifier.matches("^[a-zA-Z_][a-zA-Z0-9_]*$")) {
            throw new IllegalArgumentException("Invalid identifier format: " + identifier);
        }
        if (this.databaseTypeResolver.isMySQL()) {
            return "`" + identifier.replace("`", "``") + "`";
        }
        if (this.databaseTypeResolver.isPostgreSQL()) {
            return "\"" + identifier.replace("\"", "\"\"") + "\"";
        }
        return identifier;
    }
}

