/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.mapper;

import org.apache.fineract.infrastructure.documentmanagement.domain.Image;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.mapper.ClientMapper;
import org.springframework.stereotype.Component;

@Component
public class ClientMapperImpl
implements ClientMapper {
    public ClientData map(Client source) {
        if (source == null) {
            return null;
        }
        ClientData clientData = new ClientData();
        clientData.setAccountNo(source.getAccountNumber());
        clientData.setStatus(this.clientStatusEnum(source));
        clientData.setSubStatus(this.clientSubStatusCode(source));
        clientData.setOfficeId(this.sourceOfficeId(source));
        clientData.setOfficeName(this.sourceOfficeName(source));
        clientData.setTransferToOfficeId(this.sourceTransferToOfficeId(source));
        clientData.setTransferToOfficeName(this.sourceTransferToOfficeName(source));
        clientData.setExternalId(source.getExternalId());
        clientData.setGender(this.clientGenderCode(source));
        clientData.setImageId(this.sourceImageId(source));
        clientData.setStaffId(this.sourceStaffId(source));
        clientData.setStaffName(this.sourceStaffDisplayName(source));
        clientData.setTimeline(this.clientTimelineData(source));
        clientData.setSavingsProductId(source.getSavingsProductId());
        if (source.getId() != null) {
            clientData.setSavingsProductName(String.valueOf(source.getId()));
        }
        clientData.setSavingsAccountId(source.getSavingsAccountId());
        clientData.setClientType(this.clientTypeCode(source));
        clientData.setClientClassification(this.clientClassificationCode(source));
        clientData.setLegalForm(this.clientLegalFormEnum(source));
        clientData.setIsStaff(this.clientIsStaff(source));
        clientData.setId((Long)source.getId());
        clientData.setActive(Boolean.valueOf(source.isActive()));
        clientData.setActivationDate(source.getActivationDate());
        clientData.setFirstname(source.getFirstname());
        clientData.setMiddlename(source.getMiddlename());
        clientData.setLastname(source.getLastname());
        clientData.setFullname(source.getFullname());
        clientData.setDisplayName(source.getDisplayName());
        clientData.setMobileNo(source.getMobileNo());
        clientData.setEmailAddress(source.getEmailAddress());
        clientData.setDateOfBirth(source.getDateOfBirth());
        clientData.setSubmittedOnDate(source.getSubmittedOnDate());
        return clientData;
    }

    private Long sourceOfficeId(Client client) {
        Office office = client.getOffice();
        if (office == null) {
            return null;
        }
        return (Long)office.getId();
    }

    private String sourceOfficeName(Client client) {
        Office office = client.getOffice();
        if (office == null) {
            return null;
        }
        return office.getName();
    }

    private Long sourceTransferToOfficeId(Client client) {
        Office transferToOffice = client.getTransferToOffice();
        if (transferToOffice == null) {
            return null;
        }
        return (Long)transferToOffice.getId();
    }

    private String sourceTransferToOfficeName(Client client) {
        Office transferToOffice = client.getTransferToOffice();
        if (transferToOffice == null) {
            return null;
        }
        return transferToOffice.getName();
    }

    private Long sourceImageId(Client client) {
        Image image = client.getImage();
        if (image == null) {
            return null;
        }
        return (Long)image.getId();
    }

    private Long sourceStaffId(Client client) {
        Staff staff = client.getStaff();
        if (staff == null) {
            return null;
        }
        return (Long)staff.getId();
    }

    private String sourceStaffDisplayName(Client client) {
        Staff staff = client.getStaff();
        if (staff == null) {
            return null;
        }
        return staff.getDisplayName();
    }
}

