/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.data.ClientChargeData;
import org.apache.fineract.portfolio.client.exception.ClientChargeNotFoundException;
import org.apache.fineract.portfolio.client.service.ClientChargeReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientChargeReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ClientChargeReadPlatformServiceImpl
implements ClientChargeReadPlatformService {
    private final PaginationHelper paginationHelper;
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PlatformSecurityContext context;
    private final ClientChargeMapper clientChargeMapper = new ClientChargeMapper();

    public ClientChargeData retrieveClientCharge(Long clientId, Long clientChargeId) {
        try {
            this.context.authenticatedUser();
            ClientChargeMapper rm = new ClientChargeMapper();
            String sql = "select " + rm.schema() + " where cc.client_id=? and cc.id=? ";
            return (ClientChargeData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{clientId, clientChargeId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new ClientChargeNotFoundException(clientChargeId, clientId, e);
        }
    }

    public Page<ClientChargeData> retrieveClientCharges(Long clientId, String status, Boolean pendingPayment, SearchParameters searchParameters) {
        ClientChargeMapper rm = new ClientChargeMapper();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ").append(rm.schema()).append(" where cc.client_id=? ");
        if (status.equalsIgnoreCase("active")) {
            sqlBuilder.append(" and cc.is_active = true ");
        } else if (status.equalsIgnoreCase("inactive")) {
            sqlBuilder.append(" and cc.is_active = false ");
        }
        if (BooleanUtils.isTrue((Boolean)pendingPayment)) {
            sqlBuilder.append(" and ( cc.is_paid_derived = false and cc.waived = false) ");
        } else if (BooleanUtils.isFalse((Boolean)pendingPayment)) {
            sqlBuilder.append(" and (cc.is_paid_derived = true or cc.waived = true) ");
        }
        sqlBuilder.append(" order by cc.charge_time_enum ASC, cc.charge_due_date DESC, cc.is_penalty ASC ");
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), new Object[]{clientId}, (RowMapper)this.clientChargeMapper);
    }

    @Generated
    public ClientChargeReadPlatformServiceImpl(PaginationHelper paginationHelper, JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, PlatformSecurityContext context) {
        this.paginationHelper = paginationHelper;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.context = context;
    }
}

