/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.data.ClientFamilyMembersData;
import org.apache.fineract.portfolio.client.service.ClientFamilyMembersReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientFamilyMembersReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ClientFamilyMembersReadPlatformServiceImpl
implements ClientFamilyMembersReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final CodeValueReadPlatformService codeValueReadPlatformService;

    @Autowired
    public ClientFamilyMembersReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, CodeValueReadPlatformService codeValueReadPlatformService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
    }

    public List<ClientFamilyMembersData> getClientFamilyMembers(long clientId) {
        this.context.authenticatedUser();
        ClientFamilyMembersMapper rm = new ClientFamilyMembersMapper();
        String sql = "select " + rm.schema() + " where fmb.client_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientId});
    }

    public ClientFamilyMembersData getClientFamilyMember(long id) {
        this.context.authenticatedUser();
        ClientFamilyMembersMapper rm = new ClientFamilyMembersMapper();
        String sql = "select " + rm.schema() + " where fmb.id=? ";
        return (ClientFamilyMembersData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{id});
    }

    public ClientFamilyMembersData retrieveTemplate() {
        ArrayList maritalStatusOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("MARITAL STATUS"));
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList relationshipOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("RELATIONSHIP"));
        ArrayList professionOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("PROFESSION"));
        return ClientFamilyMembersData.builder().relationshipIdOptions(relationshipOptions).genderIdOptions(genderOptions).maritalStatusIdOptions(maritalStatusOptions).professionIdOptions(professionOptions).build();
    }
}

