/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.collateralmanagement.api.ClientCollateralManagementApiResourceSwagger;
import org.apache.fineract.portfolio.collateralmanagement.api.CollateralManagementJsonInputParams;
import org.apache.fineract.portfolio.collateralmanagement.data.ClientCollateralManagementData;
import org.apache.fineract.portfolio.collateralmanagement.data.ClientCollateralRequest;
import org.apache.fineract.portfolio.collateralmanagement.data.LoanCollateralTemplateData;
import org.apache.fineract.portfolio.collateralmanagement.data.UpdateClientCollateralRequest;
import org.apache.fineract.portfolio.collateralmanagement.service.ClientCollateralManagementReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/clients/{clientId}/collaterals")
@Component
@Tag(name="Client Collateral Management", description="Client Collateral Management is for managing collateral operations")
public class ClientCollateralManagementApiResource {
    private final DefaultToApiJsonSerializer<ClientCollateralManagementData> apiJsonSerializerDataService;
    private final DefaultToApiJsonSerializer<LoanCollateralTemplateData> apiJsonSerializerForLoanCollateralTemplateService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;
    private final ClientCollateralManagementReadPlatformService clientCollateralManagementReadPlatformService;

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Get Clients Collateral Products", description="Get Collateral Product of a Client")
    public List<ClientCollateralManagementData> getClientCollateral(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Context UriInfo uriInfo, @QueryParam(value="prodId") @Parameter(description="prodId") Long prodId) {
        this.context.authenticatedUser().validateHasReadPermission(CollateralManagementJsonInputParams.CLIENT_COLLATERAL_PRODUCT_READ_PERMISSION.getValue());
        return this.clientCollateralManagementReadPlatformService.getClientCollaterals(clientId, prodId);
    }

    @GET
    @Path(value="{clientCollateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Get Client Collateral Data", description="Get Client Collateral Data")
    public ClientCollateralManagementData getClientCollateralData(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="clientCollateralId") @Parameter(description="clientCollateralId") Long collateralId) {
        this.context.authenticatedUser().validateHasReadPermission(CollateralManagementJsonInputParams.CLIENT_COLLATERAL_PRODUCT_READ_PERMISSION.getValue());
        return this.clientCollateralManagementReadPlatformService.getClientCollateralManagementData(collateralId);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Client Collateral Template", description="Get Client Collateral Template")
    public List<LoanCollateralTemplateData> getClientCollateralTemplate(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        return this.clientCollateralManagementReadPlatformService.getLoanCollateralTemplate(clientId);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Add New Collateral For a Client", description="Add New Collateral For a Client")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientCollateralRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.PostClientCollateralResponse.class))})})
    public CommandProcessingResult addCollateral(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Parameter(hidden=true) ClientCollateralRequest clientCollateralRequest) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().addClientCollateralProduct(clientId).withJson(this.apiJsonSerializerDataService.serialize((Object)clientCollateralRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @PUT
    @Path(value="{collateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Update New Collateral of a Client", description="Update New Collateral of a Client")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=UpdateClientCollateralRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.PutClientCollateralResponse.class))})})
    public CommandProcessingResult updateCollateral(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId, @Parameter(hidden=true) UpdateClientCollateralRequest updateClientCollateralRequest) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().updateClientCollateralProduct(clientId, collateralId).withJson(this.apiJsonSerializerDataService.serialize((Object)updateClientCollateralRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @DELETE
    @Path(value="{collateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Delete Client Collateral", description="Delete Client Collateral")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientCollateralManagementApiResourceSwagger.DeleteClientCollateralResponse.class))})})
    public CommandProcessingResult deleteCollateral(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().deleteClientCollateralProduct(collateralId, clientId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
    }

    @Generated
    public ClientCollateralManagementApiResource(DefaultToApiJsonSerializer<ClientCollateralManagementData> apiJsonSerializerDataService, DefaultToApiJsonSerializer<LoanCollateralTemplateData> apiJsonSerializerForLoanCollateralTemplateService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context, ClientCollateralManagementReadPlatformService clientCollateralManagementReadPlatformService) {
        this.apiJsonSerializerDataService = apiJsonSerializerDataService;
        this.apiJsonSerializerForLoanCollateralTemplateService = apiJsonSerializerForLoanCollateralTemplateService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
        this.clientCollateralManagementReadPlatformService = clientCollateralManagementReadPlatformService;
    }
}

