/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.interestratechart.service;

import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartDataValidator;
import org.apache.fineract.portfolio.interestratechart.domain.InterestRateChart;
import org.apache.fineract.portfolio.interestratechart.domain.InterestRateChartRepositoryWrapper;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartAssembler;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartWritePlatformService;
import org.springframework.transaction.annotation.Transactional;

public class InterestRateChartWritePlatformServiceJpaRepositoryImpl
implements InterestRateChartWritePlatformService {
    private final PlatformSecurityContext context;
    private final InterestRateChartDataValidator interestRateChartDataValidator;
    private final InterestRateChartAssembler interestRateChartAssembler;
    private final InterestRateChartRepositoryWrapper interestRateChartRepository;

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        this.interestRateChartDataValidator.validateForCreate(command.json());
        InterestRateChart interestRateChart = this.interestRateChartAssembler.assembleFrom(command);
        this.interestRateChartRepository.saveAndFlush(interestRateChart);
        Long interestRateChartId = (Long)interestRateChart.getId();
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(interestRateChartId).build();
    }

    @Transactional
    public CommandProcessingResult update(Long interestRateChartId, JsonCommand command) {
        this.interestRateChartDataValidator.validateUpdate(command.json());
        LinkedHashMap changes = new LinkedHashMap(20);
        InterestRateChart interestRateChart = this.interestRateChartAssembler.assembleFrom(interestRateChartId);
        interestRateChart.update(command, changes);
        this.interestRateChartRepository.saveAndFlush(interestRateChart);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(interestRateChartId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult deleteChart(Long chartId) {
        InterestRateChart chart = this.interestRateChartRepository.findOneWithNotFoundDetection(chartId);
        this.interestRateChartRepository.delete(chart);
        return new CommandProcessingResultBuilder().withEntityId(chartId).build();
    }

    @Generated
    public InterestRateChartWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, InterestRateChartDataValidator interestRateChartDataValidator, InterestRateChartAssembler interestRateChartAssembler, InterestRateChartRepositoryWrapper interestRateChartRepository) {
        this.context = context;
        this.interestRateChartDataValidator = interestRateChartDataValidator;
        this.interestRateChartAssembler = interestRateChartAssembler;
        this.interestRateChartRepository = interestRateChartRepository;
    }
}

