/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.applychargetooverdueloaninstallment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.exception.AbstractPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.OverdueLoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class ApplyChargeToOverdueLoanInstallmentTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplyChargeToOverdueLoanInstallmentTasklet.class);
    private final ConfigurationDomainService configurationDomainService;
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanChargeWritePlatformService loanChargeWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Boolean backdatePenalties;
        Long penaltyWaitPeriodValue = this.configurationDomainService.retrievePenaltyWaitPeriod();
        Collection overdueLoanScheduledInstallments = this.loanReadPlatformService.retrieveAllLoansWithOverdueInstallments(penaltyWaitPeriodValue, backdatePenalties = Boolean.valueOf(this.configurationDomainService.isBackdatePenaltiesEnabled()));
        if (!overdueLoanScheduledInstallments.isEmpty()) {
            HashMap overdueScheduleData = new HashMap();
            for (OverdueLoanScheduleData overdueInstallment : overdueLoanScheduledInstallments) {
                if (overdueScheduleData.containsKey(overdueInstallment.getLoanId())) {
                    ((Collection)overdueScheduleData.get(overdueInstallment.getLoanId())).add(overdueInstallment);
                    continue;
                }
                ArrayList<OverdueLoanScheduleData> loanData = new ArrayList<OverdueLoanScheduleData>();
                loanData.add(overdueInstallment);
                overdueScheduleData.put(overdueInstallment.getLoanId(), loanData);
            }
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (Map.Entry entry : overdueScheduleData.entrySet()) {
                try {
                    if (((Collection)entry.getValue()).isEmpty()) continue;
                    this.loanChargeWritePlatformService.applyOverdueChargesForLoan((Long)entry.getKey(), (Collection)entry.getValue());
                }
                catch (PlatformApiDataValidationException e) {
                    List errors = e.getErrors();
                    for (ApiParameterError error : errors) {
                        log.error("Apply Charges due for overdue loans failed for account {} with message: {}", new Object[]{entry.getKey(), error.getDeveloperMessage(), e});
                    }
                    exceptions.add(e);
                }
                catch (AbstractPlatformDomainRuleException e) {
                    log.error("Apply Charges due for overdue loans failed for account {} with message: {}", new Object[]{entry.getKey(), e.getDefaultUserMessage(), e});
                    exceptions.add(e);
                }
                catch (Exception e) {
                    log.error("Apply Charges due for overdue loans failed for account {}", entry.getKey(), (Object)e);
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                throw new JobExecutionException(exceptions);
            }
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public ApplyChargeToOverdueLoanInstallmentTasklet(ConfigurationDomainService configurationDomainService, LoanReadPlatformService loanReadPlatformService, LoanChargeWritePlatformService loanChargeWritePlatformService) {
        this.configurationDomainService = configurationDomainService;
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanChargeWritePlatformService = loanChargeWritePlatformService;
    }
}

