/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.loanaccount.data.LoanSummaryData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionBalance;
import org.apache.fineract.portfolio.loanaccount.domain.ChangedTransactionDetail;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.AdvancedPaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanSchedulePeriodData;
import org.apache.fineract.portfolio.loanaccount.service.CommonLoanSummaryDataProvider;
import org.apache.fineract.portfolio.loanaccount.service.InterestScheduleModelRepositoryWrapper;
import org.apache.fineract.portfolio.loanproduct.calc.EMICalculator;
import org.apache.fineract.portfolio.loanproduct.calc.data.OutstandingDetails;
import org.apache.fineract.portfolio.loanproduct.calc.data.ProgressiveLoanInterestScheduleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProgressiveLoanSummaryDataProvider
extends CommonLoanSummaryDataProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProgressiveLoanSummaryDataProvider.class);
    private final AdvancedPaymentScheduleTransactionProcessor advancedPaymentScheduleTransactionProcessor;
    private final EMICalculator emiCalculator;
    private final LoanRepositoryWrapper loanRepository;
    private final LoanTransactionRepository loanTransactionRepository;
    private final InterestScheduleModelRepositoryWrapper modelRepository;

    public boolean accept(String loanProcessingStrategyCode) {
        return loanProcessingStrategyCode.equalsIgnoreCase("advanced-payment-allocation-strategy");
    }

    @Transactional(readOnly=true)
    public LoanSummaryData withTransactionAmountsSummary(Long loanId, LoanSummaryData defaultSummaryData, LoanScheduleData repaymentSchedule, Collection<? extends LoanTransactionBalance> loanTransactionBalances) {
        Loan loan = this.loanRepository.findOneWithNotFoundDetection(loanId, true);
        return super.withTransactionAmountsSummary(loan, defaultSummaryData, repaymentSchedule, loanTransactionBalances);
    }

    public LoanSummaryData withTransactionAmountsSummary(Loan loan, LoanSummaryData defaultSummaryData, LoanScheduleData repaymentSchedule, Collection<? extends LoanTransactionBalance> loanTransactionBalances) {
        return super.withTransactionAmountsSummary(loan, defaultSummaryData, repaymentSchedule, loanTransactionBalances);
    }

    private Optional<LoanRepaymentScheduleInstallment> getRelatedRepaymentScheduleInstallment(Loan loan, LocalDate businessDate) {
        return loan.getRepaymentScheduleInstallments().stream().filter(i -> !i.isDownPayment() && !i.isAdditional() && businessDate.isAfter(i.getFromDate()) && !businessDate.isAfter(i.getDueDate())).findFirst();
    }

    private ProgressiveLoanInterestScheduleModel calculateModel(Loan loan, LocalDate businessDate) {
        List<LoanTransaction> transactionsToReprocess = this.loanTransactionRepository.findNonReversedTransactionsForReprocessingByLoan(loan).stream().filter(t -> !t.isAccrualActivity()).toList();
        Pair changedTransactionDetailProgressiveLoanInterestScheduleModelPair = this.advancedPaymentScheduleTransactionProcessor.reprocessProgressiveLoanTransactions(loan.getDisbursementDate(), businessDate, transactionsToReprocess, loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges());
        ProgressiveLoanInterestScheduleModel model = (ProgressiveLoanInterestScheduleModel)changedTransactionDetailProgressiveLoanInterestScheduleModelPair.getRight();
        List<Long> replayedTransactions = ((ChangedTransactionDetail)changedTransactionDetailProgressiveLoanInterestScheduleModelPair.getLeft()).getTransactionChanges().stream().filter(change -> change.getOldTransaction() != null && change.getNewTransaction() != null).map(change -> (Long)change.getNewTransaction().getId()).filter(Objects::nonNull).toList();
        if (!replayedTransactions.isEmpty()) {
            log.warn("Reprocessed transactions show differences: There are unsaved changes of the following transactions: {}", replayedTransactions);
        }
        return model;
    }

    public BigDecimal computeTotalUnpaidPayableNotDueInterestAmountOnActualPeriod(Loan loan, Collection<LoanSchedulePeriodData> periods, LocalDate businessDate, CurrencyData currency, BigDecimal totalUnpaidPayableDueInterest) {
        if (loan.isMatured(businessDate) || !loan.isInterestBearing()) {
            return BigDecimal.ZERO;
        }
        Optional currentRepaymentPeriod = this.getRelatedRepaymentScheduleInstallment(loan, businessDate);
        if (currentRepaymentPeriod.isPresent()) {
            if (loan.isChargedOff() || loan.hasContractTerminationTransaction()) {
                return MathUtil.subtractToZero((BigDecimal)((LoanRepaymentScheduleInstallment)currentRepaymentPeriod.get()).getInterestOutstanding(loan.getCurrency()).getAmount(), (BigDecimal[])new BigDecimal[]{totalUnpaidPayableDueInterest});
            }
            Optional savedModel = this.modelRepository.getSavedModel(loan, businessDate);
            ProgressiveLoanInterestScheduleModel model = savedModel.orElseGet(() -> this.calculateModel(loan, businessDate));
            if (model != null) {
                OutstandingDetails outstandingDetails = this.emiCalculator.getOutstandingAmountsTillDate(model, businessDate);
                if (!loan.isInterestRecalculationEnabled()) {
                    BigDecimal interestPaid = periods.stream().map(LoanSchedulePeriodData::getInterestPaid).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal dueInterest = outstandingDetails.getOutstandingInterest().getAmount();
                    return MathUtil.subtractToZero((BigDecimal)dueInterest, (BigDecimal[])new BigDecimal[]{interestPaid, totalUnpaidPayableDueInterest});
                }
                return MathUtil.subtractToZero((BigDecimal)outstandingDetails.getOutstandingInterest().getAmount(), (BigDecimal[])new BigDecimal[]{totalUnpaidPayableDueInterest});
            }
        }
        return BigDecimal.ZERO;
    }

    @Generated
    public ProgressiveLoanSummaryDataProvider(AdvancedPaymentScheduleTransactionProcessor advancedPaymentScheduleTransactionProcessor, EMICalculator emiCalculator, LoanRepositoryWrapper loanRepository, LoanTransactionRepository loanTransactionRepository, InterestScheduleModelRepositoryWrapper modelRepository) {
        this.advancedPaymentScheduleTransactionProcessor = advancedPaymentScheduleTransactionProcessor;
        this.emiCalculator = emiCalculator;
        this.loanRepository = loanRepository;
        this.loanTransactionRepository = loanTransactionRepository;
        this.modelRepository = modelRepository;
    }
}

