/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.repaymentwithpostdatedchecks.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallmentRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.data.PostDatedChecksData;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.data.PostDatedChecksStatus;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecks;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecksRepository;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.exception.PostDatedCheckNotFoundException;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.service.RepaymentWithPostDatedChecksReadPlatformService;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class RepaymentWithPostDatedChecksReadPlatformServiceImpl
implements RepaymentWithPostDatedChecksReadPlatformService {
    private final PostDatedChecksRepository postDatedChecksRepository;
    private final LoanRepository loanRepository;
    private final LoanRepaymentScheduleInstallmentRepository loanRepaymentScheduleInstallmentRepository;

    public List<PostDatedChecksData> getPostDatedChecks(Long id) {
        Loan loan = (Loan)this.loanRepository.findById((Object)id).orElseThrow(() -> new LoanNotFoundException(id));
        List postDatedChecks = loan.getPostDatedChecks();
        ArrayList<PostDatedChecksData> postDatedChecksDataList = new ArrayList<PostDatedChecksData>();
        for (PostDatedChecks postDatedCheckObject : postDatedChecks) {
            if (PostDatedChecksStatus.POST_DATED_CHECKS_BOUNCED.equals(postDatedCheckObject.getStatus())) continue;
            postDatedChecksDataList.add(PostDatedChecksData.from((LocalDate)postDatedCheckObject.getLoanRepaymentScheduleInstallment().getDueDate(), (Long)((Long)postDatedCheckObject.getId()), (Integer)postDatedCheckObject.getLoanRepaymentScheduleInstallment().getInstallmentNumber(), (Long)postDatedCheckObject.getAccountNo(), (BigDecimal)postDatedCheckObject.getAmount(), (String)postDatedCheckObject.getBankName(), (Long)postDatedCheckObject.getCheckNo(), (Integer)postDatedCheckObject.getStatus()));
        }
        return postDatedChecksDataList;
    }

    public PostDatedChecksData getPostDatedCheck(Long id) {
        PostDatedChecks postDatedChecks = (PostDatedChecks)this.postDatedChecksRepository.findById((Object)id).orElseThrow(() -> new PostDatedCheckNotFoundException(id));
        return PostDatedChecksData.from((LocalDate)postDatedChecks.getLoanRepaymentScheduleInstallment().getDueDate(), (Long)((Long)postDatedChecks.getId()), (Integer)postDatedChecks.getLoanRepaymentScheduleInstallment().getInstallmentNumber(), (Long)postDatedChecks.getAccountNo(), (BigDecimal)postDatedChecks.getAmount(), (String)postDatedChecks.getBankName(), (Long)postDatedChecks.getCheckNo(), (Integer)postDatedChecks.getStatus());
    }

    public PostDatedChecksData getPostDatedCheckByInstallmentId(Integer id, Long loanId) {
        Loan loan = (Loan)this.loanRepository.findById((Object)loanId).orElseThrow(() -> new LoanNotFoundException(loanId));
        List postDatedChecks = loan.getPostDatedChecks();
        if (postDatedChecks == null || postDatedChecks.size() == 0) {
            throw new PostDatedCheckNotFoundException(loanId, id);
        }
        PostDatedChecks postDatedChecksData = (PostDatedChecks)postDatedChecks.stream().filter(postDatedCheck -> postDatedCheck.getLoanRepaymentScheduleInstallment().getInstallmentNumber().equals(id) && !PostDatedChecksStatus.POST_DATED_CHECKS_BOUNCED.equals(postDatedCheck.getStatus())).collect(Collectors.toList()).get(0);
        return PostDatedChecksData.from((LocalDate)postDatedChecksData.getLoanRepaymentScheduleInstallment().getDueDate(), (Long)((Long)postDatedChecksData.getId()), (Integer)postDatedChecksData.getLoanRepaymentScheduleInstallment().getInstallmentNumber(), (Long)postDatedChecksData.getAccountNo(), (BigDecimal)postDatedChecksData.getAmount(), (String)postDatedChecksData.getBankName(), (Long)postDatedChecksData.getCheckNo(), (Integer)postDatedChecksData.getStatus());
    }

    @Generated
    public RepaymentWithPostDatedChecksReadPlatformServiceImpl(PostDatedChecksRepository postDatedChecksRepository, LoanRepository loanRepository, LoanRepaymentScheduleInstallmentRepository loanRepaymentScheduleInstallmentRepository) {
        this.postDatedChecksRepository = postDatedChecksRepository;
        this.loanRepository = loanRepository;
        this.loanRepaymentScheduleInstallmentRepository = loanRepaymentScheduleInstallmentRepository;
    }
}

