/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GuarantorTransactionData;
import org.apache.fineract.client.models.PortfolioAccountData;

/**
 * GuarantorFundingData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GuarantorFundingData {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_AMOUNT_RELEASED = "amountReleased";
  @SerializedName(SERIALIZED_NAME_AMOUNT_RELEASED)
  private BigDecimal amountReleased;

  public static final String SERIALIZED_NAME_AMOUNT_REMAINING = "amountRemaining";
  @SerializedName(SERIALIZED_NAME_AMOUNT_REMAINING)
  private BigDecimal amountRemaining;

  public static final String SERIALIZED_NAME_AMOUNT_TRANSFERED = "amountTransfered";
  @SerializedName(SERIALIZED_NAME_AMOUNT_TRANSFERED)
  private BigDecimal amountTransfered;

  public static final String SERIALIZED_NAME_GUARANTOR_TRANSACTIONS = "guarantorTransactions";
  @SerializedName(SERIALIZED_NAME_GUARANTOR_TRANSACTIONS)
  private List<GuarantorTransactionData> guarantorTransactions;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_SAVINGS_ACCOUNT = "savingsAccount";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACCOUNT)
  private PortfolioAccountData savingsAccount;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private EnumOptionData status;

  public GuarantorFundingData() {
  }

  public GuarantorFundingData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public GuarantorFundingData amountReleased(BigDecimal amountReleased) {
    
    this.amountReleased = amountReleased;
    return this;
  }

  /**
   * Get amountReleased
   * @return amountReleased
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountReleased() {
    return amountReleased;
  }


  public void setAmountReleased(BigDecimal amountReleased) {
    this.amountReleased = amountReleased;
  }

  public GuarantorFundingData amountRemaining(BigDecimal amountRemaining) {
    
    this.amountRemaining = amountRemaining;
    return this;
  }

  /**
   * Get amountRemaining
   * @return amountRemaining
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountRemaining() {
    return amountRemaining;
  }


  public void setAmountRemaining(BigDecimal amountRemaining) {
    this.amountRemaining = amountRemaining;
  }

  public GuarantorFundingData amountTransfered(BigDecimal amountTransfered) {
    
    this.amountTransfered = amountTransfered;
    return this;
  }

  /**
   * Get amountTransfered
   * @return amountTransfered
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountTransfered() {
    return amountTransfered;
  }


  public void setAmountTransfered(BigDecimal amountTransfered) {
    this.amountTransfered = amountTransfered;
  }

  public GuarantorFundingData guarantorTransactions(List<GuarantorTransactionData> guarantorTransactions) {
    
    this.guarantorTransactions = guarantorTransactions;
    return this;
  }

  public GuarantorFundingData addGuarantorTransactionsItem(GuarantorTransactionData guarantorTransactionsItem) {
    if (this.guarantorTransactions == null) {
      this.guarantorTransactions = new ArrayList<>();
    }
    this.guarantorTransactions.add(guarantorTransactionsItem);
    return this;
  }

  /**
   * Get guarantorTransactions
   * @return guarantorTransactions
   */
  @javax.annotation.Nullable

  public List<GuarantorTransactionData> getGuarantorTransactions() {
    return guarantorTransactions;
  }


  public void setGuarantorTransactions(List<GuarantorTransactionData> guarantorTransactions) {
    this.guarantorTransactions = guarantorTransactions;
  }

  public GuarantorFundingData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public GuarantorFundingData savingsAccount(PortfolioAccountData savingsAccount) {
    
    this.savingsAccount = savingsAccount;
    return this;
  }

  /**
   * Get savingsAccount
   * @return savingsAccount
   */
  @javax.annotation.Nullable

  public PortfolioAccountData getSavingsAccount() {
    return savingsAccount;
  }


  public void setSavingsAccount(PortfolioAccountData savingsAccount) {
    this.savingsAccount = savingsAccount;
  }

  public GuarantorFundingData status(EnumOptionData status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public EnumOptionData getStatus() {
    return status;
  }


  public void setStatus(EnumOptionData status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GuarantorFundingData guarantorFundingData = (GuarantorFundingData) o;
    return Objects.equals(this.amount, guarantorFundingData.amount) &&
        Objects.equals(this.amountReleased, guarantorFundingData.amountReleased) &&
        Objects.equals(this.amountRemaining, guarantorFundingData.amountRemaining) &&
        Objects.equals(this.amountTransfered, guarantorFundingData.amountTransfered) &&
        Objects.equals(this.guarantorTransactions, guarantorFundingData.guarantorTransactions) &&
        Objects.equals(this.id, guarantorFundingData.id) &&
        Objects.equals(this.savingsAccount, guarantorFundingData.savingsAccount) &&
        Objects.equals(this.status, guarantorFundingData.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, amountReleased, amountRemaining, amountTransfered, guarantorTransactions, id, savingsAccount, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GuarantorFundingData {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    amountReleased: ").append(toIndentedString(amountReleased)).append("\n");
    sb.append("    amountRemaining: ").append(toIndentedString(amountRemaining)).append("\n");
    sb.append("    amountTransfered: ").append(toIndentedString(amountTransfered)).append("\n");
    sb.append("    guarantorTransactions: ").append(toIndentedString(guarantorTransactions)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    savingsAccount: ").append(toIndentedString(savingsAccount)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

