/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.fineract.client.models.CurrencyData;

/**
 * LoanProductMinimumRepaymentScheduleRelatedDetail
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanProductMinimumRepaymentScheduleRelatedDetail {
  public static final String SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION = "allowPartialPeriodInterestCalculation";
  @SerializedName(SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION)
  private Boolean allowPartialPeriodInterestCalculation;

  /**
   * Gets or Sets amortizationMethod
   */
  @JsonAdapter(AmortizationMethodEnum.Adapter.class)
  public enum AmortizationMethodEnum {
    EQUAL_PRINCIPAL("EQUAL_PRINCIPAL"),
    
    EQUAL_INSTALLMENTS("EQUAL_INSTALLMENTS"),
    
    INVALID("INVALID");

    private String value;

    AmortizationMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AmortizationMethodEnum fromValue(String value) {
      for (AmortizationMethodEnum b : AmortizationMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AmortizationMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AmortizationMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AmortizationMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AmortizationMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_AMORTIZATION_METHOD = "amortizationMethod";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_METHOD)
  private AmortizationMethodEnum amortizationMethod;

  public static final String SERIALIZED_NAME_ANNUAL_NOMINAL_INTEREST_RATE = "annualNominalInterestRate";
  @SerializedName(SERIALIZED_NAME_ANNUAL_NOMINAL_INTEREST_RATE)
  private BigDecimal annualNominalInterestRate;

  public static final String SERIALIZED_NAME_CURRENCY_DATA = "currencyData";
  @SerializedName(SERIALIZED_NAME_CURRENCY_DATA)
  private CurrencyData currencyData;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE = "daysInMonthType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE)
  private Integer daysInMonthType;

  /**
   * Gets or Sets daysInYearCustomStrategy
   */
  @JsonAdapter(DaysInYearCustomStrategyEnum.Adapter.class)
  public enum DaysInYearCustomStrategyEnum {
    FULL_LEAP_YEAR("FULL_LEAP_YEAR"),
    
    FEB_29_PERIOD_ONLY("FEB_29_PERIOD_ONLY");

    private String value;

    DaysInYearCustomStrategyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DaysInYearCustomStrategyEnum fromValue(String value) {
      for (DaysInYearCustomStrategyEnum b : DaysInYearCustomStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DaysInYearCustomStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DaysInYearCustomStrategyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DaysInYearCustomStrategyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DaysInYearCustomStrategyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY = "daysInYearCustomStrategy";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY)
  private DaysInYearCustomStrategyEnum daysInYearCustomStrategy;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private Integer daysInYearType;

  public static final String SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING = "graceOnArrearsAgeing";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING)
  private Integer graceOnArrearsAgeing;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_CHARGED = "graceOnInterestCharged";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_CHARGED)
  private Integer graceOnInterestCharged;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT = "graceOnInterestPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT)
  private Integer graceOnInterestPayment;

  public static final String SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT = "graceOnPrincipalPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT)
  private Integer graceOnPrincipalPayment;

  /**
   * Gets or Sets interestCalculationPeriodMethod
   */
  @JsonAdapter(InterestCalculationPeriodMethodEnum.Adapter.class)
  public enum InterestCalculationPeriodMethodEnum {
    DAILY("DAILY"),
    
    SAME_AS_REPAYMENT_PERIOD("SAME_AS_REPAYMENT_PERIOD"),
    
    INVALID("INVALID");

    private String value;

    InterestCalculationPeriodMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InterestCalculationPeriodMethodEnum fromValue(String value) {
      for (InterestCalculationPeriodMethodEnum b : InterestCalculationPeriodMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InterestCalculationPeriodMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InterestCalculationPeriodMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InterestCalculationPeriodMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InterestCalculationPeriodMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_METHOD = "interestCalculationPeriodMethod";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_METHOD)
  private InterestCalculationPeriodMethodEnum interestCalculationPeriodMethod;

  /**
   * Gets or Sets interestMethod
   */
  @JsonAdapter(InterestMethodEnum.Adapter.class)
  public enum InterestMethodEnum {
    DECLINING_BALANCE("DECLINING_BALANCE"),
    
    FLAT("FLAT"),
    
    INVALID("INVALID");

    private String value;

    InterestMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InterestMethodEnum fromValue(String value) {
      for (InterestMethodEnum b : InterestMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InterestMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InterestMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InterestMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InterestMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INTEREST_METHOD = "interestMethod";
  @SerializedName(SERIALIZED_NAME_INTEREST_METHOD)
  private InterestMethodEnum interestMethod;

  /**
   * Gets or Sets interestPeriodFrequencyType
   */
  @JsonAdapter(InterestPeriodFrequencyTypeEnum.Adapter.class)
  public enum InterestPeriodFrequencyTypeEnum {
    DAYS("DAYS"),
    
    WEEKS("WEEKS"),
    
    MONTHS("MONTHS"),
    
    YEARS("YEARS"),
    
    WHOLE_TERM("WHOLE_TERM"),
    
    INVALID("INVALID");

    private String value;

    InterestPeriodFrequencyTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InterestPeriodFrequencyTypeEnum fromValue(String value) {
      for (InterestPeriodFrequencyTypeEnum b : InterestPeriodFrequencyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InterestPeriodFrequencyTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InterestPeriodFrequencyTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InterestPeriodFrequencyTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InterestPeriodFrequencyTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INTEREST_PERIOD_FREQUENCY_TYPE = "interestPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_PERIOD_FREQUENCY_TYPE)
  private InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_NOMINAL_INTEREST_RATE_PER_PERIOD = "nominalInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_NOMINAL_INTEREST_RATE_PER_PERIOD)
  private BigDecimal nominalInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_RECURRING_MORATORIUM_ON_PRINCIPAL_PERIODS = "recurringMoratoriumOnPrincipalPeriods";
  @SerializedName(SERIALIZED_NAME_RECURRING_MORATORIUM_ON_PRINCIPAL_PERIODS)
  private Integer recurringMoratoriumOnPrincipalPeriods;

  public static final String SERIALIZED_NAME_REPAY_EVERY = "repayEvery";
  @SerializedName(SERIALIZED_NAME_REPAY_EVERY)
  private Integer repayEvery;

  /**
   * Gets or Sets repaymentPeriodFrequencyType
   */
  @JsonAdapter(RepaymentPeriodFrequencyTypeEnum.Adapter.class)
  public enum RepaymentPeriodFrequencyTypeEnum {
    DAYS("DAYS"),
    
    WEEKS("WEEKS"),
    
    MONTHS("MONTHS"),
    
    YEARS("YEARS"),
    
    WHOLE_TERM("WHOLE_TERM"),
    
    INVALID("INVALID");

    private String value;

    RepaymentPeriodFrequencyTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RepaymentPeriodFrequencyTypeEnum fromValue(String value) {
      for (RepaymentPeriodFrequencyTypeEnum b : RepaymentPeriodFrequencyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RepaymentPeriodFrequencyTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RepaymentPeriodFrequencyTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RepaymentPeriodFrequencyTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RepaymentPeriodFrequencyTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_REPAYMENT_PERIOD_FREQUENCY_TYPE = "repaymentPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_PERIOD_FREQUENCY_TYPE)
  private RepaymentPeriodFrequencyTypeEnum repaymentPeriodFrequencyType;

  public LoanProductMinimumRepaymentScheduleRelatedDetail() {
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail allowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
    
    this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
    return this;
  }

  /**
   * Get allowPartialPeriodInterestCalculation
   * @return allowPartialPeriodInterestCalculation
   */
  @javax.annotation.Nullable

  public Boolean getAllowPartialPeriodInterestCalculation() {
    return allowPartialPeriodInterestCalculation;
  }


  public void setAllowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
    this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail amortizationMethod(AmortizationMethodEnum amortizationMethod) {
    
    this.amortizationMethod = amortizationMethod;
    return this;
  }

  /**
   * Get amortizationMethod
   * @return amortizationMethod
   */
  @javax.annotation.Nullable

  public AmortizationMethodEnum getAmortizationMethod() {
    return amortizationMethod;
  }


  public void setAmortizationMethod(AmortizationMethodEnum amortizationMethod) {
    this.amortizationMethod = amortizationMethod;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail annualNominalInterestRate(BigDecimal annualNominalInterestRate) {
    
    this.annualNominalInterestRate = annualNominalInterestRate;
    return this;
  }

  /**
   * Get annualNominalInterestRate
   * @return annualNominalInterestRate
   */
  @javax.annotation.Nullable

  public BigDecimal getAnnualNominalInterestRate() {
    return annualNominalInterestRate;
  }


  public void setAnnualNominalInterestRate(BigDecimal annualNominalInterestRate) {
    this.annualNominalInterestRate = annualNominalInterestRate;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail currencyData(CurrencyData currencyData) {
    
    this.currencyData = currencyData;
    return this;
  }

  /**
   * Get currencyData
   * @return currencyData
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrencyData() {
    return currencyData;
  }


  public void setCurrencyData(CurrencyData currencyData) {
    this.currencyData = currencyData;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail daysInMonthType(Integer daysInMonthType) {
    
    this.daysInMonthType = daysInMonthType;
    return this;
  }

  /**
   * Get daysInMonthType
   * @return daysInMonthType
   */
  @javax.annotation.Nullable

  public Integer getDaysInMonthType() {
    return daysInMonthType;
  }


  public void setDaysInMonthType(Integer daysInMonthType) {
    this.daysInMonthType = daysInMonthType;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail daysInYearCustomStrategy(DaysInYearCustomStrategyEnum daysInYearCustomStrategy) {
    
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
    return this;
  }

  /**
   * Get daysInYearCustomStrategy
   * @return daysInYearCustomStrategy
   */
  @javax.annotation.Nullable

  public DaysInYearCustomStrategyEnum getDaysInYearCustomStrategy() {
    return daysInYearCustomStrategy;
  }


  public void setDaysInYearCustomStrategy(DaysInYearCustomStrategyEnum daysInYearCustomStrategy) {
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail daysInYearType(Integer daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public Integer getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(Integer daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail graceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
    return this;
  }

  /**
   * Get graceOnArrearsAgeing
   * @return graceOnArrearsAgeing
   */
  @javax.annotation.Nullable

  public Integer getGraceOnArrearsAgeing() {
    return graceOnArrearsAgeing;
  }


  public void setGraceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail graceOnInterestCharged(Integer graceOnInterestCharged) {
    
    this.graceOnInterestCharged = graceOnInterestCharged;
    return this;
  }

  /**
   * Get graceOnInterestCharged
   * @return graceOnInterestCharged
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestCharged() {
    return graceOnInterestCharged;
  }


  public void setGraceOnInterestCharged(Integer graceOnInterestCharged) {
    this.graceOnInterestCharged = graceOnInterestCharged;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail graceOnInterestPayment(Integer graceOnInterestPayment) {
    
    this.graceOnInterestPayment = graceOnInterestPayment;
    return this;
  }

  /**
   * Get graceOnInterestPayment
   * @return graceOnInterestPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestPayment() {
    return graceOnInterestPayment;
  }


  public void setGraceOnInterestPayment(Integer graceOnInterestPayment) {
    this.graceOnInterestPayment = graceOnInterestPayment;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail graceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
    return this;
  }

  /**
   * Get graceOnPrincipalPayment
   * @return graceOnPrincipalPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnPrincipalPayment() {
    return graceOnPrincipalPayment;
  }


  public void setGraceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail interestCalculationPeriodMethod(InterestCalculationPeriodMethodEnum interestCalculationPeriodMethod) {
    
    this.interestCalculationPeriodMethod = interestCalculationPeriodMethod;
    return this;
  }

  /**
   * Get interestCalculationPeriodMethod
   * @return interestCalculationPeriodMethod
   */
  @javax.annotation.Nullable

  public InterestCalculationPeriodMethodEnum getInterestCalculationPeriodMethod() {
    return interestCalculationPeriodMethod;
  }


  public void setInterestCalculationPeriodMethod(InterestCalculationPeriodMethodEnum interestCalculationPeriodMethod) {
    this.interestCalculationPeriodMethod = interestCalculationPeriodMethod;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail interestMethod(InterestMethodEnum interestMethod) {
    
    this.interestMethod = interestMethod;
    return this;
  }

  /**
   * Get interestMethod
   * @return interestMethod
   */
  @javax.annotation.Nullable

  public InterestMethodEnum getInterestMethod() {
    return interestMethod;
  }


  public void setInterestMethod(InterestMethodEnum interestMethod) {
    this.interestMethod = interestMethod;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail interestPeriodFrequencyType(InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType) {
    
    this.interestPeriodFrequencyType = interestPeriodFrequencyType;
    return this;
  }

  /**
   * Get interestPeriodFrequencyType
   * @return interestPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public InterestPeriodFrequencyTypeEnum getInterestPeriodFrequencyType() {
    return interestPeriodFrequencyType;
  }


  public void setInterestPeriodFrequencyType(InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType) {
    this.interestPeriodFrequencyType = interestPeriodFrequencyType;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail nominalInterestRatePerPeriod(BigDecimal nominalInterestRatePerPeriod) {
    
    this.nominalInterestRatePerPeriod = nominalInterestRatePerPeriod;
    return this;
  }

  /**
   * Get nominalInterestRatePerPeriod
   * @return nominalInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getNominalInterestRatePerPeriod() {
    return nominalInterestRatePerPeriod;
  }


  public void setNominalInterestRatePerPeriod(BigDecimal nominalInterestRatePerPeriod) {
    this.nominalInterestRatePerPeriod = nominalInterestRatePerPeriod;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail recurringMoratoriumOnPrincipalPeriods(Integer recurringMoratoriumOnPrincipalPeriods) {
    
    this.recurringMoratoriumOnPrincipalPeriods = recurringMoratoriumOnPrincipalPeriods;
    return this;
  }

  /**
   * Get recurringMoratoriumOnPrincipalPeriods
   * @return recurringMoratoriumOnPrincipalPeriods
   */
  @javax.annotation.Nullable

  public Integer getRecurringMoratoriumOnPrincipalPeriods() {
    return recurringMoratoriumOnPrincipalPeriods;
  }


  public void setRecurringMoratoriumOnPrincipalPeriods(Integer recurringMoratoriumOnPrincipalPeriods) {
    this.recurringMoratoriumOnPrincipalPeriods = recurringMoratoriumOnPrincipalPeriods;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail repayEvery(Integer repayEvery) {
    
    this.repayEvery = repayEvery;
    return this;
  }

  /**
   * Get repayEvery
   * @return repayEvery
   */
  @javax.annotation.Nullable

  public Integer getRepayEvery() {
    return repayEvery;
  }


  public void setRepayEvery(Integer repayEvery) {
    this.repayEvery = repayEvery;
  }

  public LoanProductMinimumRepaymentScheduleRelatedDetail repaymentPeriodFrequencyType(RepaymentPeriodFrequencyTypeEnum repaymentPeriodFrequencyType) {
    
    this.repaymentPeriodFrequencyType = repaymentPeriodFrequencyType;
    return this;
  }

  /**
   * Get repaymentPeriodFrequencyType
   * @return repaymentPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public RepaymentPeriodFrequencyTypeEnum getRepaymentPeriodFrequencyType() {
    return repaymentPeriodFrequencyType;
  }


  public void setRepaymentPeriodFrequencyType(RepaymentPeriodFrequencyTypeEnum repaymentPeriodFrequencyType) {
    this.repaymentPeriodFrequencyType = repaymentPeriodFrequencyType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanProductMinimumRepaymentScheduleRelatedDetail loanProductMinimumRepaymentScheduleRelatedDetail = (LoanProductMinimumRepaymentScheduleRelatedDetail) o;
    return Objects.equals(this.allowPartialPeriodInterestCalculation, loanProductMinimumRepaymentScheduleRelatedDetail.allowPartialPeriodInterestCalculation) &&
        Objects.equals(this.amortizationMethod, loanProductMinimumRepaymentScheduleRelatedDetail.amortizationMethod) &&
        Objects.equals(this.annualNominalInterestRate, loanProductMinimumRepaymentScheduleRelatedDetail.annualNominalInterestRate) &&
        Objects.equals(this.currencyData, loanProductMinimumRepaymentScheduleRelatedDetail.currencyData) &&
        Objects.equals(this.daysInMonthType, loanProductMinimumRepaymentScheduleRelatedDetail.daysInMonthType) &&
        Objects.equals(this.daysInYearCustomStrategy, loanProductMinimumRepaymentScheduleRelatedDetail.daysInYearCustomStrategy) &&
        Objects.equals(this.daysInYearType, loanProductMinimumRepaymentScheduleRelatedDetail.daysInYearType) &&
        Objects.equals(this.graceOnArrearsAgeing, loanProductMinimumRepaymentScheduleRelatedDetail.graceOnArrearsAgeing) &&
        Objects.equals(this.graceOnInterestCharged, loanProductMinimumRepaymentScheduleRelatedDetail.graceOnInterestCharged) &&
        Objects.equals(this.graceOnInterestPayment, loanProductMinimumRepaymentScheduleRelatedDetail.graceOnInterestPayment) &&
        Objects.equals(this.graceOnPrincipalPayment, loanProductMinimumRepaymentScheduleRelatedDetail.graceOnPrincipalPayment) &&
        Objects.equals(this.interestCalculationPeriodMethod, loanProductMinimumRepaymentScheduleRelatedDetail.interestCalculationPeriodMethod) &&
        Objects.equals(this.interestMethod, loanProductMinimumRepaymentScheduleRelatedDetail.interestMethod) &&
        Objects.equals(this.interestPeriodFrequencyType, loanProductMinimumRepaymentScheduleRelatedDetail.interestPeriodFrequencyType) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, loanProductMinimumRepaymentScheduleRelatedDetail.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.nominalInterestRatePerPeriod, loanProductMinimumRepaymentScheduleRelatedDetail.nominalInterestRatePerPeriod) &&
        Objects.equals(this.numberOfRepayments, loanProductMinimumRepaymentScheduleRelatedDetail.numberOfRepayments) &&
        Objects.equals(this.recurringMoratoriumOnPrincipalPeriods, loanProductMinimumRepaymentScheduleRelatedDetail.recurringMoratoriumOnPrincipalPeriods) &&
        Objects.equals(this.repayEvery, loanProductMinimumRepaymentScheduleRelatedDetail.repayEvery) &&
        Objects.equals(this.repaymentPeriodFrequencyType, loanProductMinimumRepaymentScheduleRelatedDetail.repaymentPeriodFrequencyType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowPartialPeriodInterestCalculation, amortizationMethod, annualNominalInterestRate, currencyData, daysInMonthType, daysInYearCustomStrategy, daysInYearType, graceOnArrearsAgeing, graceOnInterestCharged, graceOnInterestPayment, graceOnPrincipalPayment, interestCalculationPeriodMethod, interestMethod, interestPeriodFrequencyType, interestRecognitionOnDisbursementDate, nominalInterestRatePerPeriod, numberOfRepayments, recurringMoratoriumOnPrincipalPeriods, repayEvery, repaymentPeriodFrequencyType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanProductMinimumRepaymentScheduleRelatedDetail {\n");
    sb.append("    allowPartialPeriodInterestCalculation: ").append(toIndentedString(allowPartialPeriodInterestCalculation)).append("\n");
    sb.append("    amortizationMethod: ").append(toIndentedString(amortizationMethod)).append("\n");
    sb.append("    annualNominalInterestRate: ").append(toIndentedString(annualNominalInterestRate)).append("\n");
    sb.append("    currencyData: ").append(toIndentedString(currencyData)).append("\n");
    sb.append("    daysInMonthType: ").append(toIndentedString(daysInMonthType)).append("\n");
    sb.append("    daysInYearCustomStrategy: ").append(toIndentedString(daysInYearCustomStrategy)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    graceOnArrearsAgeing: ").append(toIndentedString(graceOnArrearsAgeing)).append("\n");
    sb.append("    graceOnInterestCharged: ").append(toIndentedString(graceOnInterestCharged)).append("\n");
    sb.append("    graceOnInterestPayment: ").append(toIndentedString(graceOnInterestPayment)).append("\n");
    sb.append("    graceOnPrincipalPayment: ").append(toIndentedString(graceOnPrincipalPayment)).append("\n");
    sb.append("    interestCalculationPeriodMethod: ").append(toIndentedString(interestCalculationPeriodMethod)).append("\n");
    sb.append("    interestMethod: ").append(toIndentedString(interestMethod)).append("\n");
    sb.append("    interestPeriodFrequencyType: ").append(toIndentedString(interestPeriodFrequencyType)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    nominalInterestRatePerPeriod: ").append(toIndentedString(nominalInterestRatePerPeriod)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    recurringMoratoriumOnPrincipalPeriods: ").append(toIndentedString(recurringMoratoriumOnPrincipalPeriods)).append("\n");
    sb.append("    repayEvery: ").append(toIndentedString(repayEvery)).append("\n");
    sb.append("    repaymentPeriodFrequencyType: ").append(toIndentedString(repaymentPeriodFrequencyType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

