/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.tier.InterestType;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.internal.util.ObjectIntProcedure;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FetchKeysMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private Integer bucketId;
    private InterestType interestType;
    private Object interestArg;
    private boolean allowTombstones;
    public KnownVersion[] serializationVersions = null;

    private FetchKeysMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, Integer bucketId, @NotNull InterestType interestType2, Object interestArg, boolean allowTombstones) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.interestType = interestType2;
        this.interestArg = interestArg;
        this.allowTombstones = allowTombstones;
    }

    public FetchKeysMessage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FetchKeysResponse send(InternalDistributedMember recipient, PartitionedRegion r, Integer bucketId, boolean allowTombstones) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "FetchKeysMessage NULL recipient");
        TXManagerImpl txManager = r.getCache().getTxManager();
        boolean resetTxState = FetchKeysMessage.isTransactionInternalSuspendNeeded(txManager);
        TXStateProxy txStateProxy = null;
        if (resetTxState) {
            txStateProxy = txManager.pauseTransaction();
        }
        try {
            FetchKeysMessage tmp = new FetchKeysMessage();
            FetchKeysResponse p = (FetchKeysResponse)tmp.createReplyProcessor(r, Collections.singleton(recipient));
            FetchKeysMessage m = new FetchKeysMessage(recipient, r.getPRId(), p, bucketId, InterestType.REGULAR_EXPRESSION, ".*", allowTombstones);
            m.setTransactionDistributed(txManager.isDistributed());
            Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
            if (failures != null && failures.size() > 0) {
                throw new ForceReattemptException(String.format("Failed sending < %s >", m));
            }
            FetchKeysResponse fetchKeysResponse = p;
            return fetchKeysResponse;
        }
        finally {
            if (resetTxState) {
                txManager.unpauseTransaction(txStateProxy);
            }
        }
    }

    private static boolean isTransactionInternalSuspendNeeded(TXManagerImpl txManager) {
        TXStateProxy txState = txManager.getTXState();
        return txState != null && txState.isRealDealLocal() && !txState.isDistTx();
    }

    public static FetchKeysResponse sendInterestQuery(InternalDistributedMember recipient, PartitionedRegion r, Integer bucketId, @NotNull InterestType interestType2, Object arg, boolean allowTombstones) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "FetchKeysMessage NULL recipient");
        FetchKeysMessage tmp = new FetchKeysMessage();
        FetchKeysResponse p = (FetchKeysResponse)tmp.createReplyProcessor(r, Collections.singleton(recipient));
        FetchKeysMessage m = new FetchKeysMessage(recipient, r.getPRId(), p, bucketId, interestType2, arg, allowTombstones);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(String.format("Failed sending < %s >", m));
        }
        return p;
    }

    @Override
    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new FetchKeysResponse(r.getSystem(), recipients);
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws CacheException, ForceReattemptException {
        PartitionedRegionDataStore ds;
        if (logger.isDebugEnabled()) {
            logger.debug("FetchKeysMessage operateOnRegion: {} bucketId: {} type: {} {}", (Object)r.getFullPath(), (Object)this.bucketId, (Object)InterestType.getString(this.interestType), (Object)(this.allowTombstones ? " with tombstones" : " without tombstones"));
        }
        if ((ds = r.getDataStore()) != null) {
            try {
                Set keys = ds.handleRemoteGetKeys(this.bucketId, this.interestType, this.interestArg, this.allowTombstones);
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "FetchKeysMessage sending {} keys back using processorId: {} : {}", (Object)keys.size(), (Object)this.getProcessorId(), (Object)keys);
                }
                r.getPrStats().endPartitionMessagesProcessing(startTime);
                FetchKeysReplyMessage.send(this.getSender(), this.getProcessorId(), dm, keys);
            }
            catch (PRLocallyDestroyedException pde) {
                if (logger.isDebugEnabled()) {
                    logger.debug("FetchKeysMessage Encountered PRLocallyDestroyedException");
                }
                throw new ForceReattemptException("Encountered PRLocallyDestroyedException", pde);
            }
        } else {
            logger.warn("FetchKeysMessage: data store not configured for this member");
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
    }

    public int getDSFID() {
        return 48;
    }

    @Override
    public KnownVersion[] getSerializationVersions() {
        return this.serializationVersions;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.bucketId = in.readInt();
        this.interestType = InterestType.valueOf(in.readInt());
        this.interestArg = DataSerializer.readObject(in);
        this.allowTombstones = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.bucketId);
        out.writeInt(this.interestType.ordinal());
        DataSerializer.writeObject(this.interestArg, out);
        out.writeBoolean(this.allowTombstones);
    }

    public static class FetchKeysResponse
    extends PartitionMessage.PartitionResponse {
        private final Set<Object> returnValue;
        private final Object endLock = new Object();
        private volatile int chunksProcessed;
        private volatile int chunksExpected;
        private volatile boolean lastChunkReceived;

        public FetchKeysResponse(InternalDistributedSystem ds, Set<?> recipients) {
            super(ds, recipients);
            this.returnValue = new HashSet<Object>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processChunk(FetchKeysReplyMessage msg) {
            boolean doneProcessing = false;
            if (msg.getException() != null) {
                this.process(msg);
            } else {
                try {
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(msg.chunk);
                    DataInputStream in = new DataInputStream(byteStream);
                    while (in.available() > 0) {
                        Object key = DataSerializer.readObject(in);
                        if (key != null) {
                            Set<Object> set = this.returnValue;
                            synchronized (set) {
                                this.returnValue.add(key);
                                continue;
                            }
                        }
                        Assert.assertTrue(in.available() == 0);
                    }
                    Object object = this.endLock;
                    synchronized (object) {
                        ++this.chunksProcessed;
                        if (msg.seriesNum + 1 == msg.numSeries && msg.lastInSeries) {
                            this.lastChunkReceived = true;
                            this.chunksExpected = msg.msgNum + 1;
                        }
                        if (this.lastChunkReceived && this.chunksExpected == this.chunksProcessed) {
                            doneProcessing = true;
                        }
                        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                            logger.trace(LogMarker.DM_VERBOSE, "{} chunksProcessed={},lastChunkReceived={},chunksExpected={},done={}", (Object)this, (Object)this.chunksProcessed, (Object)this.lastChunkReceived, (Object)this.chunksExpected, (Object)doneProcessing);
                        }
                    }
                }
                catch (Exception e) {
                    this.processException(new ReplyException("Error deserializing keys", e));
                    this.checkIfDone();
                }
                if (doneProcessing) {
                    this.process(msg);
                }
            }
        }

        public Set<Object> waitForKeys() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("FetchKeysResponse got remote CacheClosedException; forcing reattempt. {}", (Object)t.getMessage(), (Object)t);
                    throw new ForceReattemptException("FetchKeysResponse got remote CacheClosedException; forcing reattempt.", t);
                }
                if (t instanceof ForceReattemptException) {
                    logger.debug("FetchKeysResponse got remote ForceReattemptException; rethrowing. {}", (Object)e.getMessage(), (Object)e);
                    throw new ForceReattemptException("Peer requests reattempt", t);
                }
                e.handleCause();
            }
            if (!this.lastChunkReceived) {
                throw new ForceReattemptException("No replies received");
            }
            return this.returnValue;
        }
    }

    public static class FetchKeysReplyMessage
    extends ReplyMessage {
        int seriesNum;
        int msgNum;
        int numSeries;
        boolean lastInSeries;
        transient HeapDataOutputStream chunkStream;
        transient byte[] chunk;

        public FetchKeysReplyMessage() {
        }

        private FetchKeysReplyMessage(InternalDistributedMember recipient, int processorId, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries) {
            this.setRecipient(recipient);
            this.setProcessorId(processorId);
            this.seriesNum = seriesNum;
            this.msgNum = msgNum;
            this.numSeries = numSeries;
            this.lastInSeries = lastInSeries;
            this.chunkStream = chunk;
        }

        public static void send(final @NotNull InternalDistributedMember recipient, final int processorId, final @NotNull DistributionManager dm, @NotNull Set<?> keys) throws ForceReattemptException {
            boolean numSeries = true;
            boolean seriesNum = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Starting pr keys chunking for {} kets to member {}", (Object)keys.size(), (Object)recipient);
            }
            try {
                boolean finished = FetchKeysReplyMessage.chunkSet(recipient, keys, InitialImageOperation.CHUNK_SIZE_IN_BYTES, false, new ObjectIntProcedure(){
                    int msgNum = 0;
                    boolean last = false;

                    @Override
                    public boolean executeWith(Object a, int b) {
                        HeapDataOutputStream chunk = (HeapDataOutputStream)a;
                        this.last = b > 0;
                        try {
                            return FetchKeysReplyMessage.sendChunk(recipient, processorId, dm, chunk, 0, this.msgNum++, 1, this.last);
                        }
                        catch (CancelException e) {
                            return false;
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("{} pr keys chunking", (Object)(finished ? "Finished" : "DID NOT complete"));
                }
            }
            catch (IOException io) {
                throw new ForceReattemptException("Unable to send response to fetch keys request", io);
            }
        }

        static boolean sendChunk(InternalDistributedMember recipient, int processorId, DistributionManager dm, HeapDataOutputStream chunk, int seriesNum, int msgNum, int numSeries, boolean lastInSeries) {
            FetchKeysReplyMessage reply = new FetchKeysReplyMessage(recipient, processorId, chunk, seriesNum, msgNum, numSeries, lastInSeries);
            Set<InternalDistributedMember> failures = dm.putOutgoing(reply);
            return failures == null || failures.size() == 0;
        }

        static boolean chunkSet(@NotNull InternalDistributedMember recipient, Set<?> set, int chunkSizeInBytes, boolean includeValues, @NotNull ObjectIntProcedure proc) throws IOException {
            boolean sentLastChunk;
            Iterator<?> it = set.iterator();
            try (HeapDataOutputStream mos = new HeapDataOutputStream(chunkSizeInBytes + 2048, Versioning.getKnownVersionOrDefault((Version)recipient.getVersion(), (KnownVersion)KnownVersion.CURRENT));){
                boolean keepGoing;
                do {
                    mos.reset();
                    int avgItemSize = 0;
                    int itemCount = 0;
                    while (mos.size() + avgItemSize < chunkSizeInBytes && it.hasNext()) {
                        Object key = it.next();
                        DataSerializer.writeObject(key, mos);
                        avgItemSize = mos.size() / ++itemCount;
                    }
                    DataSerializer.writeObject(null, mos);
                    int lastMsg = it.hasNext() ? 0 : 1;
                    keepGoing = proc.executeWith(mos, lastMsg);
                    boolean bl = sentLastChunk = lastMsg == 1 && keepGoing;
                } while (keepGoing && it.hasNext());
            }
            return sentLastChunk;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 p) {
            long startTime = this.getTimestamp();
            FetchKeysResponse processor = (FetchKeysResponse)p;
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "FetchKeysReplyMessage processor not found");
                }
                return;
            }
            processor.processChunk(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.seriesNum);
            out.writeInt(this.msgNum);
            out.writeInt(this.numSeries);
            out.writeBoolean(this.lastInSeries);
            DataSerializer.writeObjectAsByteArray(this.chunkStream, out);
        }

        @Override
        public int getDSFID() {
            return -99;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.seriesNum = in.readInt();
            this.msgNum = in.readInt();
            this.numSeries = in.readInt();
            this.lastInSeries = in.readBoolean();
            this.chunk = DataSerializer.readByteArray(in);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FetchKeysReplyMessage ").append("processorid=").append(this.processorId);
            if (this.getSender() != null) {
                sb.append(",sender=").append(this.getSender());
            }
            sb.append(",seriesNum=").append(this.seriesNum).append(",msgNum=").append(this.msgNum).append(",numSeries=").append(this.numSeries).append(",lastInSeries=").append(this.lastInSeries);
            if (this.chunkStream != null) {
                sb.append(",size=").append(this.chunkStream.size());
            } else if (this.chunk != null) {
                sb.append(",size=").append(this.chunk.length);
            }
            if (this.getException() != null) {
                sb.append(", exception=").append(this.getException());
            }
            return sb.toString();
        }
    }
}

