/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.cache.Declarable;
import org.apache.geode.internal.cache.xmlcache.Declarable2;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlGeneratorUtils {
    private XmlGeneratorUtils() {
    }

    public static void addAttribute(AttributesImpl attributes, String localName, Object value) {
        if (null != value) {
            attributes.addAttribute("", localName, localName, "", value.toString());
        }
    }

    public static void addAttribute(AttributesImpl attributes, String prefix, String localName, Object value) {
        if (null != value) {
            attributes.addAttribute("", localName, prefix + ":" + localName, "", value.toString());
        }
    }

    public static void startElement(ContentHandler contentHandler, String prefix, String localName, AttributesImpl attributes) throws SAXException {
        contentHandler.startElement("", localName, prefix + ":" + localName, attributes);
    }

    public static void endElement(ContentHandler contentHandler, String prefix, String localName) throws SAXException {
        contentHandler.endElement("", localName, prefix + ":" + localName);
    }

    public static void emptyElement(ContentHandler contentHandler, String prefix, String localName, AttributesImpl attributes) throws SAXException {
        XmlGeneratorUtils.startElement(contentHandler, prefix, localName, attributes);
        XmlGeneratorUtils.endElement(contentHandler, prefix, localName);
    }

    public static void addDeclarable(ContentHandler handler, Declarable declarable) throws SAXException {
        AttributesImpl EMPTY = new AttributesImpl();
        String className = declarable.getClass().getName();
        handler.startElement("", "class-name", "class-name", EMPTY);
        handler.characters(className.toCharArray(), 0, className.length());
        handler.endElement("", "class-name", "class-name");
        if (!(declarable instanceof Declarable2)) {
            return;
        }
        Properties props = ((Declarable2)declarable).getConfig();
        if (props == null) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> objectObjectEntry;
            Map.Entry<Object, Object> entry = objectObjectEntry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "name", "", name);
            handler.startElement("", "parameter", "parameter", atts);
            if (value instanceof String) {
                String sValue = (String)value;
                handler.startElement("", "string", "string", EMPTY);
                handler.characters(sValue.toCharArray(), 0, sValue.length());
                handler.endElement("", "string", "string");
            } else if (value instanceof Declarable) {
                handler.startElement("", "declarable", "declarable", EMPTY);
                XmlGeneratorUtils.addDeclarable(handler, (Declarable)value);
                handler.endElement("", "declarable", "declarable");
            }
            handler.endElement("", "parameter", "parameter");
        }
    }
}

