/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net.filewatch;

import java.io.FileInputStream;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.filewatch.ExtendedAliasKeyManager;
import org.apache.geode.internal.net.filewatch.PollingFileWatcher;
import org.apache.geode.internal.util.PasswordUtil;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public final class FileWatchingX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static final ConcurrentHashMap<PathAndAlias, FileWatchingX509ExtendedKeyManager> instances = new ConcurrentHashMap();
    private final AtomicReference<X509ExtendedKeyManager> keyManager = new AtomicReference();
    private final Path keyStorePath;
    private final String keyStoreType;
    private final String keyStorePassword;
    private final String keyStoreAlias;
    private final PollingFileWatcher fileWatcher;

    private FileWatchingX509ExtendedKeyManager(Path keyStorePath, String keyStoreType, String keyStorePassword, String keyStoreAlias) {
        this.keyStorePath = keyStorePath;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreAlias = keyStoreAlias;
        this.loadKeyManager();
        this.fileWatcher = new PollingFileWatcher(this.keyStorePath, this::loadKeyManager, this::stopWatching);
    }

    public static FileWatchingX509ExtendedKeyManager newFileWatchingKeyManager(SSLConfig config) {
        return FileWatchingX509ExtendedKeyManager.newFileWatchingKeyManager(Paths.get(config.getKeystore(), new String[0]), config.getKeystoreType(), config.getKeystorePassword(), config.getAlias());
    }

    public static FileWatchingX509ExtendedKeyManager newFileWatchingKeyManager(Path keyStorePath, String type, String password, String alias) {
        return instances.computeIfAbsent(new PathAndAlias(keyStorePath, alias), k -> new FileWatchingX509ExtendedKeyManager(keyStorePath, type, password, alias));
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.keyManager.get().chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
        return this.keyManager.get().chooseEngineClientAlias(strings, principals, sslEngine);
    }

    @Override
    public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
        return this.keyManager.get().chooseEngineServerAlias(s, principals, sslEngine);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.keyManager.get().chooseServerAlias(s, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.keyManager.get().getCertificateChain(s);
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.keyManager.get().getClientAliases(s, principals);
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.keyManager.get().getPrivateKey(s);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.keyManager.get().getServerAliases(s, principals);
    }

    @VisibleForTesting
    void stopWatching() {
        this.fileWatcher.stop();
        instances.remove(new PathAndAlias(this.keyStorePath, this.keyStoreAlias), this);
    }

    @VisibleForTesting
    boolean isWatching() {
        return instances.get(new PathAndAlias(this.keyStorePath, this.keyStoreAlias)) == this;
    }

    private void loadKeyManager() {
        KeyManager[] keyManagers;
        try {
            KeyStore keyStore = StringUtils.isEmpty((CharSequence)this.keyStoreType) ? KeyStore.getInstance(KeyStore.getDefaultType()) : KeyStore.getInstance(this.keyStoreType);
            String keyStoreFilePath = this.keyStorePath.toString();
            if (StringUtils.isEmpty((CharSequence)keyStoreFilePath)) {
                keyStoreFilePath = System.getProperty("user.home") + System.getProperty("file.separator") + ".keystore";
            }
            char[] password = null;
            try (FileInputStream fileInputStream = new FileInputStream(keyStoreFilePath);){
                String passwordString = this.keyStorePassword;
                if (passwordString != null) {
                    if (passwordString.trim().equals("")) {
                        String encryptedPass = System.getenv("javax.net.ssl.keyStorePassword");
                        if (!StringUtils.isEmpty((CharSequence)encryptedPass)) {
                            String toDecrypt = "encrypted(" + encryptedPass + ")";
                            passwordString = PasswordUtil.decrypt(toDecrypt);
                            password = passwordString.toCharArray();
                        }
                    } else {
                        password = passwordString.toCharArray();
                    }
                }
                keyStore.load(fileInputStream, password);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            keyManagers = keyManagerFactory.getKeyManagers();
            if (password != null) {
                Arrays.fill(password, ' ');
            }
        }
        catch (Exception e) {
            throw new InternalGemFireException("Unable to load KeyManager", e);
        }
        for (KeyManager km : keyManagers) {
            if (!(km instanceof X509ExtendedKeyManager)) continue;
            ExtendedAliasKeyManager extendedAliasKeyManager = new ExtendedAliasKeyManager((X509ExtendedKeyManager)km, this.keyStoreAlias);
            if (this.keyManager.getAndSet(extendedAliasKeyManager) == null) {
                logger.info("Initialized KeyManager for {}", (Object)this.keyStorePath);
            } else {
                logger.info("Updated KeyManager for {}", (Object)this.keyStorePath);
            }
            return;
        }
        throw new IllegalStateException("No X509ExtendedKeyManager available");
    }

    private static class PathAndAlias {
        private final Path keyStorePath;
        private final String keyStoreAlias;

        public PathAndAlias(Path keyStorePath, String keyStoreAlias) {
            this.keyStorePath = keyStorePath;
            this.keyStoreAlias = keyStoreAlias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathAndAlias that = (PathAndAlias)o;
            return Objects.equals(this.keyStorePath, that.keyStorePath) && Objects.equals(this.keyStoreAlias, that.keyStoreAlias);
        }

        public int hashCode() {
            return Objects.hash(this.keyStorePath, this.keyStoreAlias);
        }
    }
}

