/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.management.EvictionAttributesData;
import org.apache.geode.management.FixedPartitionAttributesData;
import org.apache.geode.management.MembershipAttributesData;
import org.apache.geode.management.PartitionAttributesData;
import org.apache.geode.management.RegionAttributesData;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.beans.MetricsCalculator;
import org.apache.geode.management.internal.beans.stats.RegionClusterStatsMonitor;

public class DistributedRegionBridge {
    private final Map<ObjectName, RegionMXBean> mapOfProxy = new ConcurrentHashMap<ObjectName, RegionMXBean>();
    private volatile int setSize;
    private EvictionAttributesData evictionAttributesData;
    private MembershipAttributesData membershipAttributesData;
    private PartitionAttributesData partitionAttributesData;
    private RegionAttributesData regionAttributesData;
    private FixedPartitionAttributesData[] fixedPartitionAttributesTable;
    private final RegionClusterStatsMonitor monitor = new RegionClusterStatsMonitor();
    private final boolean isPartitionedRegion = false;

    public DistributedRegionBridge(ObjectName objectName, RegionMXBean proxy, FederationComponent newState) {
        this.addProxyToMap(objectName, proxy, newState);
    }

    public void addProxyToMap(ObjectName objectName, RegionMXBean proxy, FederationComponent newState) {
        this.mapOfProxy.put(objectName, proxy);
        this.setSize = this.mapOfProxy.keySet().size();
        this.updateRegion(newState, null);
    }

    public boolean removeProxyFromMap(ObjectName objectName, RegionMXBean proxy, FederationComponent oldState) {
        this.mapOfProxy.remove(objectName);
        this.setSize = this.mapOfProxy.keySet().size();
        if (this.setSize == 0) {
            return true;
        }
        this.updateRegion(null, oldState);
        return false;
    }

    public void updateRegion(FederationComponent newState, FederationComponent oldState) {
        this.monitor.aggregate(newState, oldState);
    }

    public EvictionAttributesData getEvictionAttributes() {
        Iterator<RegionMXBean> it;
        if (this.evictionAttributesData == null && (it = this.mapOfProxy.values().iterator()) != null) {
            while (it.hasNext()) {
                try {
                    this.evictionAttributesData = it.next().listEvictionAttributes();
                }
                catch (Exception e) {
                    this.evictionAttributesData = null;
                }
                if (this.evictionAttributesData == null) continue;
                break;
            }
        }
        return this.evictionAttributesData;
    }

    public FixedPartitionAttributesData[] getFixedPartitionAttributesData() {
        Iterator<RegionMXBean> it;
        if (this.fixedPartitionAttributesTable == null && (it = this.mapOfProxy.values().iterator()) != null) {
            while (it.hasNext()) {
                try {
                    this.fixedPartitionAttributesTable = it.next().listFixedPartitionAttributes();
                }
                catch (Exception e) {
                    this.fixedPartitionAttributesTable = null;
                }
                if (this.fixedPartitionAttributesTable == null) continue;
                break;
            }
        }
        return this.fixedPartitionAttributesTable;
    }

    public int getMemberCount() {
        return this.setSize;
    }

    public String[] getMembers() {
        Iterator<ObjectName> it = this.mapOfProxy.keySet().iterator();
        if (it != null) {
            ArrayList<String> memberList = new ArrayList<String>();
            while (it.hasNext()) {
                ObjectName tempObjName = it.next();
                String formatedMemberId = tempObjName.getKeyProperty("member");
                memberList.add(formatedMemberId);
            }
            String[] members = new String[memberList.size()];
            return memberList.toArray(members);
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public MembershipAttributesData getMembershipAttributes() {
        Iterator<RegionMXBean> it;
        if (this.membershipAttributesData == null && (it = this.mapOfProxy.values().iterator()) != null) {
            while (it.hasNext()) {
                try {
                    this.membershipAttributesData = it.next().listMembershipAttributes();
                }
                catch (Exception e) {
                    this.membershipAttributesData = null;
                }
                if (this.membershipAttributesData == null) continue;
                break;
            }
        }
        return this.membershipAttributesData;
    }

    public String getName() {
        return this.monitor.getName();
    }

    public String getParentRegion() {
        return this.monitor.getParentRegion();
    }

    public String[] listSubRegionPaths(boolean recursive) {
        String[] subRegionPathsArr = new String[]{};
        Collection<RegionMXBean> proxies = this.mapOfProxy.values();
        if (proxies != null && !proxies.isEmpty()) {
            TreeSet<String> subRegionPaths = new TreeSet<String>();
            for (RegionMXBean regionMXBean : proxies) {
                String[] listSubRegionPaths = regionMXBean.listSubregionPaths(recursive);
                subRegionPaths.addAll(Arrays.asList(listSubRegionPaths));
            }
            subRegionPathsArr = subRegionPaths.toArray(subRegionPathsArr);
        }
        return subRegionPathsArr;
    }

    public PartitionAttributesData getPartitionAttributes() {
        Iterator<RegionMXBean> it;
        if (this.partitionAttributesData == null && (it = this.mapOfProxy.values().iterator()) != null) {
            while (it.hasNext()) {
                try {
                    this.partitionAttributesData = it.next().listPartitionAttributes();
                }
                catch (Exception e) {
                    this.partitionAttributesData = null;
                }
                if (this.partitionAttributesData == null) continue;
                break;
            }
        }
        return this.partitionAttributesData;
    }

    public RegionAttributesData getRegionAttributes() {
        Iterator<RegionMXBean> it;
        if (this.regionAttributesData == null && (it = this.mapOfProxy.values().iterator()) != null) {
            while (it.hasNext()) {
                try {
                    this.regionAttributesData = it.next().listRegionAttributes();
                }
                catch (Exception e) {
                    this.regionAttributesData = null;
                }
                if (this.regionAttributesData == null) continue;
                break;
            }
        }
        return this.regionAttributesData;
    }

    public String getRegionType() {
        return this.monitor.getRegionType();
    }

    public String getFullPath() {
        return this.monitor.getFullPath();
    }

    public long getCacheListenerCallsAvgLatency() {
        return MetricsCalculator.getAverage(this.monitor.getCacheListenerCallsAvgLatency(), this.setSize);
    }

    public long getCacheWriterCallsAvgLatency() {
        return MetricsCalculator.getAverage(this.monitor.getCacheWriterCallsAvgLatency(), this.setSize);
    }

    public float getCreatesRate() {
        return this.monitor.getCreatesRate();
    }

    public float getDestroyRate() {
        return this.monitor.getDestroyRate();
    }

    public float getDiskReadsRate() {
        return this.monitor.getDiskReadsRate();
    }

    public float getDiskWritesRate() {
        return this.monitor.getDiskWritesRate();
    }

    public float getGetsRate() {
        return this.monitor.getGetsRate();
    }

    public long getHitCount() {
        if (this.isPartionedRegion()) {
            return -1L;
        }
        return this.monitor.getHitCount();
    }

    public float getHitRatio() {
        if (this.isPartionedRegion()) {
            return -1.0f;
        }
        return this.monitor.getHitRatio();
    }

    public long getLastAccessedTime() {
        if (this.isPartionedRegion()) {
            return -1L;
        }
        return this.monitor.getLastAccessedTime();
    }

    public long getLastModifiedTime() {
        if (this.isPartionedRegion()) {
            return -1L;
        }
        return this.monitor.getLastModifiedTime();
    }

    public float getLruDestroyRate() {
        return this.monitor.getLruDestroyRate();
    }

    public float getLruEvictionRate() {
        return this.monitor.getLruEvictionRate();
    }

    public long getMissCount() {
        if (this.isPartionedRegion()) {
            return -1L;
        }
        return this.monitor.getMissCount();
    }

    public float getPutAllRate() {
        return this.monitor.getPutAllRate();
    }

    public float getPutLocalRate() {
        return this.monitor.getPutLocalRate();
    }

    public long getPutRemoteAvgLatency() {
        return MetricsCalculator.getAverage(this.monitor.getPutRemoteAvgLatency(), this.setSize);
    }

    public long getPutRemoteLatency() {
        return MetricsCalculator.getAverage(this.monitor.getPutRemoteLatency(), this.setSize);
    }

    public float getPutRemoteRate() {
        return this.monitor.getPutRemoteRate();
    }

    public float getPutsRate() {
        return this.monitor.getPutsRate();
    }

    public long getSystemRegionEntryCount() {
        if (this.isPartionedRegion()) {
            return this.monitor.getSystemRegionEntryCount();
        }
        return this.monitor.getEntryCount();
    }

    public long getTotalDiskWritesProgress() {
        return this.monitor.getTotalDiskWritesProgress();
    }

    public long getTotalBytesOnDisk() {
        return this.monitor.getTotalBytesOnDisk();
    }

    public long getTotalDiskEntriesInVM() {
        return this.monitor.getTotalDiskEntriesInVM();
    }

    public long getTotalEntriesOnlyOnDisk() {
        return this.monitor.getTotalEntriesOnlyOnDisk();
    }

    public int getAvgBucketSize() {
        if (!this.isPartionedRegion()) {
            return -1;
        }
        return MetricsCalculator.getAverage(this.monitor.getAvgBucketSize(), this.setSize);
    }

    public int getBucketCount() {
        if (!this.isPartionedRegion()) {
            return -1;
        }
        return this.monitor.getBucketCount();
    }

    public int getNumBucketsWithoutRedundancy() {
        if (!this.isPartionedRegion()) {
            return -1;
        }
        return this.monitor.getNumBucketsWithoutRedundancy();
    }

    public int getPrimaryBucketCount() {
        if (!this.isPartionedRegion()) {
            return -1;
        }
        return this.monitor.getPrimaryBucketCount();
    }

    public int getTotalBucketSize() {
        if (!this.isPartionedRegion()) {
            return -1;
        }
        return this.monitor.getTotalBucketSize();
    }

    public long getDiskTaskWaiting() {
        return this.monitor.getDiskTaskWaiting();
    }

    public long getDiskUsage() {
        return this.monitor.getDiskUsage();
    }

    public float getAverageReads() {
        return this.monitor.getAverageReads();
    }

    public float getAverageWrites() {
        return this.monitor.getAverageWrites();
    }

    public boolean isGatewayEnabled() {
        return this.monitor.isGatewayEnabled();
    }

    public boolean isPersistentEnabled() {
        return this.monitor.isPersistentEnabled();
    }

    public int getEmptyNodes() {
        Iterator<RegionMXBean> it = this.mapOfProxy.values().iterator();
        int emptyNodes = 0;
        if (it != null) {
            while (it.hasNext()) {
                RegionMXBean bean = it.next();
                if (bean.getRegionType().equals(DataPolicy.EMPTY.toString())) {
                    ++emptyNodes;
                }
                if (bean.getLocalMaxMemory() != 0) continue;
                ++emptyNodes;
            }
        }
        return emptyNodes;
    }

    public long getEntrySize() {
        return this.monitor.getEntrySize();
    }

    private boolean isPartionedRegion() {
        return this.getPartitionAttributes() != null;
    }
}

