/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.mergetree.compact.aggregate.FieldBoolAndAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldBoolOrAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldCollectAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldCountAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldFirstNonNullValueAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldFirstValueAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldIgnoreRetractAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldLastNonNullValueAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldLastValueAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldListaggAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldMaxAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldMergeMapAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldMinAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldNestedUpdateAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldPrimaryKeyAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldProductAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldSumAgg;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public abstract class FieldAggregator
implements Serializable {
    protected DataType fieldType;

    public FieldAggregator(DataType dataType) {
        this.fieldType = dataType;
    }

    public static FieldAggregator createFieldAggregator(DataType fieldType, @Nullable String strAgg, boolean ignoreRetract, boolean isPrimaryKey, CoreOptions options, String field) {
        FieldAggregator fieldAggregator;
        if (isPrimaryKey) {
            fieldAggregator = new FieldPrimaryKeyAgg(fieldType);
        } else if (strAgg == null) {
            fieldAggregator = new FieldLastNonNullValueAgg(fieldType);
        } else {
            switch (strAgg) {
                case "sum": {
                    fieldAggregator = new FieldSumAgg(fieldType);
                    break;
                }
                case "max": {
                    fieldAggregator = new FieldMaxAgg(fieldType);
                    break;
                }
                case "min": {
                    fieldAggregator = new FieldMinAgg(fieldType);
                    break;
                }
                case "last_non_null_value": {
                    fieldAggregator = new FieldLastNonNullValueAgg(fieldType);
                    break;
                }
                case "last_value": {
                    fieldAggregator = new FieldLastValueAgg(fieldType);
                    break;
                }
                case "listagg": {
                    fieldAggregator = new FieldListaggAgg(fieldType);
                    break;
                }
                case "bool_or": {
                    fieldAggregator = new FieldBoolOrAgg(fieldType);
                    break;
                }
                case "bool_and": {
                    fieldAggregator = new FieldBoolAndAgg(fieldType);
                    break;
                }
                case "first_value": {
                    fieldAggregator = new FieldFirstValueAgg(fieldType);
                    break;
                }
                case "first_non_null_value": 
                case "first_not_null_value": {
                    fieldAggregator = new FieldFirstNonNullValueAgg(fieldType);
                    break;
                }
                case "count": {
                    fieldAggregator = new FieldCountAgg(fieldType);
                    break;
                }
                case "product": {
                    fieldAggregator = new FieldProductAgg(fieldType);
                    break;
                }
                case "nested_update": {
                    fieldAggregator = FieldAggregator.createFieldNestedUpdateAgg(fieldType, options.fieldNestedUpdateAggNestedKey(field));
                    break;
                }
                case "collect": {
                    Preconditions.checkArgument((boolean)(fieldType instanceof ArrayType), (String)"Data type for collect column must be 'Array' but was '%s'.", (Object[])new Object[]{fieldType});
                    fieldAggregator = new FieldCollectAgg((ArrayType)fieldType, options.fieldCollectAggDistinct(field));
                    break;
                }
                case "merge_map": {
                    Preconditions.checkArgument((boolean)(fieldType instanceof MapType), (String)"Data type of merge map column must be 'MAP' but was '%s'", (Object[])new Object[]{fieldType});
                    fieldAggregator = new FieldMergeMapAgg((MapType)fieldType);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Use unsupported aggregation: %s or spell aggregate function incorrectly!", strAgg));
                }
            }
        }
        if (ignoreRetract) {
            fieldAggregator = new FieldIgnoreRetractAgg(fieldAggregator);
        }
        return fieldAggregator;
    }

    private static FieldAggregator createFieldNestedUpdateAgg(DataType fieldType, List<String> nestedKey) {
        if (nestedKey == null) {
            nestedKey = Collections.emptyList();
        }
        String typeErrorMsg = "Data type of nested table column must be 'Array<Row>' but was '%s'.";
        Preconditions.checkArgument((boolean)(fieldType instanceof ArrayType), (String)typeErrorMsg, (Object[])new Object[]{fieldType});
        ArrayType arrayType = (ArrayType)fieldType;
        Preconditions.checkArgument((boolean)(arrayType.getElementType() instanceof RowType), (String)typeErrorMsg, (Object[])new Object[]{fieldType});
        return new FieldNestedUpdateAgg(arrayType, nestedKey);
    }

    abstract String name();

    public abstract Object agg(Object var1, Object var2);

    public void reset() {
    }

    public Object retract(Object accumulator, Object retractField) {
        throw new UnsupportedOperationException(String.format("Aggregate function '%s' does not support retraction, If you allow this function to ignore retraction messages, you can configure 'fields.${field_name}.ignore-retract'='true'.", this.name()));
    }
}

