/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.circuitBreaker;

import io.openlineage.client.circuitBreaker.CircuitBreakerState;
import io.openlineage.client.circuitBreaker.ExecutorCircuitBreaker;
import io.openlineage.client.circuitBreaker.StaticCircuitBreakerConfig;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class StaticCircuitBreaker
extends ExecutorCircuitBreaker {
    private final StaticCircuitBreakerConfig config;
    private int currentIndex;

    public StaticCircuitBreaker(@NonNull StaticCircuitBreakerConfig config) {
        super(config.getCircuitCheckIntervalInMillis());
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.currentIndex = 0;
    }

    @Override
    public CircuitBreakerState currentState() {
        if (this.currentIndex >= this.getValuesAsList().size()) {
            return new CircuitBreakerState(true);
        }
        ++this.currentIndex;
        return new CircuitBreakerState(this.getValuesAsList().get(this.currentIndex - 1));
    }

    private List<Boolean> getValuesAsList() {
        return Arrays.stream(this.config.getValuesReturned().split(",")).map(s -> Boolean.valueOf(s)).collect(Collectors.toList());
    }
}

