/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ListRoles
extends Command {
    protected String metalake;

    public ListRoles(CommandContext context, String metalake) {
        super(context);
        this.metalake = metalake;
    }

    @Override
    public void handle() {
        CharSequence[] roles = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            roles = client.listRoleNames();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (roles.length == 0) {
            this.printInformation("No roles exist.");
        } else {
            this.printResults(String.join((CharSequence)",", roles));
        }
    }
}

