/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.rest.RESTUtil;

public class ResourcePaths {
    private static final Joiner SLASH = Joiner.on((String)"/").skipNulls();
    private static final String PREFIX = "prefix";
    private final String prefix;

    public static ResourcePaths forCatalogProperties(Map<String, String> properties) {
        return new ResourcePaths(properties.get(PREFIX));
    }

    public static String config() {
        return "v1/config";
    }

    public static String tokens() {
        return "v1/oauth/tokens";
    }

    public ResourcePaths(String prefix) {
        this.prefix = prefix;
    }

    public String namespaces() {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces"});
    }

    public String namespace(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns)});
    }

    public String namespaceProperties(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns), "properties"});
    }

    public String tables(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns), "tables"});
    }

    public String table(TableIdentifier ident) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ident.namespace()), "tables", RESTUtil.encodeString(ident.name())});
    }

    public String register(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns), "register"});
    }

    public String rename() {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"tables", "rename"});
    }

    public String metrics(TableIdentifier identifier) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(identifier.namespace()), "tables", RESTUtil.encodeString(identifier.name()), "metrics"});
    }

    public String commitTransaction() {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"transactions", "commit"});
    }

    public String views(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns), "views"});
    }

    public String view(TableIdentifier ident) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ident.namespace()), "views", RESTUtil.encodeString(ident.name())});
    }

    public String renameView() {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"views", "rename"});
    }
}

