/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.user;

import com.google.inject.Inject;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.DecoratingDirectory;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.vault.ksm.conf.KsmAttributeService;
import org.apache.guacamole.vault.ksm.user.KsmConnection;
import org.apache.guacamole.vault.ksm.user.KsmConnectionGroup;
import org.apache.guacamole.vault.ksm.user.KsmDirectory;
import org.apache.guacamole.vault.ksm.user.KsmUser;
import org.apache.guacamole.vault.ksm.user.KsmUserFactory;
import org.apache.guacamole.vault.user.VaultDirectoryService;

public class KsmDirectoryService
extends VaultDirectoryService {
    @Inject
    private KsmUserFactory ksmUserFactory;
    @Inject
    private KsmAttributeService attributeService;

    public Directory<Connection> getConnectionDirectory(Directory<Connection> underlyingDirectory) throws GuacamoleException {
        return new DecoratingDirectory<Connection>(underlyingDirectory){

            protected Connection decorate(Connection connection) throws GuacamoleException {
                return new KsmConnection(connection);
            }

            protected Connection undecorate(Connection connection) throws GuacamoleException {
                return ((KsmConnection)connection).getUnderlyingConnection();
            }
        };
    }

    public Directory<ConnectionGroup> getConnectionGroupDirectory(Directory<ConnectionGroup> underlyingDirectory) throws GuacamoleException {
        return new KsmDirectory<ConnectionGroup>(underlyingDirectory){

            public void add(ConnectionGroup connectionGroup) throws GuacamoleException {
                connectionGroup.setAttributes(KsmDirectoryService.this.attributeService.processAttributes(connectionGroup.getAttributes()));
                super.add((Identifiable)connectionGroup);
            }

            public void update(ConnectionGroup connectionGroup) throws GuacamoleException {
                if (connectionGroup instanceof KsmConnectionGroup) {
                    connectionGroup = ((KsmConnectionGroup)connectionGroup).getUnderlyingConnectionGroup();
                }
                connectionGroup.setAttributes(KsmDirectoryService.this.attributeService.processAttributes(connectionGroup.getAttributes()));
                super.update((Identifiable)connectionGroup);
            }

            @Override
            protected ConnectionGroup wrap(ConnectionGroup object) {
                if (object == null) {
                    return null;
                }
                return new KsmConnectionGroup(object);
            }
        };
    }

    public Directory<User> getUserDirectory(Directory<User> underlyingDirectory) throws GuacamoleException {
        return new KsmDirectory<User>(underlyingDirectory){

            public void add(User user) throws GuacamoleException {
                user.setAttributes(KsmDirectoryService.this.attributeService.processAttributes(user.getAttributes()));
                super.add((Identifiable)user);
            }

            public void update(User user) throws GuacamoleException {
                if (user instanceof KsmUser) {
                    user = ((KsmUser)user).getUnderlyingUser();
                }
                user.setAttributes(KsmDirectoryService.this.attributeService.processAttributes(user.getAttributes()));
                super.update((Identifiable)user);
            }

            @Override
            protected User wrap(User object) {
                if (object == null) {
                    return null;
                }
                return KsmDirectoryService.this.ksmUserFactory.create(object);
            }
        };
    }
}

