/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.javax.servlet.Filter;
import org.apache.hadoop.shaded.javax.servlet.FilterChain;
import org.apache.hadoop.shaded.javax.servlet.FilterConfig;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.ServletRequest;
import org.apache.hadoop.shaded.javax.servlet.ServletResponse;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.shaded.org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostRestrictingAuthorizationFilter
implements Filter {
    public static final String HDFS_CONFIG_PREFIX = "dfs.web.authentication.";
    public static final String RESTRICTION_CONFIG = "host.allow.rules";
    public static final Predicate<String> RESTRICTED_OPERATIONS = qStr -> qStr.trim().equalsIgnoreCase("op=OPEN") || qStr.trim().equalsIgnoreCase("op=GETDELEGATIONTOKEN");
    private final Map<String, CopyOnWriteArrayList<Rule>> rulemap = new ConcurrentHashMap<String, CopyOnWriteArrayList<Rule>>();
    private static final Logger LOG = LoggerFactory.getLogger(HostRestrictingAuthorizationFilter.class);

    public static Map<String, String> getFilterParams(Configuration conf, String confPrefix) {
        return conf.getPropsWithPrefix(confPrefix);
    }

    private boolean matchRule(String user, String remoteIp, String path) {
        user = user != null ? user : "";
        path = path != null ? path : "";
        LOG.trace("Got user: {}, remoteIp: {}, path: {}", new Object[]{user, remoteIp, path});
        if (remoteIp == null) {
            LOG.trace("Returned false due to null rempteIp");
            return false;
        }
        List userRules = this.rulemap.get(user);
        userRules = userRules != null ? userRules : new ArrayList();
        List anyRules = this.rulemap.get("*");
        anyRules = anyRules != null ? anyRules : new ArrayList();
        List rules = Stream.of(userRules, anyRules).flatMap(l -> l.stream()).collect(Collectors.toList());
        for (Rule rule : rules) {
            SubnetUtils.SubnetInfo subnet = rule.getSubnet();
            String rulePath = rule.getPath();
            LOG.trace("Evaluating rule, subnet: {}, path: {}", (Object)(subnet != null ? subnet.getCidrSignature() : "*"), (Object)rulePath);
            if (subnet != null && !subnet.isInRange(remoteIp) || !FilenameUtils.directoryContains((String)rulePath, (String)path)) continue;
            LOG.debug("Found matching rule, subnet: {}, path: {}; returned true", (Object)(rule.getSubnet() != null ? subnet.getCidrSignature() : null), (Object)rulePath);
            return true;
        }
        LOG.trace("Found no rules for user");
        return false;
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        String dropboxRules = config.getInitParameter(RESTRICTION_CONFIG);
        this.loadRuleMap(dropboxRules);
    }

    private void loadRuleMap(String ruleString) throws IllegalArgumentException {
        if (ruleString == null || ruleString.equals("")) {
            LOG.debug("Got no rules - will disallow anyone access");
        } else {
            Pattern comma_split = Pattern.compile(",");
            Pattern rule_split = Pattern.compile("\\||\n");
            Map<Integer, List<String[]>> splits = rule_split.splitAsStream(ruleString).map(x -> comma_split.split((CharSequence)x, 3)).collect(Collectors.groupingBy(x -> ((String[])x).length));
            if (!splits.keySet().equals(Collections.singleton(3))) {
                String bad_lines = rule_split.splitAsStream(ruleString).filter(x -> comma_split.split((CharSequence)x, 3).length != 3).collect(Collectors.joining("\n"));
                throw new IllegalArgumentException("Bad rule definition: " + bad_lines);
            }
            int user = 0;
            int cidr = 1;
            int path = 2;
            BiFunction<CopyOnWriteArrayList, CopyOnWriteArrayList, CopyOnWriteArrayList> arrayListMerge = (v1, v2) -> {
                v1.addAll(v2);
                return v1;
            };
            for (String[] split : splits.get(3)) {
                LOG.debug("Loaded rule: user: {}, network/bits: {} path: {}", new Object[]{split[user], split[cidr], split[path]});
                final Rule rule = split[cidr].trim().equals("*") ? new Rule(null, split[path]) : new Rule(new SubnetUtils(split[cidr]).getInfo(), split[path]);
                CopyOnWriteArrayList<Rule> arrayListRule = new CopyOnWriteArrayList<Rule>(){
                    {
                        this.add(rule);
                    }
                };
                this.rulemap.merge(split[user], arrayListRule, arrayListMerge);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.handleInteraction(new ServletFilterHttpInteraction(httpRequest, httpResponse, filterChain));
    }

    public void handleInteraction(HttpInteraction interaction) throws IOException, ServletException {
        String address = interaction.getRemoteAddr();
        String query = interaction.getQueryString();
        String uri = interaction.getRequestURI();
        if (!uri.startsWith("/webhdfs/v1")) {
            LOG.trace("Proceeding with interaction since the request doesn't access WebHDFS API");
            interaction.proceed();
            return;
        }
        String path = uri.substring("/webhdfs/v1".length());
        String user = interaction.getRemoteUser();
        LOG.trace("Got request user: {}, remoteIp: {}, query: {}, path: {}", new Object[]{user, address, query, path});
        boolean authenticatedQuery = Arrays.stream(Optional.ofNullable(query).orElse("").trim().split("&")).anyMatch(RESTRICTED_OPERATIONS);
        if (!interaction.isCommitted() && authenticatedQuery) {
            String[] queryParts = query.split("&");
            if (user == null) {
                LOG.trace("Looking for delegation token to identify user");
                for (String part : queryParts) {
                    if (!part.trim().startsWith("delegation=")) continue;
                    Token t = new Token();
                    t.decodeFromUrlString(part.split("=", 2)[1]);
                    ByteArrayInputStream buf = new ByteArrayInputStream(t.getIdentifier());
                    DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
                    identifier.readFields((DataInput)new DataInputStream(buf));
                    user = identifier.getUser().getUserName();
                    LOG.trace("Updated request user: {}, remoteIp: {}, query: {}, path: {}", new Object[]{user, address, query, path});
                }
            }
            if (authenticatedQuery && !this.matchRule("*", address, path) && !this.matchRule(user, address, path)) {
                LOG.trace("Rejecting interaction; no rule found");
                interaction.sendError(403, "WebHDFS is configured write-only for " + user + "@" + address + " for file: " + path);
                return;
            }
        }
        LOG.trace("Proceeding with interaction");
        interaction.proceed();
    }

    private static final class ServletFilterHttpInteraction
    implements HttpInteraction {
        private final FilterChain chain;
        private final HttpServletRequest httpRequest;
        private final HttpServletResponse httpResponse;

        public ServletFilterHttpInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) {
            this.httpRequest = httpRequest;
            this.httpResponse = httpResponse;
            this.chain = chain;
        }

        @Override
        public boolean isCommitted() {
            return this.httpResponse.isCommitted();
        }

        @Override
        public String getRemoteAddr() {
            return this.httpRequest.getRemoteAddr();
        }

        @Override
        public String getRemoteUser() {
            return this.httpRequest.getRemoteUser();
        }

        @Override
        public String getRequestURI() {
            return this.httpRequest.getRequestURI();
        }

        @Override
        public String getQueryString() {
            return this.httpRequest.getQueryString();
        }

        @Override
        public String getMethod() {
            return this.httpRequest.getMethod();
        }

        @Override
        public void proceed() throws IOException, ServletException {
            this.chain.doFilter((ServletRequest)this.httpRequest, (ServletResponse)this.httpResponse);
        }

        @Override
        public void sendError(int code, String message) throws IOException {
            this.httpResponse.sendError(code, message);
        }
    }

    private static class Rule {
        private final SubnetUtils.SubnetInfo subnet;
        private final String path;

        Rule(SubnetUtils.SubnetInfo subnet, String path) {
            this.subnet = subnet;
            this.path = path;
        }

        public SubnetUtils.SubnetInfo getSubnet() {
            return this.subnet;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static interface HttpInteraction {
        public boolean isCommitted();

        public String getRemoteAddr();

        public String getRemoteUser();

        public String getRequestURI();

        public String getQueryString();

        public String getMethod();

        public void proceed() throws IOException, ServletException;

        public void sendError(int var1, String var2) throws IOException;
    }
}

