/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.procedure2.BaseRSProcedureCallable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotRegionCallable
extends BaseRSProcedureCallable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotRegionCallable.class);
    private SnapshotProtos.SnapshotDescription snapshot;
    private RegionInfo regionInfo;
    private ForeignExceptionDispatcher monitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCall() throws Exception {
        HRegion region = this.rs.getRegion(this.regionInfo.getEncodedName());
        if (region == null) {
            throw new NotServingRegionException("snapshot=" + this.snapshot.getName() + ", region=" + this.regionInfo.getRegionNameAsString());
        }
        LOG.debug("Starting snapshot operation on {}", (Object)region);
        region.startRegionOperation(Region.Operation.SNAPSHOT);
        try {
            if (this.snapshot.getType() == SnapshotProtos.SnapshotDescription.Type.FLUSH) {
                boolean succeeded = false;
                long readPt = region.getReadPoint(IsolationLevel.READ_COMMITTED);
                int retryTimes = this.rs.getConfiguration().getInt("hbase.snapshot.flush.retryTimes", 3);
                for (int i = 0; i < retryTimes; ++i) {
                    HRegion.FlushResult res = region.flush(true);
                    if (res.getResult() == HRegion.FlushResult.Result.CANNOT_FLUSH) {
                        region.waitForFlushes();
                        if (region.getMaxFlushedSeqId() < readPt) continue;
                        succeeded = true;
                        break;
                    }
                    succeeded = true;
                    break;
                }
                if (!succeeded) {
                    throw new IOException("Unable to complete flush " + this.regionInfo.getRegionNameAsString() + " after " + retryTimes + " attempts");
                }
            }
            LOG.debug("Snapshotting region {} for {} completed.", (Object)region, (Object)this.snapshot.getName());
            region.addRegionToSnapshot(this.snapshot, this.monitor);
        }
        finally {
            LOG.debug("Closing snapshot operation on {}", (Object)region);
            region.closeRegionOperation(Region.Operation.SNAPSHOT);
        }
    }

    @Override
    protected void initParameter(byte[] parameter) throws Exception {
        MasterProcedureProtos.SnapshotRegionParameter param = MasterProcedureProtos.SnapshotRegionParameter.parseFrom(parameter);
        this.snapshot = param.getSnapshot();
        this.regionInfo = ProtobufUtil.toRegionInfo(param.getRegion());
        this.monitor = new ForeignExceptionDispatcher(this.snapshot.getName());
    }

    @Override
    public EventType getEventType() {
        return EventType.RS_SNAPSHOT_REGIONS;
    }
}

