/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.provider.AttemptingUserProvidingSaslServer;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HBaseSaslRpcServer {
    private final AttemptingUserProvidingSaslServer serverWithProvider;
    private final SaslServer saslServer;
    private CryptoAES cryptoAES;
    private final Map<String, String> saslProps;

    public HBaseSaslRpcServer(SaslServerAuthenticationProvider provider, Map<String, String> saslProps, SecretManager<TokenIdentifier> secretManager) throws IOException {
        this.serverWithProvider = provider.createServer(secretManager, saslProps);
        this.saslServer = this.serverWithProvider.getServer();
        this.saslProps = saslProps;
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.saslServer.evaluateResponse(response);
    }

    public void dispose() {
        SaslUtil.safeDispose(this.saslServer);
    }

    public void switchToCryptoAES(CryptoAES cryptoAES) {
        this.cryptoAES = cryptoAES;
    }

    public String getAttemptingUser() {
        return this.serverWithProvider.getAttemptingUser().map(Object::toString).orElse("Unknown");
    }

    public byte[] wrap(byte[] buf, int off, int len) throws SaslException {
        if (this.cryptoAES != null) {
            return this.cryptoAES.wrap(buf, off, len);
        }
        return this.saslServer.wrap(buf, off, len);
    }

    public byte[] unwrap(byte[] buf, int off, int len) throws SaslException {
        if (this.cryptoAES != null) {
            return this.cryptoAES.unwrap(buf, off, len);
        }
        return this.saslServer.unwrap(buf, off, len);
    }

    public String getNegotiatedQop() {
        return (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
    }

    public String getRequestedQop() {
        return this.saslProps.get("javax.security.sasl.qop");
    }

    public String getAuthorizationID() {
        return this.saslServer.getAuthorizationID();
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = SaslUtil.decodeIdentifier(id);
        TokenIdentifier tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause((Throwable)e);
        }
        return (T)tokenIdentifier;
    }

    public static Throwable unwrap(Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof SecretManager.InvalidToken)) continue;
            return cause;
        }
        return e;
    }
}

