/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.WALLink;
import org.apache.hadoop.hbase.io.hadoopbackport.ThrottledInputStream;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ExportSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTTLExpiredException;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class ExportSnapshot
extends AbstractHBaseTool
implements Tool {
    public static final String NAME = "exportsnapshot";
    public static final String CONF_SOURCE_PREFIX = "exportsnapshot.from.";
    public static final String CONF_DEST_PREFIX = "exportsnapshot.to.";
    private static final Logger LOG = LoggerFactory.getLogger(ExportSnapshot.class);
    private static final String MR_NUM_MAPS = "mapreduce.job.maps";
    private static final String CONF_NUM_SPLITS = "snapshot.export.format.splits";
    private static final String CONF_SNAPSHOT_NAME = "snapshot.export.format.snapshot.name";
    private static final String CONF_SNAPSHOT_DIR = "snapshot.export.format.snapshot.dir";
    private static final String CONF_FILES_USER = "snapshot.export.files.attributes.user";
    private static final String CONF_FILES_GROUP = "snapshot.export.files.attributes.group";
    private static final String CONF_FILES_MODE = "snapshot.export.files.attributes.mode";
    private static final String CONF_CHECKSUM_VERIFY = "snapshot.export.checksum.verify";
    private static final String CONF_OUTPUT_ROOT = "snapshot.export.output.root";
    private static final String CONF_INPUT_ROOT = "snapshot.export.input.root";
    private static final String CONF_BUFFER_SIZE = "snapshot.export.buffer.size";
    private static final String CONF_MAP_GROUP = "snapshot.export.default.map.group";
    private static final String CONF_BANDWIDTH_MB = "snapshot.export.map.bandwidth.mb";
    private static final String CONF_MR_JOB_NAME = "mapreduce.job.name";
    private static final String CONF_INPUT_FILE_GROUPER_CLASS = "snapshot.export.input.file.grouper.class";
    private static final String CONF_INPUT_FILE_LOCATION_RESOLVER_CLASS = "snapshot.export.input.file.location.resolver.class";
    protected static final String CONF_SKIP_TMP = "snapshot.export.skip.tmp";
    private static final String CONF_COPY_MANIFEST_THREADS = "snapshot.export.copy.references.threads";
    private static final int DEFAULT_COPY_MANIFEST_THREADS = Runtime.getRuntime().availableProcessors();
    private static final String CONF_STORAGE_POLICY = "snapshot.export.storage.policy.family";
    private boolean verifyTarget = true;
    private boolean verifySource = true;
    private boolean verifyChecksum = true;
    private String snapshotName = null;
    private String targetName = null;
    private boolean overwrite = false;
    private String filesGroup = null;
    private String filesUser = null;
    private Path outputRoot = null;
    private Path inputRoot = null;
    private int bandwidthMB = Integer.MAX_VALUE;
    private int filesMode = 0;
    private int mappers = 0;
    private boolean resetTtl = false;
    private String storagePolicy = null;
    private String customFileGrouper = null;
    private String fileLocationResolver = null;

    private static List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> getSnapshotFiles(final Configuration conf, final FileSystem fs, Path snapshotDir) throws IOException {
        SnapshotProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        final ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>> files = new ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>>();
        final TableName table = TableName.valueOf(snapshotDesc.getTable());
        LOG.info("Loading Snapshot '" + snapshotDesc.getName() + "' hfile list");
        final HashSet addedFiles = new HashSet();
        SnapshotReferenceUtil.visitReferencedFiles(conf, fs, snapshotDir, snapshotDesc, new SnapshotReferenceUtil.SnapshotVisitor(){

            @Override
            public void storeFile(RegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                Pair snapshotFileAndSize = null;
                if (!storeFile.hasReference()) {
                    String region = regionInfo.getEncodedName();
                    String hfile = storeFile.getName();
                    snapshotFileAndSize = ExportSnapshot.getSnapshotFileAndSize(fs, conf, table, region, family, hfile, storeFile.hasFileSize() ? storeFile.getFileSize() : -1L);
                } else {
                    Pair<String, String> referredToRegionAndFile = StoreFileInfo.getReferredToRegionAndFile(storeFile.getName());
                    String referencedRegion = referredToRegionAndFile.getFirst();
                    String referencedHFile = referredToRegionAndFile.getSecond();
                    snapshotFileAndSize = ExportSnapshot.getSnapshotFileAndSize(fs, conf, table, referencedRegion, family, referencedHFile, storeFile.hasFileSize() ? storeFile.getFileSize() : -1L);
                }
                String fileToExport = ((SnapshotProtos.SnapshotFileInfo)snapshotFileAndSize.getFirst()).getHfile();
                if (!addedFiles.contains(fileToExport)) {
                    files.add(snapshotFileAndSize);
                    addedFiles.add(fileToExport);
                } else {
                    LOG.debug("Skip the existing file: {}.", (Object)fileToExport);
                }
            }
        });
        return files;
    }

    private static Pair<SnapshotProtos.SnapshotFileInfo, Long> getSnapshotFileAndSize(FileSystem fs, Configuration conf, TableName table, String region, String family, String hfile, long size) throws IOException {
        Path path = HFileLink.createPath(table, region, family, hfile);
        SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile(path.toString()).build();
        if (size == -1L) {
            size = HFileLink.buildFromHFileLinkPattern(conf, path).getFileStatus(fs).getLen();
        }
        return new Pair<SnapshotProtos.SnapshotFileInfo, Long>(fileInfo, size);
    }

    static List<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> getBalancedSplits(Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>> unsortedFiles, int ngroups) {
        ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>> files = new ArrayList<Pair<SnapshotProtos.SnapshotFileInfo, Long>>(unsortedFiles);
        Collections.sort(files, new Comparator<Pair<SnapshotProtos.SnapshotFileInfo, Long>>(){

            @Override
            public int compare(Pair<SnapshotProtos.SnapshotFileInfo, Long> a, Pair<SnapshotProtos.SnapshotFileInfo, Long> b) {
                long r = a.getSecond() - b.getSecond();
                return r < 0L ? -1 : (r > 0L ? 1 : 0);
            }
        });
        LinkedList<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> fileGroups = new LinkedList<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>>();
        int hi = files.size() - 1;
        int lo = 0;
        int dir = 1;
        int g2 = 0;
        while (hi >= lo) {
            List<Pair> group;
            if (g2 == fileGroups.size()) {
                group = new LinkedList();
                fileGroups.add(group);
            } else {
                group = (List)fileGroups.get(g2);
            }
            Pair fileInfo = (Pair)files.get(hi--);
            group.add(fileInfo);
            if ((g2 += dir) == ngroups) {
                dir = -1;
                g2 = ngroups - 1;
                continue;
            }
            if (g2 >= 0) continue;
            dir = 1;
            g2 = 0;
        }
        return fileGroups;
    }

    private void runCopyJob(Path inputRoot, Path outputRoot, String snapshotName, Path snapshotDir, boolean verifyChecksum, String filesUser, String filesGroup, int filesMode, int mappers, int bandwidthMB, String storagePolicy, String customFileGrouper, String fileLocationResolver) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = this.getConf();
        if (filesGroup != null) {
            conf.set(CONF_FILES_GROUP, filesGroup);
        }
        if (filesUser != null) {
            conf.set(CONF_FILES_USER, filesUser);
        }
        if (mappers > 0) {
            conf.setInt(CONF_NUM_SPLITS, mappers);
            conf.setInt(MR_NUM_MAPS, mappers);
        }
        conf.setInt(CONF_FILES_MODE, filesMode);
        conf.setBoolean(CONF_CHECKSUM_VERIFY, verifyChecksum);
        conf.set(CONF_OUTPUT_ROOT, outputRoot.toString());
        conf.set(CONF_INPUT_ROOT, inputRoot.toString());
        conf.setInt(CONF_BANDWIDTH_MB, bandwidthMB);
        conf.set(CONF_SNAPSHOT_NAME, snapshotName);
        conf.set(CONF_SNAPSHOT_DIR, snapshotDir.toString());
        if (storagePolicy != null) {
            for (Map.Entry<String, String> entry : this.storagePolicyPerFamily(storagePolicy).entrySet()) {
                conf.set(ExportSnapshot.generateFamilyStoragePolicyKey(entry.getKey()), entry.getValue());
            }
        }
        if (customFileGrouper != null) {
            conf.set(CONF_INPUT_FILE_GROUPER_CLASS, customFileGrouper);
        }
        if (fileLocationResolver != null) {
            conf.set(CONF_INPUT_FILE_LOCATION_RESOLVER_CLASS, fileLocationResolver);
        }
        String jobname = conf.get(CONF_MR_JOB_NAME, "ExportSnapshot-" + snapshotName);
        Job job = new Job(conf);
        job.setJobName(jobname);
        job.setJarByClass(ExportSnapshot.class);
        TableMapReduceUtil.addDependencyJars(job);
        job.setMapperClass(ExportMapper.class);
        job.setInputFormatClass(ExportSnapshotInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapSpeculativeExecution(false);
        job.setNumReduceTasks(0);
        Configuration srcConf = HBaseConfiguration.createClusterConf(conf, null, CONF_SOURCE_PREFIX);
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])new Path[]{inputRoot}, (Configuration)srcConf);
        Configuration destConf = HBaseConfiguration.createClusterConf(conf, null, CONF_DEST_PREFIX);
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])new Path[]{outputRoot}, (Configuration)destConf);
        if (!job.waitForCompletion(true)) {
            throw new ExportSnapshotException(job.getStatus().getFailureInfo());
        }
    }

    private void verifySnapshot(SnapshotProtos.SnapshotDescription snapshotDesc, Configuration baseConf, FileSystem fs, Path rootDir, Path snapshotDir) throws IOException {
        Configuration conf = new Configuration(baseConf);
        CommonFSUtils.setRootDir(conf, rootDir);
        CommonFSUtils.setFsDefault(conf, CommonFSUtils.getRootDir(conf));
        boolean isExpired = SnapshotDescriptionUtils.isExpiredSnapshot(snapshotDesc.getTtl(), snapshotDesc.getCreationTime(), EnvironmentEdgeManager.currentTime());
        if (isExpired) {
            throw new SnapshotTTLExpiredException(ProtobufUtil.createSnapshotDesc(snapshotDesc));
        }
        SnapshotReferenceUtil.verifySnapshot(conf, fs, snapshotDir, snapshotDesc);
    }

    private void setConfigParallel(FileSystem outputFs, List<Path> traversedPath, BiConsumer<FileSystem, Path> task, Configuration conf) throws IOException {
        ExecutorService pool = Executors.newFixedThreadPool(conf.getInt(CONF_COPY_MANIFEST_THREADS, DEFAULT_COPY_MANIFEST_THREADS));
        ArrayList futures = new ArrayList();
        for (Path path : traversedPath) {
            Future<?> future = pool.submit(() -> task.accept(outputFs, dstPath));
            futures.add(future);
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        finally {
            pool.shutdownNow();
        }
    }

    private void setOwnerParallel(FileSystem outputFs, String filesUser, String filesGroup, Configuration conf, List<Path> traversedPath) throws IOException {
        this.setConfigParallel(outputFs, traversedPath, (fs, path) -> {
            try {
                fs.setOwner(path, filesUser, filesGroup);
            }
            catch (IOException e) {
                throw new RuntimeException("set owner for file " + path + " to " + filesUser + ":" + filesGroup + " failed", e);
            }
        }, conf);
    }

    private void setPermissionParallel(FileSystem outputFs, short filesMode, List<Path> traversedPath, Configuration conf) throws IOException {
        if (filesMode <= 0) {
            return;
        }
        FsPermission perm = new FsPermission(filesMode);
        this.setConfigParallel(outputFs, traversedPath, (fs, path) -> {
            try {
                fs.setPermission(path, perm);
            }
            catch (IOException e) {
                throw new RuntimeException("set permission for file " + path + " to " + filesMode + " failed", e);
            }
        }, conf);
    }

    private Map<String, String> storagePolicyPerFamily(String storagePolicy) {
        HashMap<String, String> familyStoragePolicy = new HashMap<String, String>();
        for (String familyConf : storagePolicy.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            familyStoragePolicy.put(familySplit[0], familySplit[1]);
        }
        return familyStoragePolicy;
    }

    private static String generateFamilyStoragePolicyKey(String family) {
        return "snapshot.export.storage.policy.family." + family;
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.snapshotName = cmd.getOptionValue(Options.SNAPSHOT.getLongOpt(), this.snapshotName);
        this.targetName = cmd.getOptionValue(Options.TARGET_NAME.getLongOpt(), this.targetName);
        if (cmd.hasOption(Options.COPY_TO.getLongOpt())) {
            this.outputRoot = new Path(cmd.getOptionValue(Options.COPY_TO.getLongOpt()));
        }
        if (cmd.hasOption(Options.COPY_FROM.getLongOpt())) {
            this.inputRoot = new Path(cmd.getOptionValue(Options.COPY_FROM.getLongOpt()));
        }
        this.mappers = this.getOptionAsInt(cmd, Options.MAPPERS.getLongOpt(), this.mappers);
        this.filesUser = cmd.getOptionValue(Options.CHUSER.getLongOpt(), this.filesUser);
        this.filesGroup = cmd.getOptionValue(Options.CHGROUP.getLongOpt(), this.filesGroup);
        this.filesMode = this.getOptionAsInt(cmd, Options.CHMOD.getLongOpt(), this.filesMode, 8);
        this.bandwidthMB = this.getOptionAsInt(cmd, Options.BANDWIDTH.getLongOpt(), this.bandwidthMB);
        this.overwrite = cmd.hasOption(Options.OVERWRITE.getLongOpt());
        this.verifyChecksum = !cmd.hasOption(Options.NO_CHECKSUM_VERIFY.getLongOpt());
        this.verifyTarget = !cmd.hasOption(Options.NO_TARGET_VERIFY.getLongOpt());
        this.verifySource = !cmd.hasOption(Options.NO_SOURCE_VERIFY.getLongOpt());
        this.resetTtl = cmd.hasOption(Options.RESET_TTL.getLongOpt());
        if (cmd.hasOption(Options.STORAGE_POLICY.getLongOpt())) {
            this.storagePolicy = cmd.getOptionValue(Options.STORAGE_POLICY.getLongOpt());
        }
        if (cmd.hasOption(Options.CUSTOM_FILE_GROUPER.getLongOpt())) {
            this.customFileGrouper = cmd.getOptionValue(Options.CUSTOM_FILE_GROUPER.getLongOpt());
        }
        if (cmd.hasOption(Options.FILE_LOCATION_RESOLVER.getLongOpt())) {
            this.fileLocationResolver = cmd.getOptionValue(Options.FILE_LOCATION_RESOLVER.getLongOpt());
        }
    }

    @Override
    public int doWork() throws IOException {
        Path initialOutputSnapshotDir;
        Path outputSnapshotDir;
        Path snapshotTmpDir;
        Path snapshotDir;
        boolean skipTmp;
        FileSystem outputFs;
        Configuration destConf;
        FileSystem inputFs;
        block36: {
            ArrayList<Path> travesedPaths;
            Path needSetOwnerDir;
            Configuration conf;
            block37: {
                conf = this.getConf();
                if (this.snapshotName == null) {
                    System.err.println("Snapshot name not provided.");
                    LOG.error("Use -h or --help for usage instructions.");
                    return 1;
                }
                if (this.outputRoot == null) {
                    System.err.println("Destination file-system (--" + Options.COPY_TO.getLongOpt() + ") not provided.");
                    LOG.error("Use -h or --help for usage instructions.");
                    return 1;
                }
                if (this.targetName == null) {
                    this.targetName = this.snapshotName;
                }
                if (this.inputRoot == null) {
                    this.inputRoot = CommonFSUtils.getRootDir(conf);
                } else {
                    CommonFSUtils.setRootDir(conf, this.inputRoot);
                }
                Configuration srcConf = HBaseConfiguration.createClusterConf(conf, null, CONF_SOURCE_PREFIX);
                inputFs = FileSystem.get((URI)this.inputRoot.toUri(), (Configuration)srcConf);
                destConf = HBaseConfiguration.createClusterConf(conf, null, CONF_DEST_PREFIX);
                outputFs = FileSystem.get((URI)this.outputRoot.toUri(), (Configuration)destConf);
                skipTmp = conf.getBoolean(CONF_SKIP_TMP, false) || conf.get("hbase.snapshot.working.dir") != null;
                snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshotName, this.inputRoot);
                snapshotTmpDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.targetName, this.outputRoot, destConf);
                outputSnapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.targetName, this.outputRoot);
                initialOutputSnapshotDir = skipTmp ? outputSnapshotDir : snapshotTmpDir;
                LOG.debug("inputFs={}, inputRoot={}", (Object)inputFs.getUri().toString(), (Object)this.inputRoot);
                LOG.debug("outputFs={}, outputRoot={}, skipTmp={}, initialOutputSnapshotDir={}", new Object[]{outputFs, this.outputRoot.toString(), skipTmp, initialOutputSnapshotDir});
                SnapshotProtos.SnapshotDescription sourceSnapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(inputFs, snapshotDir);
                if (this.verifySource) {
                    LOG.info("Verify the source snapshot's expiration status and integrity.");
                    this.verifySnapshot(sourceSnapshotDesc, srcConf, inputFs, this.inputRoot, snapshotDir);
                }
                if (outputFs.exists(needSetOwnerDir = SnapshotDescriptionUtils.getSnapshotRootDir(this.outputRoot))) {
                    if (skipTmp) {
                        needSetOwnerDir = outputSnapshotDir;
                    } else {
                        needSetOwnerDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.outputRoot, destConf);
                        if (outputFs.exists(needSetOwnerDir)) {
                            needSetOwnerDir = snapshotTmpDir;
                        }
                    }
                }
                if (outputFs.exists(outputSnapshotDir)) {
                    if (this.overwrite) {
                        if (!outputFs.delete(outputSnapshotDir, true)) {
                            System.err.println("Unable to remove existing snapshot directory: " + outputSnapshotDir);
                            return 1;
                        }
                    } else {
                        System.err.println("The snapshot '" + this.targetName + "' already exists in the destination: " + outputSnapshotDir);
                        return 1;
                    }
                }
                if (!skipTmp && outputFs.exists(snapshotTmpDir)) {
                    if (this.overwrite) {
                        if (!outputFs.delete(snapshotTmpDir, true)) {
                            System.err.println("Unable to remove existing snapshot tmp directory: " + snapshotTmpDir);
                            return 1;
                        }
                    } else {
                        System.err.println("A snapshot with the same name '" + this.targetName + "' may be in-progress");
                        System.err.println("Please check " + snapshotTmpDir + ". If the snapshot has completed, ");
                        System.err.println("consider removing " + snapshotTmpDir + " by using the -overwrite option");
                        return 1;
                    }
                }
                travesedPaths = new ArrayList();
                boolean copySucceeded = false;
                try {
                    LOG.info("Copy Snapshot Manifest from " + snapshotDir + " to " + initialOutputSnapshotDir);
                    travesedPaths = FSUtils.copyFilesParallel(inputFs, snapshotDir, outputFs, initialOutputSnapshotDir, conf, conf.getInt(CONF_COPY_MANIFEST_THREADS, DEFAULT_COPY_MANIFEST_THREADS));
                    copySucceeded = true;
                    if (!copySucceeded) break block36;
                    if (this.filesUser == null && this.filesGroup == null) break block37;
                    LOG.warn((this.filesUser == null ? "" : "Change the owner of " + needSetOwnerDir + " to " + this.filesUser) + (this.filesGroup == null ? "" : ", Change the group of " + needSetOwnerDir + " to " + this.filesGroup));
                }
                catch (IOException e) {
                    try {
                        throw new ExportSnapshotException("Failed to copy the snapshot directory: from=" + snapshotDir + " to=" + initialOutputSnapshotDir, e);
                    }
                    catch (Throwable throwable) {
                        if (copySucceeded) {
                            if (this.filesUser != null || this.filesGroup != null) {
                                LOG.warn((this.filesUser == null ? "" : "Change the owner of " + needSetOwnerDir + " to " + this.filesUser) + (this.filesGroup == null ? "" : ", Change the group of " + needSetOwnerDir + " to " + this.filesGroup));
                                this.setOwnerParallel(outputFs, this.filesUser, this.filesGroup, conf, travesedPaths);
                            }
                            if (this.filesMode > 0) {
                                LOG.warn("Change the permission of " + needSetOwnerDir + " to " + this.filesMode);
                                this.setPermissionParallel(outputFs, (short)this.filesMode, travesedPaths, conf);
                            }
                        }
                        throw throwable;
                    }
                }
                this.setOwnerParallel(outputFs, this.filesUser, this.filesGroup, conf, travesedPaths);
            }
            if (this.filesMode > 0) {
                LOG.warn("Change the permission of " + needSetOwnerDir + " to " + this.filesMode);
                this.setPermissionParallel(outputFs, (short)this.filesMode, travesedPaths, conf);
            }
        }
        if (!this.targetName.equals(this.snapshotName) || this.resetTtl) {
            SnapshotProtos.SnapshotDescription.Builder snapshotDescBuilder = SnapshotDescriptionUtils.readSnapshotInfo(inputFs, snapshotDir).toBuilder();
            if (!this.targetName.equals(this.snapshotName)) {
                snapshotDescBuilder.setName(this.targetName);
            }
            if (this.resetTtl) {
                snapshotDescBuilder.setTtl(0L);
            }
            SnapshotDescriptionUtils.writeSnapshotInfo(snapshotDescBuilder.build(), initialOutputSnapshotDir, outputFs);
            if (this.filesUser != null || this.filesGroup != null) {
                outputFs.setOwner(new Path(initialOutputSnapshotDir, ".snapshotinfo"), this.filesUser, this.filesGroup);
            }
            if (this.filesMode > 0) {
                outputFs.setPermission(new Path(initialOutputSnapshotDir, ".snapshotinfo"), new FsPermission((short)this.filesMode));
            }
        }
        try {
            this.runCopyJob(this.inputRoot, this.outputRoot, this.snapshotName, snapshotDir, this.verifyChecksum, this.filesUser, this.filesGroup, this.filesMode, this.mappers, this.bandwidthMB, this.storagePolicy, this.customFileGrouper, this.fileLocationResolver);
            LOG.info("Finalize the Snapshot Export");
            if (!skipTmp && !outputFs.rename(snapshotTmpDir, outputSnapshotDir)) {
                throw new ExportSnapshotException("Unable to rename snapshot directory from=" + snapshotTmpDir + " to=" + outputSnapshotDir);
            }
            if (this.verifyTarget) {
                LOG.info("Verify the exported snapshot's expiration status and integrity.");
                SnapshotProtos.SnapshotDescription targetSnapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(outputFs, outputSnapshotDir);
                this.verifySnapshot(targetSnapshotDesc, destConf, outputFs, this.outputRoot, outputSnapshotDir);
            }
            LOG.info("Export Completed: " + this.targetName);
            return 0;
        }
        catch (Exception e) {
            LOG.error("Snapshot export failed", (Throwable)e);
            if (!skipTmp) {
                outputFs.delete(snapshotTmpDir, true);
            }
            outputFs.delete(outputSnapshotDir, true);
            return 1;
        }
    }

    @Override
    protected void printUsage() {
        super.printUsage();
        System.out.println("\nExamples:\n  hbase snapshot export \\\n    --snapshot MySnapshot --copy-to hdfs://srv2:8082/hbase \\\n    --chuser MyUser --chgroup MyGroup --chmod 700 --mappers 16\n\n  hbase snapshot export \\\n    --snapshot MySnapshot --copy-from hdfs://srv2:8082/hbase \\\n    --copy-to hdfs://srv1:50070/hbase");
    }

    @Override
    protected void addOptions() {
        this.addRequiredOption(Options.SNAPSHOT);
        this.addOption(Options.COPY_TO);
        this.addOption(Options.COPY_FROM);
        this.addOption(Options.TARGET_NAME);
        this.addOption(Options.NO_CHECKSUM_VERIFY);
        this.addOption(Options.NO_TARGET_VERIFY);
        this.addOption(Options.NO_SOURCE_VERIFY);
        this.addOption(Options.OVERWRITE);
        this.addOption(Options.CHUSER);
        this.addOption(Options.CHGROUP);
        this.addOption(Options.CHMOD);
        this.addOption(Options.MAPPERS);
        this.addOption(Options.BANDWIDTH);
        this.addOption(Options.RESET_TTL);
        this.addOption(Options.CUSTOM_FILE_GROUPER);
        this.addOption(Options.FILE_LOCATION_RESOLVER);
    }

    public static void main(String[] args) {
        new ExportSnapshot().doStaticMain(args);
    }

    static class ExportSnapshotInputFormat
    extends InputFormat<BytesWritable, NullWritable> {
        ExportSnapshotInputFormat() {
        }

        public RecordReader<BytesWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext tac) throws IOException, InterruptedException {
            return new ExportSnapshotRecordReader(((ExportSnapshotInputSplit)split).getSplitKeys());
        }

        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            Path snapshotDir = new Path(conf.get(ExportSnapshot.CONF_SNAPSHOT_DIR));
            FileSystem fs = FileSystem.get((URI)snapshotDir.toUri(), (Configuration)conf);
            List snapshotFiles = ExportSnapshot.getSnapshotFiles(conf, fs, snapshotDir);
            Collection<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> balancedGroups = this.groupFilesForSplits(conf, snapshotFiles);
            Class fileLocationResolverClass = conf.getClass(ExportSnapshot.CONF_INPUT_FILE_LOCATION_RESOLVER_CLASS, NoopFileLocationResolver.class, FileLocationResolver.class);
            FileLocationResolver fileLocationResolver = (FileLocationResolver)ReflectionUtils.newInstance((Class)fileLocationResolverClass, (Configuration)conf);
            LOG.info("FileLocationResolver {} will provide location metadata for each InputSplit", (Object)fileLocationResolverClass);
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(balancedGroups.size());
            for (Collection collection : balancedGroups) {
                splits.add(new ExportSnapshotInputSplit(collection, fileLocationResolver));
            }
            return splits;
        }

        Collection<List<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> groupFilesForSplits(Configuration conf, List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> snapshotFiles) {
            int mappers = conf.getInt(ExportSnapshot.CONF_NUM_SPLITS, 0);
            if (mappers == 0 && !snapshotFiles.isEmpty()) {
                mappers = 1 + snapshotFiles.size() / conf.getInt(ExportSnapshot.CONF_MAP_GROUP, 10);
                mappers = Math.min(mappers, snapshotFiles.size());
                conf.setInt(ExportSnapshot.CONF_NUM_SPLITS, mappers);
                conf.setInt(ExportSnapshot.MR_NUM_MAPS, mappers);
            }
            Class inputFileGrouperClass = conf.getClass(ExportSnapshot.CONF_INPUT_FILE_GROUPER_CLASS, NoopCustomFileGrouper.class, CustomFileGrouper.class);
            CustomFileGrouper customFileGrouper = (CustomFileGrouper)ReflectionUtils.newInstance((Class)inputFileGrouperClass, (Configuration)conf);
            Collection<Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> groups = customFileGrouper.getGroupedInputFiles(snapshotFiles);
            LOG.info("CustomFileGrouper {} split input files into {} groups", (Object)inputFileGrouperClass, (Object)groups.size());
            int mappersPerGroup = groups.isEmpty() ? 1 : Math.max(mappers / groups.size(), 1);
            LOG.info("Splitting each group into {} InputSplits, to achieve closest possible amount of mappers to target of {}", (Object)mappersPerGroup, (Object)mappers);
            return groups.stream().map(g2 -> ExportSnapshot.getBalancedSplits(g2, mappersPerGroup)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private static class ExportSnapshotRecordReader
        extends RecordReader<BytesWritable, NullWritable> {
            private final List<Pair<BytesWritable, Long>> files;
            private long totalSize = 0L;
            private long procSize = 0L;
            private int index = -1;

            ExportSnapshotRecordReader(List<Pair<BytesWritable, Long>> files) {
                this.files = files;
                for (Pair<BytesWritable, Long> fileInfo : files) {
                    this.totalSize += fileInfo.getSecond().longValue();
                }
            }

            public void close() {
            }

            public BytesWritable getCurrentKey() {
                return this.files.get(this.index).getFirst();
            }

            public NullWritable getCurrentValue() {
                return NullWritable.get();
            }

            public float getProgress() {
                return (float)this.procSize / (float)this.totalSize;
            }

            public void initialize(InputSplit split, TaskAttemptContext tac) {
            }

            public boolean nextKeyValue() {
                if (this.index >= 0) {
                    this.procSize += this.files.get(this.index).getSecond().longValue();
                }
                return ++this.index < this.files.size();
            }
        }

        static class ExportSnapshotInputSplit
        extends InputSplit
        implements Writable {
            private List<Pair<BytesWritable, Long>> files;
            private String[] locations;
            private long length;

            public ExportSnapshotInputSplit() {
                this.files = null;
                this.locations = null;
            }

            public ExportSnapshotInputSplit(Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>> snapshotFiles, FileLocationResolver fileLocationResolver) {
                this.files = new ArrayList<Pair<BytesWritable, Long>>(snapshotFiles.size());
                for (Pair<SnapshotProtos.SnapshotFileInfo, Long> fileInfo : snapshotFiles) {
                    this.files.add(new Pair<BytesWritable, Long>(new BytesWritable(fileInfo.getFirst().toByteArray()), fileInfo.getSecond()));
                    this.length += fileInfo.getSecond().longValue();
                }
                this.locations = fileLocationResolver.getLocationsForInputFiles(snapshotFiles).toArray(new String[0]);
                LOG.trace("This ExportSnapshotInputSplit has files {} of collective size {}, with location hints: {}", new Object[]{this.files, this.length, this.locations});
            }

            private List<Pair<BytesWritable, Long>> getSplitKeys() {
                return this.files;
            }

            public long getLength() throws IOException, InterruptedException {
                return this.length;
            }

            public String[] getLocations() throws IOException, InterruptedException {
                return this.locations;
            }

            public void readFields(DataInput in) throws IOException {
                int count = in.readInt();
                this.files = new ArrayList<Pair<BytesWritable, Long>>(count);
                this.length = 0L;
                for (int i = 0; i < count; ++i) {
                    BytesWritable fileInfo = new BytesWritable();
                    fileInfo.readFields(in);
                    long size = in.readLong();
                    this.files.add(new Pair<BytesWritable, Long>(fileInfo, size));
                    this.length += size;
                }
                int locationCount = in.readInt();
                ArrayList<String> locations = new ArrayList<String>(locationCount);
                for (int i = 0; i < locationCount; ++i) {
                    locations.add(in.readUTF());
                }
                this.locations = locations.toArray(new String[0]);
            }

            public void write(DataOutput out) throws IOException {
                out.writeInt(this.files.size());
                for (Pair<BytesWritable, Long> fileInfo : this.files) {
                    fileInfo.getFirst().write(out);
                    out.writeLong(fileInfo.getSecond());
                }
                out.writeInt(this.locations.length);
                for (String location : this.locations) {
                    out.writeUTF(location);
                }
            }
        }
    }

    private static class ExportMapper
    extends Mapper<BytesWritable, NullWritable, NullWritable, NullWritable> {
        private static final Logger LOG = LoggerFactory.getLogger(ExportMapper.class);
        static final int REPORT_SIZE = 0x100000;
        static final int BUFFER_SIZE = 65536;
        private boolean verifyChecksum;
        private String filesGroup;
        private String filesUser;
        private short filesMode;
        private int bufferSize;
        private FileSystem outputFs;
        private Path outputArchive;
        private Path outputRoot;
        private FileSystem inputFs;
        private Path inputArchive;
        private Path inputRoot;
        private static Testing testing = new Testing();

        private ExportMapper() {
        }

        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            Configuration srcConf = HBaseConfiguration.createClusterConf(conf, null, ExportSnapshot.CONF_SOURCE_PREFIX);
            Configuration destConf = HBaseConfiguration.createClusterConf(conf, null, ExportSnapshot.CONF_DEST_PREFIX);
            this.verifyChecksum = conf.getBoolean(ExportSnapshot.CONF_CHECKSUM_VERIFY, true);
            this.filesGroup = conf.get(ExportSnapshot.CONF_FILES_GROUP);
            this.filesUser = conf.get(ExportSnapshot.CONF_FILES_USER);
            this.filesMode = (short)conf.getInt(ExportSnapshot.CONF_FILES_MODE, 0);
            this.outputRoot = new Path(conf.get(ExportSnapshot.CONF_OUTPUT_ROOT));
            this.inputRoot = new Path(conf.get(ExportSnapshot.CONF_INPUT_ROOT));
            this.inputArchive = new Path(this.inputRoot, "archive");
            this.outputArchive = new Path(this.outputRoot, "archive");
            try {
                this.inputFs = FileSystem.get((URI)this.inputRoot.toUri(), (Configuration)srcConf);
            }
            catch (IOException e) {
                throw new IOException("Could not get the input FileSystem with root=" + this.inputRoot, e);
            }
            try {
                this.outputFs = FileSystem.get((URI)this.outputRoot.toUri(), (Configuration)destConf);
            }
            catch (IOException e) {
                throw new IOException("Could not get the output FileSystem with root=" + this.outputRoot, e);
            }
            int defaultBlockSize = Math.max((int)this.outputFs.getDefaultBlockSize(this.outputRoot), 65536);
            this.bufferSize = conf.getInt(ExportSnapshot.CONF_BUFFER_SIZE, defaultBlockSize);
            LOG.info("Using bufferSize=" + Strings.humanReadableInt(this.bufferSize));
            for (Counter c : Counter.values()) {
                context.getCounter((Enum)c).increment(0L);
            }
            if (context.getConfiguration().getBoolean("test.snapshot.export.failure", false)) {
                ExportMapper.testing.failuresCountToInject = conf.getInt("test.snapshot.export.failure.count", 0);
                ExportMapper.testing.injectedFailureCount = context.getTaskAttemptID().getId();
            }
        }

        public void map(BytesWritable key, NullWritable value, Mapper.Context context) throws InterruptedException, IOException {
            SnapshotProtos.SnapshotFileInfo inputInfo = SnapshotProtos.SnapshotFileInfo.parseFrom(key.copyBytes());
            Path outputPath = this.getOutputPath(inputInfo);
            this.copyFile(context, inputInfo, outputPath);
        }

        private Path getOutputPath(SnapshotProtos.SnapshotFileInfo inputInfo) throws IOException {
            Path path = null;
            switch (inputInfo.getType()) {
                case HFILE: {
                    Path inputPath = new Path(inputInfo.getHfile());
                    String family = inputPath.getParent().getName();
                    TableName table = HFileLink.getReferencedTableName(inputPath.getName());
                    String region = HFileLink.getReferencedRegionName(inputPath.getName());
                    String hfile = HFileLink.getReferencedHFileName(inputPath.getName());
                    path = new Path(CommonFSUtils.getTableDir(new Path("./"), table), new Path(region, new Path(family, hfile)));
                    break;
                }
                case WAL: {
                    LOG.warn("snapshot does not keeps WALs: " + inputInfo);
                    break;
                }
                default: {
                    throw new IOException("Invalid File Type: " + inputInfo.getType().toString());
                }
            }
            return new Path(this.outputArchive, path);
        }

        private void injectTestFailure(Mapper.Context context, SnapshotProtos.SnapshotFileInfo inputInfo) throws IOException {
            if (!context.getConfiguration().getBoolean("test.snapshot.export.failure", false)) {
                return;
            }
            if (ExportMapper.testing.injectedFailureCount >= ExportMapper.testing.failuresCountToInject) {
                return;
            }
            ++ExportMapper.testing.injectedFailureCount;
            context.getCounter((Enum)Counter.COPY_FAILED).increment(1L);
            LOG.debug("Injecting failure. Count: " + ExportMapper.testing.injectedFailureCount);
            throw new IOException(String.format("TEST FAILURE (%d of max %d): Unable to copy input=%s", ExportMapper.testing.injectedFailureCount, ExportMapper.testing.failuresCountToInject, inputInfo));
        }

        private void copyFile(Mapper.Context context, SnapshotProtos.SnapshotFileInfo inputInfo, Path outputPath) throws IOException {
            FileStatus outputStat;
            FileStatus inputStat = this.getSourceFileStatus(context, inputInfo);
            if (this.outputFs.exists(outputPath) && (outputStat = this.outputFs.getFileStatus(outputPath)) != null && this.sameFile(inputStat, outputStat)) {
                LOG.info("Skip copy " + inputStat.getPath() + " to " + outputPath + ", same file.");
                context.getCounter((Enum)Counter.FILES_SKIPPED).increment(1L);
                context.getCounter((Enum)Counter.BYTES_SKIPPED).increment(inputStat.getLen());
                return;
            }
            Object in = this.openSourceFile(context, inputInfo);
            int bandwidthMB = context.getConfiguration().getInt(ExportSnapshot.CONF_BANDWIDTH_MB, 100);
            if (Integer.MAX_VALUE != bandwidthMB) {
                in = new ThrottledInputStream(new BufferedInputStream((InputStream)in), (long)(bandwidthMB * 1024) * 1024L);
            }
            Path inputPath = inputStat.getPath();
            try {
                context.getCounter((Enum)Counter.BYTES_EXPECTED).increment(inputStat.getLen());
                this.createOutputPath(outputPath.getParent());
                String family = new Path(inputInfo.getHfile()).getParent().getName();
                String familyStoragePolicy = ExportSnapshot.generateFamilyStoragePolicyKey(family);
                if (this.stringIsNotEmpty(context.getConfiguration().get(familyStoragePolicy))) {
                    String key = context.getConfiguration().get(familyStoragePolicy);
                    LOG.info("Setting storage policy {} for {}", (Object)key, (Object)outputPath.getParent());
                    this.outputFs.setStoragePolicy(outputPath.getParent(), key);
                }
                FSDataOutputStream out = this.outputFs.create(outputPath, true);
                long stime = EnvironmentEdgeManager.currentTime();
                long totalBytesWritten = this.copyData(context, inputPath, (InputStream)in, outputPath, out, inputStat.getLen());
                this.verifyCopyResult(inputStat, this.outputFs.getFileStatus(outputPath));
                long etime = EnvironmentEdgeManager.currentTime();
                LOG.info("copy completed for input=" + inputPath + " output=" + outputPath);
                LOG.info("size=" + totalBytesWritten + " (" + Strings.humanReadableInt(totalBytesWritten) + ") time=" + StringUtils.formatTimeDiff((long)etime, (long)stime) + String.format(" %.3fM/sec", (double)totalBytesWritten / ((double)(etime - stime) / 1000.0) / 1048576.0));
                context.getCounter((Enum)Counter.FILES_COPIED).increment(1L);
                if (!this.preserveAttributes(outputPath, inputStat)) {
                    LOG.warn("You may have to run manually chown on: " + outputPath);
                }
            }
            catch (IOException e) {
                LOG.error("Error copying " + inputPath + " to " + outputPath, (Throwable)e);
                context.getCounter((Enum)Counter.COPY_FAILED).increment(1L);
                throw e;
            }
            finally {
                this.injectTestFailure(context, inputInfo);
            }
        }

        private void createOutputPath(Path path) throws IOException {
            if (this.filesUser == null && this.filesGroup == null) {
                this.outputFs.mkdirs(path);
            } else {
                Path parent = path.getParent();
                if (!this.outputFs.exists(parent) && !parent.isRoot()) {
                    this.createOutputPath(parent);
                }
                this.outputFs.mkdirs(path);
                if (this.filesUser != null || this.filesGroup != null) {
                    this.outputFs.setOwner(path, this.filesUser, this.filesGroup);
                }
                if (this.filesMode > 0) {
                    this.outputFs.setPermission(path, new FsPermission(this.filesMode));
                }
            }
        }

        private boolean preserveAttributes(Path path, FileStatus refStat) {
            String group;
            FileStatus stat;
            try {
                stat = this.outputFs.getFileStatus(path);
            }
            catch (IOException e) {
                LOG.warn("Unable to get the status for file=" + path);
                return false;
            }
            try {
                if (this.filesMode > 0 && stat.getPermission().toShort() != this.filesMode) {
                    this.outputFs.setPermission(path, new FsPermission(this.filesMode));
                } else if (refStat != null && !stat.getPermission().equals((Object)refStat.getPermission())) {
                    this.outputFs.setPermission(path, refStat.getPermission());
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to set the permission for file=" + stat.getPath() + ": " + e.getMessage());
                return false;
            }
            boolean hasRefStat = refStat != null;
            String user = this.stringIsNotEmpty(this.filesUser) || !hasRefStat ? this.filesUser : refStat.getOwner();
            String string = group = this.stringIsNotEmpty(this.filesGroup) || !hasRefStat ? this.filesGroup : refStat.getGroup();
            if (this.stringIsNotEmpty(user) || this.stringIsNotEmpty(group)) {
                try {
                    if (!user.equals(stat.getOwner()) || !group.equals(stat.getGroup())) {
                        this.outputFs.setOwner(path, user, group);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Unable to set the owner/group for file=" + stat.getPath() + ": " + e.getMessage());
                    LOG.warn("The user/group may not exist on the destination cluster: user=" + user + " group=" + group);
                    return false;
                }
            }
            return true;
        }

        private boolean stringIsNotEmpty(String str) {
            return str != null && !str.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long copyData(Mapper.Context context, Path inputPath, InputStream in, Path outputPath, FSDataOutputStream out, long inputFileSize) throws IOException {
            String statusMessage = "copied %s/" + Strings.humanReadableInt(inputFileSize) + " (%.1f%%)";
            try {
                int bytesRead;
                byte[] buffer = new byte[this.bufferSize];
                long totalBytesWritten = 0L;
                int reportBytes = 0;
                while ((bytesRead = in.read(buffer)) > 0) {
                    out.write(buffer, 0, bytesRead);
                    totalBytesWritten += (long)bytesRead;
                    if ((reportBytes += bytesRead) < 0x100000) continue;
                    context.getCounter((Enum)Counter.BYTES_COPIED).increment((long)reportBytes);
                    context.setStatus(String.format(statusMessage, Strings.humanReadableInt(totalBytesWritten), Float.valueOf((float)totalBytesWritten / (float)inputFileSize * 100.0f)) + " from " + inputPath + " to " + outputPath);
                    reportBytes = 0;
                }
                context.getCounter((Enum)Counter.BYTES_COPIED).increment((long)reportBytes);
                context.setStatus(String.format(statusMessage, Strings.humanReadableInt(totalBytesWritten), Float.valueOf((float)totalBytesWritten / (float)inputFileSize * 100.0f)) + " from " + inputPath + " to " + outputPath);
                long l = totalBytesWritten;
                return l;
            }
            finally {
                out.close();
                in.close();
            }
        }

        private FSDataInputStream openSourceFile(Mapper.Context context, SnapshotProtos.SnapshotFileInfo fileInfo) throws IOException {
            try {
                Configuration conf = context.getConfiguration();
                FileLink link = null;
                switch (fileInfo.getType()) {
                    case HFILE: {
                        Path inputPath = new Path(fileInfo.getHfile());
                        link = this.getFileLink(inputPath, conf);
                        break;
                    }
                    case WAL: {
                        String serverName = fileInfo.getWalServer();
                        String logName = fileInfo.getWalName();
                        link = new WALLink(this.inputRoot, serverName, logName);
                        break;
                    }
                    default: {
                        throw new IOException("Invalid File Type: " + fileInfo.getType().toString());
                    }
                }
                return link.open(this.inputFs);
            }
            catch (IOException e) {
                context.getCounter((Enum)Counter.MISSING_FILES).increment(1L);
                LOG.error("Unable to open source file=" + fileInfo.toString(), (Throwable)e);
                throw e;
            }
        }

        private FileStatus getSourceFileStatus(Mapper.Context context, SnapshotProtos.SnapshotFileInfo fileInfo) throws IOException {
            try {
                Configuration conf = context.getConfiguration();
                FileLink link = null;
                switch (fileInfo.getType()) {
                    case HFILE: {
                        Path inputPath = new Path(fileInfo.getHfile());
                        link = this.getFileLink(inputPath, conf);
                        break;
                    }
                    case WAL: {
                        link = new WALLink(this.inputRoot, fileInfo.getWalServer(), fileInfo.getWalName());
                        break;
                    }
                    default: {
                        throw new IOException("Invalid File Type: " + fileInfo.getType().toString());
                    }
                }
                return link.getFileStatus(this.inputFs);
            }
            catch (FileNotFoundException e) {
                context.getCounter((Enum)Counter.MISSING_FILES).increment(1L);
                LOG.error("Unable to get the status for source file=" + fileInfo.toString(), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                LOG.error("Unable to get the status for source file=" + fileInfo.toString(), (Throwable)e);
                throw e;
            }
        }

        private FileLink getFileLink(Path path, Configuration conf) throws IOException {
            String regionName = HFileLink.getReferencedRegionName(path.getName());
            TableName tableName = HFileLink.getReferencedTableName(path.getName());
            if (MobUtils.getMobRegionInfo(tableName).getEncodedName().equals(regionName)) {
                return HFileLink.buildFromHFileLinkPattern(MobUtils.getQualifiedMobRootDir(conf), HFileArchiveUtil.getArchivePath(conf), path);
            }
            return HFileLink.buildFromHFileLinkPattern(this.inputRoot, this.inputArchive, path);
        }

        private FileChecksum getFileChecksum(FileSystem fs, Path path) {
            try {
                return fs.getFileChecksum(path);
            }
            catch (IOException e) {
                LOG.warn("Unable to get checksum for file=" + path, (Throwable)e);
                return null;
            }
        }

        private void verifyCopyResult(FileStatus inputStat, FileStatus outputStat) throws IOException {
            FileChecksum outChecksum;
            FileChecksum inChecksum;
            ChecksumComparison checksumComparison;
            long inputLen = inputStat.getLen();
            long outputLen = outputStat.getLen();
            Path inputPath = inputStat.getPath();
            Path outputPath = outputStat.getPath();
            if (inputLen != outputLen) {
                throw new IOException("Mismatch in length of input:" + inputPath + " (" + inputLen + ") and output:" + outputPath + " (" + outputLen + ")");
            }
            if (inputLen != 0L && this.verifyChecksum && !(checksumComparison = this.verifyChecksum(inChecksum = this.getFileChecksum(this.inputFs, inputStat.getPath()), outChecksum = this.getFileChecksum(this.outputFs, outputStat.getPath()))).equals((Object)ChecksumComparison.TRUE)) {
                String outputScheme;
                StringBuilder errMessage = new StringBuilder("Checksum mismatch between ").append(inputPath).append(" and ").append(outputPath).append(".");
                boolean addSkipHint = false;
                String inputScheme = this.inputFs.getScheme();
                if (!inputScheme.equals(outputScheme = this.outputFs.getScheme())) {
                    errMessage.append(" Input and output filesystems are of different types.\n").append("Their checksum algorithms may be incompatible.");
                    addSkipHint = true;
                } else if (inputStat.getBlockSize() != outputStat.getBlockSize()) {
                    errMessage.append(" Input and output differ in block-size.");
                    addSkipHint = true;
                } else if (inChecksum != null && outChecksum != null && !inChecksum.getAlgorithmName().equals(outChecksum.getAlgorithmName())) {
                    errMessage.append(" Input and output checksum algorithms are of different types.");
                    addSkipHint = true;
                }
                if (addSkipHint) {
                    errMessage.append(" You can choose file-level checksum validation via -Ddfs.checksum.combine.mode=COMPOSITE_CRC when block-sizes or filesystems are different.\n").append(" Or you can skip checksum-checks altogether with -no-checksum-verify,").append(" for the table backup scenario, you should use -i option to skip checksum-checks.\n").append(" (NOTE: By skipping checksums, one runs the risk of masking data-corruption during file-transfer.)\n");
                }
                throw new IOException(errMessage.toString());
            }
        }

        private ChecksumComparison verifyChecksum(FileChecksum inChecksum, FileChecksum outChecksum) {
            if (inChecksum == null || outChecksum == null || !inChecksum.getAlgorithmName().equals(outChecksum.getAlgorithmName())) {
                return ChecksumComparison.INCOMPATIBLE;
            }
            if (inChecksum.equals((Object)outChecksum)) {
                return ChecksumComparison.TRUE;
            }
            return ChecksumComparison.FALSE;
        }

        private boolean sameFile(FileStatus inputStat, FileStatus outputStat) {
            if (inputStat.getLen() != outputStat.getLen()) {
                return false;
            }
            if (!this.verifyChecksum) {
                return true;
            }
            FileChecksum inChecksum = this.getFileChecksum(this.inputFs, inputStat.getPath());
            if (inChecksum == null) {
                return false;
            }
            FileChecksum outChecksum = this.getFileChecksum(this.outputFs, outputStat.getPath());
            if (outChecksum == null) {
                return false;
            }
            return inChecksum.equals((Object)outChecksum);
        }
    }

    static class NoopFileLocationResolver
    implements FileLocationResolver {
        NoopFileLocationResolver() {
        }

        @Override
        public Set<String> getLocationsForInputFiles(Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>> files) {
            return ImmutableSet.of();
        }
    }

    @InterfaceAudience.Public
    public static interface FileLocationResolver {
        public Set<String> getLocationsForInputFiles(Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>> var1);
    }

    private static class NoopCustomFileGrouper
    implements CustomFileGrouper {
        private NoopCustomFileGrouper() {
        }

        @Override
        public Collection<Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> getGroupedInputFiles(Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>> snapshotFiles) {
            return ImmutableList.of(snapshotFiles);
        }
    }

    @InterfaceAudience.Public
    public static interface CustomFileGrouper {
        public Collection<Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>>> getGroupedInputFiles(Collection<Pair<SnapshotProtos.SnapshotFileInfo, Long>> var1);
    }

    public static enum ChecksumComparison {
        TRUE,
        FALSE,
        INCOMPATIBLE;

    }

    public static enum Counter {
        MISSING_FILES,
        FILES_COPIED,
        FILES_SKIPPED,
        COPY_FAILED,
        BYTES_EXPECTED,
        BYTES_SKIPPED,
        BYTES_COPIED;

    }

    static final class Options {
        static final Option SNAPSHOT = new Option(null, "snapshot", true, "Snapshot to restore.");
        static final Option TARGET_NAME = new Option(null, "target", true, "Target name for the snapshot.");
        static final Option COPY_TO = new Option(null, "copy-to", true, "Remote destination hdfs://");
        static final Option COPY_FROM = new Option(null, "copy-from", true, "Input folder hdfs:// (default hbase.rootdir)");
        static final Option NO_CHECKSUM_VERIFY = new Option(null, "no-checksum-verify", false, "Do not verify checksum, use name+length only.");
        static final Option NO_TARGET_VERIFY = new Option(null, "no-target-verify", false, "Do not verify the exported snapshot's expiration status and integrity.");
        static final Option NO_SOURCE_VERIFY = new Option(null, "no-source-verify", false, "Do not verify the source snapshot's expiration status and integrity.");
        static final Option OVERWRITE = new Option(null, "overwrite", false, "Rewrite the snapshot manifest if already exists.");
        static final Option CHUSER = new Option(null, "chuser", true, "Change the owner of the files to the specified one.");
        static final Option CHGROUP = new Option(null, "chgroup", true, "Change the group of the files to the specified one.");
        static final Option CHMOD = new Option(null, "chmod", true, "Change the permission of the files to the specified one.");
        static final Option MAPPERS = new Option(null, "mappers", true, "Number of mappers to use during the copy (mapreduce.job.maps). If you provide a --custom-file-grouper, then --mappers is interpreted as the number of mappers per group.");
        static final Option BANDWIDTH = new Option(null, "bandwidth", true, "Limit bandwidth to this value in MB/second.");
        static final Option RESET_TTL = new Option(null, "reset-ttl", false, "Do not copy TTL for the snapshot");
        static final Option STORAGE_POLICY = new Option(null, "storage-policy", true, "Storage policy for export snapshot output directory, with format like: f=HOT&g=ALL_SDD");
        static final Option CUSTOM_FILE_GROUPER = new Option(null, "custom-file-grouper", true, "Fully qualified class name of an implementation of ExportSnapshot.CustomFileGrouper. See JavaDoc on that class for more information.");
        static final Option FILE_LOCATION_RESOLVER = new Option(null, "file-location-resolver", true, "Fully qualified class name of an implementation of ExportSnapshot.FileLocationResolver. See JavaDoc on that class for more information.");

        Options() {
        }
    }

    static class Testing {
        static final String CONF_TEST_FAILURE = "test.snapshot.export.failure";
        static final String CONF_TEST_FAILURE_COUNT = "test.snapshot.export.failure.count";
        int failuresCountToInject = 0;
        int injectedFailureCount = 0;

        Testing() {
        }
    }
}

