/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.extras.extended.CertGenerationRequest;
import org.apache.directory.api.util.Strings;

public class CertGenerationObject
extends AbstractAsn1Object {
    private CertGenerationRequest request;
    private int requestLength = 0;

    public CertGenerationObject(CertGenerationRequest request) {
        this.request = request;
    }

    public int computeLength() {
        int len = Strings.getBytesUtf8((String)this.request.getTargetDN()).length;
        this.requestLength = 1 + BerValue.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.request.getIssuerDN()).length;
        this.requestLength += 1 + BerValue.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.request.getSubjectDN()).length;
        this.requestLength += 1 + BerValue.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.request.getKeyAlgorithm()).length;
        this.requestLength += 1 + BerValue.getNbBytes((int)len) + len;
        return 1 + BerValue.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(BerValue.getBytes((int)this.requestLength));
        BerValue.encode((ByteBuffer)bb, (String)this.request.getTargetDN());
        BerValue.encode((ByteBuffer)bb, (String)this.request.getIssuerDN());
        BerValue.encode((ByteBuffer)bb, (String)this.request.getSubjectDN());
        BerValue.encode((ByteBuffer)bb, (String)this.request.getKeyAlgorithm());
        return bb;
    }
}

