/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestShortCircuitGet {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestShortCircuitGet.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static final byte[] VALUE = Bytes.toBytes((String)"testValue");
    static final byte[] r0 = Bytes.toBytes((String)"row-0");
    static final byte[] r1 = Bytes.toBytes((String)"row-1");
    static final byte[] r2 = Bytes.toBytes((String)"row-2");
    static final byte[] r3 = Bytes.toBytes((String)"row-3");
    static final byte[] r4 = Bytes.toBytes((String)"row-4");
    static final byte[] r5 = Bytes.toBytes((String)"row-5");
    static final byte[] r6 = Bytes.toBytes((String)"row-6");
    static final TableName tableName = TableName.valueOf((String)"TestShortCircuitGet");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.rpc.timeout", 1800000);
        conf.setInt("hbase.client.scanner.timeout.period", 1800000);
        conf.setInt("hbase.client.operation.timeout", 3600000);
        conf.setStrings("hbase.regionserver.impl", new String[]{MyRegionServer.class.getName()});
        conf.setInt("hbase.client.retries.number", 1);
        conf.setInt("hbase.client.pause", 10000);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScannerCloseWhenScanAndGetInCP() throws Exception {
        try (Table table = null;){
            table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, 1, 65536, MyScanObserver.class.getName());
            this.putToTable(table, r0);
            this.putToTable(table, r1);
            this.putToTable(table, r2);
            this.putToTable(table, r3);
            this.putToTable(table, r4);
            this.putToTable(table, r5);
            this.putToTable(table, r6);
        }
        Configuration conf = TEST_UTIL.getConfiguration();
        ResultScanner resultScanner = null;
        Connection conn = null;
        Table clientTable = null;
        try {
            conn = ConnectionFactory.createConnection((Configuration)conf);
            clientTable = conn.getTable(tableName);
            Scan scan = new Scan();
            scan.setCaching(1);
            scan.withStartRow(r0, true).withStopRow(r1, true);
            resultScanner = table.getScanner(scan);
            Result result = resultScanner.next();
            Assert.assertTrue((String)"Expected row: row-0", (boolean)Bytes.equals((byte[])r0, (byte[])result.getRow()));
            result = resultScanner.next();
            Assert.assertTrue((String)"Expected row: row-1", (boolean)Bytes.equals((byte[])r1, (byte[])result.getRow()));
            Assert.assertNull((Object)resultScanner.next());
        }
        finally {
            if (resultScanner != null) {
                resultScanner.close();
            }
            if (clientTable != null) {
                clientTable.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        Assert.assertTrue((MyRSRpcServices.exceptionRef.get() == null ? 1 : 0) != 0);
        Assert.assertTrue((MyScanObserver.exceptionRef.get() == null ? 1 : 0) != 0);
    }

    private void putToTable(Table ht, byte[] rowkey) throws IOException {
        Put put = new Put(rowkey);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
    }

    public static class MyScanObserver
    implements RegionCoprocessor,
    RegionObserver {
        private static volatile boolean inCP = false;
        private static AtomicReference<Throwable> exceptionRef = new AtomicReference<Object>(null);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> observerContext, Scan scan, RegionScanner regionScanner) throws IOException {
            if (inCP) {
                return regionScanner;
            }
            HRegion region = (HRegion)((RegionCoprocessorEnvironment)observerContext.getEnvironment()).getRegion();
            int prevScannerCount = region.scannerReadPoints.size();
            Table table1 = null;
            Get get2 = new Get(r2);
            inCP = true;
            try (Connection connection = ((RegionCoprocessorEnvironment)observerContext.getEnvironment()).createConnection(((RegionCoprocessorEnvironment)observerContext.getEnvironment()).getConfiguration());){
                try {
                    table1 = connection.getTable(tableName);
                    Result result = table1.get(get2);
                    Assert.assertTrue((String)"Expected row: row-2", (boolean)Bytes.equals((byte[])r2, (byte[])result.getRow()));
                }
                finally {
                    if (table1 != null) {
                        table1.close();
                    }
                    inCP = false;
                }
                Assert.assertTrue((prevScannerCount == region.scannerReadPoints.size() ? 1 : 0) != 0);
                ServerCall serverCall = (ServerCall)RpcServer.getCurrentCall().get();
                Assert.assertTrue((serverCall.getCallBack() == null ? 1 : 0) != 0);
                Get get3 = new Get(r3);
                Get get4 = new Get(r4);
                Table table2 = null;
                inCP = true;
                try {
                    table2 = connection.getTable(tableName);
                    Result[] results = table2.get(Arrays.asList(get3, get4));
                    Assert.assertTrue((String)"Expected row: row-3", (boolean)Bytes.equals((byte[])r3, (byte[])results[0].getRow()));
                    Assert.assertTrue((String)"Expected row: row-4", (boolean)Bytes.equals((byte[])r4, (byte[])results[1].getRow()));
                }
                finally {
                    if (table2 != null) {
                        table2.close();
                    }
                    inCP = false;
                }
                Assert.assertTrue((prevScannerCount == region.scannerReadPoints.size() ? 1 : 0) != 0);
                serverCall = (ServerCall)RpcServer.getCurrentCall().get();
                Assert.assertTrue((serverCall.getCallBack() == null ? 1 : 0) != 0);
                Scan newScan = new Scan();
                newScan.setCaching(1);
                newScan.withStartRow(r5, true).withStopRow(r6, true);
                Table table3 = null;
                ResultScanner resultScanner = null;
                inCP = true;
                try {
                    table3 = connection.getTable(tableName);
                    resultScanner = table3.getScanner(newScan);
                    Result result = resultScanner.next();
                    Assert.assertTrue((String)"Expected row: row-5", (boolean)Bytes.equals((byte[])r5, (byte[])result.getRow()));
                    result = resultScanner.next();
                    Assert.assertTrue((String)"Expected row: row-6", (boolean)Bytes.equals((byte[])r6, (byte[])result.getRow()));
                    result = resultScanner.next();
                    Assert.assertNull((Object)result);
                }
                finally {
                    if (resultScanner != null) {
                        resultScanner.close();
                    }
                    if (table3 != null) {
                        table3.close();
                    }
                    inCP = false;
                }
                Assert.assertTrue((prevScannerCount == region.scannerReadPoints.size() ? 1 : 0) != 0);
                serverCall = (ServerCall)RpcServer.getCurrentCall().get();
                Assert.assertTrue((serverCall.getCallBack() == null ? 1 : 0) != 0);
                RegionScanner regionScanner2 = regionScanner;
                return regionScanner2;
            }
            catch (Throwable e) {
                exceptionRef.set(e);
                throw e;
            }
        }
    }

    private static class MyRSRpcServices
    extends RSRpcServices {
        private static AtomicReference<Throwable> exceptionRef = new AtomicReference<Object>(null);

        public MyRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
            try {
                if (!MyScanObserver.inCP) {
                    return super.multi(rpcc, request);
                }
                Assert.assertTrue((!RpcServer.getCurrentCall().isPresent() ? 1 : 0) != 0);
                return super.multi(rpcc, request);
            }
            catch (Throwable e) {
                exceptionRef.set(e);
                throw new ServiceException(e);
            }
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            try {
                if (!MyScanObserver.inCP) {
                    return super.scan(controller, request);
                }
                HRegion region = null;
                if (request.hasRegion()) {
                    region = this.getRegion(request.getRegion());
                }
                if (region != null && TableName.isMetaTableName((TableName)region.getTableDescriptor().getTableName())) {
                    return super.scan(controller, request);
                }
                Assert.assertTrue((!RpcServer.getCurrentCall().isPresent() ? 1 : 0) != 0);
                return super.scan(controller, request);
            }
            catch (Throwable e) {
                exceptionRef.set(e);
                throw new ServiceException(e);
            }
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            try {
                if (!MyScanObserver.inCP) {
                    return super.get(controller, request);
                }
                HRegion region = null;
                if (request.hasRegion()) {
                    region = this.getRegion(request.getRegion());
                }
                if (region != null && TableName.isMetaTableName((TableName)region.getTableDescriptor().getTableName())) {
                    return super.get(controller, request);
                }
                Assert.assertTrue((!RpcServer.getCurrentCall().isPresent() ? 1 : 0) != 0);
                return super.get(controller, request);
            }
            catch (Throwable e) {
                exceptionRef.set(e);
                throw new ServiceException(e);
            }
        }
    }

    private static class MyRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public MyRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new MyRSRpcServices(this);
        }
    }
}

