/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
class WALProcedureMap {
    private static final Logger LOG = LoggerFactory.getLogger(WALProcedureMap.class);
    private final Map<Long, ProcedureProtos.Procedure> procMap = new HashMap<Long, ProcedureProtos.Procedure>();
    private long minModifiedProcId = Long.MAX_VALUE;
    private long maxModifiedProcId = Long.MIN_VALUE;

    WALProcedureMap() {
    }

    private void trackProcId(long procId) {
        this.minModifiedProcId = Math.min(this.minModifiedProcId, procId);
        this.maxModifiedProcId = Math.max(this.maxModifiedProcId, procId);
    }

    private static boolean isIncreasing(ProcedureProtos.Procedure current, ProcedureProtos.Procedure candidate) {
        boolean increasing;
        boolean bl = increasing = current.getLastUpdate() <= candidate.getLastUpdate();
        if (!increasing) {
            LOG.warn("NOT INCREASING! current=" + current + ", candidate=" + candidate);
        }
        return increasing;
    }

    public void add(ProcedureProtos.Procedure proc) {
        this.procMap.compute(proc.getProcId(), (procId, existingProc) -> {
            if (existingProc == null || WALProcedureMap.isIncreasing(existingProc, proc)) {
                return proc;
            }
            return existingProc;
        });
        this.trackProcId(proc.getProcId());
    }

    public void remove(long procId) {
        this.procMap.remove(procId);
    }

    public boolean isEmpty() {
        return this.procMap.isEmpty();
    }

    public boolean contains(long procId) {
        return this.procMap.containsKey(procId);
    }

    public void merge(WALProcedureMap other) {
        other.procMap.forEach(this.procMap::putIfAbsent);
        this.maxModifiedProcId = Math.max(this.maxModifiedProcId, other.maxModifiedProcId);
        this.minModifiedProcId = Math.max(this.minModifiedProcId, other.minModifiedProcId);
        other.procMap.clear();
        other.maxModifiedProcId = Long.MIN_VALUE;
        other.minModifiedProcId = Long.MAX_VALUE;
    }

    public Collection<ProcedureProtos.Procedure> getProcedures() {
        return Collections.unmodifiableCollection(this.procMap.values());
    }

    public long getMinModifiedProcId() {
        return this.minModifiedProcId;
    }

    public long getMaxModifiedProcId() {
        return this.maxModifiedProcId;
    }
}

