/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.support;

import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatResponse;

public final class UsageCalculator {
    private UsageCalculator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Usage getCumulativeUsage(Usage currentUsage, ChatResponse previousChatResponse) {
        Usage usageFromPreviousChatResponse = null;
        if (previousChatResponse == null || previousChatResponse.getMetadata() == null || previousChatResponse.getMetadata().getUsage() == null) {
            return currentUsage;
        }
        usageFromPreviousChatResponse = previousChatResponse.getMetadata().getUsage();
        if (!UsageCalculator.isEmpty(currentUsage)) {
            Integer promptTokens = currentUsage.getPromptTokens();
            Integer generationTokens = currentUsage.getCompletionTokens();
            Integer totalTokens = currentUsage.getTotalTokens();
            promptTokens = promptTokens + usageFromPreviousChatResponse.getPromptTokens();
            generationTokens = generationTokens + usageFromPreviousChatResponse.getCompletionTokens();
            totalTokens = totalTokens + usageFromPreviousChatResponse.getTotalTokens();
            return new DefaultUsage(promptTokens, generationTokens, totalTokens);
        }
        return usageFromPreviousChatResponse;
    }

    public static boolean isEmpty(Usage usage) {
        if (usage == null) {
            return true;
        }
        return usage != null && (long)usage.getTotalTokens().intValue() == 0L;
    }
}

