/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientWrapper;
import org.apache.hadoop.hive.metastore.client.ThriftHiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.client.builder.HiveMetaStoreClientBuilder;
import org.apache.thrift.TException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HiveMetaStoreClient
extends MetaStoreClientWrapper
implements IMetaStoreClient,
AutoCloseable {
    public static final String MANUALLY_INITIATED_COMPACTION = "manual";
    public static final String RENAME_PARTITION_MAKE_COPY = "renamePartitionMakeCopy";
    private ThriftHiveMetaStoreClient thriftClient = null;

    public HiveMetaStoreClient(Configuration conf) throws MetaException {
        this(conf, null, true);
    }

    public HiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this(conf, hookLoader, true);
    }

    public HiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        this(conf, hookLoader, new HiveMetaStoreClientBuilder(conf).newClient(allowEmbedded).build());
    }

    private HiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader, IMetaStoreClient baseMetaStoreClient) {
        super(HiveMetaStoreClient.createUnderlyingClient(conf, hookLoader, baseMetaStoreClient), conf);
        if (baseMetaStoreClient instanceof ThriftHiveMetaStoreClient) {
            ThriftHiveMetaStoreClient metaStoreClient;
            this.thriftClient = metaStoreClient = (ThriftHiveMetaStoreClient)baseMetaStoreClient;
        }
    }

    private static IMetaStoreClient createUnderlyingClient(Configuration conf, HiveMetaHookLoader hookLoader, IMetaStoreClient baseMetaStoreClient) {
        return new HiveMetaStoreClientBuilder(conf).client(baseMetaStoreClient).withHooks(hookLoader).threadSafe().build();
    }

    private <T> T doCall(ThriftCallable<T> callable) throws TException {
        if (this.thriftClient != null) {
            return callable.call();
        }
        throw new UnsupportedOperationException();
    }

    public boolean createType(Type type) throws TException {
        return this.doCall(() -> this.thriftClient.createType(type));
    }

    public boolean dropType(String type) throws TException {
        return this.doCall(() -> this.thriftClient.dropType(type));
    }

    public Type getType(String name) throws TException {
        return this.doCall(() -> this.thriftClient.getType(name));
    }

    public Map<String, Type> getTypeAll(String name) throws TException {
        return this.doCall(() -> this.thriftClient.getTypeAll(name));
    }

    public void createTable(Table tbl, EnvironmentContext envContext) throws TException {
        CreateTableRequest request = new CreateTableRequest(tbl);
        if (envContext != null) {
            request.setEnvContext(envContext);
        }
        this.createTable(request);
    }

    public Table getTable(String catName, String dbName, String tableName, boolean getColumnStats, String engine) throws TException {
        return this.doCall(() -> this.thriftClient.getTable(catName, dbName, tableName, getColumnStats, engine));
    }

    public void dropTable(String catName, String dbname, String name, boolean deleteData, boolean ignoreUnknownTab, EnvironmentContext envContext) throws TException {
        this.doCall(() -> {
            this.thriftClient.dropTable(catName, dbname, name, deleteData, ignoreUnknownTab, envContext);
            return null;
        });
    }

    public Partition add_partition(Partition new_part, EnvironmentContext envContext) throws TException {
        return this.doCall(() -> this.thriftClient.add_partition(new_part, envContext));
    }

    public Partition appendPartition(String dbName, String tableName, List<String> partVals, EnvironmentContext ec) throws TException {
        return this.doCall(() -> this.thriftClient.appendPartition(dbName, tableName, partVals, ec));
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName) throws TException {
        return this.doCall(() -> this.thriftClient.appendPartitionByName(dbName, tableName, partName));
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName, EnvironmentContext envContext) throws TException {
        return this.doCall(() -> this.thriftClient.appendPartitionByName(dbName, tableName, partName, envContext));
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, EnvironmentContext env_context) throws TException {
        return this.doCall(() -> this.thriftClient.dropPartition(db_name, tbl_name, part_vals, env_context));
    }

    public boolean dropPartition(String dbName, String tableName, String partName, boolean dropData, EnvironmentContext ec) throws TException {
        return this.doCall(() -> this.thriftClient.dropPartition(dbName, tableName, partName, dropData, ec));
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partVals) throws TException {
        return this.doCall(() -> this.thriftClient.dropPartition(dbName, tableName, partVals));
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData) throws TException {
        return this.doCall(() -> this.thriftClient.dropPartitionByName(dbName, tableName, partName, deleteData));
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData, EnvironmentContext envContext) throws TException {
        return this.doCall(() -> this.thriftClient.dropPartitionByName(dbName, tableName, partName, deleteData, envContext));
    }

    @VisibleForTesting
    public ThriftHiveMetaStoreClient getThriftClient() {
        return this.thriftClient;
    }

    public static void setProcessorCapabilities(String[] capabilities) {
        ThriftHiveMetaStoreClient.setProcessorCapabilities(capabilities);
    }

    public static void setProcessorIdentifier(String id) {
        ThriftHiveMetaStoreClient.setProcessorIdentifier(id);
    }

    public static String[] getProcessorCapabilities() {
        return ThriftHiveMetaStoreClient.getProcessorCapabilities();
    }

    public static String getProcessorIdentifier() {
        return ThriftHiveMetaStoreClient.getProcessorIdentifier();
    }

    @FunctionalInterface
    private static interface ThriftCallable<T> {
        public T call() throws TException;
    }
}

