/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.apache.hadoop.hive.ql.reexec.ReExecDriver;
import org.apache.hadoop.hive.ql.reexec.ReExecutionStrategyType;

public final class DriverFactory {
    private DriverFactory() {
        throw new UnsupportedOperationException("DriverFactory should not be instantiated!");
    }

    public static IDriver newDriver(HiveConf conf) {
        return DriverFactory.newDriver(DriverFactory.getNewQueryState(conf), QueryInfo.getFromConf(conf));
    }

    public static IDriver newDriver(QueryState queryState, QueryInfo queryInfo) {
        boolean enabled = queryState.getConf().getBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ENABLED);
        if (!enabled) {
            return new Driver(queryState, queryInfo);
        }
        String strategies = queryState.getConf().getVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES);
        strategies = Strings.nullToEmpty((String)strategies);
        ArrayList<IReExecutionPlugin> plugins = new ArrayList<IReExecutionPlugin>();
        for (String string : strategies.split(",")) {
            if (string.trim().isEmpty()) continue;
            plugins.add(DriverFactory.buildReExecPlugin(string));
        }
        return new ReExecDriver(queryState, queryInfo, plugins);
    }

    private static IReExecutionPlugin buildReExecPlugin(String name) throws RuntimeException {
        Class<IReExecutionPlugin> pluginType;
        try {
            pluginType = ReExecutionStrategyType.getPluginClassByName(name);
        }
        catch (IllegalArgumentException e) {
            try {
                Class<IReExecutionPlugin> cls = Class.forName(name);
                if (cls.isAssignableFrom(IReExecutionPlugin.class)) {
                    throw new RuntimeException("Not re-execution plugin: " + name);
                }
                pluginType = cls;
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("Unknown re-execution plugin: " + name + " (" + HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES.varname + ")");
            }
        }
        try {
            return pluginType.getDeclaredConstructor(null).newInstance(null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unknown re-execution plugin: " + name + " (" + HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES.varname + ")");
        }
    }

    public static QueryState getNewQueryState(HiveConf conf) {
        return new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(conf).build();
    }
}

