/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.jdo.JDODataStoreException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.common.DataCopyStatistics;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.MaterializationSnapshot;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Batchable;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.GetFunctionsRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionFilterMode;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogBatchRequest;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.client.builder.HiveMetaStoreClientBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.RetryUtilities;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.database.drop.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.CheckJDOException;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreClientWithLocalCache;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewMetadata;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.RewriteAlgorithm;
import org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.TableConstraintsInfo;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTableExecuteSpec;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.metadata.Hive");
    private final String CLASS_NAME = Hive.class.getName();
    private HiveConf conf = null;
    private IMetaStoreClient metaStoreClient;
    private UserGroupInformation owner;
    private boolean isAllowClose = true;
    private static final int DEFAULT_BATCH_DECAYING_FACTOR = 2;
    private final ConcurrentHashMap<String, Long> metaCallTimeMap = new ConcurrentHashMap();
    private static ThreadLocalHive hiveDB = new ThreadLocalHive();
    private static final AtomicInteger didRegisterAllFuncs = new AtomicInteger(0);
    private static final int REG_FUNCS_NO = 0;
    private static final int REG_FUNCS_DONE = 2;
    private static final int REG_FUNCS_PENDING = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAllFunctionsOnce() throws HiveException {
        boolean breakLoop = false;
        block21: while (!breakLoop) {
            int val = didRegisterAllFuncs.get();
            switch (val) {
                case 0: {
                    if (!didRegisterAllFuncs.compareAndSet(val, 1)) continue block21;
                    breakLoop = true;
                    continue block21;
                }
                case 1: {
                    AtomicInteger atomicInteger = didRegisterAllFuncs;
                    synchronized (atomicInteger) {
                        try {
                            didRegisterAllFuncs.wait(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
            throw new AssertionError(val);
        }
        try {
            this.reloadFunctions();
            didRegisterAllFuncs.compareAndSet(1, 2);
        }
        catch (Error | Exception e) {
            LOG.warn("Failed to register all functions.", e);
            didRegisterAllFuncs.compareAndSet(1, 0);
            if (e instanceof Exception) {
                throw new HiveException(e);
            }
            throw e;
        }
        finally {
            AtomicInteger atomicInteger = didRegisterAllFuncs;
            synchronized (atomicInteger) {
                didRegisterAllFuncs.notifyAll();
            }
        }
    }

    public void reloadFunctions() throws HiveException {
        HashSet<String> registryFunctions = new HashSet<String>(FunctionRegistry.getFunctionNames(".+\\..+"));
        for (org.apache.hadoop.hive.metastore.api.Function function : this.getAllFunctions()) {
            String functionName = function.getFunctionName();
            try {
                LOG.info("Registering function " + functionName + " " + function.getClassName());
                String qualFunc = FunctionUtils.qualifyFunctionName(functionName, function.getDbName());
                FunctionRegistry.registerPermanentFunction(qualFunc, function.getClassName(), false, FunctionUtils.toFunctionResource(function.getResourceUris()));
                registryFunctions.remove(qualFunc);
            }
            catch (Exception e) {
                LOG.warn("Failed to register persistent function " + functionName + ":" + function.getClassName() + ". Ignore and continue.");
            }
        }
        for (String functionName : registryFunctions) {
            try {
                FunctionRegistry.unregisterPermanentFunction(functionName);
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister persistent function " + functionName + "on reload. Ignore and continue.");
            }
        }
    }

    public static Hive get(Configuration c, Class<?> clazz) throws HiveException {
        return Hive.get(c instanceof HiveConf ? (HiveConf)c : new HiveConf(c, clazz));
    }

    public static Hive get(HiveConf c) throws HiveException {
        return Hive.getInternal(c, false, false, true);
    }

    public static Hive createHiveForSession(HiveConf c) throws HiveException {
        return Hive.create(c, true);
    }

    public void setConf(HiveConf c) {
        this.conf = c;
    }

    public static Hive getWithFastCheck(HiveConf c) throws HiveException {
        return Hive.getWithFastCheck(c, true);
    }

    public static Hive getWithFastCheck(HiveConf c, boolean doRegisterAllFns) throws HiveException {
        return Hive.getInternal(c, false, true, doRegisterAllFns);
    }

    public static Hive getWithoutRegisterFns(HiveConf c) throws HiveException {
        return Hive.getInternal(c, false, false, false);
    }

    private static Hive getInternal(HiveConf c, boolean needsRefresh, boolean isFastCheck, boolean doRegisterAllFns) throws HiveException {
        Hive db = (Hive)hiveDB.get();
        if (db == null || !db.isCurrentUserOwner() || needsRefresh || c != null && !Hive.isCompatible(db, c, isFastCheck)) {
            if (db != null) {
                LOG.debug("Creating new db. db = " + String.valueOf(db) + ", needsRefresh = " + needsRefresh + ", db.isCurrentUserOwner = " + db.isCurrentUserOwner());
                Hive.closeCurrent();
            }
            db = Hive.create(c, doRegisterAllFns);
        }
        if (c != null) {
            db.conf = c;
        }
        return db;
    }

    private static Hive create(HiveConf c, boolean doRegisterAllFns) throws HiveException {
        if (c == null) {
            c = Hive.createHiveConf();
        }
        c.set("fs.scheme.class", "dfs");
        Hive newdb = new Hive(c, doRegisterAllFns);
        if ((newdb.getHMSClientCapabilities() == null || newdb.getHMSClientCapabilities().length == 0) && c.get(HiveConf.ConfVars.METASTORE_CLIENT_CAPABILITIES.varname) != null) {
            String[] capabilities = c.get(HiveConf.ConfVars.METASTORE_CLIENT_CAPABILITIES.varname).split(",");
            newdb.setHMSClientCapabilities(capabilities);
            String hostName = "unknown";
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            newdb.setHMSClientIdentifier("Hiveserver2#" + HiveVersionInfo.getVersion() + "@" + hostName);
        }
        hiveDB.set(newdb);
        return newdb;
    }

    private static HiveConf createHiveConf() {
        SessionState session = SessionState.get();
        return session == null ? new HiveConf(Hive.class) : session.getConf();
    }

    public void setHMSClientCapabilities(String[] capabilities) {
        HiveMetaStoreClient.setProcessorCapabilities((String[])capabilities);
    }

    public void setHMSClientIdentifier(String id) {
        HiveMetaStoreClient.setProcessorIdentifier((String)id);
    }

    public String[] getHMSClientCapabilities() {
        return HiveMetaStoreClient.getProcessorCapabilities();
    }

    public String getHMSClientIdentifier() {
        return HiveMetaStoreClient.getProcessorIdentifier();
    }

    private static boolean isCompatible(Hive db, HiveConf c, boolean isFastCheck) {
        if (isFastCheck) {
            return db.metaStoreClient == null || db.metaStoreClient.isSameConfObj((Configuration)c);
        }
        return db.metaStoreClient == null || db.metaStoreClient.isCompatibleWith((Configuration)c);
    }

    private boolean isCurrentUserOwner() throws HiveException {
        try {
            return this.owner == null || this.owner.equals((Object)UserGroupInformation.getCurrentUser());
        }
        catch (IOException e) {
            throw new HiveException("Error getting current user: " + e.getMessage(), (Throwable)e);
        }
    }

    public static Hive getThreadLocal() {
        return (Hive)hiveDB.get();
    }

    public static Hive get() throws HiveException {
        return Hive.get(true);
    }

    @VisibleForTesting
    public static Hive get(IMetaStoreClient msc) throws HiveException, MetaException {
        Hive hive = Hive.get(true);
        hive.setMSC(msc);
        return hive;
    }

    public static Hive get(boolean doRegisterAllFns) throws HiveException {
        return Hive.getInternal(null, false, false, doRegisterAllFns);
    }

    public static Hive get(HiveConf c, boolean needsRefresh) throws HiveException {
        return Hive.getInternal(c, needsRefresh, false, true);
    }

    public static void set(Hive hive) {
        hiveDB.set(hive);
    }

    public static void closeCurrent() {
        hiveDB.remove();
    }

    private Hive(HiveConf c, boolean doRegisterAllFns) throws HiveException {
        this.conf = c;
        System.setProperty("calcite.enable.rexnode.digest.normalize", "false");
        if (doRegisterAllFns) {
            this.registerAllFunctionsOnce();
        }
    }

    protected void finalize() throws Throwable {
        this.close(true);
        super.finalize();
    }

    public void setAllowClose(boolean allowClose) {
        this.isAllowClose = allowClose;
    }

    public boolean allowClose() {
        return this.isAllowClose;
    }

    public void close(boolean forceClose) {
        if (this.allowClose() || forceClose) {
            LOG.debug("Closing current thread's connection to Hive Metastore.");
            if (this.metaStoreClient != null) {
                this.metaStoreClient.close();
                this.metaStoreClient = null;
            }
            if (this.owner != null) {
                this.owner = null;
            }
        }
    }

    public void createCatalog(Catalog catalog, boolean ifNotExist) throws AlreadyExistsException, HiveException {
        try {
            this.getMSC().createCatalog(catalog);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExist) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void dropCatalog(String catName, boolean ignoreUnknownCat) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropCatalog(catName);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownCat) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createDatabase(Database db, boolean ifNotExist) throws AlreadyExistsException, HiveException {
        try {
            this.getMSC().createDatabase(db);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExist) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createDatabase(Database db) throws AlreadyExistsException, HiveException {
        this.createDatabase(db, false);
    }

    public void dropDatabase(String name) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws HiveException, NoSuchObjectException {
        this.dropDatabase(new DropDatabaseDesc(name, ignoreUnknownDb, cascade, deleteData));
    }

    public void dropDatabase(DropDatabaseDesc desc) throws HiveException, NoSuchObjectException {
        boolean isSoftDelete = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
        long txnId = Optional.ofNullable(SessionState.get()).map(SessionState::getTxnMgr).map(HiveTxnManager::getCurrentTxnId).orElse(0L);
        DropDatabaseRequest req = new DropDatabaseRequest();
        req.setCatalogName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
        req.setName(desc.getDatabaseName());
        req.setIgnoreUnknownDb(desc.getIfExists());
        req.setDeleteData(desc.isDeleteData());
        req.setCascade(desc.isCasdade());
        req.setSoftDelete(isSoftDelete);
        req.setTxnId(txnId);
        try {
            this.getMSC().dropDatabase(req);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public Table getTranslateTableDryrun(org.apache.hadoop.hive.metastore.api.Table tbl) throws HiveException {
        org.apache.hadoop.hive.metastore.api.Table tTable = null;
        try {
            tTable = this.getMSC().getTranslateTableDryrun(tbl);
        }
        catch (AlreadyExistsException e) {
            throw new HiveException((Throwable)e);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return new Table(tTable);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, -1, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, bucketCount, bucketCols, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols, Map<String, String> parameters) throws HiveException {
        if (columns == null) {
            throw new HiveException("columns not specified for table " + tableName);
        }
        Table tbl = this.newTable(tableName);
        tbl.setInputFormatClass(fileInputFormat.getName());
        tbl.setOutputFormatClass(fileOutputFormat.getName());
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "default");
            tbl.getCols().add(field);
        }
        if (partCols != null) {
            for (String partCol : partCols) {
                FieldSchema part = new FieldSchema();
                part.setName(partCol);
                part.setType("string");
                tbl.getPartCols().add(part);
            }
        }
        tbl.setSerializationLib(LazySimpleSerDe.class.getName());
        tbl.setNumBuckets(bucketCount);
        tbl.setBucketCols(bucketCols);
        if (parameters != null) {
            tbl.setParameters(parameters);
        }
        this.createTable(tbl);
    }

    public void alterTable(Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional) throws HiveException {
        this.alterTable(newTbl.getCatName(), newTbl.getDbName(), newTbl.getTableName(), newTbl, cascade, environmentContext, transactional);
    }

    public void alterTable(String fullyQlfdTblName, Table newTbl, EnvironmentContext environmentContext, boolean transactional) throws HiveException {
        String[] names = Utilities.getDbTableName(fullyQlfdTblName);
        this.alterTable(null, names[0], names[1], newTbl, false, environmentContext, transactional);
    }

    public void alterTable(String fullyQlfdTblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional) throws HiveException {
        String[] names = Utilities.getDbTableName(fullyQlfdTblName);
        this.alterTable(null, names[0], names[1], newTbl, cascade, environmentContext, transactional);
    }

    public void alterTable(String fullyQlfdTblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional, long writeId) throws HiveException {
        String[] names = Utilities.getDbTableName(fullyQlfdTblName);
        this.alterTable(null, names[0], names[1], newTbl, cascade, environmentContext, transactional, writeId);
    }

    public void alterTable(String catName, String dbName, String tblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional) throws HiveException {
        this.alterTable(catName, dbName, tblName, newTbl, cascade, environmentContext, transactional, 0L);
    }

    public void alterTable(String catName, String dbName, String tblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext, boolean transactional, long replWriteId) throws HiveException {
        if (catName == null) {
            catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        }
        try {
            if (newTbl.getParameters() != null) {
                newTbl.getParameters().remove("transient_lastDdlTime");
            }
            if (environmentContext == null) {
                environmentContext = new EnvironmentContext();
            }
            if (Hive.isRename(environmentContext)) {
                newTbl.validateName((Configuration)this.conf);
                environmentContext.putToProperties("old_table_name", tblName);
                environmentContext.putToProperties("old_db_name", dbName);
            } else {
                newTbl.checkValidity((Configuration)this.conf);
            }
            if (cascade) {
                environmentContext.putToProperties("CASCADE", "true");
            }
            AcidUtils.TableSnapshot tableSnapshot = null;
            if (transactional) {
                if (replWriteId > 0L) {
                    ValidReaderWriteIdList writeIds = new ValidReaderWriteIdList(TableName.getDbTable((String)dbName, (String)tblName), new long[0], new BitSet(), replWriteId);
                    tableSnapshot = new AcidUtils.TableSnapshot(replWriteId, writeIds.writeToString());
                } else {
                    tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, newTbl, dbName, tblName, true);
                }
                if (tableSnapshot != null) {
                    newTbl.getTTable().setWriteId(tableSnapshot.getWriteId());
                } else {
                    LOG.warn("Cannot get a table snapshot for " + tblName);
                }
            }
            this.getMSC().alter_table(catName, dbName, tblName, newTbl.getTTable(), environmentContext, tableSnapshot == null ? null : tableSnapshot.getValidWriteIdList());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), (Throwable)e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isRename(EnvironmentContext environmentContext) {
        if (environmentContext.isSetProperties()) {
            String operation = (String)environmentContext.getProperties().get("alterTableOpType");
            return operation != null && AlterTableType.RENAME == AlterTableType.valueOf(operation);
        }
        return false;
    }

    public void createDataConnector(DataConnector connector, boolean ifNotExist) throws AlreadyExistsException, HiveException {
        try {
            this.getMSC().createDataConnector(connector);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExist) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createDataConnector(DataConnector connector) throws AlreadyExistsException, HiveException {
        this.createDataConnector(connector, false);
    }

    public void dropDataConnector(String name, boolean ifNotExists) throws HiveException, NoSuchObjectException {
        this.dropDataConnector(name, ifNotExists, true);
    }

    public void dropDataConnector(String name, boolean ifNotExists, boolean checkReferences) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropDataConnector(name, ifNotExists, checkReferences);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public DataConnector getDataConnector(String dcName) throws HiveException {
        try {
            return this.getMSC().getDataConnector(dcName);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<String> getAllDataConnectorNames() throws HiveException {
        try {
            return this.getMSC().getAllDataConnectorNames();
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void alterDataConnector(String dcName, DataConnector connector) throws HiveException {
        try {
            this.getMSC().alterDataConnector(dcName, connector);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter dataconnector " + dcName + ". " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("DataConnector " + dcName + " does not exists.", (Throwable)e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter dataconnector " + dcName + ". " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateCreationMetadata(String dbName, String tableName, MaterializedViewMetadata metadata) throws HiveException {
        try {
            this.getMSC().updateCreationMetadata(dbName, tableName, metadata.creationMetadata);
        }
        catch (TException e) {
            throw new HiveException("Unable to update creation metadata " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public void alterPartition(String tblName, Partition newPart, EnvironmentContext environmentContext, boolean transactional) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        this.alterPartition(null, names[0], names[1], newPart, environmentContext, transactional);
    }

    public void alterPartition(String catName, String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext, boolean transactional) throws InvalidOperationException, HiveException {
        try {
            if (catName == null) {
                catName = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
            }
            this.validatePartition(newPart);
            String location = newPart.getLocation();
            if (location != null) {
                location = Utilities.getQualifiedPath(this.conf, new Path(location));
                newPart.setLocation(location);
            }
            if (environmentContext == null) {
                environmentContext = new EnvironmentContext();
            }
            AcidUtils.TableSnapshot tableSnapshot = null;
            if (transactional) {
                tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, newPart.getTable(), true);
                if (tableSnapshot != null) {
                    newPart.getTPartition().setWriteId(tableSnapshot.getWriteId());
                } else {
                    LOG.warn("Cannot get a table snapshot for " + tblName);
                }
            }
            this.getMSC().alter_partition(catName, dbName, tblName, newPart.getTPartition(), environmentContext, tableSnapshot == null ? null : tableSnapshot.getValidWriteIdList());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), (Throwable)e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), (Throwable)e);
        }
    }

    private void validatePartition(Partition newPart) throws HiveException {
        if (newPart.getParameters() != null) {
            newPart.getParameters().remove("transient_lastDdlTime");
        }
        newPart.checkValidity();
    }

    public void alterPartitions(String tblName, List<Partition> newParts, EnvironmentContext environmentContext, boolean transactional) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName(tblName);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> newTParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        try {
            AcidUtils.TableSnapshot tableSnapshot = null;
            if (transactional) {
                tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, newParts.get(0).getTable(), true);
            }
            for (Partition tmpPart : newParts) {
                String location;
                if (tmpPart.getParameters() != null) {
                    tmpPart.getParameters().remove("transient_lastDdlTime");
                }
                if ((location = tmpPart.getLocation()) != null) {
                    location = Utilities.getQualifiedPath(this.conf, new Path(location));
                    tmpPart.setLocation(location);
                }
                newTParts.add(tmpPart.getTPartition());
            }
            this.getMSC().alter_partitions(names[0], names[1], newTParts, environmentContext, tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null, tableSnapshot != null ? tableSnapshot.getWriteId() : -1L);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), (Throwable)e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), (Throwable)e);
        }
    }

    public void renamePartition(Table tbl, Map<String, String> oldPartSpec, Partition newPart, long replWriteId) throws HiveException {
        try {
            LinkedHashMap<String, String> newPartSpec = newPart.getSpec();
            if (oldPartSpec.keySet().size() != tbl.getPartCols().size() || newPartSpec.keySet().size() != tbl.getPartCols().size()) {
                throw new HiveException("Unable to rename partition to the same name: number of partition cols don't match. ");
            }
            if (!oldPartSpec.keySet().equals(newPartSpec.keySet())) {
                throw new HiveException("Unable to rename partition to the same name: old and new partition cols don't match. ");
            }
            ArrayList<String> pvals = new ArrayList<String>();
            for (FieldSchema field : tbl.getPartCols()) {
                String val = oldPartSpec.get(field.getName());
                if (val == null || val.length() == 0) {
                    throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
                }
                if (val == null) continue;
                pvals.add(val);
            }
            String validWriteIds = null;
            boolean clonePart = false;
            long txnId = 0L;
            if (AcidUtils.isTransactionalTable(tbl)) {
                AcidUtils.TableSnapshot tableSnapshot;
                if (replWriteId > 0L) {
                    ValidReaderWriteIdList writeIds = new ValidReaderWriteIdList(TableName.getDbTable((String)tbl.getDbName(), (String)tbl.getTableName()), new long[0], new BitSet(), replWriteId);
                    tableSnapshot = new AcidUtils.TableSnapshot(replWriteId, writeIds.writeToString());
                } else {
                    tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, tbl, true);
                }
                if (tableSnapshot != null) {
                    newPart.getTPartition().setWriteId(tableSnapshot.getWriteId());
                    validWriteIds = tableSnapshot.getValidWriteIdList();
                }
                clonePart = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_RENAME_PARTITION_MAKE_COPY) || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
                txnId = Optional.ofNullable(SessionState.get()).map(ss -> ss.getTxnMgr().getCurrentTxnId()).orElse(0L);
            }
            String catName = tbl.getCatalogName() != null ? tbl.getCatalogName() : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
            this.getMSC().renamePartition(catName, tbl.getDbName(), tbl.getTableName(), pvals, newPart.getTPartition(), validWriteIds, txnId, clonePart);
        }
        catch (InvalidOperationException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), (Throwable)e);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), (Throwable)e);
        }
        catch (TException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), (Throwable)e);
        }
    }

    public void alterDatabase(String dbName, Database db) throws HiveException {
        try {
            this.getMSC().alterDatabase(dbName, db);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Database " + dbName + " does not exists.", (Throwable)e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), (Throwable)e);
        }
    }

    public void createTable(Table tbl) throws HiveException {
        this.createTable(tbl, false);
    }

    public void createTable(Table tbl, boolean ifNotExists, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws HiveException {
        try {
            AcidUtils.TableSnapshot tableSnapshot;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tbl.getDbName())) {
                tbl.setDbName(SessionState.get().getCurrentDatabase());
            }
            if (tbl.getCols().size() == 0 || tbl.getSd().getColsSize() == 0) {
                tbl.setFields(HiveMetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)tbl.getDeserializer(), (Configuration)this.conf));
            }
            tbl.checkValidity((Configuration)this.conf);
            if (tbl.getParameters() != null) {
                tbl.getParameters().remove("transient_lastDdlTime");
            }
            org.apache.hadoop.hive.metastore.api.Table tTbl = tbl.getTTable();
            PrincipalPrivilegeSet principalPrivs = new PrincipalPrivilegeSet();
            SessionState ss = SessionState.get();
            if (ss != null) {
                CreateTableAutomaticGrant grants = ss.getCreateTableGrants();
                if (grants != null) {
                    principalPrivs.setUserPrivileges(grants.getUserGrants());
                    principalPrivs.setGroupPrivileges(grants.getGroupGrants());
                    principalPrivs.setRolePrivileges(grants.getRoleGrants());
                    tTbl.setPrivileges(principalPrivs);
                }
                if (AcidUtils.isTransactionalTable(tbl)) {
                    boolean createTableUseSuffix;
                    boolean bl = createTableUseSuffix = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX) || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
                    if (createTableUseSuffix && (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty())) {
                        tbl.setProperty("soft_delete", Boolean.TRUE.toString());
                    }
                    tTbl.setTxnId(ss.getTxnMgr().getCurrentTxnId());
                }
            }
            if (tTbl.getWriteId() <= 0L && (tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, tbl, true)) != null) {
                tTbl.setWriteId(tableSnapshot.getWriteId());
            }
            CreateTableRequest request = new CreateTableRequest(tTbl);
            if (DDLUtils.isIcebergTable(tbl)) {
                EnvironmentContext envContext = new EnvironmentContext();
                if (TableType.MANAGED_TABLE.equals((Object)tbl.getTableType())) {
                    envContext.putToProperties("create_table_as_external", Boolean.TRUE.toString());
                }
                if (DDLUtils.isIcebergStatsSource(this.conf)) {
                    envContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
                }
                request.setEnvContext(envContext);
            }
            request.setPrimaryKeys(primaryKeys);
            request.setForeignKeys(foreignKeys);
            request.setUniqueConstraints(uniqueConstraints);
            request.setNotNullConstraints(notNullConstraints);
            request.setDefaultConstraints(defaultConstraints);
            request.setCheckConstraints(checkConstraints);
            this.getMSC().createTable(request);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createTable(Table tbl, boolean ifNotExists) throws HiveException {
        this.createTable(tbl, ifNotExists, null, null, null, null, null, null);
    }

    public static List<FieldSchema> getFieldsFromDeserializerForMsStorage(Table tbl, Deserializer deserializer, Configuration conf) throws SerDeException, MetaException {
        List schema = HiveMetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)deserializer, (Configuration)conf);
        for (FieldSchema field : schema) {
            field.setType("<derived from deserializer>");
        }
        return schema;
    }

    public void dropTable(String tableName, boolean ifPurge) throws HiveException {
        String[] names = Utilities.getDbTableName(tableName);
        this.dropTable(names[0], names[1], true, true, ifPurge);
    }

    public void dropTable(Table table, boolean ifPurge) throws HiveException {
        boolean tableWithSuffix = AcidUtils.isTableSoftDeleteEnabled(table, this.conf);
        long txnId = Optional.ofNullable(SessionState.get()).map(ss -> ss.getTxnMgr().getCurrentTxnId()).orElse(0L);
        table.getTTable().setTxnId(txnId);
        this.dropTable(table.getTTable(), !tableWithSuffix, true, ifPurge);
    }

    public void dropTable(String tableName) throws HiveException {
        this.dropTable(tableName, false);
    }

    public void dropTable(String dbName, String tableName) throws HiveException {
        this.dropTable(dbName, tableName, true, true, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws HiveException {
        this.dropTable(dbName, tableName, deleteData, ignoreUnknownTab, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws HiveException {
        try {
            this.getMSC().dropTable(dbName, tableName, deleteData, ignoreUnknownTab, ifPurge);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw new HiveException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void dropTable(org.apache.hadoop.hive.metastore.api.Table table, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws HiveException {
        try {
            this.getMSC().dropTable(table, deleteData, ignoreUnknownTab, ifPurge);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        finally {
            AcidUtils.tryInvalidateDirCache(table);
        }
    }

    public void truncateTable(String dbDotTableName, Map<String, String> partSpec, Long writeId) throws HiveException {
        try {
            List<String> partNames;
            Table table = this.getTable(dbDotTableName, true);
            AcidUtils.TableSnapshot snapshot = null;
            if (AcidUtils.isTransactionalTable(table)) {
                if (writeId <= 0L) {
                    snapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, table, true);
                } else {
                    String fullTableName = AcidUtils.getFullTableName(table.getDbName(), table.getTableName());
                    ValidWriteIdList writeIdList = this.getMSC().getValidWriteIds(fullTableName, writeId);
                    snapshot = new AcidUtils.TableSnapshot(writeId, writeIdList.writeToString());
                }
            }
            List<String> list = partNames = partSpec != null ? this.getPartitionNames(table, partSpec, (short)-1) : null;
            if (snapshot == null) {
                this.getMSC().truncateTable(table.getFullTableName(), partNames);
            } else {
                boolean truncateUseBase = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_TRUNCATE_USE_BASE) || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
                this.getMSC().truncateTable(table.getDbName(), table.getTableName(), partNames, snapshot.getValidWriteIdList(), snapshot.getWriteId(), !truncateUseBase);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Table getTable(String tableName) throws HiveException {
        return this.getTable(tableName, true);
    }

    public Table getTable(String tableName, boolean throwException) throws HiveException {
        String[] nameParts = tableName.split("\\.");
        if (nameParts.length == 3) {
            Table table = this.getTable(nameParts[0], nameParts[1], nameParts[2], throwException);
            return table;
        }
        String[] names = Utilities.getDbTableName(tableName);
        Table table = this.getTable(names[0], names[1], null, throwException);
        return table;
    }

    public Table getTable(String dbName, String tableName) throws HiveException {
        if (tableName.contains(".")) {
            String[] names = Utilities.getDbTableName(tableName);
            return this.getTable(names[0], names[1], null, true);
        }
        return this.getTable(dbName, tableName, null, true);
    }

    public Table getTable(TableName tableName) throws HiveException {
        return this.getTable((String)ObjectUtils.firstNonNull((Object[])new String[]{tableName.getDb(), SessionState.get().getCurrentDatabase()}), tableName.getTable(), tableName.getTableMetaRef(), true);
    }

    public Table getTable(String dbName, String tableName, String tableMetaRef, boolean throwException) throws HiveException {
        return this.getTable(dbName, tableName, tableMetaRef, throwException, false);
    }

    public Table getTable(String dbName, String tableName, boolean throwException) throws HiveException {
        return this.getTable(dbName, tableName, null, throwException);
    }

    public Table getTable(String dbName, String tableName, boolean throwException, boolean checkTransactional) throws HiveException {
        return this.getTable(dbName, tableName, null, throwException, checkTransactional, false);
    }

    public Table getTable(String dbName, String tableName, String tableMetaRef, boolean throwException, boolean checkTransactional) throws HiveException {
        return this.getTable(dbName, tableName, tableMetaRef, throwException, checkTransactional, false);
    }

    public Table getTable(String dbName, String tableName, String tableMetaRef, boolean throwException, boolean checkTransactional, boolean getColumnStats) throws HiveException {
        if (tableName == null || tableName.equals("")) {
            throw new HiveException("empty table creation??");
        }
        org.apache.hadoop.hive.metastore.api.Table tTable = null;
        try {
            GetTableRequest request = new GetTableRequest(dbName, tableName);
            request.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
            request.setGetColumnStats(getColumnStats);
            request.setEngine("hive");
            if (checkTransactional) {
                long txnId;
                ValidWriteIdList validWriteIdList = null;
                long l = txnId = SessionState.get() != null && SessionState.get().getTxnMgr() != null ? SessionState.get().getTxnMgr().getCurrentTxnId() : 0L;
                if (txnId > 0L) {
                    validWriteIdList = AcidUtils.getTableValidWriteIdListWithTxnList((Configuration)this.conf, dbName, tableName);
                }
                request.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
            }
            tTable = this.getMSC().getTable(request);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                throw new InvalidTableException(tableName);
            }
            return null;
        }
        catch (Exception e) {
            throw new HiveException("Unable to fetch table " + tableName + ". " + e.getMessage(), (Throwable)e);
        }
        if (!TableType.VIRTUAL_VIEW.toString().equals(tTable.getTableType())) {
            char[] b;
            String sf;
            Map parameters = tTable.getSd().getParameters();
            String string = sf = parameters != null ? (String)parameters.get("serialization.format") : null;
            if (sf != null && (b = sf.toCharArray()).length == 1 && b[0] < '\n') {
                parameters.put("serialization.format", Integer.toString(b[0]));
            }
            if (MetadataTypedColumnsetSerDe.class.getName().equals(tTable.getSd().getSerdeInfo().getSerializationLib()) && tTable.getSd().getColsSize() > 0 && ((FieldSchema)tTable.getSd().getCols().get(0)).getType().indexOf(60) == -1) {
                tTable.getSd().getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            }
        }
        Table t = new Table(tTable);
        if (tableMetaRef != null) {
            if (t.getStorageHandler() == null || !t.getStorageHandler().isTableMetaRefSupported()) {
                throw new SemanticException(ErrorMsg.TABLE_META_REF_NOT_SUPPORTED, new String[]{t.getTableName()});
            }
            t = t.getStorageHandler().checkAndSetTableMetaRef(t, tableMetaRef);
        }
        return t;
    }

    private ValidWriteIdList getValidWriteIdList(String dbName, String tableName) throws LockException {
        long txnId = Optional.ofNullable(SessionState.get()).map(ss -> ss.getTxnMgr().getCurrentTxnId()).orElse(0L);
        return txnId > 0L ? AcidUtils.getTableValidWriteIdListWithTxnList((Configuration)this.conf, dbName, tableName) : new ValidReaderWriteIdList();
    }

    public List<String> getAllTables() throws HiveException {
        return this.getTablesByType(SessionState.get().getCurrentDatabase(), null, null);
    }

    public List<String> getAllTables(String dbName) throws HiveException {
        return this.getTablesByType(dbName, ".*", null);
    }

    public List<Table> getAllTableObjects(String dbName) throws HiveException {
        return this.getTableObjects(dbName, ".*", null);
    }

    public List<String> getAllMaterializedViews(String dbName) throws HiveException {
        return this.getTablesByType(dbName, ".*", TableType.MATERIALIZED_VIEW);
    }

    public List<Table> getAllMaterializedViewObjects(String dbName) throws HiveException {
        return this.getTableObjects(dbName, ".*", TableType.MATERIALIZED_VIEW);
    }

    public List<Table> getMaterializedViewObjectsByPattern(String dbName, String pattern) throws HiveException {
        return this.getTableObjects(dbName, pattern, TableType.MATERIALIZED_VIEW);
    }

    public List<Table> getTableObjects(String dbName, String pattern, TableType tableType) throws HiveException {
        try {
            return Lists.transform((List)this.getMSC().getTableObjectsByName(dbName, this.getTablesByType(dbName, pattern, tableType)), (Function)new Function<org.apache.hadoop.hive.metastore.api.Table, Table>(this){

                public Table apply(org.apache.hadoop.hive.metastore.api.Table table) {
                    return new Table(table);
                }
            });
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<String> getTablesByPattern(String tablePattern) throws HiveException {
        return this.getTablesByType(SessionState.get().getCurrentDatabase(), tablePattern, null);
    }

    public List<String> getTablesByPattern(String dbName, String tablePattern) throws HiveException {
        return this.getTablesByType(dbName, tablePattern, null);
    }

    public List<String> getTablesForDb(String database, String tablePattern) throws HiveException {
        return this.getTablesByType(database, tablePattern, null);
    }

    public List<String> getTablesByType(String dbName, String pattern, TableType type) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getTablesByType");
        if (dbName == null) {
            dbName = SessionState.get().getCurrentDatabase();
        }
        try {
            List result = type != null ? (pattern != null ? this.getMSC().getTables(dbName, pattern, type) : this.getMSC().getTables(dbName, ".*", type)) : (pattern != null ? this.getMSC().getTables(dbName, pattern) : this.getMSC().getTables(dbName, ".*"));
            List list = result;
            return list;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getTablesByType", "HS2-cache");
        }
    }

    public List<HiveRelOptMaterialization> getPreprocessedMaterializedViewsFromRegistry(Set<TableName> tablesUsed, Supplier<String> validTxnsList, HiveTxnManager txnMgr) throws HiveException {
        List<HiveRelOptMaterialization> materializedViews = HiveMaterializedViewsRegistry.get().getRewritingMaterializedViews();
        if (materializedViews.isEmpty()) {
            return Collections.emptyList();
        }
        return this.filterAugmentMaterializedViews(materializedViews, tablesUsed, validTxnsList, txnMgr);
    }

    private List<HiveRelOptMaterialization> filterAugmentMaterializedViews(List<HiveRelOptMaterialization> materializedViews, Set<TableName> tablesUsed, Supplier<String> validTxnsList, HiveTxnManager txnMgr) throws HiveException {
        boolean tryIncrementalRewriting = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_INCREMENTAL);
        try {
            ArrayList<HiveRelOptMaterialization> result = new ArrayList<HiveRelOptMaterialization>();
            for (HiveRelOptMaterialization materialization : materializedViews) {
                Table materializedViewTable = HiveMaterializedViewUtils.extractTable(materialization);
                Boolean outdated = this.isOutdatedMaterializedView(materializedViewTable, tablesUsed, false, validTxnsList, txnMgr);
                if (outdated == null) continue;
                if (outdated.booleanValue()) {
                    if (!tryIncrementalRewriting) {
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as its contents are outdated");
                        continue;
                    }
                    materialization = HiveMaterializedViewUtils.augmentMaterializationWithTimeInformation(materialization, validTxnsList, materializedViewTable.getMVMetadata().getSnapshot());
                }
                result.addAll(HiveMaterializedViewUtils.deriveGroupingSetsMaterializedViews(materialization));
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public Boolean isOutdatedMaterializedView(Table materializedViewTable, Set<TableName> tablesUsed, boolean forceMVContentsUpToDate, Supplier<String> validTxnsList, HiveTxnManager txnMgr) throws HiveException {
        long defaultTimeWindow = HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW, (TimeUnit)TimeUnit.MILLISECONDS);
        String timeWindowString = materializedViewTable.getProperty("rewriting.time.window");
        long timeWindow = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)timeWindowString) ? defaultTimeWindow : HiveConf.toTime((String)timeWindowString, (TimeUnit)HiveConf.getDefaultTimeUnit((HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW), (TimeUnit)TimeUnit.MILLISECONDS);
        MaterializedViewMetadata mvMetadata = materializedViewTable.getMVMetadata();
        boolean outdated = false;
        if (timeWindow < 0L) {
            outdated = forceMVContentsUpToDate;
        } else if (forceMVContentsUpToDate || timeWindow == 0L || mvMetadata.getMaterializationTime() < System.currentTimeMillis() - timeWindow) {
            return HiveMaterializedViewUtils.isOutdatedMaterializedView(validTxnsList, txnMgr, this, tablesUsed, materializedViewTable);
        }
        return outdated;
    }

    public Boolean isOutdatedMaterializedView(Supplier<String> validTxnsList, HiveTxnManager txnManager, Table table) throws HiveException {
        return HiveMaterializedViewUtils.isOutdatedMaterializedView(validTxnsList, txnManager, this, table.getMVMetadata().getSourceTableNames(), table);
    }

    public boolean validateMaterializedViewsFromRegistry(List<Table> cachedMaterializedViewTables, Set<TableName> tablesUsed, Supplier<String> validTxnsList, HiveTxnManager txnMgr) throws HiveException {
        try {
            boolean result = true;
            for (Table cachedMaterializedViewTable : cachedMaterializedViewTables) {
                Table materializedViewTable = this.getTable(cachedMaterializedViewTable.getDbName(), cachedMaterializedViewTable.getTableName());
                if (materializedViewTable == null || !materializedViewTable.isRewriteEnabled()) {
                    HiveMaterializedViewsRegistry.get().dropMaterializedView(cachedMaterializedViewTable);
                    result = false;
                    continue;
                }
                Boolean outdated = this.isOutdatedMaterializedView(cachedMaterializedViewTable, tablesUsed, false, validTxnsList, txnMgr);
                if (outdated == null) {
                    result = false;
                    continue;
                }
                if (outdated.booleanValue()) {
                    if (!cachedMaterializedViewTable.equals(materializedViewTable)) {
                        HiveMaterializedViewsRegistry.get().refreshMaterializedView(this.conf, cachedMaterializedViewTable, materializedViewTable);
                        result = false;
                        continue;
                    }
                    Materialization invalidationInfo = this.getMaterializationInvalidationInfo(materializedViewTable.getMVMetadata());
                    if (invalidationInfo != null && !invalidationInfo.isSourceTablesUpdateDeleteModified() && !invalidationInfo.isSourceTablesCompacted()) continue;
                    result = false;
                    continue;
                }
                if (cachedMaterializedViewTable.equals(materializedViewTable)) continue;
                HiveMaterializedViewsRegistry.get().refreshMaterializedView(this.conf, cachedMaterializedViewTable, materializedViewTable);
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private Materialization getMaterializationInvalidationInfo(MaterializedViewMetadata metadata) throws TException, HiveException {
        Optional<SourceTable> first = metadata.getSourceTables().stream().findFirst();
        if (!first.isPresent()) {
            Materialization materialization = new Materialization();
            materialization.setSourceTablesCompacted(true);
            materialization.setSourceTablesUpdateDeleteModified(true);
            return new Materialization();
        }
        Table table = this.getTable(first.get().getTable().getDbName(), first.get().getTable().getTableName());
        if (!table.isNonNative() || !table.getStorageHandler().areSnapshotsSupported()) {
            return this.getMSC().getMaterializationInvalidationInfo(metadata.creationMetadata, this.conf.get("hive.txn.valid.txns"));
        }
        boolean allHasAppendsOnly = this.allTablesHasAppendsOnly(metadata);
        Materialization materialization = new Materialization();
        materialization.setSourceTablesCompacted(!allHasAppendsOnly);
        materialization.setSourceTablesUpdateDeleteModified(!allHasAppendsOnly);
        return materialization;
    }

    private boolean allTablesHasAppendsOnly(MaterializedViewMetadata metadata) throws HiveException {
        MaterializationSnapshot mvSnapshot = MaterializationSnapshot.fromJson((String)metadata.creationMetadata.getValidTxnList());
        for (SourceTable sourceTable : metadata.getSourceTables()) {
            Table table = this.getTable(sourceTable.getTable().getDbName(), sourceTable.getTable().getTableName());
            HiveStorageHandler storageHandler = table.getStorageHandler();
            if (storageHandler != null && storageHandler.areSnapshotsSupported() && this.tableHasAppendsOnly(storageHandler, table, mvSnapshot)) continue;
            return false;
        }
        return true;
    }

    private boolean tableHasAppendsOnly(HiveStorageHandler storageHandler, Table table, MaterializationSnapshot mvSnapshot) {
        for (SnapshotContext snapshot : storageHandler.getSnapshotContexts(table, (SnapshotContext)mvSnapshot.getTableSnapshots().get(table.getFullyQualifiedName()))) {
            if (SnapshotContext.WriteOperationType.APPEND.equals((Object)snapshot.getOperation())) continue;
            return false;
        }
        return true;
    }

    public List<HiveRelOptMaterialization> getPreprocessedMaterializedViews(Set<TableName> tablesUsed, Supplier<String> validTxnsList, HiveTxnManager txnMgr) throws HiveException {
        List<Table> materializedViewTables = this.getAllMaterializedViewObjectsForRewriting();
        if (materializedViewTables.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getValidMaterializedViews(materializedViewTables, tablesUsed, false, true, validTxnsList, txnMgr, EnumSet.of(RewriteAlgorithm.CALCITE));
    }

    public HiveRelOptMaterialization getMaterializedViewForRebuild(String dbName, String materializedViewName, Set<TableName> tablesUsed, Supplier<String> validTxnsList, HiveTxnManager txnMgr) throws HiveException {
        List<HiveRelOptMaterialization> validMaterializedViews = this.getValidMaterializedViews((List<Table>)ImmutableList.of((Object)this.getTable(dbName, materializedViewName)), tablesUsed, true, false, validTxnsList, txnMgr, RewriteAlgorithm.ALL);
        if (validMaterializedViews.isEmpty()) {
            return null;
        }
        Preconditions.checkState((validMaterializedViews.size() == 1 ? 1 : 0) != 0, (Object)"Returned more than a materialized view for rebuild");
        return validMaterializedViews.get(0);
    }

    private List<HiveRelOptMaterialization> getValidMaterializedViews(List<Table> materializedViewTables, Set<TableName> tablesUsed, boolean forceMVContentsUpToDate, boolean expandGroupingSets, Supplier<String> validTxnsList, HiveTxnManager txnMgr, EnumSet<RewriteAlgorithm> scope) throws HiveException {
        boolean tryIncrementalRewriting = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_INCREMENTAL);
        boolean tryIncrementalRebuild = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REBUILD_INCREMENTAL);
        try {
            ArrayList<HiveRelOptMaterialization> result = new ArrayList<HiveRelOptMaterialization>();
            for (Table materializedViewTable : materializedViewTables) {
                HiveRelOptMaterialization hiveRelOptMaterialization;
                Table cachedMaterializedViewTable;
                HiveRelOptMaterialization relOptMaterialization;
                Boolean outdated = this.isOutdatedMaterializedView(materializedViewTable, tablesUsed, forceMVContentsUpToDate, validTxnsList, txnMgr);
                if (outdated == null) continue;
                MaterializedViewMetadata metadata = materializedViewTable.getMVMetadata();
                Materialization invalidationInfo = null;
                if (outdated.booleanValue()) {
                    boolean ignore;
                    if (forceMVContentsUpToDate && !tryIncrementalRebuild) {
                        ignore = true;
                    } else if (!forceMVContentsUpToDate && !tryIncrementalRewriting) {
                        ignore = true;
                    } else {
                        invalidationInfo = this.getMaterializationInvalidationInfo(metadata);
                        boolean bl = ignore = invalidationInfo == null || invalidationInfo.isSourceTablesCompacted();
                    }
                    if (ignore) {
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as its contents are outdated");
                        continue;
                    }
                }
                if ((relOptMaterialization = HiveMaterializedViewsRegistry.get().getRewritingMaterializedView(materializedViewTable.getDbName(), materializedViewTable.getTableName(), scope)) != null && (cachedMaterializedViewTable = HiveMaterializedViewUtils.extractTable(relOptMaterialization)).equals(materializedViewTable)) {
                    if (outdated.booleanValue()) {
                        relOptMaterialization = HiveMaterializedViewUtils.augmentMaterializationWithTimeInformation(relOptMaterialization, validTxnsList, metadata.getSnapshot());
                    }
                    this.addToMaterializationList(expandGroupingSets, invalidationInfo, relOptMaterialization, result);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " was not in the cache or it is not supported by specified rewrite algorithm {}", scope);
                }
                if ((hiveRelOptMaterialization = HiveMaterializedViewsRegistry.get().createMaterialization(this.conf, materializedViewTable)) == null || !hiveRelOptMaterialization.isSupported(scope)) continue;
                relOptMaterialization = hiveRelOptMaterialization;
                HiveMaterializedViewsRegistry.get().refreshMaterializedView(this.conf, null, materializedViewTable);
                if (outdated.booleanValue()) {
                    relOptMaterialization = HiveMaterializedViewUtils.augmentMaterializationWithTimeInformation(hiveRelOptMaterialization, validTxnsList, metadata.getSnapshot());
                }
                this.addToMaterializationList(expandGroupingSets, invalidationInfo, relOptMaterialization, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private void addToMaterializationList(boolean expandGroupingSets, Materialization invalidationInfo, HiveRelOptMaterialization relOptMaterialization, List<HiveRelOptMaterialization> result) {
        if (expandGroupingSets) {
            List<HiveRelOptMaterialization> hiveRelOptMaterializationList = HiveMaterializedViewUtils.deriveGroupingSetsMaterializedViews(relOptMaterialization);
            if (invalidationInfo != null) {
                for (HiveRelOptMaterialization materialization : hiveRelOptMaterializationList) {
                    result.add(materialization.updateInvalidation(invalidationInfo));
                }
            } else {
                result.addAll(hiveRelOptMaterializationList);
            }
        } else {
            result.add(invalidationInfo == null ? relOptMaterialization : relOptMaterialization.updateInvalidation(invalidationInfo));
        }
    }

    public List<Table> getAllMaterializedViewObjectsForRewriting() throws HiveException {
        try {
            return this.getMSC().getAllMaterializedViewObjectsForRewriting().stream().map(Table::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<HiveRelOptMaterialization> getMaterializedViewsByAST(ASTNode astNode, Set<TableName> tablesUsed, Supplier<String> validTxnsList, HiveTxnManager txnMgr) throws HiveException {
        List<HiveRelOptMaterialization> materializedViews = HiveMaterializedViewsRegistry.get().getRewritingMaterializedViews(astNode);
        if (materializedViews.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<HiveRelOptMaterialization> result = new ArrayList<HiveRelOptMaterialization>();
            for (HiveRelOptMaterialization materialization : materializedViews) {
                Table materializedViewTable = HiveMaterializedViewUtils.extractTable(materialization);
                Boolean outdated = this.isOutdatedMaterializedView(materializedViewTable, tablesUsed, false, validTxnsList, txnMgr);
                if (outdated == null) {
                    LOG.debug("Unable to determine if Materialized view " + materializedViewTable.getFullyQualifiedName() + " contents are outdated. It may uses external tables?");
                    continue;
                }
                if (outdated.booleanValue()) {
                    LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as its contents are outdated");
                    continue;
                }
                result.add(materialization);
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<String> getAllDatabases() throws HiveException {
        try {
            return this.getMSC().getAllDatabases();
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<String> getDatabasesByPattern(String databasePattern) throws HiveException {
        try {
            return this.getMSC().getDatabases(databasePattern);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public boolean grantPrivileges(PrivilegeBag privileges) throws HiveException {
        try {
            return this.getMSC().grant_privileges(privileges);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_privileges(privileges, grantOption);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void validateDatabaseExists(String databaseName) throws SemanticException {
        boolean exists;
        try {
            exists = this.databaseExists(databaseName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName), (Throwable)e);
        }
        if (!exists) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName));
        }
    }

    public Catalog getCatalog(String catName) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getCatalog");
        try {
            Catalog catalog = this.getMSC().getCatalog(catName);
            return catalog;
        }
        catch (NoSuchObjectException e) {
            Catalog catalog = null;
            return catalog;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getCatalog", "HS2-cache");
        }
    }

    public void alterCatalog(String catName, Catalog catalog) throws HiveException {
        try {
            this.getMSC().alterCatalog(catName, catalog);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Catalog " + catName + " does not exists.", (Throwable)e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter catalog " + catName + ". " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean databaseExists(String dbName) throws HiveException {
        return this.getDatabase(dbName) != null;
    }

    public Database getDatabase(String dbName) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getDatabase");
        try {
            Database database = this.getMSC().getDatabase(dbName);
            return database;
        }
        catch (NoSuchObjectException e) {
            Database database = null;
            return database;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getDatabase", "HS2-cache");
        }
    }

    public Database getDatabase(String catName, String dbName) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getDatabase2");
        try {
            Database database = this.getMSC().getDatabase(catName, dbName);
            return database;
        }
        catch (NoSuchObjectException e) {
            Database database = null;
            return database;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getDatabase2", "HS2-cache");
        }
    }

    public Database getDatabaseCurrent() throws HiveException {
        String currentDb = SessionState.get().getCurrentDatabase();
        return this.getDatabase(currentDb);
    }

    private AcidUtils.TableSnapshot getTableSnapshot(Table tbl, Long writeId) throws LockException {
        AcidUtils.TableSnapshot tableSnapshot = null;
        if (writeId != null && writeId > 0L) {
            ValidWriteIdList writeIds = AcidUtils.getTableValidWriteIdListWithTxnList((Configuration)this.conf, tbl.getDbName(), tbl.getTableName());
            tableSnapshot = new AcidUtils.TableSnapshot(writeId, writeIds.writeToString());
        } else {
            tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, tbl, tbl.getDbName(), tbl.getTableName(), true);
        }
        return tableSnapshot;
    }

    public Partition loadPartition(Path loadPath, Table tbl, Map<String, String> partSpec, LoadTableDesc.LoadFileType loadFileType, boolean inheritTableSpecs, boolean inheritLocation, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcidIUDoperation, boolean resetStatistics, Long writeId, int stmtId, boolean isInsertOverwrite, boolean isDirectInsert) throws HiveException {
        AcidUtils.TableSnapshot tableSnapshot;
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin("MoveTask", "LoadPartition");
        Partition oldPart = this.getPartition(tbl, partSpec, false);
        boolean isTxnTable = AcidUtils.isTransactionalTable(tbl);
        List<FileStatus> newFiles = null;
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary()) {
            newFiles = Collections.synchronizedList(new ArrayList());
        }
        Partition newTPart = this.loadPartitionInternal(loadPath, tbl, partSpec, oldPart, loadFileType, inheritTableSpecs, inheritLocation, isSkewedStoreAsSubdir, isSrcLocal, isAcidIUDoperation, resetStatistics, writeId, stmtId, isInsertOverwrite, isTxnTable, newFiles, isDirectInsert);
        AcidUtils.TableSnapshot tableSnapshot2 = tableSnapshot = isTxnTable ? this.getTableSnapshot(tbl, writeId) : null;
        if (tableSnapshot != null) {
            newTPart.getTPartition().setWriteId(tableSnapshot.getWriteId());
        }
        if (oldPart == null) {
            this.addPartitionToMetastore(newTPart, resetStatistics, tbl, tableSnapshot);
            if (isTxnTable && null != newFiles) {
                this.addWriteNotificationLog(tbl, partSpec, newFiles, writeId, null);
            }
        } else {
            try {
                this.setStatsPropAndAlterPartition(resetStatistics, tbl, newTPart, tableSnapshot);
            }
            catch (TException e) {
                LOG.error("Error loading partitions", (Throwable)e);
                throw new HiveException((Throwable)e);
            }
        }
        perfLogger.perfLogEnd("MoveTask", "LoadPartition");
        return newTPart;
    }

    private Partition loadPartitionInternal(Path loadPath, Table tbl, Map<String, String> partSpec, Partition oldPart, LoadTableDesc.LoadFileType loadFileType, boolean inheritTableSpecs, boolean inheritLocation, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcidIUDoperation, boolean resetStatistics, Long writeId, int stmtId, boolean isInsertOverwrite, boolean isTxnTable, List<FileStatus> newFiles, boolean isDirectInsert) throws HiveException {
        Path tblDataLocationPath = tbl.getDataLocation();
        boolean isMmTableWrite = AcidUtils.isInsertOnlyTable(tbl.getParameters());
        assert (tbl.getPath() != null) : "null==getPath() for " + tbl.getTableName();
        boolean isFullAcidTable = AcidUtils.isFullAcidTable(tbl);
        List<Object> newFileStatuses = null;
        try {
            PerfLogger perfLogger = SessionState.getPerfLogger();
            Path oldPartPath = oldPart != null ? oldPart.getDataLocation() : null;
            Path newPartPath = null;
            if (inheritLocation) {
                FileSystem tblPathFS;
                FileSystem oldPartPathFS;
                newPartPath = Hive.genPartPathFromTable(tbl, partSpec, tblDataLocationPath);
                if (oldPart != null && FileUtils.isEqualFileSystemAndSameOzoneBucket((FileSystem)(oldPartPathFS = oldPartPath.getFileSystem((Configuration)this.getConf())), (FileSystem)(tblPathFS = tblDataLocationPath.getFileSystem((Configuration)this.getConf())), (Path)oldPartPath, (Path)tblDataLocationPath)) {
                    newPartPath = oldPartPath;
                }
            } else {
                newPartPath = oldPartPath == null ? Hive.genPartPathFromTable(tbl, partSpec, tblDataLocationPath) : oldPartPath;
            }
            perfLogger.perfLogBegin("MoveTask", "FileMoves");
            if ((isMmTableWrite || isDirectInsert || isFullAcidTable) && loadPath.equals((Object)newPartPath) || loadFileType == LoadTableDesc.LoadFileType.IGNORE) {
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("not moving " + String.valueOf(loadPath) + " to " + String.valueOf(newPartPath) + " (MM = " + isMmTableWrite + ", Direct insert = " + isDirectInsert + ")");
                }
                if (newFiles != null) {
                    if (!newFiles.isEmpty()) {
                        newFileStatuses = new ArrayList<FileStatus>();
                        newFileStatuses.addAll(newFiles);
                    } else {
                        newFileStatuses = this.listFilesCreatedByQuery(loadPath, writeId, stmtId);
                        newFiles.addAll(newFileStatuses);
                    }
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("maybe deleting stuff from " + String.valueOf(oldPartPath) + " (new " + String.valueOf(newPartPath) + ") for replace");
                }
            } else {
                boolean isManaged;
                Path destPath = newPartPath;
                if (isMmTableWrite) {
                    destPath = new Path(destPath, isInsertOverwrite ? AcidUtils.baseDir(writeId) : AcidUtils.deltaSubdir(writeId, writeId, stmtId));
                }
                if (!isAcidIUDoperation && isFullAcidTable) {
                    destPath = this.fixFullAcidPathForLoadData(loadFileType, destPath, writeId, stmtId, tbl);
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("moving " + String.valueOf(loadPath) + " to " + String.valueOf(destPath));
                }
                boolean bl = isManaged = tbl.getTableType() == TableType.MANAGED_TABLE;
                if (!isTxnTable && (loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL || oldPart == null && !isAcidIUDoperation)) {
                    boolean isSkipTrash = MetaStoreUtils.isSkipTrash(tbl.getParameters());
                    boolean needRecycle = !tbl.isTemporary() && ReplChangeManager.shouldEnableCm((Database)this.getDatabase(tbl.getDbName()), (org.apache.hadoop.hive.metastore.api.Table)tbl.getTTable());
                    this.replaceFiles(tbl.getPath(), loadPath, destPath, oldPartPath, this.getConf(), isSrcLocal, isSkipTrash, newFiles, FileUtils.HIDDEN_FILES_PATH_FILTER, needRecycle, isManaged, isInsertOverwrite);
                } else {
                    FileSystem fs = destPath.getFileSystem((Configuration)this.conf);
                    Hive.copyFiles(this.conf, loadPath, destPath, fs, isSrcLocal, isAcidIUDoperation, loadFileType == LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, newFiles, tbl.getNumBuckets() > 0, isFullAcidTable, isManaged, false);
                }
            }
            perfLogger.perfLogEnd("MoveTask", "FileMoves");
            Partition newTPart = oldPart != null ? oldPart : new Partition(tbl, partSpec, newPartPath);
            this.alterPartitionSpecInMemory(tbl, partSpec, newTPart.getTPartition(), inheritTableSpecs, newPartPath.toString());
            this.validatePartition(newTPart);
            if (null != oldPart && null != newFiles) {
                if (isTxnTable) {
                    this.addWriteNotificationLog(tbl, partSpec, newFiles, writeId, null);
                } else {
                    this.fireInsertEvent(tbl, partSpec, loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL, newFiles);
                }
            } else {
                LOG.debug("No new files were created, and is not a replace, or we're inserting into a partition that does not exist yet. Skipping generating INSERT event.");
            }
            if (isSkewedStoreAsSubdir) {
                org.apache.hadoop.hive.metastore.api.Partition newCreatedTpart = newTPart.getTPartition();
                SkewedInfo skewedInfo = newCreatedTpart.getSd().getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(newPartPath, skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
                newCreatedTpart.getSd().setSkewedInfo(skewedInfo);
            }
            if (resetStatistics || !this.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER)) {
                LOG.debug("Clear partition column statistics by setting basic stats to false for " + newTPart.getCompleteName());
                StatsSetupConst.setBasicStatsState(newTPart.getParameters(), (String)"false");
            }
            if (oldPart == null) {
                newTPart.getTPartition().setParameters(new HashMap());
                if (this.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER)) {
                    StatsSetupConst.setStatsStateForCreateTable(newTPart.getParameters(), (List)MetaStoreUtils.getColumnNames(tbl.getCols()), (String)"true");
                }
                List<Object> filesForStats = null;
                filesForStats = newFileStatuses != null && !newFileStatuses.isEmpty() ? newFileStatuses : (isTxnTable ? AcidUtils.getAcidFilesForStats(newTPart.getTable(), newPartPath, (Configuration)this.conf, null) : HiveStatsUtils.getFileStatusRecurse((Path)newPartPath, (int)-1, (FileSystem)newPartPath.getFileSystem((Configuration)this.conf)));
                if (filesForStats != null) {
                    MetaStoreServerUtils.populateQuickStats(filesForStats, newTPart.getParameters());
                } else {
                    MetaStoreServerUtils.clearQuickStats(newTPart.getParameters());
                }
            }
            return newTPart;
        }
        catch (IOException | InvalidOperationException | MetaException e) {
            LOG.error("Error in loadPartitionInternal", e);
            throw new HiveException(e);
        }
    }

    private void addPartitionToMetastore(Partition newTPart, boolean resetStatistics, Table tbl, AcidUtils.TableSnapshot tableSnapshot) throws HiveException {
        try {
            LOG.debug("Adding new partition " + String.valueOf(newTPart.getSpec()));
            this.getMSC().add_partition(newTPart.getTPartition());
        }
        catch (AlreadyExistsException aee) {
            LOG.debug("Caught AlreadyExistsException, trying to alter partition instead");
            try {
                this.setStatsPropAndAlterPartition(resetStatistics, tbl, newTPart, tableSnapshot);
            }
            catch (TException e) {
                LOG.error("Error setStatsPropAndAlterPartition", (Throwable)e);
                throw new HiveException((Throwable)e);
            }
        }
        catch (Exception e) {
            try {
                FileSystem newPathFileSystem = newTPart.getPartitionPath().getFileSystem((Configuration)this.getConf());
                boolean isSkipTrash = MetaStoreUtils.isSkipTrash(tbl.getParameters());
                FileStatus status = newPathFileSystem.getFileStatus(newTPart.getPartitionPath());
                Hive.trashFiles(newPathFileSystem, new FileStatus[]{status}, (Configuration)this.getConf(), isSkipTrash);
            }
            catch (IOException io) {
                LOG.error("Could not delete partition directory contents after failed partition creation: ", (Throwable)io);
            }
            LOG.error("Error addPartitionToMetastore", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    private void addPartitionsToMetastore(List<Partition> partitions, boolean resetStatistics, Table tbl, List<AcidUtils.TableSnapshot> tableSnapshots) throws HiveException {
        try {
            if (partitions.isEmpty() || tableSnapshots.isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                StringBuffer debugMsg = new StringBuffer("Adding new partitions ");
                partitions.forEach(partition -> debugMsg.append(String.valueOf(partition.getSpec()) + " "));
                LOG.debug(debugMsg.toString());
            }
            this.getMSC().add_partitions(partitions.stream().map(Partition::getTPartition).collect(Collectors.toList()));
        }
        catch (AlreadyExistsException aee) {
            LOG.debug("Caught AlreadyExistsException, trying to add partitions one by one.");
            assert (partitions.size() == tableSnapshots.size());
            for (int i = 0; i < partitions.size(); ++i) {
                this.addPartitionToMetastore(partitions.get(i), resetStatistics, tbl, tableSnapshots.get(i));
            }
        }
        catch (Exception e) {
            try {
                for (Partition partition2 : partitions) {
                    FileSystem newPathFileSystem = partition2.getPartitionPath().getFileSystem((Configuration)this.getConf());
                    boolean isSkipTrash = MetaStoreUtils.isSkipTrash(tbl.getParameters());
                    FileStatus status = newPathFileSystem.getFileStatus(partition2.getPartitionPath());
                    Hive.trashFiles(newPathFileSystem, new FileStatus[]{status}, (Configuration)this.getConf(), isSkipTrash);
                }
            }
            catch (IOException io) {
                LOG.error("Could not delete partition directory contents after failed partition creation: ", (Throwable)io);
            }
            LOG.error("Failed addPartitionsToMetastore", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    private static Path genPartPathFromTable(Table tbl, Map<String, String> partSpec, Path tblDataLocationPath) throws MetaException {
        Path partPath = new Path(tbl.getDataLocation(), Warehouse.makePartPath(partSpec));
        return new Path(tblDataLocationPath.toUri().getScheme(), tblDataLocationPath.toUri().getAuthority(), partPath.toUri().getPath());
    }

    private Path fixFullAcidPathForLoadData(LoadTableDesc.LoadFileType loadFileType, Path destPath, long writeId, int stmtId, Table tbl) throws HiveException {
        switch (loadFileType) {
            case REPLACE_ALL: {
                destPath = new Path(destPath, AcidUtils.baseDir(writeId));
                break;
            }
            case KEEP_EXISTING: {
                destPath = new Path(destPath, AcidUtils.deltaSubdir(writeId, writeId, stmtId));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected " + LoadTableDesc.LoadFileType.class.getName() + " " + String.valueOf((Object)loadFileType));
            }
        }
        try {
            FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)SessionState.getSessionConf());
            if (!FileUtils.mkdir((FileSystem)fs, (Path)destPath, (Configuration)this.conf)) {
                LOG.warn(String.valueOf(destPath) + " already exists?!?!");
            }
        }
        catch (IOException e) {
            throw new HiveException("load: error while creating " + String.valueOf(destPath) + ";loadFileType=" + String.valueOf((Object)loadFileType), (Throwable)e);
        }
        return destPath;
    }

    public static void listFilesInsideAcidDirectory(Path acidDir, FileSystem srcFs, List<Path> newFiles, PathFilter filter) throws IOException {
        FileStatus[] acidFiles = null;
        acidFiles = filter != null ? srcFs.listStatus(acidDir, filter) : srcFs.listStatus(acidDir);
        if (acidFiles == null) {
            LOG.debug("No files added by this query in: " + String.valueOf(acidDir));
            return;
        }
        LOG.debug("Listing files under " + String.valueOf(acidDir));
        for (FileStatus acidFile : acidFiles) {
            if (!acidFile.isDirectory()) {
                newFiles.add(acidFile.getPath());
                continue;
            }
            Hive.listFilesInsideAcidDirectory(acidFile.getPath(), srcFs, newFiles, null);
        }
    }

    private List<FileStatus> listFilesCreatedByQuery(Path loadPath, long writeId, int stmtId) throws HiveException {
        try {
            FileSystem srcFs = loadPath.getFileSystem((Configuration)this.conf);
            AcidUtils.IdFullPathFiler filter = new AcidUtils.IdFullPathFiler(writeId, stmtId, loadPath);
            return HdfsUtils.listLocatedFileStatus(srcFs, loadPath, filter, true);
        }
        catch (FileNotFoundException e) {
            LOG.info("directory does not exist: " + String.valueOf(loadPath));
        }
        catch (IOException e) {
            LOG.error("Error listing files", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    private void setStatsPropAndAlterPartition(boolean resetStatistics, Table tbl, Partition newTPart, AcidUtils.TableSnapshot tableSnapshot) throws TException {
        EnvironmentContext ec = new EnvironmentContext();
        if (!resetStatistics) {
            ec.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        LOG.debug("Altering existing partition " + String.valueOf(newTPart.getSpec()));
        this.getMSC().alter_partition(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), newTPart.getTPartition(), new EnvironmentContext(), tableSnapshot == null ? null : tableSnapshot.getValidWriteIdList());
    }

    private void setStatsPropAndAlterPartitions(boolean resetStatistics, Table tbl, List<Partition> partitions, AcidUtils.TableSnapshot tableSnapshot) throws TException {
        if (partitions.isEmpty() || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER)) {
            return;
        }
        EnvironmentContext ec = new EnvironmentContext();
        if (!resetStatistics) {
            ec.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Altering existing partitions ");
            partitions.forEach(p -> sb.append(p.getSpec()));
            LOG.debug(sb.toString());
        }
        String validWriteIdList = null;
        long writeId = 0L;
        if (tableSnapshot != null) {
            validWriteIdList = tableSnapshot.getValidWriteIdList();
            writeId = tableSnapshot.getWriteId();
        }
        this.getMSC().alter_partitions(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), partitions.stream().map(Partition::getTPartition).collect(Collectors.toList()), ec, validWriteIdList, writeId);
    }

    private void walkDirTree(FileStatus fSta, FileSystem fSys, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) throws IOException {
        if (!fSta.isDir()) {
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Processing LB leaf " + String.valueOf(fSta.getPath()));
            }
            this.constructOneLBLocationMap(fSta, skewedColValueLocationMaps, newPartPath, skewedInfo);
            return;
        }
        FileStatus[] children = fSys.listStatus(fSta.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        if (children != null) {
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Processing LB dir " + String.valueOf(fSta.getPath()));
            }
            for (FileStatus child : children) {
                this.walkDirTree(child, fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
            }
        }
    }

    private void constructOneLBLocationMap(FileStatus fSta, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) {
        String partDirName;
        Path lbdPath = fSta.getPath().getParent();
        ArrayList<String> skewedValue = new ArrayList<String>();
        String lbDirName = FileUtils.unescapePathName((String)lbdPath.toString());
        String lbDirSuffix = lbDirName.replace(partDirName = FileUtils.unescapePathName((String)newPartPath.toString()), "");
        if (lbDirSuffix.startsWith("/")) {
            lbDirSuffix = lbDirSuffix.substring(1);
        }
        String[] dirNames = lbDirSuffix.split("/");
        int keysFound = 0;
        int dirsToTake = 0;
        int colCount = skewedInfo.getSkewedColNames().size();
        while (dirsToTake < dirNames.length && keysFound < colCount) {
            String dirName;
            if ((dirName = dirNames[dirsToTake++]).equalsIgnoreCase("HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME")) {
                ++keysFound;
                continue;
            }
            String[] kv = dirName.split("=");
            if (kv.length == 2) {
                skewedValue.add(kv[1]);
                ++keysFound;
                continue;
            }
            LOG.warn("Skipping unknown directory " + dirName + " when expecting LB keys or default directory (from " + lbDirName + ")");
        }
        for (int i = 0; i < dirNames.length - dirsToTake; ++i) {
            lbdPath = lbdPath.getParent();
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Saving LB location " + String.valueOf(lbdPath) + " based on " + colCount + " keys and " + String.valueOf(fSta.getPath()));
        }
        if (skewedValue.size() > 0 && skewedValue.size() == colCount && !skewedColValueLocationMaps.containsKey(skewedValue)) {
            skewedColValueLocationMaps.put(skewedValue, lbdPath.toString());
        }
    }

    private Map<List<String>, String> constructListBucketingLocationMap(Path newPartPath, SkewedInfo skewedInfo) throws IOException, FileNotFoundException {
        HashMap<List<String>, String> skewedColValueLocationMaps = new HashMap<List<String>, String>();
        FileSystem fSys = newPartPath.getFileSystem((Configuration)this.conf);
        this.walkDirTree(fSys.getFileStatus(newPartPath), fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
        return skewedColValueLocationMaps;
    }

    public Map<Map<String, String>, Partition> loadDynamicPartitions(LoadTableDesc tbd, int numLB, boolean isAcid, long writeId, int stmtId, boolean resetStatistics, AcidUtils.Operation operation, Map<Path, Utilities.PartitionDetails> partitionDetailsMap) throws HiveException {
        boolean isTxnTable;
        PrintStream printStream;
        boolean inPlaceEligible;
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin("MoveTask", "LoadDynamicPartitions");
        Path loadPath = tbd.getSourcePath();
        Table tbl = this.getTable(tbd.getTable().getTableName());
        Map<String, String> partSpec = tbd.getPartitionSpec();
        AtomicInteger partitionsLoaded = new AtomicInteger(0);
        boolean bl = inPlaceEligible = this.conf.getLong("fs.trash.interval", 0L) <= 0L && InPlaceUpdate.canRenderInPlace((HiveConf)this.conf) && !SessionState.getConsole().getIsSilent();
        if (inPlaceEligible) {
            SessionState.getConsole();
            printStream = SessionState.LogHelper.getInfoStream();
        } else {
            printStream = null;
        }
        PrintStream ps = printStream;
        SessionState parentSession = SessionState.get();
        LinkedList tasks = Lists.newLinkedList();
        boolean fetchPartitionInfo = true;
        boolean scanPartitionsByName = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOAD_DYNAMIC_PARTITIONS_SCAN_SPECIFIC_PARTITIONS);
        if (scanPartitionsByName && !tbd.isDirectInsert() && !AcidUtils.isTransactionalTable(tbl)) {
            LinkedList<String> partitionNames = new LinkedList<String>();
            for (Utilities.PartitionDetails partitionDetails : partitionDetailsMap.values()) {
                if (partitionDetails.fullSpec == null || partitionDetails.fullSpec.isEmpty()) continue;
                partitionNames.add(Warehouse.makeDynamicPartNameNoTrailingSeperator(partitionDetails.fullSpec));
            }
            List<Partition> partitions = Hive.get().getPartitionsByNames(tbl, partitionNames);
            for (Partition partition : partitions) {
                LOG.debug("HMS partition spec: {}", partition.getSpec());
                partitionDetailsMap.entrySet().parallelStream().filter(entry -> ((Utilities.PartitionDetails)entry.getValue()).fullSpec.equals(partition.getSpec())).findAny().ifPresent(entry -> {
                    ((Utilities.PartitionDetails)entry.getValue()).partition = partition;
                    ((Utilities.PartitionDetails)entry.getValue()).hasOldPartition = true;
                });
            }
            fetchPartitionInfo = false;
        }
        AcidUtils.TableSnapshot tableSnapshot = (isTxnTable = AcidUtils.isTransactionalTable(tbl)) ? this.getTableSnapshot(tbl, writeId) : null;
        for (Map.Entry<Path, Utilities.PartitionDetails> entry2 : partitionDetailsMap.entrySet()) {
            boolean getPartitionFromHms = fetchPartitionInfo;
            tasks.add(() -> {
                Utilities.PartitionDetails partitionDetails = (Utilities.PartitionDetails)entry2.getValue();
                Map<String, String> fullPartSpec = partitionDetails.fullSpec;
                try {
                    Object object;
                    Partition existing;
                    SessionState.setCurrentSessionState(parentSession);
                    if (getPartitionFromHms && (existing = this.getPartition(tbl, fullPartSpec, false)) != null) {
                        partitionDetails.partition = existing;
                        partitionDetails.hasOldPartition = true;
                    }
                    LOG.info("New loading path = " + String.valueOf(entry2.getKey()) + " withPartSpec " + String.valueOf(fullPartSpec));
                    Partition oldPartition = partitionDetails.partition;
                    List<Object> newFiles = null;
                    if (partitionDetails.newFiles != null) {
                        newFiles = partitionDetails.newFiles;
                    } else if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary()) {
                        newFiles = Collections.synchronizedList(new ArrayList());
                    }
                    Partition partition = this.loadPartitionInternal((Path)entry2.getKey(), tbl, fullPartSpec, oldPartition, tbd.getLoadFileType(), true, false, numLB > 0, false, isAcid, resetStatistics, writeId, stmtId, tbd.isInsertOverwrite(), isTxnTable, newFiles, tbd.isDirectInsert());
                    if (tableSnapshot != null) {
                        partition.getTPartition().setWriteId(tableSnapshot.getWriteId());
                    }
                    partitionDetails.tableSnapshot = tableSnapshot;
                    if (oldPartition == null) {
                        partitionDetails.newFiles = newFiles;
                        partitionDetails.partition = partition;
                    }
                    if (inPlaceEligible) {
                        object = ps;
                        synchronized (object) {
                            InPlaceUpdate.rePositionCursor((PrintStream)ps);
                            partitionsLoaded.incrementAndGet();
                            InPlaceUpdate.reprintLine((PrintStream)ps, (String)("Loaded : " + partitionsLoaded.get() + "/" + partitionDetailsMap.size() + " partitions."));
                        }
                    }
                    object = partition;
                    return object;
                }
                catch (Exception e) {
                    LOG.error("Exception when loading partition with parameters  partPath=" + String.valueOf(entry2.getKey()) + ",  table=" + tbl.getTableName() + ",  partSpec=" + String.valueOf(fullPartSpec) + ",  loadFileType=" + tbd.getLoadFileType().toString() + ",  listBucketingLevel=" + numLB + ",  isAcid=" + isAcid + ",  resetStatistics=" + resetStatistics, (Throwable)e);
                    throw e;
                }
                finally {
                    Hive.closeCurrent();
                }
            });
        }
        int n = this.conf.getInt(HiveConf.ConfVars.HIVE_LOAD_DYNAMIC_PARTITIONS_THREAD_COUNT.varname, 1);
        ExecutorService executor = Executors.newFixedThreadPool(n, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("load-dynamic-partitionsToAdd-%d").build());
        List<Object> futures = Lists.newLinkedList();
        LinkedHashMap result = Maps.newLinkedHashMap();
        try {
            futures = executor.invokeAll(tasks);
            LOG.info("Number of partitionsToAdd to be added is " + futures.size());
            for (Future future : futures) {
                Partition partition = (Partition)future.get();
                result.put(partition.getSpec(), partition);
            }
            this.addPartitionsToMetastore(partitionDetailsMap.entrySet().stream().filter(entry -> !((Utilities.PartitionDetails)entry.getValue()).hasOldPartition).map(entry -> ((Utilities.PartitionDetails)entry.getValue()).partition).collect(Collectors.toList()), resetStatistics, tbl, partitionDetailsMap.entrySet().stream().filter(entry -> !((Utilities.PartitionDetails)entry.getValue()).hasOldPartition).map(entry -> ((Utilities.PartitionDetails)entry.getValue()).tableSnapshot).collect(Collectors.toList()));
            ArrayList<WriteNotificationLogRequest> requestList = new ArrayList<WriteNotificationLogRequest>();
            int n2 = this.conf.getIntVar(HiveConf.ConfVars.HIVE_WRITE_NOTIFICATION_MAX_BATCH_SIZE);
            for (Map.Entry<Path, Utilities.PartitionDetails> entry3 : partitionDetailsMap.entrySet()) {
                Utilities.PartitionDetails partitionDetails = entry3.getValue();
                if (!isTxnTable || partitionDetails.newFiles == null) continue;
                this.addWriteNotificationLog(tbl, partitionDetails.fullSpec, partitionDetails.newFiles, writeId, requestList);
                if (requestList == null || requestList.size() < n2) continue;
                boolean batchSupported = this.addWriteNotificationLogInBatch(tbl, requestList);
                if (batchSupported) {
                    requestList.clear();
                    continue;
                }
                requestList = null;
            }
            if (requestList != null && requestList.size() > 0) {
                this.addWriteNotificationLogInBatch(tbl, requestList);
            }
            this.setStatsPropAndAlterPartitions(resetStatistics, tbl, partitionDetailsMap.entrySet().stream().filter(entry -> ((Utilities.PartitionDetails)entry.getValue()).hasOldPartition).map(entry -> ((Utilities.PartitionDetails)entry.getValue()).partition).collect(Collectors.toList()), tableSnapshot);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HiveException("Exception when loading " + partitionDetailsMap.size() + " partitions in table " + tbl.getTableName() + " with loadPath=" + String.valueOf(loadPath), (Throwable)e);
        }
        catch (TException e) {
            LOG.error("Failed loadDynamicPartitions", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        catch (Exception e) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Exception when loading partitionsToAdd with parameters ");
            stringBuffer.append("partPaths=");
            partitionDetailsMap.keySet().forEach(path -> logMsg.append(String.valueOf(path) + ", "));
            stringBuffer.append("table=" + tbl.getTableName() + ", ").append("partSpec=" + String.valueOf(partSpec) + ", ").append("loadFileType=" + tbd.getLoadFileType().toString() + ", ").append("listBucketingLevel=" + numLB + ", ").append("isAcid=" + isAcid + ", ").append("resetStatistics=" + resetStatistics);
            LOG.error(stringBuffer.toString(), (Throwable)e);
            throw e;
        }
        finally {
            LOG.debug("Cancelling " + futures.size() + " dynamic loading tasks");
            executor.shutdownNow();
        }
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST) && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION)) {
            throw new HiveException(HiveConf.ConfVars.HIVE_TEST_MODE_FAIL_LOAD_DYNAMIC_PARTITION.name() + "=true");
        }
        try {
            if (isTxnTable) {
                List partNames = result.values().stream().map(Partition::getName).collect(Collectors.toList());
                this.getMSC().addDynamicPartitions(parentSession.getTxnMgr().getCurrentTxnId(), writeId, tbl.getDbName(), tbl.getTableName(), partNames, AcidUtils.toDataOperationType(operation));
            }
            LOG.info("Loaded " + result.size() + "partitionsToAdd");
            perfLogger.perfLogEnd("MoveTask", "LoadDynamicPartitions");
            return result;
        }
        catch (TException te) {
            LOG.error("Failed loadDynamicPartitions", (Throwable)te);
            throw new HiveException("Exception updating metastore for acid table " + tbd.getTable().getTableName() + " with partitions " + String.valueOf(result.values()), (Throwable)te);
        }
    }

    private boolean addWriteNotificationLogInBatch(Table tbl, List<WriteNotificationLogRequest> requestList) throws HiveException, MetaException, TException {
        long start = System.currentTimeMillis();
        boolean supported = true;
        WriteNotificationLogBatchRequest rqst = new WriteNotificationLogBatchRequest(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), requestList);
        try {
            Hive.get(this.conf).getMSC().addWriteNotificationLogInBatch(rqst);
        }
        catch (TApplicationException e) {
            int type = e.getType();
            if (type == 1 || type == 3) {
                LOG.info("addWriteNotificationLogInBatch failed with ", (Throwable)e);
                for (WriteNotificationLogRequest request : requestList) {
                    Hive.get(this.conf).getMSC().addWriteNotificationLog(request);
                }
                supported = false;
            }
            throw e;
        }
        long end = System.currentTimeMillis();
        LOG.info("Time taken to add " + requestList.size() + " write notifications: " + (float)(end - start) / 1000.0f + " seconds");
        return supported;
    }

    public void loadTable(Path loadPath, String tableName, LoadTableDesc.LoadFileType loadFileType, boolean isSrcLocal, boolean isSkewedStoreAsSubdir, boolean isAcidIUDoperation, boolean resetStatistics, Long writeId, int stmtId, boolean isInsertOverwrite, boolean isDirectInsert) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin("MoveTask", "LoadTable");
        List<FileStatus> newFiles = null;
        Table tbl = this.getTable(tableName);
        assert (tbl.getPath() != null) : "null==getPath() for " + tbl.getTableName();
        boolean isTxnTable = AcidUtils.isTransactionalTable(tbl);
        boolean isMmTable = AcidUtils.isInsertOnlyTable(tbl);
        boolean isFullAcidTable = AcidUtils.isFullAcidTable(tbl);
        boolean isCompactionTable = AcidUtils.isCompactionTable(tbl.getParameters());
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary()) {
            newFiles = Collections.synchronizedList(new ArrayList());
        }
        if ((isMmTable || isDirectInsert || isFullAcidTable) && loadPath.equals((Object)tbl.getPath()) || loadFileType == LoadTableDesc.LoadFileType.IGNORE) {
            if (Utilities.FILE_OP_LOGGER.isDebugEnabled()) {
                Utilities.FILE_OP_LOGGER.debug("not moving " + String.valueOf(loadPath) + " to " + String.valueOf(tbl.getPath()) + " (MM)");
            }
            if (newFiles != null) {
                newFiles.addAll(this.listFilesCreatedByQuery(loadPath, writeId, stmtId));
            }
        } else {
            boolean isManaged;
            Path tblPath;
            Path destPath = tblPath = tbl.getPath();
            if (isMmTable) {
                destPath = new Path(destPath, isInsertOverwrite ? AcidUtils.baseDir(writeId) : AcidUtils.deltaSubdir(writeId, writeId, stmtId));
            }
            if (!isAcidIUDoperation && isFullAcidTable) {
                destPath = this.fixFullAcidPathForLoadData(loadFileType, destPath, writeId, stmtId, tbl);
            }
            Utilities.FILE_OP_LOGGER.debug("moving " + String.valueOf(loadPath) + " to " + String.valueOf(tblPath) + " (replace = " + String.valueOf((Object)loadFileType) + ")");
            perfLogger.perfLogBegin("MoveTask", "FileMoves");
            boolean bl = isManaged = tbl.getTableType() == TableType.MANAGED_TABLE;
            if (loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL && !isTxnTable) {
                boolean isSkipTrash = MetaStoreUtils.isSkipTrash(tbl.getParameters());
                boolean needRecycle = !tbl.isTemporary() && ReplChangeManager.shouldEnableCm((Database)this.getDatabase(tbl.getDbName()), (org.apache.hadoop.hive.metastore.api.Table)tbl.getTTable());
                this.replaceFiles(tblPath, loadPath, destPath, tblPath, this.conf, isSrcLocal, isSkipTrash, newFiles, FileUtils.HIDDEN_FILES_PATH_FILTER, needRecycle, isManaged, isInsertOverwrite);
            } else {
                try {
                    FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                    Hive.copyFiles(this.conf, loadPath, destPath, fs, isSrcLocal, isAcidIUDoperation, loadFileType == LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, newFiles, tbl.getNumBuckets() > 0, isFullAcidTable, isManaged, isCompactionTable);
                }
                catch (IOException e) {
                    throw new HiveException("addFiles: filesystem error in check phase", (Throwable)e);
                }
            }
            perfLogger.perfLogEnd("MoveTask", "FileMoves");
        }
        if (resetStatistics || !this.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER)) {
            LOG.debug("Clear table column statistics and set basic statistics to false for " + tbl.getCompleteName());
            StatsSetupConst.setBasicStatsState(tbl.getParameters(), (String)"false");
        }
        try {
            if (isSkewedStoreAsSubdir) {
                SkewedInfo skewedInfo = tbl.getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(tbl.getPath(), skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
            }
        }
        catch (IOException e) {
            LOG.error("Failed loadTable", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        EnvironmentContext environmentContext = null;
        if (!resetStatistics) {
            environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        this.alterTable(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), tbl, false, environmentContext, true, writeId == null ? 0L : writeId);
        if (AcidUtils.isTransactionalTable(tbl)) {
            this.addWriteNotificationLog(tbl, null, newFiles, writeId, null);
        } else {
            this.fireInsertEvent(tbl, null, loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL, newFiles);
        }
        perfLogger.perfLogEnd("MoveTask", "LoadTable");
    }

    @VisibleForTesting
    public Partition createPartition(Table tbl, Map<String, String> partSpec) throws HiveException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition part = Partition.createMetaPartitionObject(tbl, partSpec, null);
            AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, tbl);
            part.setWriteId(tableSnapshot != null ? tableSnapshot.getWriteId() : 0L);
            return new Partition(tbl, this.getMSC().add_partition(part));
        }
        catch (Exception e) {
            LOG.error("Failed createPartition", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> addPartitions(List<org.apache.hadoop.hive.metastore.api.Partition> partitions, boolean ifNotExists, boolean needResults) throws HiveException {
        try {
            return this.getMSC().add_partitions(partitions, ifNotExists, needResults);
        }
        catch (Exception e) {
            LOG.error("Failed addPartitions", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public org.apache.hadoop.hive.metastore.api.Partition getPartition(Table t, String dbName, String tableName, List<String> params) throws HiveException {
        try {
            GetPartitionRequest req = new GetPartitionRequest();
            req.setDbName(dbName);
            req.setTblName(tableName);
            req.setPartVals(params);
            if (AcidUtils.isTransactionalTable(t)) {
                ValidWriteIdList validWriteIdList = this.getValidWriteIdList(dbName, tableName);
                req.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
                req.setId(t.getTTable().getId());
            }
            GetPartitionResponse res = this.getMSC().getPartitionRequest(req);
            return res.getPartition();
        }
        catch (Exception e) {
            LOG.error("Failed getPartition", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public void alterPartitions(String dbName, String tableName, List<org.apache.hadoop.hive.metastore.api.Partition> partitions, EnvironmentContext ec, String validWriteIdList, long writeId) throws HiveException {
        try {
            this.getMSC().alter_partitions(dbName, tableName, partitions, ec, validWriteIdList, writeId);
        }
        catch (Exception e) {
            LOG.error("Failed alterPartitions", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> getPartitionsByNames(String dbName, String tableName, List<String> partitionNames, Table t) throws HiveException {
        try {
            GetPartitionsByNamesRequest req = new GetPartitionsByNamesRequest();
            req.setDb_name(dbName);
            req.setTbl_name(tableName);
            req.setNames(partitionNames);
            return this.getPartitionsByNames(req, t);
        }
        catch (Exception e) {
            LOG.error("Failed getPartitionsByNames", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> getPartitionsByNames(GetPartitionsByNamesRequest req, Table table) throws HiveException {
        try {
            if (AcidUtils.isTransactionalTable(table)) {
                ValidWriteIdList validWriteIdList = this.getValidWriteIdList(req.getDb_name(), req.getTbl_name());
                req.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
                req.setId(table.getTTable().getId());
            }
            return this.getMSC().getPartitionsByNames(req).getPartitions();
        }
        catch (Exception e) {
            LOG.error("Failed getPartitionsByNames", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec) throws HiveException {
        if (tbl.hasNonNativePartitionSupport()) {
            return tbl.getStorageHandler().getPartition(tbl, partSpec, Context.RewritePolicy.get(this.conf));
        }
        return this.getPartition(tbl, partSpec, false);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate) throws HiveException {
        return this.getPartition(tbl, partSpec, forceCreate, null, true);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate, String partPath, boolean inheritTableSpecs) throws HiveException {
        tbl.validatePartColumnNames(partSpec, true);
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING) || val != null && val.length() == 0) {
                throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
            }
            if (val == null) continue;
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = null;
        try {
            String userName = Hive.getUserName();
            tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, userName, this.getGroupNames());
        }
        catch (NoSuchObjectException nsoe) {
            tpart = null;
        }
        catch (Exception e) {
            LOG.error("Failed getPartitionWithAuthInfo", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        try {
            if (forceCreate) {
                if (tpart == null) {
                    String userName;
                    LOG.debug("creating partition for table " + tbl.getTableName() + " with partition spec : " + String.valueOf(partSpec));
                    try {
                        tpart = this.getMSC().appendPartition(tbl.getDbName(), tbl.getTableName(), pvals);
                    }
                    catch (AlreadyExistsException aee) {
                        LOG.debug("Caught already exists exception, trying to alter partition instead");
                        userName = Hive.getUserName();
                        tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, userName, this.getGroupNames());
                        this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    }
                    catch (Exception e) {
                        if (CheckJDOException.isJDODataStoreException(e)) {
                            LOG.debug("Caught JDO exception, trying to alter partition instead");
                            userName = Hive.getUserName();
                            tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, userName, this.getGroupNames());
                            if (tpart == null) {
                                throw e;
                            }
                            this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                        }
                        throw e;
                    }
                } else {
                    this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    this.fireInsertEvent(tbl, partSpec, true, null);
                }
            }
            if (tpart == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.error("Failed getPartition", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        return new Partition(tbl, tpart);
    }

    private void alterPartitionSpec(Table tbl, Map<String, String> partSpec, org.apache.hadoop.hive.metastore.api.Partition tpart, boolean inheritTableSpecs, String partPath) throws HiveException, InvalidOperationException {
        this.alterPartitionSpecInMemory(tbl, partSpec, tpart, inheritTableSpecs, partPath);
        this.alterPartition(tbl.getCatalogName(), tbl.getDbName(), tbl.getTableName(), new Partition(tbl, tpart), null, true);
    }

    private void alterPartitionSpecInMemory(Table tbl, Map<String, String> partSpec, org.apache.hadoop.hive.metastore.api.Partition tpart, boolean inheritTableSpecs, String partPath) throws HiveException, InvalidOperationException {
        LOG.debug("altering partition for table " + tbl.getTableName() + " with partition spec : " + String.valueOf(partSpec));
        if (inheritTableSpecs) {
            tpart.getSd().setOutputFormat(tbl.getTTable().getSd().getOutputFormat());
            tpart.getSd().setInputFormat(tbl.getTTable().getSd().getInputFormat());
            tpart.getSd().getSerdeInfo().setSerializationLib(tbl.getSerializationLib());
            tpart.getSd().getSerdeInfo().setParameters(tbl.getTTable().getSd().getSerdeInfo().getParameters());
            tpart.getSd().setBucketCols(tbl.getBucketCols());
            tpart.getSd().setNumBuckets(tbl.getNumBuckets());
            tpart.getSd().setSortCols(tbl.getSortCols());
        }
        if (partPath == null || partPath.trim().equals("")) {
            throw new HiveException("new partition path should not be null or empty.");
        }
        tpart.getSd().setLocation(partPath);
    }

    public void addWriteNotificationLog(Table tbl, Map<String, String> partitionSpec, List<FileStatus> newFiles, Long writeId, List<WriteNotificationLogRequest> requestList) throws HiveException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML)) {
            LOG.debug("write notification log is ignored as dml event logging is disabled");
            return;
        }
        if (tbl.isTemporary()) {
            LOG.debug("write notification log is ignored as " + tbl.getTableName() + " is temporary : " + writeId);
            return;
        }
        if (newFiles == null || newFiles.isEmpty()) {
            LOG.debug("write notification log is ignored as file list is empty");
            return;
        }
        LOG.debug("adding write notification log for operation " + writeId + " table " + tbl.getCompleteName() + "partition " + String.valueOf(partitionSpec) + " list of files " + String.valueOf(newFiles));
        try {
            Long txnId = SessionState.get().getTxnMgr().getCurrentTxnId();
            ArrayList<String> partitionVals = null;
            if (partitionSpec != null && !partitionSpec.isEmpty()) {
                partitionVals = new ArrayList<String>();
                for (FieldSchema fs : tbl.getPartitionKeys()) {
                    partitionVals.add(partitionSpec.get(fs.getName()));
                }
            }
            Hive.addWriteNotificationLog(this.conf, tbl, partitionVals, txnId, writeId, newFiles, requestList);
        }
        catch (IOException | TException e) {
            throw new HiveException(e);
        }
    }

    public static void addWriteNotificationLog(HiveConf conf, Table tbl, List<String> partitionVals, Long txnId, Long writeId, List<FileStatus> newFiles, List<WriteNotificationLogRequest> requestList) throws IOException, HiveException, TException {
        FileSystem fileSystem = tbl.getDataLocation().getFileSystem((Configuration)conf);
        InsertEventRequestData insertData = new InsertEventRequestData();
        insertData.setReplace(true);
        WriteNotificationLogRequest rqst = new WriteNotificationLogRequest(txnId.longValue(), writeId.longValue(), tbl.getDbName(), tbl.getTableName(), insertData);
        Hive.addInsertFileInformation(newFiles, fileSystem, insertData);
        rqst.setPartitionVals(partitionVals);
        if (requestList == null) {
            Hive.get(conf).getMSC().addWriteNotificationLog(rqst);
        } else {
            requestList.add(rqst);
        }
    }

    public void fireInsertEvent(String dbName, String tblName, Map<String, String> partitionSpec, boolean replace, List<String> newFiles) throws HiveException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML)) {
            LOG.info("DML Events not enabled. Set " + HiveConf.ConfVars.FIRE_EVENTS_FOR_DML.varname);
            return;
        }
        Table table = this.getTable(dbName, tblName);
        if (table != null && !table.isTemporary()) {
            ArrayList<FileStatus> newFileStatusObject = null;
            String parentDir = null;
            if (newFiles != null && newFiles.size() > 0) {
                newFileStatusObject = new ArrayList<FileStatus>(newFiles.size());
                if (partitionSpec != null && partitionSpec.size() > 0) {
                    Partition part = this.getPartition(table, partitionSpec, false);
                    parentDir = part.getLocation();
                } else {
                    parentDir = table.getSd().getLocation();
                }
                for (String fileName : newFiles) {
                    FileStatus fStatus = new FileStatus();
                    fStatus.setPath(new Path(parentDir, fileName));
                    newFileStatusObject.add(fStatus);
                }
            }
            this.fireInsertEvent(table, partitionSpec, replace, newFileStatusObject);
        }
    }

    void fireInsertEvent(Table tbl, Map<String, String> partitionSpec, boolean replace, List<FileStatus> newFiles) throws HiveException {
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML)) {
            LOG.debug("Firing dml insert event");
            if (tbl.isTemporary()) {
                LOG.debug("Not firing dml insert event as " + tbl.getTableName() + " is temporary");
                return;
            }
            try {
                FileSystem fileSystem = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                FireEventRequestData data = new FireEventRequestData();
                InsertEventRequestData insertData = new InsertEventRequestData();
                insertData.setReplace(replace);
                insertData.setFilesAdded(new ArrayList());
                data.setInsertData(insertData);
                if (newFiles != null && !newFiles.isEmpty()) {
                    Hive.addInsertFileInformation(newFiles, fileSystem, insertData);
                }
                FireEventRequest rqst = new FireEventRequest(true, data);
                rqst.setDbName(tbl.getDbName());
                rqst.setTableName(tbl.getTableName());
                if (partitionSpec != null && partitionSpec.size() > 0) {
                    ArrayList<String> partVals = new ArrayList<String>(partitionSpec.size());
                    for (FieldSchema fs : tbl.getPartitionKeys()) {
                        partVals.add(partitionSpec.get(fs.getName()));
                    }
                    rqst.setPartitionVals(partVals);
                }
                this.getMSC().fireListenerEvent(rqst);
            }
            catch (IOException | TException e) {
                throw new HiveException(e);
            }
        }
    }

    private static void addInsertFileInformation(List<FileStatus> newFiles, FileSystem fileSystem, InsertEventRequestData insertData) throws IOException {
        LinkedList<Path> directories = null;
        for (FileStatus status : newFiles) {
            if (status.isDirectory()) {
                if (directories == null) {
                    directories = new LinkedList<Path>();
                }
                directories.add(status.getPath());
                continue;
            }
            Hive.addInsertNonDirectoryInformation(status.getPath(), fileSystem, insertData);
        }
        if (directories == null) {
            return;
        }
        while (!directories.isEmpty()) {
            Path dir = (Path)directories.poll();
            FileStatus[] contents = fileSystem.listStatus(dir);
            if (contents == null) continue;
            for (FileStatus status : contents) {
                if (status.isDirectory()) {
                    directories.add(status.getPath());
                    continue;
                }
                Hive.addInsertNonDirectoryInformation(status.getPath(), fileSystem, insertData);
            }
        }
    }

    private static void addInsertNonDirectoryInformation(Path p, FileSystem fileSystem, InsertEventRequestData insertData) throws IOException {
        insertData.addToFilesAdded(p.toString());
        FileChecksum cksum = fileSystem.getFileChecksum(p);
        String acidDirPath = AcidUtils.getFirstLevelAcidDirPath(p.getParent(), fileSystem);
        if (cksum != null) {
            String checksumString = StringUtils.byteToHexString((byte[])cksum.getBytes(), (int)0, (int)cksum.getLength());
            insertData.addToFilesAddedChecksum(checksumString);
        } else {
            insertData.addToFilesAddedChecksum("");
        }
        if (acidDirPath != null) {
            insertData.addToSubDirectoryList(acidDirPath);
        }
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partitionValues, boolean deleteData) throws HiveException {
        return this.dropPartition(dbName, tableName, partitionValues, PartitionDropOptions.instance().deleteData(deleteData));
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partitionValues, PartitionDropOptions options) throws HiveException {
        try {
            return this.getMSC().dropPartition(dbName, tableName, partitionValues, options);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", (Throwable)e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Partition> dropPartitions(String dbName, String tableName, List<Pair<Integer, byte[]>> partitionExpressions, PartitionDropOptions dropOptions) throws HiveException {
        RequestPartsSpec rps = new RequestPartsSpec();
        ArrayList<DropPartitionsExpr> exprs = new ArrayList<DropPartitionsExpr>(partitionExpressions.size());
        for (Pair<Integer, byte[]> partExpr : partitionExpressions) {
            DropPartitionsExpr dpe = new DropPartitionsExpr();
            dpe.setExpr((byte[])partExpr.getRight());
            dpe.setPartArchiveLevel(((Integer)partExpr.getLeft()).intValue());
            exprs.add(dpe);
        }
        rps.setExprs(exprs);
        return this.dropPartitions(new TableName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tableName), rps, dropOptions);
    }

    public List<Partition> dropPartitions(TableName tableName, RequestPartsSpec partsSpec, PartitionDropOptions dropOptions) throws HiveException {
        try {
            Table table = this.getTable(tableName.getDb(), tableName.getTable());
            if (!dropOptions.deleteData) {
                AcidUtils.TableSnapshot snapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, table, true);
                if (snapshot != null) {
                    dropOptions.setWriteId(Long.valueOf(snapshot.getWriteId()));
                }
                long txnId = Optional.ofNullable(SessionState.get()).map(ss -> ss.getTxnMgr().getCurrentTxnId()).orElse(0L);
                dropOptions.setTxnId(Long.valueOf(txnId));
            }
            List partitions = this.getMSC().dropPartitions(tableName, partsSpec, dropOptions, null);
            return Hive.convertFromMetastore(table, partitions);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", (Throwable)e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getPartitionNames(String dbName, String tblName, short max) throws HiveException {
        Table tbl = new Table(dbName, tblName);
        return this.getPartitionNames(tbl, max);
    }

    public List<String> getPartitionNames(Table tbl, short max) throws HiveException {
        List names = null;
        try {
            if (tbl.hasNonNativePartitionSupport()) {
                return tbl.getStorageHandler().getPartitionNames(tbl);
            }
            names = this.getMSC().listPartitionNames(tbl.getDbName(), tbl.getTableName(), max);
        }
        catch (NoSuchObjectException nsoe) {
            return Lists.newArrayList();
        }
        catch (Exception e) {
            LOG.error("Failed getPartitionNames", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        return names;
    }

    public List<String> getPartitionNames(String dbName, String tblName, Map<String, String> partSpec, short max) throws HiveException {
        Table tbl = this.getTable(dbName, tblName);
        return this.getPartitionNames(tbl, partSpec, max);
    }

    public List<String> getPartitionNames(Table tbl, Map<String, String> partSpec, short max) throws HiveException {
        if (tbl.hasNonNativePartitionSupport()) {
            return tbl.getStorageHandler().getPartitionNames(tbl, partSpec);
        }
        List pvals = MetaStoreUtils.getPvals(tbl.getPartCols(), partSpec);
        return this.getPartitionNamesByPartitionVals(tbl, pvals, max);
    }

    public List<String> getPartitionNamesByPartitionVals(Table tbl, List<String> pVals, short max) throws HiveException {
        List names = null;
        try {
            GetPartitionNamesPsRequest req = new GetPartitionNamesPsRequest();
            req.setDbName(tbl.getDbName());
            req.setTblName(tbl.getTableName());
            req.setPartValues(pVals);
            req.setMaxParts(max);
            if (AcidUtils.isTransactionalTable(tbl)) {
                ValidWriteIdList validWriteIdList = this.getValidWriteIdList(tbl.getDbName(), tbl.getTableName());
                req.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
                req.setId(tbl.getTTable().getId());
            }
            GetPartitionNamesPsResponse res = this.getMSC().listPartitionNamesRequest(req);
            names = res.getNames();
        }
        catch (NoSuchObjectException nsoe) {
            throw new HiveException("Invalid catName/dbName/tableName or table doesn't exist.", (Throwable)nsoe);
        }
        catch (Exception e) {
            LOG.error("Failed getPartitionNames", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        return names;
    }

    public List<String> getPartitionNames(Table tbl, ExprNodeGenericFuncDesc expr, String order, short maxParts) throws HiveException {
        List names = null;
        byte[] exprBytes = new byte[]{-1};
        if (expr != null) {
            exprBytes = SerializationUtilities.serializeObjectWithTypeInformation(expr);
        }
        try {
            String defaultPartitionName = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_PARTITION_NAME);
            PartitionsByExprRequest req = new PartitionsByExprRequest(tbl.getDbName(), tbl.getTableName(), ByteBuffer.wrap(exprBytes));
            if (defaultPartitionName != null) {
                req.setDefaultPartitionName(defaultPartitionName);
            }
            if (maxParts >= 0) {
                req.setMaxParts(maxParts);
            }
            req.setOrder(order);
            req.setCatName(tbl.getCatalogName());
            if (AcidUtils.isTransactionalTable(tbl)) {
                ValidWriteIdList validWriteIdList = this.getValidWriteIdList(tbl.getDbName(), tbl.getTableName());
                req.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
                req.setId(tbl.getTTable().getId());
            }
            names = this.getMSC().listPartitionNames(req);
        }
        catch (NoSuchObjectException nsoe) {
            return Lists.newArrayList();
        }
        catch (Exception e) {
            LOG.error("Failed getPartitionNames", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Partition> getPartitions(Table tbl) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getPartitions");
        try {
            if (tbl.hasNonNativePartitionSupport()) {
                List<Partition> list = tbl.getStorageHandler().getPartitions(tbl);
                return list;
            }
            int batchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
            ArrayList<Partition> arrayList = new ArrayList<Partition>(this.getAllPartitionsInBatches(tbl, batchSize, 2, MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.GETPARTITIONS_BATCH_MAX_RETRIES), null, true, Hive.getUserName(), this.getGroupNames()));
            return arrayList;
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getPartitions", "HS2-cache");
        }
    }

    public Set<Partition> getAllPartitions(Table tbl) throws HiveException {
        if (!tbl.isPartitioned()) {
            return Sets.newHashSet((Object[])new Partition[]{new Partition(tbl)});
        }
        LinkedHashSet parts = Sets.newLinkedHashSet();
        if (tbl.hasNonNativePartitionSupport()) {
            parts.addAll(tbl.getStorageHandler().getPartitions(tbl));
        } else {
            List tParts;
            try {
                tParts = this.getMSC().listPartitions(tbl.getDbName(), tbl.getTableName(), (short)-1);
            }
            catch (Exception e) {
                LOG.error("Failed getAllPartitionsOf", (Throwable)e);
                throw new HiveException((Throwable)e);
            }
            for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                parts.add(new Partition(tbl, tpart));
            }
        }
        return parts;
    }

    public Set<Partition> getAllPartitionsOf(Table tbl) throws HiveException {
        int batchSize;
        int n = batchSize = tbl.hasNonNativePartitionSupport() ? 0 : MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
        if (batchSize > 0) {
            return this.getAllPartitionsInBatches(tbl, batchSize, 2, MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.GETPARTITIONS_BATCH_MAX_RETRIES), null, false);
        }
        return this.getAllPartitions(tbl);
    }

    public Set<Partition> getAllPartitionsInBatches(Table tbl, int batchSize, int decayingFactor, int maxRetries, Map<String, String> partialPartitionSpec, boolean isAuthRequired) throws HiveException {
        return this.getAllPartitionsInBatches(tbl, batchSize, decayingFactor, maxRetries, partialPartitionSpec, isAuthRequired, null, null);
    }

    public Set<Partition> getAllPartitionsInBatches(final Table tbl, int batchSize, int decayingFactor, int maxRetries, final Map<String, String> partialPartitionSpec, final boolean isAuthRequired, final String userName, final List<String> groupNames) throws HiveException {
        if (!tbl.isPartitioned()) {
            return Sets.newHashSet((Object[])new Partition[]{new Partition(tbl)});
        }
        final LinkedHashSet<Partition> result = new LinkedHashSet<Partition>();
        RetryUtilities.ExponentiallyDecayingBatchWork<Void> batchTask = new RetryUtilities.ExponentiallyDecayingBatchWork<Void>(this, batchSize, decayingFactor, maxRetries){

            public Void execute(int size) throws HiveException {
                result.clear();
                PartitionIterable partitionIterable = new PartitionIterable(Hive.get(), tbl, partialPartitionSpec, size, isAuthRequired, userName, groupNames);
                partitionIterable.forEach(result::add);
                return null;
            }
        };
        try {
            batchTask.run();
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return result;
    }

    public Set<Partition> getAllPartitionsWithSpecsInBatches(Table tbl, int batchSize, int decayingFactor, int maxRetries, final GetPartitionsRequest request) throws HiveException, TException {
        if (!tbl.isPartitioned()) {
            return Sets.newHashSet((Object[])new Partition[]{new Partition(tbl)});
        }
        final LinkedHashSet<Partition> result = new LinkedHashSet<Partition>();
        RetryUtilities.ExponentiallyDecayingBatchWork<Void> batchTask = new RetryUtilities.ExponentiallyDecayingBatchWork<Void>(this, batchSize, decayingFactor, maxRetries){

            public Void execute(int size) throws HiveException, TException {
                result.clear();
                PartitionIterable partitionIterable = new PartitionIterable(Hive.get(), request, size);
                partitionIterable.forEach(result::add);
                return null;
            }
        };
        try {
            batchTask.run();
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec, short limit) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getPartitions2");
        try {
            if (limit >= 0) {
                List<Partition> list = this.getPartitionsWithAuth(tbl, partialPartSpec, limit);
                return list;
            }
            int batchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
            ArrayList<Partition> arrayList = new ArrayList<Partition>(this.getAllPartitionsInBatches(tbl, batchSize, 2, MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.GETPARTITIONS_BATCH_MAX_RETRIES), partialPartSpec, true, Hive.getUserName(), this.getGroupNames()));
            return arrayList;
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getPartitions2", "HS2-cache");
        }
    }

    private List<Partition> getPartitionsWithAuth(Table tbl, Map<String, String> partialPartSpec, short limit) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{tbl.getTableName()});
        }
        List partialPvals = MetaStoreUtils.getPvals(tbl.getPartCols(), partialPartSpec);
        List partitions = null;
        try {
            String userName = Hive.getUserName();
            partitions = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), partialPvals, limit, userName, this.getGroupNames());
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        ArrayList<Partition> qlPartitions = new ArrayList<Partition>();
        for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
            qlPartitions.add(new Partition(tbl, p));
        }
        return qlPartitions;
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        if (tbl.hasNonNativePartitionSupport()) {
            return tbl.getStorageHandler().getPartitions(tbl, partialPartSpec);
        }
        return this.getPartitions(tbl, partialPartSpec, (short)-1);
    }

    public List<Partition> getPartitionsByNames(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{tbl.getTableName()});
        }
        List<String> names = this.getPartitionNames(tbl, partialPartSpec, (short)-1);
        return this.getPartitionsByNames(tbl, names);
    }

    public List<Partition> getPartitionsByNames(Table tbl, List<String> partNames) throws HiveException {
        return this.getPartitionsByNames(tbl, partNames, false);
    }

    public List<Partition> getPartitionsByNames(Table tbl, List<String> partNames, boolean getColStats) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{tbl.getTableName()});
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>(partNames.size());
        int batchSize = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
        int nParts = partNames.size();
        int nBatches = nParts / batchSize;
        try {
            for (int i = 0; i < nBatches; ++i) {
                GetPartitionsByNamesRequest req = new GetPartitionsByNamesRequest();
                req.setDb_name(tbl.getDbName());
                req.setTbl_name(tbl.getTableName());
                req.setNames(partNames.subList(i * batchSize, (i + 1) * batchSize));
                req.setGet_col_stats(false);
                List<org.apache.hadoop.hive.metastore.api.Partition> tParts = this.getPartitionsByNames(req, tbl);
                if (tParts == null) continue;
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                    partitions.add(new Partition(tbl, tpart));
                }
            }
            if (nParts > nBatches * batchSize) {
                String validWriteIdList = null;
                Long tableId = null;
                if (AcidUtils.isTransactionalTable(tbl)) {
                    ValidWriteIdList vWriteIdList = this.getValidWriteIdList(tbl.getDbName(), tbl.getTableName());
                    validWriteIdList = vWriteIdList != null ? vWriteIdList.toString() : null;
                    tableId = tbl.getTTable().getId();
                }
                GetPartitionsByNamesRequest req = MetaStoreUtils.convertToGetPartitionsByNamesRequest((String)tbl.getDbName(), (String)tbl.getTableName(), partNames.subList(nBatches * batchSize, nParts), (boolean)getColStats, (String)"hive", (String)validWriteIdList, tableId);
                List tParts = this.getMSC().getPartitionsByNames(req).getPartitions();
                if (tParts != null) {
                    for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                        partitions.add(new Partition(tbl, tpart));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return partitions;
    }

    public List<Partition> getPartitionsAuthByNames(Table tbl, List<String> partNames, String userName, List<String> groupNames) throws HiveException {
        List tParts;
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{tbl.getTableName()});
        }
        GetPartitionsPsWithAuthRequest req = new GetPartitionsPsWithAuthRequest();
        req.setTblName(tbl.getTableName());
        req.setDbName(tbl.getDbName());
        req.setUserName(userName);
        req.setGroupNames(groupNames);
        req.setPartNames(partNames);
        if (AcidUtils.isTransactionalTable(tbl)) {
            ValidWriteIdList validWriteIdList = this.getValidWriteIdList(tbl.getDbName(), tbl.getTableName());
            req.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
            req.setId(tbl.getTTable().getId());
        }
        try {
            GetPartitionsPsWithAuthResponse res = this.getMSC().listPartitionsWithAuthInfoRequest(req);
            tParts = res.getPartitions();
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        ArrayList<Partition> parts = new ArrayList<Partition>(tParts.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
            parts.add(new Partition(tbl, tpart));
        }
        return parts;
    }

    public List<Partition> getPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{tbl.getTableName()});
        }
        List tParts = this.getMSC().listPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter, (short)-1);
        return Hive.convertFromMetastore(tbl, tParts);
    }

    public List<Partition> getPartitionsWithSpecs(Table tbl, GetPartitionsRequest request) throws HiveException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{tbl.getTableName()});
        }
        int batchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
        if (batchSize > 0) {
            return new ArrayList<Partition>(this.getAllPartitionsWithSpecsInBatches(tbl, batchSize, 2, MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.GETPARTITIONS_BATCH_MAX_RETRIES), request));
        }
        return this.getPartitionsWithSpecsInternal(tbl, request);
    }

    List<Partition> getPartitionsWithSpecsInternal(Table tbl, GetPartitionsRequest request) throws HiveException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{tbl.getTableName()});
        }
        GetPartitionsResponse response = this.getMSC().getPartitionsWithSpecs(request);
        List partitionSpecs = response.getPartitionSpec();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.addAll(Hive.convertFromPartSpec(partitionSpecs.iterator(), tbl));
        return partitions;
    }

    List<Partition> getPartitionsWithSpecsByNames(final Table tbl, List<String> partNames, GetPartitionsRequest request) throws HiveException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, new String[]{tbl.getTableName()});
        }
        final ArrayList<Partition> partitions = new ArrayList<Partition>(partNames.size());
        int batchSize = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
        final GetPartitionsRequest req = request;
        if (!req.isSetFilterSpec()) {
            req.setFilterSpec(new GetPartitionsFilterSpec());
        }
        try {
            Batchable.runBatched((int)batchSize, partNames, (Batchable)new Batchable<String, Void>(){

                public List<Void> run(List<String> list) throws Exception {
                    req.getFilterSpec().setFilters(list);
                    req.getFilterSpec().setFilterMode(PartitionFilterMode.BY_NAMES);
                    List<Partition> tParts = Hive.this.getPartitionsWithSpecsInternal(tbl, req);
                    if (tParts != null) {
                        partitions.addAll(tParts);
                    }
                    return Collections.emptyList();
                }
            });
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return partitions;
    }

    private static List<Partition> convertFromMetastore(Table tbl, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws HiveException {
        if (partitions == null) {
            return Collections.emptyList();
        }
        ArrayList<Partition> results = new ArrayList<Partition>(partitions.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tPart : partitions) {
            results.add(new Partition(tbl, tPart));
        }
        return results;
    }

    static List<Partition> convertFromPartSpec(Iterator<PartitionSpec> iterator, Table tbl) throws HiveException, TException {
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<Partition> results = new ArrayList<Partition>();
        while (iterator.hasNext()) {
            PartitionSpec partitionSpec = iterator.next();
            if (partitionSpec.getPartitionList() != null) {
                for (org.apache.hadoop.hive.metastore.api.Partition msPart : partitionSpec.getPartitionList().getPartitions()) {
                    results.add(new Partition(tbl, msPart));
                }
                continue;
            }
            for (PartitionWithoutSD partitionWithoutSD : partitionSpec.getSharedSDPartitionSpec().getPartitions()) {
                org.apache.hadoop.hive.metastore.api.Partition part = new org.apache.hadoop.hive.metastore.api.Partition();
                part.setTableName(partitionSpec.getTableName());
                part.setDbName(partitionSpec.getDbName());
                part.setCatName(partitionSpec.getCatName());
                part.setCreateTime(partitionWithoutSD.getCreateTime());
                part.setLastAccessTime(partitionWithoutSD.getLastAccessTime());
                part.setParameters(partitionWithoutSD.getParameters());
                part.setPrivileges(partitionWithoutSD.getPrivileges());
                part.setSd(partitionSpec.getSharedSDPartitionSpec().getSd().deepCopy());
                Object partitionLocation = null;
                if (partitionWithoutSD.getRelativePath() == null || partitionWithoutSD.getRelativePath().isEmpty()) {
                    if (tbl.getDataLocation() != null) {
                        Path partPath = new Path(tbl.getDataLocation(), Warehouse.makePartName(tbl.getPartCols(), (List)partitionWithoutSD.getValues()));
                        partitionLocation = partPath.toString();
                    }
                } else {
                    partitionLocation = tbl.getSd().getLocation();
                    partitionLocation = (String)partitionLocation + partitionWithoutSD.getRelativePath();
                }
                part.getSd().setLocation(partitionLocation);
                part.setValues(partitionWithoutSD.getValues());
                part.setWriteId(partitionSpec.getWriteId());
                Partition hivePart = new Partition(tbl, part);
                results.add(hivePart);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPartitionsByExpr(Table tbl, ExprNodeDesc expr, HiveConf conf, List<Partition> partitions) throws HiveException, TException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getPartitionsByExpr");
        try {
            Preconditions.checkNotNull(partitions);
            String defaultPartitionName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_PARTITION_NAME);
            if (tbl.hasNonNativePartitionSupport()) {
                partitions.addAll(tbl.getStorageHandler().getPartitionsByExpr(tbl, expr));
                boolean bl = false;
                return bl;
            }
            byte[] exprBytes = SerializationUtilities.serializeObjectWithTypeInformation(expr);
            ArrayList msParts = new ArrayList();
            ValidWriteIdList validWriteIdList = null;
            PartitionsByExprRequest req = this.buildPartitionByExprRequest(tbl, exprBytes, defaultPartitionName, conf, null);
            if (AcidUtils.isTransactionalTable(tbl)) {
                validWriteIdList = this.getValidWriteIdList(tbl.getDbName(), tbl.getTableName());
                req.setValidWriteIdList(validWriteIdList != null ? validWriteIdList.toString() : null);
                req.setId(tbl.getTTable().getId());
            }
            boolean hasUnknownParts = this.getMSC().listPartitionsSpecByExpr(req, msParts);
            partitions.addAll(Hive.convertFromPartSpec(msParts.iterator(), tbl));
            boolean bl = hasUnknownParts;
            return bl;
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getPartitionsByExpr", "HS2-cache");
        }
    }

    private PartitionsByExprRequest buildPartitionByExprRequest(Table tbl, byte[] exprBytes, String defaultPartitionName, HiveConf conf, String validWriteIdList) {
        PartitionsByExprRequest req = new PartitionsByExprRequest(tbl.getDbName(), tbl.getTableName(), ByteBuffer.wrap(exprBytes));
        if (defaultPartitionName != null) {
            req.setDefaultPartitionName(defaultPartitionName);
        }
        req.setCatName(MetaStoreUtils.getDefaultCatalog((Configuration)conf));
        req.setValidWriteIdList(validWriteIdList);
        req.setId(tbl.getTTable().getId());
        return req;
    }

    public int getNumPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException("Partition spec should only be supplied for a partitioned table");
        }
        int numParts = this.getMSC().getNumPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter);
        return numParts;
    }

    public void validatePartitionNameCharacters(List<String> partVals) throws HiveException {
        try {
            this.getMSC().validatePartitionNameCharacters(partVals);
        }
        catch (Exception e) {
            LOG.error("Failed validatePartitionNameCharacters", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public void createRole(String roleName, String ownerName) throws HiveException {
        try {
            this.getMSC().create_role(new Role(roleName, -1, ownerName));
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void dropRole(String roleName) throws HiveException {
        try {
            this.getMSC().drop_role(roleName);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<String> getAllRoleNames() throws HiveException {
        try {
            return this.getMSC().listRoleNames();
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<RolePrincipalGrant> getRoleGrantInfoForPrincipal(String principalName, PrincipalType principalType) throws HiveException {
        try {
            GetRoleGrantsForPrincipalRequest req = new GetRoleGrantsForPrincipalRequest(principalName, principalType);
            GetRoleGrantsForPrincipalResponse resp = this.getMSC().get_role_grants_for_principal(req);
            return resp.getPrincipalGrants();
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public boolean grantRole(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().grant_role(roleName, userName, principalType, grantor, grantorType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public boolean revokeRole(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_role(roleName, userName, principalType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<Role> listRoles(String userName, PrincipalType principalType) throws HiveException {
        try {
            return this.getMSC().list_roles(userName, principalType);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectType objectType, String db_name, String table_name, List<String> part_values, String column_name, String user_name, List<String> group_names) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, db_name, table_name, part_values, column_name);
            return this.getMSC().get_privilege_set(hiveObj, user_name, group_names);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<HiveObjectPrivilege> showPrivilegeGrant(HiveObjectType objectType, String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String columnName) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, dbName, tableName, partValues, columnName);
            return this.getMSC().list_privileges(principalName, principalType, hiveObj);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private static void copyFiles(final HiveConf conf, final FileSystem destFs, FileStatus[] srcs, final FileSystem srcFs, final Path destf, final boolean isSrcLocal, final boolean isOverwrite, final List<Path> newFiles, boolean acidRename, boolean isManaged, boolean isCompactionTable) throws HiveException {
        try {
            FileStatus fullDestStatus = destFs.getFileStatus(destf);
            if (!fullDestStatus.isDirectory()) {
                throw new HiveException(String.valueOf(destf) + " is not a directory.");
            }
        }
        catch (IOException e1) {
            throw new HiveException((Throwable)e1);
        }
        LinkedList<Future<Pair<Path, Path>>> futures = new LinkedList<Future<Pair<Path, Path>>>();
        ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build()) : null;
        int taskId = 0;
        Arrays.sort(srcs);
        String configuredOwner = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOAD_DATA_OWNER);
        for (FileStatus src : srcs) {
            Object[] files;
            if (src.isDirectory()) {
                try {
                    files = srcFs.listStatus(src.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                }
                catch (IOException e) {
                    if (null != pool) {
                        pool.shutdownNow();
                    }
                    throw new HiveException((Throwable)e);
                }
            } else {
                files = new FileStatus[]{src};
            }
            if (isCompactionTable && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_WRITE_ACID_VERSION_FILE)) {
                try {
                    AcidUtils.OrcAcidVersion.writeVersionFile(destf, destFs);
                }
                catch (IOException e) {
                    if (null != pool) {
                        pool.shutdownNow();
                    }
                    throw new HiveException((Throwable)e);
                }
            }
            final SessionState parentSession = SessionState.get();
            Arrays.sort(files);
            for (Object srcFile : files) {
                final Path srcP = srcFile.getPath();
                boolean needToCopy = Hive.needToCopy(conf, srcP, destf, srcFs, destFs, configuredOwner, isManaged);
                final boolean isRenameAllowed = !needToCopy && !isSrcLocal;
                final String msg = "Unable to move source " + String.valueOf(srcP) + " to destination " + String.valueOf(destf);
                if (null == pool) {
                    try {
                        Path destPath = Hive.mvFile(conf, srcFs, srcP, destFs, destf, isSrcLocal, isOverwrite, isRenameAllowed, acidRename ? taskId++ : -1);
                        if (null == newFiles) continue;
                        newFiles.add(destPath);
                        continue;
                    }
                    catch (Exception e) {
                        throw Hive.getHiveException(e, msg, "Failed to move: {}");
                    }
                }
                final int finalTaskId = acidRename ? taskId++ : -1;
                futures.add(pool.submit(new Callable<Pair<Path, Path>>(){

                    @Override
                    public Pair<Path, Path> call() throws HiveException {
                        SessionState.setCurrentSessionState(parentSession);
                        try {
                            Path destPath = Hive.mvFile(conf, srcFs, srcP, destFs, destf, isSrcLocal, isOverwrite, isRenameAllowed, finalTaskId);
                            if (null != newFiles) {
                                newFiles.add(destPath);
                            }
                            return Pair.of((Object)srcP, (Object)destPath);
                        }
                        catch (Exception e) {
                            throw Hive.getHiveException(e, msg);
                        }
                    }
                }));
            }
        }
        if (null != pool) {
            pool.shutdown();
            for (Future future : futures) {
                try {
                    Pair pair = (Pair)future.get();
                    LOG.debug("Moved src: {}, to dest: {}", (Object)((Path)pair.getLeft()).toString(), (Object)((Path)pair.getRight()).toString());
                }
                catch (Exception e) {
                    throw Hive.handlePoolException(pool, e);
                }
            }
        }
    }

    private static boolean isSubDir(Path srcf, Path destf, FileSystem srcFs, FileSystem destFs, boolean isSrcLocal) {
        if (srcf == null) {
            LOG.debug("The source path is null for isSubDir method.");
            return false;
        }
        String fullF1 = Hive.getQualifiedPathWithoutSchemeAndAuthority(srcf, srcFs).toString() + "/";
        String fullF2 = Hive.getQualifiedPathWithoutSchemeAndAuthority(destf, destFs).toString() + "/";
        boolean isInTest = HiveConf.getBoolVar((Configuration)srcFs.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST);
        LOG.debug("The source path is " + fullF1 + " and the destination path is " + fullF2);
        if (isInTest) {
            return fullF1.startsWith(fullF2);
        }
        String schemaSrcf = srcf.toUri().getScheme();
        String schemaDestf = destf.toUri().getScheme();
        if (schemaDestf == null && isSrcLocal) {
            LOG.debug("The source file is in the local while the dest not.");
            return false;
        }
        if (schemaSrcf != null && schemaDestf != null && !schemaSrcf.equals(schemaDestf)) {
            LOG.debug("The source path's schema is " + schemaSrcf + " and the destination path's schema is " + schemaDestf + ".");
            return false;
        }
        return fullF1.startsWith(fullF2);
    }

    private static Path getQualifiedPathWithoutSchemeAndAuthority(Path srcf, FileSystem fs) {
        Path currentWorkingDir = fs.getWorkingDirectory();
        Path path = srcf.makeQualified(srcf.toUri(), currentWorkingDir);
        return ShimLoader.getHadoopShims().getPathWithoutSchemeAndAuthority(path);
    }

    private static String getPathName(int taskId) {
        return Utilities.replaceTaskId("000000", taskId) + "_0";
    }

    private static Path mvFile(HiveConf conf, FileSystem sourceFs, Path sourcePath, FileSystem destFs, Path destDirPath, boolean isSrcLocal, boolean isOverwrite, boolean isRenameAllowed, int taskId) throws IOException {
        String fullname = sourcePath.getName();
        String name = taskId == -1 ? FilenameUtils.getBaseName((String)sourcePath.getName()) : Hive.getPathName(taskId);
        String type = FilenameUtils.getExtension((String)sourcePath.getName());
        Path destFilePath = new Path(destDirPath, taskId == -1 ? fullname : name);
        int counter = 1;
        while (destFs.exists(destFilePath)) {
            if (isOverwrite) {
                destFs.delete(destFilePath, false);
                break;
            }
            destFilePath = new Path(destDirPath, name + "_copy_" + counter + (String)(taskId == -1 && !type.isEmpty() ? "." + type : ""));
            ++counter;
        }
        if (isRenameAllowed) {
            destFs.rename(sourcePath, destFilePath);
        } else if (isSrcLocal) {
            destFs.copyFromLocalFile(sourcePath, destFilePath);
        } else {
            if (!FileUtils.copy((FileSystem)sourceFs, (Path)sourcePath, (FileSystem)destFs, (Path)destFilePath, (boolean)false, (boolean)false, (HiveConf)conf, (DataCopyStatistics)new DataCopyStatistics())) {
                LOG.error("Copy failed for source: " + String.valueOf(sourcePath) + " to destination: " + String.valueOf(destFilePath));
                throw new IOException("File copy failed.");
            }
            try {
                if (!sourceFs.delete(sourcePath, true)) {
                    LOG.warn("Delete source failed for source: " + String.valueOf(sourcePath) + " during copy to destination: " + String.valueOf(destFilePath));
                }
            }
            catch (Exception e) {
                LOG.warn("Delete source failed for source: " + String.valueOf(sourcePath) + " during copy to destination: " + String.valueOf(destFilePath), (Throwable)e);
            }
        }
        return destFilePath;
    }

    public static void clearDestForSubDirSrc(HiveConf conf, Path dest, Path src, boolean isSrcLocal) throws IOException {
        FileSystem destFS = dest.getFileSystem((Configuration)conf);
        FileSystem srcFS = src.getFileSystem((Configuration)conf);
        if (Hive.isSubDir(src, dest, srcFS, destFS, isSrcLocal)) {
            FileStatus[] existingFiles;
            Path fullDestPath;
            Path fullSrcPath = Hive.getQualifiedPathWithoutSchemeAndAuthority(src, srcFS);
            if (fullSrcPath.equals((Object)(fullDestPath = Hive.getQualifiedPathWithoutSchemeAndAuthority(dest, destFS)))) {
                return;
            }
            Path parent = fullSrcPath;
            while (!parent.getParent().equals((Object)fullDestPath)) {
                parent = parent.getParent();
            }
            for (FileStatus fileStatus : existingFiles = destFS.listStatus(dest, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (fileStatus.getPath().getName().equals(parent.getName())) continue;
                destFS.delete(fileStatus.getPath(), true);
            }
        }
    }

    public void recycleDirToCmPath(Path dataPath, boolean isPurge) throws HiveException {
        try {
            CmRecycleRequest request = new CmRecycleRequest(dataPath.toString(), isPurge);
            this.getMSC().recycleDirToCmPath(request);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    private static void deleteAndRename(FileSystem destFs, Path destFile, FileStatus srcStatus, Path destPath) throws IOException {
        try {
            destFs.delete(destFile);
            LOG.info("Deleted destination file: {}", (Object)destFile.toUri());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (!destFs.rename(srcStatus.getPath(), destFile)) {
            throw new IOException("rename for src path: " + String.valueOf(srcStatus.getPath()) + " to dest:" + String.valueOf(destPath) + " returned false");
        }
    }

    public static boolean moveFile(HiveConf conf, Path srcf, final Path destf, boolean replace, boolean isSrcLocal, boolean isManaged) throws HiveException {
        FileSystem srcFs;
        FileSystem destFs;
        try {
            destFs = destf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get dest fs", (Throwable)e);
            throw new HiveException(e.getMessage(), (Throwable)e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get src fs", (Throwable)e);
            throw new HiveException(e.getMessage(), (Throwable)e);
        }
        String configuredOwner = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOAD_DATA_OWNER);
        boolean srcIsSubDirOfDest = Hive.isSubDir(srcf, destf, srcFs, destFs, isSrcLocal);
        boolean destIsSubDirOfSrc = Hive.isSubDir(destf, srcf, destFs, srcFs, false);
        String msg = "Unable to move source " + String.valueOf(srcf) + " to destination " + String.valueOf(destf);
        try {
            if (replace) {
                try {
                    if (replace && !srcIsSubDirOfDest) {
                        destFs.delete(destf, true);
                        LOG.debug("The path " + destf.toString() + " is deleted");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            final SessionState parentSession = SessionState.get();
            if (isSrcLocal) {
                destFs.copyFromLocalFile(srcf, destf);
                return true;
            }
            if (Hive.needToCopy(conf, srcf, destf, srcFs, destFs, configuredOwner, isManaged)) {
                LOG.debug("Copying source " + String.valueOf(srcf) + " to " + String.valueOf(destf) + " because HDFS encryption zones are different.");
                return FileUtils.copy((FileSystem)srcf.getFileSystem((Configuration)conf), (Path)srcf, (FileSystem)destf.getFileSystem((Configuration)conf), (Path)destf, (boolean)true, (boolean)replace, (HiveConf)conf, (DataCopyStatistics)new DataCopyStatistics());
            }
            if (srcIsSubDirOfDest || destIsSubDirOfSrc) {
                ExecutorService pool;
                FileStatus[] srcs = destFs.listStatus(srcf, FileUtils.HIDDEN_FILES_PATH_FILTER);
                LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
                ExecutorService executorService = pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build()) : null;
                if (destIsSubDirOfSrc && !destFs.exists(destf)) {
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("Creating " + String.valueOf(destf));
                    }
                    destFs.mkdirs(destf);
                }
                for (final FileStatus srcStatus : srcs) {
                    final Path destFile = new Path(destf, srcStatus.getPath().getName());
                    final String poolMsg = "Unable to move source " + String.valueOf(srcStatus.getPath()) + " to destination " + String.valueOf(destFile);
                    if (null == pool) {
                        Hive.deleteAndRename(destFs, destFile, srcStatus, destf);
                        continue;
                    }
                    futures.add(pool.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws HiveException {
                            SessionState.setCurrentSessionState(parentSession);
                            try {
                                Hive.deleteAndRename(destFs, destFile, srcStatus, destf);
                            }
                            catch (Exception e) {
                                throw Hive.getHiveException(e, poolMsg);
                            }
                            return null;
                        }
                    }));
                }
                if (null != pool) {
                    pool.shutdown();
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            throw Hive.handlePoolException(pool, e);
                        }
                    }
                }
                return true;
            }
            return destFs.rename(srcf, destf);
        }
        catch (Exception e) {
            throw Hive.getHiveException(e, msg);
        }
    }

    private static HiveException getHiveException(Exception e, String msg) {
        return Hive.getHiveException(e, msg, null);
    }

    private static HiveException handlePoolException(ExecutorService pool, Exception e) {
        HiveException he = null;
        if (e instanceof HiveException) {
            he = (HiveException)((Object)e);
            if (he.getCanonicalErrorMsg() != ErrorMsg.GENERIC_ERROR) {
                if (he.getCanonicalErrorMsg() == ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
                    LOG.error("Failed to move: {}", (Object)he.getMessage());
                } else {
                    LOG.error("Failed to move: {}", (Object)he.getRemoteErrorMsg());
                }
            }
        } else {
            LOG.error("Failed to move: {}", (Object)e.getMessage());
            he = new HiveException(e.getCause());
        }
        pool.shutdownNow();
        return he;
    }

    private static HiveException getHiveException(Exception e, String msg, String logMsg) {
        String hiveErrMsg = null;
        hiveErrMsg = e.getMessage() != null ? String.format("%s%s%s", msg, ": ", Splitter.on((String)System.getProperty("line.separator")).split((CharSequence)e.getMessage()).iterator().next()) : msg;
        ErrorMsg errorMsg = ErrorMsg.getErrorMsg((Exception)e);
        if (logMsg != null) {
            LOG.info(String.format(logMsg, e.getMessage()));
        }
        if (errorMsg != ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
            return new HiveException((Throwable)e, e.getMessage(), errorMsg, new String[]{hiveErrMsg});
        }
        return new HiveException(msg, (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean needToCopy(HiveConf conf, Path srcf, Path destf, FileSystem srcFs, FileSystem destFs, String configuredOwner, boolean isManaged) throws HiveException {
        if (!FileUtils.isEqualFileSystemAndSameOzoneBucket((FileSystem)srcFs, (FileSystem)destFs, (Path)srcf, (Path)destf)) {
            return true;
        }
        if (isManaged && !configuredOwner.isEmpty() && srcFs instanceof DistributedFileSystem) {
            try {
                FileStatus srcs = srcFs.getFileStatus(srcf);
                String runningUser = UserGroupInformation.getLoginUser().getShortUserName();
                boolean isOwned = FileUtils.isOwnerOfFileHierarchy((FileSystem)srcFs, (FileStatus)srcs, (String)configuredOwner, (boolean)false);
                if (!configuredOwner.equals(runningUser)) {
                    if (isOwned) return true;
                    throw new HiveException("Load Data failed for " + String.valueOf(srcf) + " as the file is not owned by " + configuredOwner + " and load data is also not ran as " + configuredOwner);
                }
                UserGroupInformation proxyUser = null;
                try {
                    proxyUser = FileUtils.getProxyUser((String)configuredOwner);
                    FileSystem fsAsUser = FileUtils.getFsAsUser((FileSystem)srcFs, (UserGroupInformation)proxyUser);
                    if (!isOwned || !FileUtils.isActionPermittedForFileHierarchy((FileSystem)srcFs, (FileStatus)srcs, (String)configuredOwner, (FsAction)FsAction.WRITE, (boolean)false, (FileSystem)fsAsUser)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    FileUtils.closeFs((UserGroupInformation)proxyUser);
                }
            }
            catch (IOException e) {
                throw new HiveException("Could not fetch FileStatus for source file");
            }
            catch (HiveException e) {
                throw new HiveException((Throwable)e);
            }
            catch (Exception e) {
                throw new HiveException(" Failed in looking up Permissions on file + " + String.valueOf(srcf));
            }
        }
        if (!DFSUtilClient.isHDFSEncryptionEnabled((Configuration)conf)) {
            return false;
        }
        HadoopShims.HdfsEncryptionShim srcHdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(srcFs, conf);
        HadoopShims.HdfsEncryptionShim destHdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(destFs, conf);
        try {
            if (srcHdfsEncryptionShim == null) return false;
            if (destHdfsEncryptionShim == null) return false;
            if (!srcHdfsEncryptionShim.isPathEncrypted(srcf)) {
                if (!destHdfsEncryptionShim.isPathEncrypted(destf)) return false;
            }
            if (srcHdfsEncryptionShim.arePathsOnSameEncryptionZone(srcf, destf, destHdfsEncryptionShim)) return false;
            return true;
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    protected static void copyFiles(HiveConf conf, Path srcf, Path destf, FileSystem fs, boolean isSrcLocal, boolean isAcidIUD, boolean isOverwrite, List<FileStatus> newFilesStatus, boolean isBucketed, boolean isFullAcidTable, boolean isManaged, boolean isCompactionTable) throws HiveException {
        FileStatus[] srcs;
        FileSystem srcFs;
        try {
            if (!fs.exists(destf)) {
                FileUtils.mkdir((FileSystem)fs, (Path)destf, (Configuration)conf);
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while checking/creating destination directory!!!", (Throwable)e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
            srcs = srcFs.globStatus(srcf);
        }
        catch (IOException e) {
            LOG.error("addFiles: filesystem error in check phase", (Throwable)e);
            throw new HiveException("addFiles: filesystem error in check phase. " + e.getMessage(), (Throwable)e);
        }
        if (srcs == null) {
            LOG.info("No sources specified to move: " + String.valueOf(srcf));
            return;
        }
        List<Path> newFiles = null;
        if (newFilesStatus != null) {
            newFiles = Collections.synchronizedList(new ArrayList());
        }
        if (isAcidIUD) {
            Hive.moveAcidFiles(srcFs, srcs, destf, newFiles, conf);
        } else {
            Hive.copyFiles(conf, fs, srcs, srcFs, destf, isSrcLocal, isOverwrite, newFiles, isFullAcidTable && !isBucketed, isManaged, isCompactionTable);
        }
        if (newFilesStatus != null) {
            for (Path filePath : newFiles) {
                try {
                    newFilesStatus.add(fs.getFileStatus(filePath));
                }
                catch (Exception e) {
                    LOG.error("Failed to get getFileStatus", (Throwable)e);
                    throw new HiveException(e.getMessage());
                }
            }
        }
    }

    public static void moveAcidFiles(FileSystem fs, FileStatus[] stats, Path dst, List<Path> newFiles, HiveConf conf) throws HiveException {
        HashSet<Path> createdDeltaDirs = new HashSet<Path>();
        for (FileStatus stat : stats) {
            Path srcPath = stat.getPath();
            LOG.debug("Acid move Looking for original buckets in " + String.valueOf(srcPath));
            FileStatus[] origBucketStats = null;
            try {
                origBucketStats = fs.listStatus(srcPath, AcidUtils.originalBucketFilter);
                if (origBucketStats == null || origBucketStats.length == 0) {
                    FileStatus[] unionSubdirs = fs.globStatus(new Path(srcPath, "HIVE_UNION_SUBDIR_[0-9]*"));
                    ArrayList buckets = new ArrayList();
                    for (FileStatus unionSubdir : unionSubdirs) {
                        Collections.addAll(buckets, fs.listStatus(unionSubdir.getPath(), AcidUtils.originalBucketFilter));
                    }
                    origBucketStats = buckets.toArray(new FileStatus[buckets.size()]);
                }
            }
            catch (IOException e) {
                String msg = "Unable to look for bucket files in src path " + srcPath.toUri().toString();
                LOG.error(msg);
                throw new HiveException(msg, (Throwable)e);
            }
            LOG.debug("Acid move found " + origBucketStats.length + " original buckets");
            for (FileStatus origBucketStat : origBucketStats) {
                Path origBucketPath = origBucketStat.getPath();
                Hive.moveAcidFiles("delta_", AcidUtils.deltaFileFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles, conf);
                Hive.moveAcidFiles("delete_delta_", AcidUtils.deleteEventDeltaDirFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles, conf);
                Hive.moveAcidFiles("base_", AcidUtils.baseFileFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles, conf);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void moveAcidFiles(final String deltaFileType, PathFilter pathFilter, final FileSystem fs, final Path dst, Path origBucketPath, Set<Path> createdDeltaDirs, final List<Path> newFiles, HiveConf conf) throws HiveException {
        try {
            LOG.debug("Acid move looking for " + deltaFileType + " files in bucket " + String.valueOf(origBucketPath));
            FileStatus[] deltaStats = null;
            try {
                deltaStats = fs.listStatus(origBucketPath, pathFilter);
            }
            catch (IOException e) {
                throw new HiveException("Unable to look for " + deltaFileType + " files in original bucket " + origBucketPath.toUri().toString(), (Throwable)e);
            }
            LOG.debug("Acid move found " + deltaStats.length + " " + deltaFileType + " files");
            LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
            ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Acid-Files-Thread-%d").build()) : null;
            final Set<Path> createdDeltaDirsSync = Collections.synchronizedSet(createdDeltaDirs);
            for (final FileStatus deltaStat : deltaStats) {
                if (null == pool) {
                    Hive.moveAcidFilesForDelta(deltaFileType, fs, dst, createdDeltaDirsSync, newFiles, deltaStat);
                    continue;
                }
                futures.add(pool.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws HiveException {
                        try {
                            Hive.moveAcidFilesForDelta(deltaFileType, fs, dst, createdDeltaDirsSync, newFiles, deltaStat);
                        }
                        catch (Exception e) {
                            String poolMsg = "Unable to move source " + deltaStat.getPath().getName() + " to destination " + dst.getName();
                            throw Hive.getHiveException(e, poolMsg);
                        }
                        return null;
                    }
                }));
            }
            if (null == pool) return;
            pool.shutdown();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    pool.shutdownNow();
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (!(e.getCause() instanceof HiveException)) throw Hive.handlePoolException(pool, e);
                    throw (HiveException)e.getCause();
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e.getMessage(), (Throwable)e);
        }
    }

    private static void moveAcidFilesForDelta(String deltaFileType, FileSystem fs, Path dst, Set<Path> createdDeltaDirs, List<Path> newFiles, FileStatus deltaStat) throws HiveException {
        Path deltaPath = deltaStat.getPath();
        Path deltaDest = new Path(dst, deltaPath.getName());
        try {
            if (!createdDeltaDirs.contains(deltaDest)) {
                try {
                    if (fs.mkdirs(deltaDest)) {
                        try {
                            fs.rename(AcidUtils.OrcAcidVersion.getVersionFilePath(deltaStat.getPath()), AcidUtils.OrcAcidVersion.getVersionFilePath(deltaDest));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                    createdDeltaDirs.add(deltaDest);
                }
                catch (IOException swallowIt) {
                    LOG.info("Unable to create " + deltaFileType + " directory " + String.valueOf(deltaDest) + ", assuming it already exists: " + swallowIt.getMessage());
                }
            }
            FileStatus[] bucketStats = fs.listStatus(deltaPath, AcidUtils.bucketFileFilter);
            LOG.debug("Acid move found " + bucketStats.length + " bucket files");
            for (FileStatus bucketStat : bucketStats) {
                Path bucketSrc = bucketStat.getPath();
                Path bucketDest = new Path(deltaDest, bucketSrc.getName());
                LOG.info("Moving bucket " + bucketSrc.toUri().toString() + " to " + bucketDest.toUri().toString());
                try {
                    fs.rename(bucketSrc, bucketDest);
                    if (newFiles == null) continue;
                    newFiles.add(bucketDest);
                }
                catch (Exception e) {
                    throw Hive.getHiveException(e, "Unable to move source " + String.valueOf(bucketSrc) + " to destination " + String.valueOf(bucketDest));
                }
            }
        }
        catch (IOException e) {
            throw new HiveException("Error moving acid files " + e.getMessage(), (Throwable)e);
        }
    }

    private void replaceFiles(Path tablePath, Path srcf, Path destf, Path oldPath, final HiveConf conf, final boolean isSrcLocal, boolean purge, List<FileStatus> newFiles, PathFilter deletePathFilter, boolean isNeedRecycle, final boolean isManaged, boolean isInsertOverwrite) throws HiveException {
        block18: {
            try {
                FileStatus[] srcs;
                FileSystem destFs = destf.getFileSystem((Configuration)conf);
                try {
                    FileSystem srcFs = srcf.getFileSystem((Configuration)conf);
                    srcs = srcFs.globStatus(srcf);
                }
                catch (IOException e) {
                    throw new HiveException("Getting globStatus " + srcf.toString(), (Throwable)e);
                }
                if (oldPath == null && isInsertOverwrite) {
                    this.deleteOldPathForReplace(destf, destf, conf, purge, deletePathFilter, isNeedRecycle);
                }
                if (oldPath != null && (srcs != null || isInsertOverwrite)) {
                    this.deleteOldPathForReplace(destf, oldPath, conf, purge, deletePathFilter, isNeedRecycle);
                }
                if (srcs == null) {
                    LOG.info("No sources specified to move: " + String.valueOf(srcf));
                    return;
                }
                boolean destfExist = FileUtils.mkdir((FileSystem)destFs, (Path)destf, (Configuration)conf);
                if (!destfExist) {
                    throw new IOException("Directory " + destf.toString() + " does not exist and could not be created.");
                }
                if (srcs.length == 1 && srcs[0].isDirectory()) {
                    if (!Hive.moveFile(conf, srcs[0].getPath(), destf, true, isSrcLocal, isManaged)) {
                        throw new IOException("Error moving: " + String.valueOf(srcf) + " into: " + String.valueOf(destf));
                    }
                    if (newFiles != null) {
                        newFiles.addAll(HdfsUtils.listLocatedFileStatus(destFs, destf, null, true));
                    }
                    break block18;
                }
                LinkedHashMap moveFutures = Maps.newLinkedHashMapWithExpectedSize((int)srcs.length);
                int moveFilesThreadCount = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT);
                ListeningExecutorService pool = moveFilesThreadCount > 0 ? Executors.newFixedThreadPool(moveFilesThreadCount, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Replace-Thread-%d").build()) : MoreExecutors.newDirectExecutorService();
                final SessionState parentSession = SessionState.get();
                for (final FileStatus src : srcs) {
                    final Path destFile = new Path(destf, src.getPath().getName());
                    moveFutures.put(pool.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            SessionState.setCurrentSessionState(parentSession);
                            return Hive.moveFile(conf, src.getPath(), destFile, true, isSrcLocal, isManaged);
                        }
                    }), destFile);
                }
                pool.shutdown();
                for (Map.Entry entry : moveFutures.entrySet()) {
                    boolean moveFailed;
                    try {
                        moveFailed = (Boolean)((Future)entry.getKey()).get() == false;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        pool.shutdownNow();
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                        if (e.getCause() instanceof HiveException) {
                            throw (HiveException)e.getCause();
                        }
                        throw Hive.handlePoolException((ExecutorService)pool, e);
                    }
                    if (moveFailed) {
                        throw new IOException("Error moving: " + String.valueOf(srcf) + " into: " + String.valueOf(destf));
                    }
                    if (null == newFiles) continue;
                    newFiles.add(destFs.getFileStatus((Path)entry.getValue()));
                }
            }
            catch (IOException e) {
                throw new HiveException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void deleteOldPathForReplace(Path destPath, Path oldPath, HiveConf conf, boolean purge, PathFilter pathFilter, boolean isNeedRecycle) throws HiveException {
        Utilities.FILE_OP_LOGGER.debug("Deleting old paths for replace in " + String.valueOf(destPath) + " and old path " + String.valueOf(oldPath));
        boolean isOldPathUnderDestf = false;
        try {
            FileSystem oldFs = oldPath.getFileSystem((Configuration)conf);
            FileSystem destFs = destPath.getFileSystem((Configuration)conf);
            isOldPathUnderDestf = Hive.isSubDir(oldPath, destPath, oldFs, destFs, false);
            if (isOldPathUnderDestf && oldFs.exists(oldPath)) {
                this.cleanUpOneDirectoryForReplace(oldPath, oldFs, pathFilter, conf, purge, isNeedRecycle);
            }
        }
        catch (IOException e) {
            if (isOldPathUnderDestf) {
                throw new HiveException("Directory " + oldPath.toString() + " could not be cleaned up.", (Throwable)e);
            }
            LOG.warn("Directory " + oldPath.toString() + " cannot be cleaned: " + String.valueOf(e), (Throwable)e);
        }
    }

    public void cleanUpOneDirectoryForReplace(Path path, FileSystem fs, PathFilter pathFilter, HiveConf conf, boolean purge, boolean isNeedRecycle) throws IOException, HiveException {
        if (isNeedRecycle && conf.getBoolVar(HiveConf.ConfVars.REPL_CM_ENABLED)) {
            this.recycleDirToCmPath(path, purge);
        }
        if (!fs.exists(path)) {
            return;
        }
        FileStatus[] statuses = fs.listStatus(path, pathFilter);
        if (statuses == null || statuses.length == 0) {
            return;
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            String s = "Deleting files under " + String.valueOf(path) + " for replace: ";
            for (FileStatus file : statuses) {
                s = s + file.getPath().getName() + ", ";
            }
            Utilities.FILE_OP_LOGGER.trace(s);
        }
        if (!Hive.trashFiles(fs, statuses, (Configuration)conf, purge)) {
            throw new HiveException("Old path " + String.valueOf(path) + " has not been cleaned up.");
        }
    }

    public static boolean trashFiles(final FileSystem fs, FileStatus[] statuses, final Configuration conf, final boolean purge) throws IOException {
        boolean result = true;
        if (statuses == null || statuses.length == 0) {
            return false;
        }
        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
        ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Delete-Thread-%d").build()) : null;
        final SessionState parentSession = SessionState.get();
        for (final FileStatus status : statuses) {
            if (null == pool) {
                result &= org.apache.hadoop.hive.metastore.utils.FileUtils.deleteDir((FileSystem)fs, (Path)status.getPath(), (boolean)purge, (Configuration)conf);
                continue;
            }
            futures.add(pool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SessionState.setCurrentSessionState(parentSession);
                    return org.apache.hadoop.hive.metastore.utils.FileUtils.deleteDir((FileSystem)fs, (Path)status.getPath(), (boolean)purge, (Configuration)conf);
                }
            }));
        }
        if (null != pool) {
            pool.shutdown();
            for (Future future : futures) {
                try {
                    result &= ((Boolean)future.get()).booleanValue();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Failed to delete: ", (Throwable)e);
                    pool.shutdownNow();
                    throw new IOException(e);
                }
            }
        }
        return result;
    }

    public static boolean isHadoop1() {
        return ShimLoader.getMajorVersion().startsWith("0.20");
    }

    public List<Partition> exchangeTablePartitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws HiveException {
        try {
            List partitions = this.getMSC().exchange_partitions(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
            return Hive.convertFromMetastore(this.getTable(destDb, destinationTableName), partitions);
        }
        catch (Exception ex) {
            LOG.error("Failed exchangeTablePartitions", (Throwable)ex);
            throw new HiveException((Throwable)ex);
        }
    }

    private IMetaStoreClient createMetaStoreClient(boolean allowEmbedded) throws MetaException {
        HiveMetaHookLoader hookLoader = new HiveMetaHookLoader(){

            public HiveMetaHook getHook(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
                HiveStorageHandler storageHandler = Hive.this.createStorageHandler(tbl);
                return storageHandler == null ? null : storageHandler.getMetaHook();
            }
        };
        HiveMetaStoreClientBuilder msClientBuilder = new HiveMetaStoreClientBuilder((Configuration)this.conf).newClient(allowEmbedded).enhanceWith(client -> HiveMetaStoreClientWithLocalCache.newClient((Configuration)this.conf, client)).enhanceWith(client -> SessionHiveMetaStoreClient.newClient((Configuration)this.conf, client)).withHooks(hookLoader).threadSafe();
        if (!this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH)) {
            msClientBuilder = msClientBuilder.withRetry(this.metaCallTimeMap);
        }
        return msClientBuilder.build();
    }

    @Nullable
    private HiveStorageHandler createStorageHandler(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
        try {
            if (tbl == null) {
                return null;
            }
            String className = Hive.getStorageHandlerClassName(tbl);
            HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)this.conf, className);
            return storageHandler;
        }
        catch (HiveException ex) {
            LOG.error("Failed createStorageHandler", (Throwable)ex);
            throw new MetaException("Failed to load storage handler:  " + ex.getMessage());
        }
    }

    private static String getStorageHandlerClassName(org.apache.hadoop.hive.metastore.api.Table tbl) {
        String tableType = (String)tbl.getParameters().get("table_type");
        String metaTableStorage = (String)tbl.getParameters().get("storage_handler");
        if ("ICEBERG".equalsIgnoreCase(tableType) && metaTableStorage == null) {
            return "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler";
        }
        return metaTableStorage;
    }

    @VisibleForTesting
    public synchronized void setMSC(IMetaStoreClient client) throws MetaException {
        this.metaStoreClient = client;
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized IMetaStoreClient getMSC() throws MetaException {
        return this.getMSC(true, false);
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized IMetaStoreClient getMSC(boolean allowEmbedded, boolean forceCreate) throws MetaException {
        if (this.metaStoreClient == null || forceCreate) {
            try {
                this.owner = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                String msg = "Error getting current user: " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                throw new MetaException(msg + "\n" + StringUtils.stringifyException((Throwable)e));
            }
            try {
                this.metaStoreClient = this.createMetaStoreClient(allowEmbedded);
            }
            catch (RuntimeException ex) {
                for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
                    if (!(t instanceof JDODataStoreException) || t.getMessage() == null || !t.getMessage().contains("autoCreate")) continue;
                    LOG.error("Cannot initialize metastore due to autoCreate error", t);
                    throw new SchemaException("Hive metastore database is not initialized. Please use schematool (e.g. ./schematool -initSchema -dbType ...) to create the schema. If needed, don't forget to include the option to auto-create the underlying database in your JDBC connection string (e.g. ?createDatabaseIfNotExist=true for mysql)");
                }
                throw ex;
            }
        }
        return this.metaStoreClient;
    }

    private static String getUserName() {
        return SessionState.getUserFromAuthenticator();
    }

    private List<String> getGroupNames() {
        SessionState ss = SessionState.get();
        if (ss != null && ss.getAuthenticator() != null) {
            return ss.getAuthenticator().getGroupNames();
        }
        return null;
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String name, Deserializer serde, Configuration conf) throws HiveException {
        try {
            return HiveMetaStoreUtils.getFieldsFromDeserializer((String)name, (Deserializer)serde, (Configuration)conf);
        }
        catch (SerDeException e) {
            throw new HiveException("Error in getting fields from serde. " + e.getMessage(), (Throwable)e);
        }
        catch (MetaException e) {
            throw new HiveException("Error in getting fields from serde." + e.getMessage(), (Throwable)e);
        }
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws HiveException {
        try {
            ColumnStatistics colStat = (ColumnStatistics)request.getColStats().get(0);
            ColumnStatisticsDesc statsDesc = colStat.getStatsDesc();
            if (request.getWriteId() <= 0L || request.getValidWriteIdList() == null) {
                Table tbl = this.getTable(statsDesc.getDbName(), statsDesc.getTableName());
                AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, tbl, true);
                request.setValidWriteIdList(tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null);
                request.setWriteId(tableSnapshot != null ? tableSnapshot.getWriteId() : 0L);
            }
            return this.getMSC().setPartitionColumnStatistics(request);
        }
        catch (Exception e) {
            LOG.debug("Failed setPartitionColumnStatistics", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tblName, List<String> colNames, boolean checkTransactional) throws HiveException {
        Table tbl = this.getTable(dbName, tblName);
        return this.getTableColumnStatistics(tbl, colNames, checkTransactional);
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(Table tbl, List<String> colNames, boolean checkTransactional) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getTableColumnStatistics");
        List retv = null;
        try {
            Object tableSnapshot;
            if (tbl.isNonNative() && tbl.getStorageHandler().canProvideColStatistics(tbl)) {
                List<ColumnStatisticsObj> list = tbl.getStorageHandler().getColStatistics(tbl, colNames);
                return list;
            }
            if (checkTransactional) {
                tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, tbl);
                retv = this.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), colNames, "hive", tableSnapshot != null ? ((AcidUtils.TableSnapshot)tableSnapshot).getValidWriteIdList() : null);
            } else {
                retv = this.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), colNames, "hive");
            }
            tableSnapshot = retv;
            return tableSnapshot;
        }
        catch (Exception e) {
            LOG.debug("Failed getTableColumnStatistics", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getTableColumnStatistics", "HS2-cache");
        }
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames, boolean checkTransactional) throws HiveException {
        String writeIdList = null;
        try {
            if (checkTransactional) {
                Table tbl = this.getTable(dbName, tableName);
                AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, tbl);
                writeIdList = tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null;
            }
            return this.getMSC().getPartitionColumnStatistics(dbName, tableName, partNames, colNames, "hive", writeIdList);
        }
        catch (Exception e) {
            LOG.debug("Failed getPartitionColumnStatistics", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName, boolean checkTransactional) throws HiveException {
        Table tbl = this.getTable(dbName, tblName);
        return this.getAggrColStatsFor(tbl, colNames, partName, checkTransactional);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggrStats getAggrColStatsFor(Table tbl, List<String> colNames, List<String> partName, boolean checkTransactional) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getAggrColStatsFor");
        String writeIdList = null;
        try {
            AcidUtils.TableSnapshot tableSnapshot;
            if (tbl.isNonNative() && tbl.getStorageHandler().canProvideColStatistics(tbl)) {
                AggrStats aggrStats = tbl.getStorageHandler().getAggrColStatsFor(tbl, colNames, partName);
                return aggrStats;
            }
            if (checkTransactional) {
                tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.conf, tbl);
                writeIdList = tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null;
            }
            tableSnapshot = this.getMSC().getAggrColStatsFor(tbl.getDbName(), tbl.getTableName(), colNames, partName, "hive", writeIdList);
            return tableSnapshot;
        }
        catch (Exception e) {
            LOG.debug("Failed getAggrColStatsFor", (Throwable)e);
            AggrStats aggrStats = new AggrStats(new ArrayList(), 0L);
            return aggrStats;
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getAggrColStatsFor", "HS2-cache");
        }
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws HiveException {
        try {
            return this.getMSC().deleteTableColumnStatistics(dbName, tableName, colName, "hive");
        }
        catch (Exception e) {
            LOG.debug("Failed deleteTableColumnStatistics", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws HiveException {
        try {
            return this.getMSC().deletePartitionColumnStatistics(dbName, tableName, partName, colName, "hive");
        }
        catch (Exception e) {
            LOG.debug("Failed deletePartitionColumnStatistics", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public void updateTransactionalStatistics(UpdateTransactionalStatsRequest req) throws HiveException {
        try {
            this.getMSC().updateTransactionalStatistics(req);
        }
        catch (Exception e) {
            LOG.debug("Failed updateTransactionalStatistics", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public Table newTable(String tableName) throws HiveException {
        String[] names = Utilities.getDbTableName(tableName);
        return new Table(names[0], names[1]);
    }

    public String getDelegationToken(String owner, String renewer) throws HiveException {
        try {
            return this.getMSC().getDelegationToken(owner, renewer);
        }
        catch (Exception e) {
            LOG.error("Failed getDelegationToken", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public void cancelDelegationToken(String tokenStrForm) throws HiveException {
        try {
            this.getMSC().cancelDelegationToken(tokenStrForm);
        }
        catch (Exception e) {
            LOG.error("Failed cancelDelegationToken", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    @Deprecated
    public void compact(String dbname, String tableName, String partName, String compactType, Map<String, String> tblproperties) throws HiveException {
        this.compact2(dbname, tableName, partName, compactType, tblproperties);
    }

    @Deprecated
    public CompactionResponse compact2(String dbname, String tableName, String partName, String compactType, Map<String, String> tblproperties) throws HiveException {
        CompactionType cr;
        if ("major".equalsIgnoreCase(compactType)) {
            cr = CompactionType.MAJOR;
        } else if ("minor".equalsIgnoreCase(compactType)) {
            cr = CompactionType.MINOR;
        } else {
            throw new RuntimeException("Unknown compaction type " + compactType);
        }
        CompactionRequest request = new CompactionRequest(dbname, tableName, cr);
        request.setPartitionname(partName);
        request.setProperties(tblproperties);
        return this.compact(request);
    }

    public CompactionResponse compact(CompactionRequest request) throws HiveException {
        try {
            return this.getMSC().compact2(request);
        }
        catch (Exception e) {
            LOG.error("Failed compact3", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public ShowCompactResponse showCompactions() throws HiveException {
        try {
            return this.getMSC().showCompactions();
        }
        catch (Exception e) {
            LOG.error("Failed showCompactions", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public ShowCompactResponse showCompactions(ShowCompactRequest request) throws HiveException {
        try {
            return this.getMSC().showCompactions(request);
        }
        catch (Exception e) {
            LOG.error("Failed showCompactions", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public GetOpenTxnsInfoResponse showTransactions() throws HiveException {
        try {
            return this.getMSC().showTxns();
        }
        catch (Exception e) {
            LOG.error("Failed showTransactions", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public void abortTransactions(List<Long> txnids, long errorCode) throws HiveException {
        AbortTxnsRequest abortTxnsRequest = new AbortTxnsRequest(txnids);
        abortTxnsRequest.setErrorCode(errorCode);
        try {
            this.getMSC().abortTxns(abortTxnsRequest);
        }
        catch (Exception e) {
            LOG.error("Failed abortTransactions", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    public void createFunction(org.apache.hadoop.hive.metastore.api.Function func) throws HiveException {
        try {
            this.getMSC().createFunction(func);
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public void alterFunction(String dbName, String funcName, org.apache.hadoop.hive.metastore.api.Function newFunction) throws HiveException {
        try {
            this.getMSC().alterFunction(dbName, funcName, newFunction);
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public void dropFunction(String dbName, String funcName) throws HiveException {
        try {
            this.getMSC().dropFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public org.apache.hadoop.hive.metastore.api.Function getFunction(String dbName, String funcName) throws HiveException {
        try {
            return this.getMSC().getFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Function> getAllFunctions() throws HiveException {
        try {
            List functions = this.getMSC().getAllFunctions().getFunctions();
            return functions == null ? new ArrayList() : functions;
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws HiveException {
        try {
            return this.getMSC().getFunctions(dbName, pattern);
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Function> getFunctionsInDb(String dbName, String pattern) throws HiveException {
        try {
            GetFunctionsRequest request = new GetFunctionsRequest(dbName);
            request.setPattern(pattern);
            request.setCatalogName(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf));
            request.setReturnNames(false);
            return this.getMSC().getFunctionsRequest(request).getFunctions();
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public void setMetaConf(String propName, String propValue) throws HiveException {
        try {
            if (Arrays.stream(MetastoreConf.metaConfVars).anyMatch(s -> s.getVarname().equals(propName))) {
                this.conf.set(propName, propValue);
            }
            this.getMSC().setMetaConf(propName, propValue);
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public String getMetaConf(String propName) throws HiveException {
        try {
            return this.getMSC().getMetaConf(propName);
        }
        catch (TException te) {
            throw new HiveException((Throwable)te);
        }
    }

    public void clearMetaCallTiming() {
        this.metaCallTimeMap.clear();
    }

    public static ImmutableMap<String, Long> dumpMetaCallTimingWithoutEx(String phase) {
        try {
            return Hive.get().dumpAndClearMetaCallTiming(phase);
        }
        catch (HiveException he) {
            LOG.warn("Caught exception attempting to write metadata call information " + String.valueOf((Object)he), (Throwable)he);
            return null;
        }
    }

    public ImmutableMap<String, Long> dumpAndClearMetaCallTiming(String phase) {
        if (LOG.isInfoEnabled()) {
            boolean phaseInfoLogged = this.logDumpPhase(phase);
            LOG.info("Total time spent in each metastore function (ms): " + String.valueOf(this.metaCallTimeMap));
            for (Map.Entry<String, Long> callTime : this.metaCallTimeMap.entrySet()) {
                if (callTime.getValue() <= 1000L) continue;
                if (!phaseInfoLogged) {
                    phaseInfoLogged = this.logDumpPhase(phase);
                }
                LOG.info("Total time spent in this metastore function was greater than 1000ms : " + String.valueOf(callTime));
            }
        }
        ImmutableMap result = ImmutableMap.copyOf(this.metaCallTimeMap);
        this.metaCallTimeMap.clear();
        return result;
    }

    private boolean logDumpPhase(String phase) {
        LOG.info("Dumping metastore api call timing information for : " + phase + " phase");
        return true;
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws HiveException {
        try {
            return this.getMSC().getFileMetadata(fileIds);
        }
        catch (TException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataByExpr(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws HiveException {
        try {
            return this.getMSC().getFileMetadataBySarg(fileIds, sarg, doGetFooters);
        }
        catch (TException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void clearFileMetadata(List<Long> fileIds) throws HiveException {
        try {
            this.getMSC().clearFileMetadata(fileIds);
        }
        catch (TException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws HiveException {
        try {
            this.getMSC().putFileMetadata(fileIds, metadata);
        }
        catch (TException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws HiveException {
        try {
            boolean willCache = this.getMSC().cacheFileMetadata(dbName, tableName, partName, allParts);
            if (!willCache) {
                throw new HiveException("Caching file metadata is not supported by metastore or for this file format");
            }
        }
        catch (TException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void dropConstraint(String dbName, String tableName, String constraintName) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropConstraint(dbName, tableName, constraintName);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<SQLPrimaryKey> getPrimaryKeyList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getPrimaryKeys(new PrimaryKeysRequest(dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<SQLForeignKey> getForeignKeyList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getForeignKeys(new ForeignKeysRequest(null, null, dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<SQLUniqueConstraint> getUniqueConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getUniqueConstraints(new UniqueConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<SQLNotNullConstraint> getNotNullConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getNotNullConstraints(new NotNullConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<SQLDefaultConstraint> getDefaultConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getDefaultConstraints(new DefaultConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<SQLCheckConstraint> getCheckConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getCheckConstraints(new CheckConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public SQLAllTableConstraints getTableConstraints(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getAllTableConstraints(new AllTableConstraintsRequest(dbName, tblName, MetaStoreUtils.getDefaultCatalog((Configuration)this.conf)));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public TableConstraintsInfo getTableConstraints(String dbName, String tblName, boolean fetchReliable, boolean fetchEnabled) throws HiveException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.CLASS_NAME, "getTableConstraints");
        try {
            SQLAllTableConstraints tableConstraints = this.getMSC().getAllTableConstraints(new AllTableConstraintsRequest(dbName, tblName, MetaStoreUtils.getDefaultCatalog((Configuration)this.conf)));
            if (fetchReliable && tableConstraints != null) {
                if (CollectionUtils.isNotEmpty((Collection)tableConstraints.getPrimaryKeys())) {
                    tableConstraints.setPrimaryKeys(tableConstraints.getPrimaryKeys().stream().filter(SQLPrimaryKey::isRely_cstr).collect(Collectors.toList()));
                }
                if (CollectionUtils.isNotEmpty((Collection)tableConstraints.getForeignKeys())) {
                    tableConstraints.setForeignKeys(tableConstraints.getForeignKeys().stream().filter(SQLForeignKey::isRely_cstr).collect(Collectors.toList()));
                }
                if (CollectionUtils.isNotEmpty((Collection)tableConstraints.getUniqueConstraints())) {
                    tableConstraints.setUniqueConstraints(tableConstraints.getUniqueConstraints().stream().filter(SQLUniqueConstraint::isRely_cstr).collect(Collectors.toList()));
                }
                if (CollectionUtils.isNotEmpty((Collection)tableConstraints.getNotNullConstraints())) {
                    tableConstraints.setNotNullConstraints(tableConstraints.getNotNullConstraints().stream().filter(SQLNotNullConstraint::isRely_cstr).collect(Collectors.toList()));
                }
            }
            if (fetchEnabled && tableConstraints != null) {
                if (CollectionUtils.isNotEmpty((Collection)tableConstraints.getCheckConstraints())) {
                    tableConstraints.setCheckConstraints(tableConstraints.getCheckConstraints().stream().filter(SQLCheckConstraint::isEnable_cstr).collect(Collectors.toList()));
                }
                if (CollectionUtils.isNotEmpty((Collection)tableConstraints.getDefaultConstraints())) {
                    tableConstraints.setDefaultConstraints(tableConstraints.getDefaultConstraints().stream().filter(SQLDefaultConstraint::isEnable_cstr).collect(Collectors.toList()));
                }
            }
            TableConstraintsInfo tableConstraintsInfo = new TableConstraintsInfo(new PrimaryKeyInfo(tableConstraints.getPrimaryKeys(), tblName, dbName), new ForeignKeyInfo(tableConstraints.getForeignKeys(), tblName, dbName), new UniqueConstraint(tableConstraints.getUniqueConstraints(), tblName, dbName), new DefaultConstraint(tableConstraints.getDefaultConstraints(), tblName, dbName), new CheckConstraint(tableConstraints.getCheckConstraints()), new NotNullConstraint(tableConstraints.getNotNullConstraints(), tblName, dbName));
            return tableConstraintsInfo;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        finally {
            perfLogger.perfLogEnd(this.CLASS_NAME, "getTableConstraints", "HS2-cache");
        }
    }

    public NotNullConstraint getEnabledNotNullConstraints(String dbName, String tblName) throws HiveException {
        try {
            List notNullConstraints = this.getMSC().getNotNullConstraints(new NotNullConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (notNullConstraints != null && !notNullConstraints.isEmpty()) {
                notNullConstraints = notNullConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new NotNullConstraint(notNullConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public CheckConstraint getEnabledCheckConstraints(String dbName, String tblName) throws HiveException {
        try {
            List checkConstraints = this.getMSC().getCheckConstraints(new CheckConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (checkConstraints != null && !checkConstraints.isEmpty()) {
                checkConstraints = checkConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new CheckConstraint(checkConstraints);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public DefaultConstraint getEnabledDefaultConstraints(String dbName, String tblName) throws HiveException {
        try {
            List defaultConstraints = this.getMSC().getDefaultConstraints(new DefaultConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (defaultConstraints != null && !defaultConstraints.isEmpty()) {
                defaultConstraints = defaultConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new DefaultConstraint(defaultConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addPrimaryKey(primaryKeyCols);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addForeignKey(foreignKeyCols);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void addUniqueConstraint(List<SQLUniqueConstraint> uniqueConstraintCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addUniqueConstraint(uniqueConstraintCols);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void addNotNullConstraint(List<SQLNotNullConstraint> notNullConstraintCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addNotNullConstraint(notNullConstraintCols);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void addDefaultConstraint(List<SQLDefaultConstraint> defaultConstraints) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addDefaultConstraint(defaultConstraints);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void addCheckConstraint(List<SQLCheckConstraint> checkConstraints) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addCheckConstraint(checkConstraints);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createResourcePlan(WMResourcePlan resourcePlan, String copyFromName, boolean ifNotExists) throws HiveException {
        String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
        if (resourcePlan.isSetNs() && !ns.equals(resourcePlan.getNs())) {
            throw new HiveException("Cannot create a plan in a different NS; was " + resourcePlan.getNs() + ", configured " + ns);
        }
        resourcePlan.setNs(ns);
        try {
            this.getMSC().createResourcePlan(resourcePlan, copyFromName);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException((Throwable)e, ErrorMsg.RESOURCE_PLAN_ALREADY_EXISTS, new String[]{resourcePlan.getName()});
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public WMFullResourcePlan getResourcePlan(String rpName) throws HiveException {
        try {
            return this.getMSC().getResourcePlan(rpName, this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE));
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public List<WMResourcePlan> getAllResourcePlans() throws HiveException {
        try {
            return this.getMSC().getAllResourcePlans(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE));
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void dropResourcePlan(String rpName, boolean ifExists) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            this.getMSC().dropResourcePlan(rpName, ns);
        }
        catch (NoSuchObjectException e) {
            if (!ifExists) {
                throw new HiveException((Throwable)e, ErrorMsg.RESOURCE_PLAN_NOT_EXISTS, new String[]{rpName});
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public WMFullResourcePlan alterResourcePlan(String rpName, WMNullableResourcePlan resourcePlan, boolean canActivateDisabled, boolean isForceDeactivate, boolean isReplace) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            if (resourcePlan.isSetNs() && !ns.equals(resourcePlan.getNs())) {
                throw new HiveException("Cannot modify a plan in a different NS; was " + resourcePlan.getNs() + ", configured " + ns);
            }
            resourcePlan.setNs(ns);
            return this.getMSC().alterResourcePlan(rpName, ns, resourcePlan, canActivateDisabled, isForceDeactivate, isReplace);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public WMFullResourcePlan getActiveResourcePlan() throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            return this.getMSC().getActiveResourcePlan(ns);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public WMValidateResourcePlanResponse validateResourcePlan(String rpName) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            return this.getMSC().validateResourcePlan(rpName, ns);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createWMTrigger(WMTrigger trigger) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            if (trigger.isSetNs() && !ns.equals(trigger.getNs())) {
                throw new HiveException("Cannot create a trigger in a different NS; was " + trigger.getNs() + ", configured " + ns);
            }
            trigger.setNs(ns);
            this.getMSC().createWMTrigger(trigger);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void alterWMTrigger(WMTrigger trigger) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            if (trigger.isSetNs() && !ns.equals(trigger.getNs())) {
                throw new HiveException("Cannot modify a trigger in a different NS; was " + trigger.getNs() + ", configured " + ns);
            }
            trigger.setNs(ns);
            this.getMSC().alterWMTrigger(trigger);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void dropWMTrigger(String rpName, String triggerName) throws HiveException {
        try {
            this.getMSC().dropWMTrigger(rpName, triggerName, this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE));
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createWMPool(WMPool pool) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            if (pool.isSetNs() && !ns.equals(pool.getNs())) {
                throw new HiveException("Cannot create a pool in a different NS; was " + pool.getNs() + ", configured " + ns);
            }
            pool.setNs(ns);
            this.getMSC().createWMPool(pool);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void alterWMPool(WMNullablePool pool, String poolPath) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            if (pool.isSetNs() && !ns.equals(pool.getNs())) {
                throw new HiveException("Cannot modify a pool in a different NS; was " + pool.getNs() + ", configured " + ns);
            }
            pool.setNs(ns);
            this.getMSC().alterWMPool(pool, poolPath);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void dropWMPool(String resourcePlanName, String poolPath) throws HiveException {
        try {
            this.getMSC().dropWMPool(resourcePlanName, poolPath, this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE));
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createOrUpdateWMMapping(WMMapping mapping, boolean isUpdate) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            if (mapping.isSetNs() && !ns.equals(mapping.getNs())) {
                throw new HiveException("Cannot create a mapping in a different NS; was " + mapping.getNs() + ", configured " + ns);
            }
            mapping.setNs(ns);
            this.getMSC().createOrUpdateWMMapping(mapping, isUpdate);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void dropWMMapping(WMMapping mapping) throws HiveException {
        try {
            String ns = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE);
            if (mapping.isSetNs() && !ns.equals(mapping.getNs())) {
                throw new HiveException("Cannot modify a mapping in a different NS; was " + mapping.getNs() + ", configured " + ns);
            }
            mapping.setNs(ns);
            this.getMSC().dropWMMapping(mapping);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void createOrDropTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, boolean shouldDrop) throws HiveException {
        try {
            this.getMSC().createOrDropTriggerToPoolMapping(resourcePlanName, triggerName, poolPath, shouldDrop, this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_WM_NAMESPACE));
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    @Nullable
    public StorageHandlerInfo getStorageHandlerInfo(Table table) throws HiveException {
        try {
            HiveStorageHandler storageHandler = this.createStorageHandler(table.getTTable());
            return storageHandler == null ? null : storageHandler.getStorageHandlerInfo(table.getTTable());
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void alterTableExecuteOperation(Table table, AlterTableExecuteSpec executeSpec) throws HiveException {
        try {
            HiveStorageHandler storageHandler = Optional.ofNullable(this.createStorageHandler(table.getTTable())).orElseThrow(() -> new UnsupportedOperationException(String.format("ALTER EXECUTE is not supported for table %s", table.getTableName())));
            storageHandler.executeOperation(table, executeSpec);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public void alterTableSnapshotRefOperation(Table table, AlterTableSnapshotRefSpec alterTableSnapshotRefSpec) throws HiveException {
        try {
            HiveStorageHandler storageHandler = this.createStorageHandler(table.getTTable());
            storageHandler.alterTableSnapshotRefOperation(table, alterTableSnapshotRefSpec);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    public AbortCompactResponse abortCompactions(AbortCompactionRequest request) throws HiveException {
        try {
            return this.getMSC().abortCompactions(request);
        }
        catch (Exception e) {
            LOG.error("Failed abortCompactions", (Throwable)e);
            throw new HiveException((Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.close(true);
    }

    private static class ThreadLocalHive
    extends ThreadLocal<Hive> {
        private ThreadLocalHive() {
        }

        @Override
        protected Hive initialValue() {
            return null;
        }

        @Override
        public synchronized void set(Hive hiveObj) {
            Hive currentHive = (Hive)this.get();
            if (currentHive != hiveObj) {
                this.remove();
                super.set(hiveObj);
            }
        }

        @Override
        public synchronized void remove() {
            Hive currentHive = (Hive)this.get();
            if (currentHive != null) {
                currentHive.close(false);
                super.remove();
            }
        }
    }

    public static class SchemaException
    extends MetaException {
        private static final long serialVersionUID = 1L;

        public SchemaException(String message) {
            super(message);
        }
    }
}

