/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TableSample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QBParseInfo {
    private boolean isSubQ;
    private String alias;
    private ASTNode joinExpr;
    private ASTNode hints;
    private ASTNode colAliases;
    private List<ASTNode> hintList;
    private final Map<String, ASTNode> aliasToSrc = new HashMap<String, ASTNode>();
    private final Map<String, ASTNode> nameToDest = new HashMap<String, ASTNode>();
    private final Map<String, List<String>> nameToDestSchema = new HashMap<String, List<String>>();
    private final Map<String, TableSample> nameToSample = new HashMap<String, TableSample>();
    private final Map<ASTNode, String> exprToColumnAlias = new HashMap<ASTNode, String>();
    private final Map<String, ASTNode> destToSelExpr;
    private final Map<String, ASTNode> destToWhereExpr;
    private final Map<String, ASTNode> destToGroupby;
    private final Set<String> destRollups;
    private final Set<String> destCubes;
    private final Set<String> destGroupingSets;
    private final Map<String, ASTNode> destToHaving;
    private final Map<String, ASTNode> destToQualify;
    private final Map<String, Boolean> destToOpType;
    private final Map<String, ASTNode> insertIntoTables;
    private final Map<String, ASTNode> insertOverwriteTables;
    private ASTNode queryFromExpr;
    private boolean isAnalyzeCommand;
    private boolean isNoScanAnalyzeCommand;
    private final Map<String, BaseSemanticAnalyzer.TableSpec> tableSpecs;
    private BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite;
    private final Map<String, ASTNode> destToClusterby;
    private final Map<String, ASTNode> destToDistributeby;
    private final Map<String, ASTNode> destToSortby;
    private final Map<String, List<ASTNode>> aliasToLateralViews;
    private final Map<String, ASTNode> destToLateralView = new HashMap<String, ASTNode>();
    private final Map<String, ASTNode> destToOrderby;
    private final Map<String, AbstractMap.SimpleEntry<Integer, Integer>> destToLimit;
    private int outerQueryLimit;
    private final Map<String, Map<String, ASTNode>> destToAggregationExprs;
    private final Map<String, List<ASTNode>> destToDistinctFuncExprs;
    private final Map<String, Map<String, ASTNode>> destToWindowingExprs;
    private boolean isInsertOverwriteDir = false;
    private static final Logger LOG = LoggerFactory.getLogger((String)QBParseInfo.class.getName());

    public QBParseInfo(String alias, boolean isSubQ) {
        this.destToSelExpr = new LinkedHashMap<String, ASTNode>();
        this.destToWhereExpr = new HashMap<String, ASTNode>();
        this.destToGroupby = new HashMap<String, ASTNode>();
        this.destToHaving = new HashMap<String, ASTNode>();
        this.destToQualify = new HashMap<String, ASTNode>();
        this.destToClusterby = new HashMap<String, ASTNode>();
        this.destToDistributeby = new HashMap<String, ASTNode>();
        this.destToSortby = new HashMap<String, ASTNode>();
        this.destToOrderby = new HashMap<String, ASTNode>();
        this.destToLimit = new HashMap<String, AbstractMap.SimpleEntry<Integer, Integer>>();
        this.destToOpType = new HashMap<String, Boolean>();
        this.insertIntoTables = new HashMap<String, ASTNode>();
        this.insertOverwriteTables = new HashMap<String, ASTNode>();
        this.destRollups = new HashSet<String>();
        this.destCubes = new HashSet<String>();
        this.destGroupingSets = new HashSet<String>();
        this.destToAggregationExprs = new LinkedHashMap<String, Map<String, ASTNode>>();
        this.destToWindowingExprs = new LinkedHashMap<String, Map<String, ASTNode>>();
        this.destToDistinctFuncExprs = new HashMap<String, List<ASTNode>>();
        this.alias = StringInternUtils.internIfNotNull((String)alias);
        this.isSubQ = isSubQ;
        this.outerQueryLimit = -1;
        this.aliasToLateralViews = new HashMap<String, List<ASTNode>>();
        this.tableSpecs = new HashMap<String, BaseSemanticAnalyzer.TableSpec>();
    }

    public void clearAggregationExprsForClause(String clause) {
        this.destToAggregationExprs.get(clause).clear();
    }

    public void setAggregationExprsForClause(String clause, Map<String, ASTNode> aggregationTrees) {
        this.destToAggregationExprs.put(clause, aggregationTrees);
    }

    public void addAggregationExprsForClause(String clause, Map<String, ASTNode> aggregationTrees) {
        if (this.destToAggregationExprs.containsKey(clause)) {
            this.destToAggregationExprs.get(clause).putAll(aggregationTrees);
        } else {
            this.destToAggregationExprs.put(clause, aggregationTrees);
        }
    }

    public void addInsertIntoTable(String fullName, ASTNode ast) {
        this.insertIntoTables.put(fullName.toLowerCase(), ast);
    }

    public void setDestToOpType(String clause, boolean value) {
        this.destToOpType.put(clause, value);
    }

    public boolean isDestToOpTypeInsertOverwrite(String clause) {
        if (this.destToOpType.containsKey(clause)) {
            return this.destToOpType.get(clause);
        }
        return false;
    }

    public boolean isInsertIntoTable(String dbName, String table, String branchName) {
        String fullName = dbName + "." + table;
        if (branchName != null) {
            fullName = fullName + "." + branchName;
        }
        return this.insertIntoTables.containsKey(fullName.toLowerCase());
    }

    public boolean isInsertIntoTable(String fullTableName) {
        return this.insertIntoTables.containsKey(fullTableName.toLowerCase());
    }

    public void setInsertOverwriteDirectory(boolean isInsertOverwriteDir) {
        this.isInsertOverwriteDir = isInsertOverwriteDir;
    }

    public Map<String, ASTNode> getAggregationExprsForClause(String clause) {
        return this.destToAggregationExprs.get(clause);
    }

    public void addWindowingExprToClause(String clause, ASTNode windowingExprNode) {
        Map<String, ASTNode> windowingExprs = this.destToWindowingExprs.get(clause);
        if (windowingExprs == null) {
            windowingExprs = new LinkedHashMap<String, ASTNode>();
            this.destToWindowingExprs.put(clause, windowingExprs);
        }
        windowingExprs.put(windowingExprNode.toStringTree(), windowingExprNode);
    }

    public Map<String, ASTNode> getWindowingExprsForClause(String clause) {
        return this.destToWindowingExprs.get(clause);
    }

    public void clearDistinctFuncExprsForClause(String clause) {
        List<ASTNode> l = this.destToDistinctFuncExprs.get(clause);
        if (l != null) {
            l.clear();
        }
    }

    public void setDistinctFuncExprsForClause(String clause, List<ASTNode> ast) {
        this.destToDistinctFuncExprs.put(clause, ast);
    }

    public List<ASTNode> getDistinctFuncExprsForClause(String clause) {
        return this.destToDistinctFuncExprs.get(clause);
    }

    public void setSelExprForClause(String clause, ASTNode ast) {
        this.destToSelExpr.put(clause, ast);
    }

    public void setQueryFromExpr(ASTNode ast) {
        this.queryFromExpr = ast;
    }

    public void setWhrExprForClause(String clause, ASTNode ast) {
        this.destToWhereExpr.put(clause, ast);
    }

    public void setHavingExprForClause(String clause, ASTNode ast) {
        this.destToHaving.put(clause, ast);
    }

    public void setGroupByExprForClause(String clause, ASTNode ast) {
        this.destToGroupby.put(clause, ast);
    }

    public void setDestForClause(String clause, ASTNode ast) {
        this.nameToDest.put(clause, ast);
    }

    List<String> setDestSchemaForClause(String clause, List<String> columnList) {
        return this.nameToDestSchema.put(clause, columnList);
    }

    List<String> getDestSchemaForClause(String clause) {
        return this.nameToDestSchema.get(clause);
    }

    public void setClusterByExprForClause(String clause, ASTNode ast) {
        this.destToClusterby.put(clause, ast);
    }

    public void setDistributeByExprForClause(String clause, ASTNode ast) {
        this.destToDistributeby.put(clause, ast);
    }

    public void setSortByExprForClause(String clause, ASTNode ast) {
        this.destToSortby.put(clause, ast);
    }

    public void setOrderByExprForClause(String clause, ASTNode ast) {
        this.destToOrderby.put(clause, ast);
    }

    public void setSrcForAlias(String alias, ASTNode ast) {
        this.aliasToSrc.put(alias.toLowerCase(), ast);
    }

    public Set<String> getClauseNames() {
        return this.destToSelExpr.keySet();
    }

    public Set<String> getClauseNamesForDest() {
        return this.nameToDest.keySet();
    }

    public ASTNode getDestForClause(String clause) {
        return this.nameToDest.get(clause);
    }

    public ASTNode getWhrForClause(String clause) {
        return this.destToWhereExpr.get(clause);
    }

    public Map<String, ASTNode> getDestToWhereExpr() {
        return this.destToWhereExpr;
    }

    public ASTNode getGroupByForClause(String clause) {
        return this.destToGroupby.get(clause);
    }

    public Set<String> getDestRollups() {
        return this.destRollups;
    }

    public Set<String> getDestCubes() {
        return this.destCubes;
    }

    public Set<String> getDestGroupingSets() {
        return this.destGroupingSets;
    }

    public Map<String, ASTNode> getDestToGroupBy() {
        return this.destToGroupby;
    }

    public ASTNode getHavingForClause(String clause) {
        return this.destToHaving.get(clause);
    }

    public Map<String, ASTNode> getDestToHaving() {
        return this.destToHaving;
    }

    public ASTNode getSelForClause(String clause) {
        return this.destToSelExpr.get(clause);
    }

    public ASTNode getQueryFrom() {
        return this.queryFromExpr;
    }

    public ASTNode getClusterByForClause(String clause) {
        return this.destToClusterby.get(clause);
    }

    public Map<String, ASTNode> getDestToClusterBy() {
        return this.destToClusterby;
    }

    public ASTNode getDistributeByForClause(String clause) {
        return this.destToDistributeby.get(clause);
    }

    public Map<String, ASTNode> getDestToDistributeBy() {
        return this.destToDistributeby;
    }

    public ASTNode getSortByForClause(String clause) {
        return this.destToSortby.get(clause);
    }

    public ASTNode getOrderByForClause(String clause) {
        return this.destToOrderby.get(clause);
    }

    public Map<String, ASTNode> getDestToSortBy() {
        return this.destToSortby;
    }

    public Map<String, ASTNode> getDestToOrderBy() {
        return this.destToOrderby;
    }

    public ASTNode getSrcForAlias(String alias) {
        return this.aliasToSrc.get(alias.toLowerCase());
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean getIsSubQ() {
        return this.isSubQ;
    }

    public void setIsSubQ(boolean isSubQ) {
        this.isSubQ = isSubQ;
    }

    public ASTNode getJoinExpr() {
        return this.joinExpr;
    }

    public void setJoinExpr(ASTNode joinExpr) {
        this.joinExpr = joinExpr;
    }

    public TableSample getTabSample(String alias) {
        return this.nameToSample.get(alias.toLowerCase());
    }

    public void setTabSample(String alias, TableSample tableSample) {
        this.nameToSample.put(alias.toLowerCase(), tableSample);
    }

    public String getExprToColumnAlias(ASTNode expr) {
        return this.exprToColumnAlias.get(expr);
    }

    public Map<ASTNode, String> getAllExprToColumnAlias() {
        return this.exprToColumnAlias;
    }

    public boolean hasExprToColumnAlias(ASTNode expr) {
        return this.exprToColumnAlias.containsKey(expr);
    }

    public void setExprToColumnAlias(ASTNode expr, String alias) {
        this.exprToColumnAlias.put(expr, StringInternUtils.internIfNotNull((String)alias));
    }

    public void setDestLimit(String dest, Integer offset, Integer limit) {
        this.destToLimit.put(dest, new AbstractMap.SimpleEntry<Integer, Integer>(offset, limit));
    }

    public Integer getDestLimit(String dest) {
        return this.destToLimit.get(dest) == null ? null : this.destToLimit.get(dest).getValue();
    }

    public Integer getDestLimitOffset(String dest) {
        return this.destToLimit.get(dest) == null ? 0 : this.destToLimit.get(dest).getKey();
    }

    public int getOuterQueryLimit() {
        return this.outerQueryLimit;
    }

    public void setOuterQueryLimit(int outerQueryLimit) {
        this.outerQueryLimit = outerQueryLimit;
    }

    public boolean isTopLevelSimpleSelectStarQuery() {
        if (this.alias != null || this.destToSelExpr.size() != 1 || !this.isSimpleSelectQuery()) {
            return false;
        }
        for (ASTNode selExprs : this.destToSelExpr.values()) {
            if (selExprs.getChildCount() != 1) {
                return false;
            }
            Tree sel = selExprs.getChild(0).getChild(0);
            if (sel != null && sel.getType() == 843) continue;
            return false;
        }
        return true;
    }

    public boolean isSimpleSelectQuery() {
        if (!(this.joinExpr == null && this.destToOrderby.isEmpty() && this.destToSortby.isEmpty() && this.destToGroupby.isEmpty() && this.destToClusterby.isEmpty() && this.destToDistributeby.isEmpty() && this.destRollups.isEmpty() && this.destCubes.isEmpty() && this.destGroupingSets.isEmpty() && this.destToHaving.isEmpty())) {
            return false;
        }
        for (Map<String, ASTNode> map : this.destToAggregationExprs.values()) {
            if (map == null || map.isEmpty()) continue;
            return false;
        }
        for (Map<String, ASTNode> map : this.destToWindowingExprs.values()) {
            if (map == null || map.isEmpty()) continue;
            return false;
        }
        for (List list : this.destToDistinctFuncExprs.values()) {
            if (list.isEmpty()) continue;
            return false;
        }
        for (ASTNode aSTNode : this.nameToDest.values()) {
            if (aSTNode.getChild(0).getType() == 1291) continue;
            return false;
        }
        return true;
    }

    public void setHints(ASTNode hint) {
        this.hints = hint;
    }

    public void setHintList(List<ASTNode> hintList) {
        this.hintList = hintList;
    }

    public List<ASTNode> getHintList() {
        return this.hintList;
    }

    public ASTNode getHints() {
        return this.hints;
    }

    public Map<String, List<ASTNode>> getAliasToLateralViews() {
        return this.aliasToLateralViews;
    }

    public List<ASTNode> getLateralViewsForAlias(String alias) {
        return this.aliasToLateralViews.get(alias.toLowerCase());
    }

    public void addLateralViewForAlias(String alias, ASTNode lateralView) {
        List<ASTNode> lateralViews = this.aliasToLateralViews.get(alias);
        if (lateralViews == null) {
            lateralViews = new ArrayList<ASTNode>();
            this.aliasToLateralViews.put(alias, lateralViews);
        }
        lateralViews.add(lateralView);
    }

    public void setIsAnalyzeCommand(boolean isAnalyzeCommand) {
        this.isAnalyzeCommand = isAnalyzeCommand;
    }

    public boolean isAnalyzeCommand() {
        return this.isAnalyzeCommand;
    }

    public void addTableSpec(String tName, BaseSemanticAnalyzer.TableSpec tSpec) {
        this.tableSpecs.put(tName, tSpec);
    }

    public BaseSemanticAnalyzer.TableSpec getTableSpec(String tName) {
        return this.tableSpecs.get(tName);
    }

    public BaseSemanticAnalyzer.TableSpec getTableSpec() {
        Iterator<String> tName = this.tableSpecs.keySet().iterator();
        return this.tableSpecs.get(tName.next());
    }

    public Map<String, AbstractMap.SimpleEntry<Integer, Integer>> getDestToLimit() {
        return this.destToLimit;
    }

    public Map<String, Map<String, ASTNode>> getDestToAggregationExprs() {
        return this.destToAggregationExprs;
    }

    public Map<String, List<ASTNode>> getDestToDistinctFuncExprs() {
        return this.destToDistinctFuncExprs;
    }

    public Map<String, TableSample> getNameToSample() {
        return this.nameToSample;
    }

    public Map<String, ASTNode> getDestToLateralView() {
        return this.destToLateralView;
    }

    public void setQualifyExprForClause(String dest, ASTNode ast) {
        this.destToQualify.put(dest, ast);
    }

    public ASTNode getQualifyExprForClause(String dest) {
        return this.destToQualify.get(dest);
    }

    public boolean hasQualifyClause() {
        return !this.destToQualify.isEmpty();
    }

    public BaseSemanticAnalyzer.AnalyzeRewriteContext getAnalyzeRewrite() {
        return this.analyzeRewrite;
    }

    public void setAnalyzeRewrite(BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite) {
        this.analyzeRewrite = analyzeRewrite;
    }

    public boolean isNoScanAnalyzeCommand() {
        return this.isNoScanAnalyzeCommand;
    }

    public void setNoScanAnalyzeCommand(boolean isNoScanAnalyzeCommand) {
        this.isNoScanAnalyzeCommand = isNoScanAnalyzeCommand;
    }

    public Map<String, ASTNode> getInsertOverwriteTables() {
        return this.insertOverwriteTables;
    }

    public boolean hasInsertTables() {
        return this.insertIntoTables.size() > 0 || this.insertOverwriteTables.size() > 0;
    }

    public boolean isInsertOverwriteDirectory() {
        return this.isInsertOverwriteDir;
    }

    public boolean isFullyAggregate() throws SemanticException {
        for (ASTNode selectClause : this.destToSelExpr.values()) {
            for (Node node : selectClause.getChildren()) {
                ASTNode selexpr = (ASTNode)node;
                Tree expressionTypeToken = selexpr.getChild(0);
                int selectExprType = expressionTypeToken.getType();
                if (selectExprType != 1039 && selectExprType != 1040 && selectExprType != 1041) {
                    return false;
                }
                if (expressionTypeToken.getChild(0).getType() != 24) {
                    return false;
                }
                String functionName = BaseSemanticAnalyzer.unescapeIdentifier(expressionTypeToken.getChild(0).getText());
                FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(functionName);
                if (functionInfo == null) {
                    return false;
                }
                if (functionInfo.getGenericUDAFResolver() != null) continue;
                return false;
            }
        }
        return true;
    }

    public ASTNode getColAliases() {
        return this.colAliases;
    }

    public void setColAliases(ASTNode colAliases) {
        this.colAliases = colAliases;
    }

    protected static enum ClauseType {
        CLUSTER_BY_CLAUSE,
        DISTRIBUTE_BY_CLAUSE,
        ORDER_BY_CLAUSE,
        SORT_BY_CLAUSE;

    }
}

