/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.ql.ErrorMsg;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CompactionException
extends RuntimeException {
    private final ErrorMsg canonicalErrorMsg;
    private final String remoteErrorMsg;

    public CompactionException() {
        this((Throwable)null, (String)null, ErrorMsg.GENERIC_ERROR, new String[0]);
    }

    public CompactionException(String message) {
        this(message, null);
    }

    public CompactionException(Throwable cause) {
        this(cause, (String)null, ErrorMsg.GENERIC_ERROR, new String[0]);
    }

    public CompactionException(String message, Throwable cause) {
        super(message, cause);
        this.canonicalErrorMsg = ErrorMsg.GENERIC_ERROR;
        this.remoteErrorMsg = null;
    }

    public CompactionException(ErrorMsg message, String ... msgArgs) {
        this((Throwable)null, (String)null, message, msgArgs);
    }

    public CompactionException(Throwable cause, ErrorMsg errorMsg, String ... msgArgs) {
        this(cause, (String)null, errorMsg, msgArgs);
    }

    public CompactionException(Throwable cause, ErrorMsg errorMsg) {
        this(cause, (String)null, errorMsg, new String[0]);
    }

    public CompactionException(ErrorMsg errorMsg) {
        this((Throwable)null, (String)null, errorMsg, new String[0]);
    }

    public CompactionException(Throwable cause, String remErrMsg, ErrorMsg errorMsg, String ... msgArgs) {
        super(errorMsg.format(msgArgs), cause);
        this.canonicalErrorMsg = errorMsg;
        this.remoteErrorMsg = remErrMsg;
    }

    public ErrorMsg getCanonicalErrorMsg() {
        return this.canonicalErrorMsg;
    }

    public String getRemoteErrorMsg() {
        return this.remoteErrorMsg;
    }

    public CompactionException(Throwable throwable, String message, Object ... args) {
        super(String.format(message, args), throwable);
        this.canonicalErrorMsg = ErrorMsg.GENERIC_ERROR;
        this.remoteErrorMsg = null;
    }
}

