/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;

public abstract class AlterPartitionsMessage
extends EventMessage {
    protected AlterPartitionsMessage() {
        super(EventMessage.EventType.ALTER_PARTITIONS);
    }

    public abstract String getTable();

    public abstract String getTableType();

    public abstract Table getTableObj() throws Exception;

    public abstract boolean getIsTruncateOp();

    public abstract Long getWriteId();

    public abstract List<Map<String, String>> getPartitions();

    public abstract Iterable<Partition> getPartitionObjs() throws Exception;

    @Override
    public EventMessage checkValid() {
        if (this.getTable() == null) {
            throw new IllegalStateException("Table name unset.");
        }
        if (this.getPartitions() == null) {
            throw new IllegalStateException("Partition-list unset.");
        }
        try {
            this.getPartitionObjs().forEach(partition -> {
                if (this.getWriteId().longValue() != partition.getWriteId()) {
                    throw new IllegalStateException("Different write id in the same event");
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get the partition objects");
        }
        return super.checkValid();
    }
}

