/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4;

import java.io.Closeable;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.http4.Http4FileObject;
import org.apache.commons.vfs2.provider.http4.Http4FileProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;

@Deprecated
public class Http4FileSystem
extends AbstractFileSystem {
    private final URI internalBaseURI;
    private final HttpClient httpClient;
    private final HttpClientContext httpClientContext;

    protected Http4FileSystem(FileName rootName, FileSystemOptions fileSystemOptions, HttpClient httpClient, HttpClientContext httpClientContext) {
        super(rootName, null, fileSystemOptions);
        String rootURI = this.getRootURI();
        int offset = rootURI.indexOf(58);
        char lastCharOfScheme = offset > 0 ? rootURI.charAt(offset - 1) : (char)'\u0000';
        String scheme = lastCharOfScheme == 's' || lastCharOfScheme == 'S' ? "https" : "http";
        this.internalBaseURI = URI.create(scheme + rootURI.substring(offset));
        this.httpClient = httpClient;
        this.httpClientContext = httpClientContext;
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(Http4FileProvider.CAPABILITIES);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new Http4FileObject<Http4FileSystem>(name, this);
    }

    @Override
    protected void doCloseCommunicationLink() {
        if (this.httpClient instanceof Closeable) {
            Uncheck.run(() -> ((Closeable)this.httpClient).close());
        }
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpClientContext getHttpClientContext() {
        return this.httpClientContext;
    }

    protected URI getInternalBaseURI() {
        return this.internalBaseURI;
    }
}

