/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceTestUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SourceTestUtils.class);
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_CONCURRENT_SPLITTING_TRIALS_PER_ITEM = 100;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_CONCURRENT_SPLITTING_TRIALS_TOTAL = 1000;

    public static <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ReadableStructuralValue<T>> createStructuralValues(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized List<T> list) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<ReadableStructuralValue<T>> result = new ArrayList<ReadableStructuralValue<T>>();
        for (T elem : list) {
            result.add(new ReadableStructuralValue<T>(elem, coder.structuralValue(elem)));
        }
        return result;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> readFromSource(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (BoundedSource.BoundedReader<T> reader = source.createReader(options);){
            List<T> list = SourceTestUtils.readFromUnstartedReader(reader);
            return list;
        }
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> readFromSplitsOfSource(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList res = Lists.newArrayList();
        for (BoundedSource<T> split : source.split(desiredBundleSizeBytes, options)) {
            res.addAll(SourceTestUtils.readFromSource(split, options));
        }
        return res;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> readFromUnstartedReader(@UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return SourceTestUtils.readRemainingFromReader(reader, false);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> readFromStartedReader(@UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return SourceTestUtils.readRemainingFromReader(reader, true);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> readNItemsFromUnstartedReader(@UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader, @UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return SourceTestUtils.readNItemsFromReader(reader, n, false);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> readNItemsFromStartedReader(@UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader, @UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return SourceTestUtils.readNItemsFromReader(reader, n, true);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized List<T> readNItemsFromReader(@UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader, @UnknownKeyFor @NonNull @Initialized int n, @UnknownKeyFor @NonNull @Initialized boolean started) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<T> res = new ArrayList<T>();
        for (int i = 0; i < n; ++i) {
            boolean more;
            boolean shouldStart = i == 0 && !started;
            boolean bl = more = shouldStart ? reader.start() : reader.advance();
            if (n != Integer.MAX_VALUE) {
                Assert.assertTrue((boolean)more);
            }
            if (!more) break;
            res.add(reader.getCurrent());
        }
        return res;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> readRemainingFromReader(@UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader, @UnknownKeyFor @NonNull @Initialized boolean started) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return SourceTestUtils.readNItemsFromReader(reader, Integer.MAX_VALUE, started);
    }

    public static <T> void assertSourcesEqualReferenceSource(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> referenceSource, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedSource<T>> sources, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Coder coder = referenceSource.getOutputCoder();
        List<T> referenceRecords = SourceTestUtils.readFromSource(referenceSource, options);
        ArrayList<T> bundleRecords = new ArrayList<T>();
        for (BoundedSource<T> source : sources) {
            MatcherAssert.assertThat((String)("Coder type for source " + source + " is not compatible with Coder type for referenceSource " + referenceSource), source.getOutputCoder(), (Matcher)Matchers.equalTo(coder));
            List<T> elems = SourceTestUtils.readFromSource(source, options);
            bundleRecords.addAll(elems);
        }
        List bundleValues = SourceTestUtils.createStructuralValues(coder, bundleRecords);
        List referenceValues = SourceTestUtils.createStructuralValues(coder, referenceRecords);
        MatcherAssert.assertThat(bundleValues, (Matcher)Matchers.containsInAnyOrder((Object[])referenceValues.toArray()));
    }

    public static <T> void assertUnstartedReaderReadsSameAsItsSource(@UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> reader, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Coder coder = reader.getCurrentSource().getOutputCoder();
        List<T> expected = SourceTestUtils.readFromUnstartedReader(reader);
        List<T> actual = SourceTestUtils.readFromSource(reader.getCurrentSource(), options);
        List expectedStructural = SourceTestUtils.createStructuralValues(coder, expected);
        List actualStructural = SourceTestUtils.createStructuralValues(coder, actual);
        MatcherAssert.assertThat(actualStructural, (Matcher)Matchers.containsInAnyOrder((Object[])expectedStructural.toArray()));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SplitAtFractionResult assertSplitAtFractionBehavior(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized int numItemsToReadBeforeSplit, @UnknownKeyFor @NonNull @Initialized double splitFraction, @UnknownKeyFor @NonNull @Initialized ExpectedSplitOutcome expectedOutcome, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return SourceTestUtils.assertSplitAtFractionBehaviorImpl(source, SourceTestUtils.readFromSource(source, options), numItemsToReadBeforeSplit, splitFraction, expectedOutcome, options);
    }

    private static <T> void assertListsEqualInOrder(@UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized String expectedLabel, @UnknownKeyFor @NonNull @Initialized List<T> expected, @UnknownKeyFor @NonNull @Initialized String actualLabel, @UnknownKeyFor @NonNull @Initialized List<T> actual) {
        int i;
        for (i = 0; i < expected.size() && i < actual.size(); ++i) {
            if (Objects.equals(expected.get(i), actual.get(i))) continue;
            Assert.fail((String)String.format("%s: %s and %s have %d items in common and then differ. Item in %s (%d more): %s, item in %s (%d more): %s", message, expectedLabel, actualLabel, i, expectedLabel, expected.size() - i - 1, expected.get(i), actualLabel, actual.size() - i - 1, actual.get(i)));
        }
        if (i < expected.size()) {
            Assert.fail((String)String.format("%s: %s has %d more items after matching all %d from %s. First 5: %s", message, expectedLabel, expected.size() - actual.size(), actual.size(), actualLabel, expected.subList(actual.size(), Math.min(expected.size(), actual.size() + 5))));
        } else if (i < actual.size()) {
            Assert.fail((String)String.format("%s: %s has %d more items after matching all %d from %s. First 5: %s", message, actualLabel, actual.size() - expected.size(), expected.size(), expectedLabel, actual.subList(expected.size(), Math.min(actual.size(), expected.size() + 5))));
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    private static <T> @UnknownKeyFor @NonNull @Initialized SplitAtFractionResult assertSplitAtFractionBehaviorImpl(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized List<T> expectedItems, @UnknownKeyFor @NonNull @Initialized int numItemsToReadBeforeSplit, @UnknownKeyFor @NonNull @Initialized double splitFraction, @UnknownKeyFor @NonNull @Initialized ExpectedSplitOutcome expectedOutcome, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try (BoundedSource.BoundedReader<T> reader = source.createReader(options);){
            Source originalSource = reader.getCurrentSource();
            List<T> currentItems = SourceTestUtils.readNItemsFromUnstartedReader(reader, numItemsToReadBeforeSplit);
            BoundedSource<T> residual = reader.splitAtFraction(splitFraction);
            if (residual != null) {
                Assert.assertFalse((String)String.format("Primary source didn't change after a successful split of %s at %f after reading %d items. Was the source object mutated instead of creating a new one? Source objects MUST be immutable.", source, splitFraction, numItemsToReadBeforeSplit), (reader.getCurrentSource() == originalSource ? 1 : 0) != 0);
                Assert.assertFalse((String)String.format("Residual source equal to original source after a successful split of %s at %f after reading %d items. Was the source object mutated instead of creating a new one? Source objects MUST be immutable.", source, splitFraction, numItemsToReadBeforeSplit), (reader.getCurrentSource() == residual ? 1 : 0) != 0);
            }
            switch (expectedOutcome) {
                case MUST_SUCCEED_AND_BE_CONSISTENT: {
                    Assert.assertNotNull((String)("Failed to split reader of source: " + source + " at " + splitFraction + " after reading " + numItemsToReadBeforeSplit + " items"), residual);
                    break;
                }
                case MUST_FAIL: {
                    Assert.assertEquals(null, residual);
                    break;
                }
            }
            currentItems.addAll(SourceTestUtils.readRemainingFromReader(reader, numItemsToReadBeforeSplit > 0));
            Source primary = reader.getCurrentSource();
            SplitAtFractionResult splitAtFractionResult = SourceTestUtils.verifySingleSplitAtFractionResult(source, expectedItems, currentItems, primary, residual, numItemsToReadBeforeSplit, splitFraction, options);
            return splitAtFractionResult;
        }
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized SplitAtFractionResult verifySingleSplitAtFractionResult(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized List<T> expectedItems, @UnknownKeyFor @NonNull @Initialized List<T> currentItems, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> primary, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> residual, @UnknownKeyFor @NonNull @Initialized int numItemsToReadBeforeSplit, @UnknownKeyFor @NonNull @Initialized double splitFraction, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        List<T> primaryItems = SourceTestUtils.readFromSource(primary, options);
        if (residual != null) {
            List<T> residualItems = SourceTestUtils.readFromSource(residual, options);
            ArrayList<T> totalItems = new ArrayList<T>();
            totalItems.addAll(primaryItems);
            totalItems.addAll(residualItems);
            String errorMsgForPrimarySourceComp = String.format("Continued reading after split yielded different items than primary source: split at %s after reading %s items, original source: %s, primary source: %s", splitFraction, numItemsToReadBeforeSplit, source, primary);
            String errorMsgForTotalSourceComp = String.format("Items in primary and residual sources after split do not add up to items in the original source. Split at %s after reading %s items; original source: %s, primary: %s, residual: %s", splitFraction, numItemsToReadBeforeSplit, source, primary, residual);
            Coder coder = primary.getOutputCoder();
            List primaryValues = SourceTestUtils.createStructuralValues(coder, primaryItems);
            List currentValues = SourceTestUtils.createStructuralValues(coder, currentItems);
            List expectedValues = SourceTestUtils.createStructuralValues(coder, expectedItems);
            List totalValues = SourceTestUtils.createStructuralValues(coder, totalItems);
            SourceTestUtils.assertListsEqualInOrder(errorMsgForPrimarySourceComp, "current", currentValues, "primary", primaryValues);
            SourceTestUtils.assertListsEqualInOrder(errorMsgForTotalSourceComp, "total", expectedValues, "primary+residual", totalValues);
            return new SplitAtFractionResult(primaryItems.size(), residualItems.size());
        }
        return new SplitAtFractionResult(primaryItems.size(), -1);
    }

    public static <T> void assertSplitAtFractionSucceedsAndConsistent(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized int numItemsToReadBeforeSplit, @UnknownKeyFor @NonNull @Initialized double splitFraction, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        SourceTestUtils.assertSplitAtFractionBehavior(source, numItemsToReadBeforeSplit, splitFraction, ExpectedSplitOutcome.MUST_SUCCEED_AND_BE_CONSISTENT, options);
    }

    public static <T> void assertSplitAtFractionFails(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized int numItemsToReadBeforeSplit, @UnknownKeyFor @NonNull @Initialized double splitFraction, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        SourceTestUtils.assertSplitAtFractionBehavior(source, numItemsToReadBeforeSplit, splitFraction, ExpectedSplitOutcome.MUST_FAIL, options);
    }

    private static <T> void assertSplitAtFractionBinary(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized List<T> expectedItems, @UnknownKeyFor @NonNull @Initialized int numItemsToBeReadBeforeSplit, @UnknownKeyFor @NonNull @Initialized double leftFraction, @UnknownKeyFor @NonNull @Initialized SplitAtFractionResult leftResult, @UnknownKeyFor @NonNull @Initialized double rightFraction, @UnknownKeyFor @NonNull @Initialized SplitAtFractionResult rightResult, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized SplitFractionStatistics stats) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (rightFraction - leftFraction < 0.001) {
            return;
        }
        double middleFraction = (rightFraction + leftFraction) / 2.0;
        if (leftResult == null) {
            leftResult = SourceTestUtils.assertSplitAtFractionBehaviorImpl(source, expectedItems, numItemsToBeReadBeforeSplit, leftFraction, ExpectedSplitOutcome.MUST_BE_CONSISTENT_IF_SUCCEEDS, options);
        }
        if (rightResult == null) {
            rightResult = SourceTestUtils.assertSplitAtFractionBehaviorImpl(source, expectedItems, numItemsToBeReadBeforeSplit, rightFraction, ExpectedSplitOutcome.MUST_BE_CONSISTENT_IF_SUCCEEDS, options);
        }
        SplitAtFractionResult middleResult = SourceTestUtils.assertSplitAtFractionBehaviorImpl(source, expectedItems, numItemsToBeReadBeforeSplit, middleFraction, ExpectedSplitOutcome.MUST_BE_CONSISTENT_IF_SUCCEEDS, options);
        if (middleResult.numResidualItems != -1) {
            stats.successfulFractions.add(middleFraction);
        }
        if (middleResult.numResidualItems > 0) {
            stats.nonTrivialFractions.add(middleFraction);
        }
        if (leftResult.numPrimaryItems != middleResult.numPrimaryItems) {
            SourceTestUtils.assertSplitAtFractionBinary(source, expectedItems, numItemsToBeReadBeforeSplit, leftFraction, leftResult, middleFraction, middleResult, options, stats);
        }
        if (rightResult.numPrimaryItems != middleResult.numPrimaryItems) {
            SourceTestUtils.assertSplitAtFractionBinary(source, expectedItems, numItemsToBeReadBeforeSplit, middleFraction, middleResult, rightFraction, rightResult, options, stats);
        }
    }

    public static <T> void assertSplitAtFractionExhaustive(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int i;
        List<T> expectedItems = SourceTestUtils.readFromSource(source, options);
        Assert.assertFalse((String)"Empty source", (boolean)expectedItems.isEmpty());
        Assert.assertFalse((String)"Source reads a single item", (expectedItems.size() == 1 ? 1 : 0) != 0);
        ArrayList<List<Double>> allNonTrivialFractions = new ArrayList<List<Double>>();
        boolean anySuccessfulFractions = false;
        boolean anyNonTrivialFractions = false;
        for (i = 0; i < expectedItems.size(); ++i) {
            SplitFractionStatistics stats = new SplitFractionStatistics();
            SourceTestUtils.assertSplitAtFractionBinary(source, expectedItems, i, 0.0, null, 1.0, null, options, stats);
            if (!stats.successfulFractions.isEmpty()) {
                anySuccessfulFractions = true;
            }
            if (!stats.nonTrivialFractions.isEmpty()) {
                anyNonTrivialFractions = true;
            }
            allNonTrivialFractions.add(stats.nonTrivialFractions);
        }
        Assert.assertTrue((String)"splitAtFraction test completed vacuously: no successful split fractions found", (boolean)anySuccessfulFractions);
        Assert.assertTrue((String)"splitAtFraction test completed vacuously: no non-trivial split fractions found", (boolean)anyNonTrivialFractions);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        int numTotalTrials = 0;
        for (i = 0; i < expectedItems.size(); ++i) {
            int numTrials;
            block8: {
                double minNonTrivialFraction = 2.0;
                Iterator iterator = ((List)allNonTrivialFractions.get(i)).iterator();
                while (iterator.hasNext()) {
                    double fraction = (Double)iterator.next();
                    minNonTrivialFraction = Math.min(minNonTrivialFraction, fraction);
                }
                if (minNonTrivialFraction == 2.0) continue;
                numTrials = 0;
                boolean haveSuccess = false;
                boolean haveFailure = false;
                do {
                    if (++numTrials > 100) {
                        LOG.warn("After {} concurrent splitting trials at item #{}, observed only {}, giving up on this item", new Object[]{numTrials, i, haveSuccess ? "success" : "failure"});
                        break block8;
                    }
                    if (SourceTestUtils.assertSplitAtFractionConcurrent(executor, source, expectedItems, i, minNonTrivialFraction, options)) {
                        haveSuccess = true;
                        continue;
                    }
                    haveFailure = true;
                } while (!haveSuccess || !haveFailure);
                LOG.info("{} trials to observe both success and failure of concurrent splitting at item #{}", (Object)numTrials, (Object)i);
            }
            if ((numTotalTrials += numTrials) <= 1000) continue;
            LOG.warn("After {} total concurrent splitting trials, considered only {} items, giving up.", (Object)numTotalTrials, (Object)i);
            break;
        }
        LOG.info("{} total concurrent splitting trials for {} items", (Object)numTotalTrials, (Object)expectedItems.size());
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized boolean assertSplitAtFractionConcurrent(@UnknownKeyFor @NonNull @Initialized ExecutorService executor, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source, @UnknownKeyFor @NonNull @Initialized List<T> expectedItems, @UnknownKeyFor @NonNull @Initialized int numItemsToReadBeforeSplitting, @UnknownKeyFor @NonNull @Initialized double fraction, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BoundedSource.BoundedReader reader = source.createReader(options);
        CountDownLatch unblockSplitter = new CountDownLatch(1);
        Future<List> readerThread = executor.submit(() -> {
            try {
                List items = SourceTestUtils.readNItemsFromUnstartedReader(reader, numItemsToReadBeforeSplitting);
                unblockSplitter.countDown();
                items.addAll(SourceTestUtils.readRemainingFromReader(reader, numItemsToReadBeforeSplitting > 0));
                List list = items;
                return list;
            }
            finally {
                reader.close();
            }
        });
        Future<KV> splitterThread = executor.submit(() -> {
            unblockSplitter.await();
            BoundedSource residual = reader.splitAtFraction(fraction);
            if (residual == null) {
                return null;
            }
            return KV.of(reader.getCurrentSource(), residual);
        });
        List currentItems = readerThread.get();
        KV splitSources = splitterThread.get();
        if (splitSources == null) {
            return false;
        }
        SplitAtFractionResult res = SourceTestUtils.verifySingleSplitAtFractionResult(source, expectedItems, currentItems, (BoundedSource)splitSources.getKey(), (BoundedSource)splitSources.getValue(), numItemsToReadBeforeSplitting, fraction, options);
        return res.numResidualItems > 0;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized BoundedSource<T> toUnsplittableSource(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource) {
        return new UnsplittableSource(boundedSource);
    }

    private static class UnsplittableSource<@UnknownKeyFor T>
    extends BoundedSource<T> {
        private final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource;

        private UnsplittableSource(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource) {
            this.boundedSource = (BoundedSource)Preconditions.checkNotNull(boundedSource, (Object)"boundedSource");
        }

        @Override
        public void populateDisplayData( @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.boundedSource.populateDisplayData(builder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return ImmutableList.of((Object)this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.boundedSource.getEstimatedSizeBytes(options);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new UnsplittableReader(this.boundedSource, this.boundedSource.createReader(options));
        }

        @Override
        public void validate() {
            this.boundedSource.validate();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
            return this.boundedSource.getOutputCoder();
        }

        private static class UnsplittableReader<@UnknownKeyFor T>
        extends BoundedSource.BoundedReader<T> {
            private final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource;
            private final @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> boundedReader;

            private UnsplittableReader(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource, @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> boundedReader) {
                this.boundedSource = (BoundedSource)Preconditions.checkNotNull(boundedSource, (Object)"boundedSource");
                this.boundedReader = (BoundedSource.BoundedReader)Preconditions.checkNotNull(boundedReader, (Object)"boundedReader");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized BoundedSource<T> getCurrentSource() {
                return this.boundedSource;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.boundedReader.start();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
                return this.boundedReader.advance();
            }

            @Override
            public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                return this.boundedReader.getCurrent();
            }

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.boundedReader.close();
            }

            @Override
            public @Nullable @UnknownKeyFor @Initialized BoundedSource<T> splitAtFraction(@UnknownKeyFor @NonNull @Initialized double fraction) {
                return null;
            }

            @Override
            public @Nullable @UnknownKeyFor @Initialized Double getFractionConsumed() {
                return this.boundedReader.getFractionConsumed();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized long getSplitPointsConsumed() {
                return this.boundedReader.getSplitPointsConsumed();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized long getSplitPointsRemaining() {
                return this.boundedReader.getSplitPointsRemaining();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                return this.boundedReader.getCurrentTimestamp();
            }
        }
    }

    private static class SplitFractionStatistics {
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Double> successfulFractions = new ArrayList<Double>();
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Double> nonTrivialFractions = new ArrayList<Double>();

        private SplitFractionStatistics() {
        }
    }

    private static class SplitAtFractionResult {
        public @UnknownKeyFor @NonNull @Initialized int numPrimaryItems;
        public @UnknownKeyFor @NonNull @Initialized int numResidualItems;

        public SplitAtFractionResult(@UnknownKeyFor @NonNull @Initialized int numPrimaryItems, @UnknownKeyFor @NonNull @Initialized int numResidualItems) {
            this.numPrimaryItems = numPrimaryItems;
            this.numResidualItems = numResidualItems;
        }
    }

    public static enum ExpectedSplitOutcome {
        MUST_SUCCEED_AND_BE_CONSISTENT,
        MUST_FAIL,
        MUST_BE_CONSISTENT_IF_SUCCEEDS;

    }

    private static class ReadableStructuralValue<@UnknownKeyFor T> {
        private T originalValue;
        private @UnknownKeyFor @NonNull @Initialized Object structuralValue;

        public ReadableStructuralValue(T originalValue, @UnknownKeyFor @NonNull @Initialized Object structuralValue) {
            this.originalValue = originalValue;
            this.structuralValue = structuralValue;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode(this.structuralValue);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == null || !(obj instanceof ReadableStructuralValue)) {
                return false;
            }
            return Objects.equals(this.structuralValue, ((ReadableStructuralValue)obj).structuralValue);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return String.format("[%s (structural %s)]", this.originalValue, this.structuralValue);
        }
    }
}

