/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.spi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.spi.InetAddressResolver;
import java.net.spi.InetAddressResolverProvider;
import java.util.ArrayList;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

class DnsjavaInetAddressResolver
implements InetAddressResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DnsjavaInetAddressResolver.class);
    private static final String PREFER_V6_PROPERTY = "java.net.preferIPv6Addresses";
    private final boolean preferV6;
    private final InetAddressResolverProvider.Configuration configuration;

    DnsjavaInetAddressResolver(InetAddressResolverProvider.Configuration configuration) {
        log.info("Enabling dnsjava SPI");
        this.configuration = configuration;
        this.preferV6 = Boolean.getBoolean(PREFER_V6_PROPERTY);
    }

    @Override
    public Stream<InetAddress> lookupByName(String host, InetAddressResolver.LookupPolicy lookupPolicy) throws UnknownHostException {
        Record[] records;
        Name name;
        if (host.equalsIgnoreCase(this.configuration.lookupLocalHostName()) || "localhost".equalsIgnoreCase(host)) {
            return this.configuration.builtinResolver().lookupByName(host, lookupPolicy);
        }
        try {
            name = new Name(host);
        }
        catch (TextParseException e) {
            throw new UnknownHostException(host);
        }
        ArrayList<InetAddress> results = new ArrayList<InetAddress>(8);
        boolean ranIpV4 = false;
        boolean ranIpV6 = false;
        int characteristics = lookupPolicy.characteristics();
        if ((characteristics & 0xC) == 0) {
            characteristics = this.preferV6 ? (characteristics |= 8) : (characteristics |= 4);
        }
        if ((characteristics & 2) == 2 && (characteristics & 8) == 8) {
            records = new Lookup(name, 28).run();
            if (records != null) {
                for (Record r : records) {
                    results.add(((AAAARecord)r).getAddress());
                }
            }
            ranIpV6 = true;
        }
        if ((characteristics & 1) == 1 && (characteristics & 4) == 4) {
            records = new Lookup(name, 1).run();
            if (records != null) {
                for (Record r : records) {
                    results.add(((ARecord)r).getAddress());
                }
            }
            ranIpV4 = true;
        }
        if ((characteristics & 1) == 1 && !ranIpV4 && (records = new Lookup(name, 1).run()) != null) {
            for (Record r : records) {
                results.add(((ARecord)r).getAddress());
            }
        }
        if ((characteristics & 2) == 2 && !ranIpV6 && (records = new Lookup(name, 28).run()) != null) {
            for (Record r : records) {
                results.add(((AAAARecord)r).getAddress());
            }
        }
        if (results.isEmpty()) {
            throw new UnknownHostException(host);
        }
        return results.stream();
    }

    @Override
    public String lookupByAddress(byte[] addr) throws UnknownHostException {
        Name name = ReverseMap.fromAddress(InetAddress.getByAddress(addr));
        Record[] records = new Lookup(name, 12).run();
        if (records == null) {
            throw new UnknownHostException("Unknown address: " + String.valueOf(name));
        }
        return ((PTRRecord)records[0]).getTarget().toString();
    }
}

