/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Iterator;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;

public class ResultSubpartitionIndexSet
extends IndexRange {
    public ResultSubpartitionIndexSet(int index) {
        this(index, index);
    }

    public ResultSubpartitionIndexSet(IndexRange indexRange) {
        this(indexRange.getStartIndex(), indexRange.getEndIndex());
    }

    public ResultSubpartitionIndexSet(int startIndex, int endIndex) {
        super(startIndex, endIndex);
    }

    public boolean contains(int index) {
        return index >= this.startIndex && index <= this.endIndex;
    }

    public Iterable<Integer> values() {
        return () -> new Iterator<Integer>(){
            private int index;
            {
                this.index = ResultSubpartitionIndexSet.this.startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index <= ResultSubpartitionIndexSet.this.endIndex;
            }

            @Override
            public Integer next() {
                return this.index++;
            }
        };
    }

    public void writeTo(ByteBuf target) {
        target.writeInt(this.startIndex);
        target.writeInt(this.endIndex);
    }

    public static int getByteBufLength(ResultSubpartitionIndexSet indexSet) {
        return 8;
    }

    public static ResultSubpartitionIndexSet fromByteBuf(ByteBuf source) {
        int startIndex = source.readInt();
        int endIndex = source.readInt();
        return new ResultSubpartitionIndexSet(startIndex, endIndex);
    }
}

