/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.options;

import com.google.api.client.googleapis.services.AbstractGoogleClient;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface GoogleApiDebugOptions
extends PipelineOptions {
    @Description(value="This option enables tracing of API calls to Google services used within the Apache Beam SDK. Values are expected in JSON format {\"ApiName\":\"TraceDestination\",...} where the ApiName represents the request classes canonical name. The TraceDestination is a logical trace consumer to whom the trace will be reported. Typically, \"producer\" is the right destination to use: this makes API traces available to the team offering the API. Note that by enabling this option, the contents of the requests to and from Google Cloud services will be made available to Google. For example, by specifying {\"Dataflow\":\"producer\"}, all calls to the Dataflow service will be made available to Google, specifically to the Google Cloud Dataflow team.")
    public @UnknownKeyFor @NonNull @Initialized GoogleApiTracer getGoogleApiTrace();

    public void setGoogleApiTrace(@UnknownKeyFor @NonNull @Initialized GoogleApiTracer var1);

    public static class GoogleApiTracer
    extends HashMap<String, String>
    implements GoogleClientRequestInitializer {
        public @UnknownKeyFor @NonNull @Initialized GoogleApiTracer addTraceFor(@UnknownKeyFor @NonNull @Initialized AbstractGoogleClient client, @UnknownKeyFor @NonNull @Initialized String traceDestination) {
            this.put(client.getClass().getCanonicalName(), traceDestination);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized GoogleApiTracer addTraceFor(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AbstractGoogleClientRequest<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> request, @UnknownKeyFor @NonNull @Initialized String traceDestination) {
            this.put(request.getClass().getCanonicalName(), traceDestination);
            return this;
        }

        public void initialize(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AbstractGoogleClientRequest<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> request) throws @UnknownKeyFor @NonNull @Initialized IOException {
            for (Map.Entry entry : this.entrySet()) {
                if (!request.getClass().getCanonicalName().contains((CharSequence)entry.getKey())) continue;
                request.set("$trace", entry.getValue());
            }
        }
    }
}

