/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.RowFilter;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableReadOptions;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_BigtableReadOptions
extends BigtableReadOptions {
    private final ValueProvider<String> tableId;
    private final @Nullable ValueProvider<RowFilter> rowFilter;
    private final @Nullable ValueProvider<List<ByteKeyRange>> keyRanges;
    private final @Nullable Integer maxBufferElementCount;
    private final @Nullable Duration attemptTimeout;
    private final @Nullable Duration operationTimeout;
    private final @Nullable Duration waitTimeout;

    private AutoValue_BigtableReadOptions(ValueProvider<String> tableId, @Nullable ValueProvider<RowFilter> rowFilter, @Nullable ValueProvider<List<ByteKeyRange>> keyRanges, @Nullable Integer maxBufferElementCount, @Nullable Duration attemptTimeout, @Nullable Duration operationTimeout, @Nullable Duration waitTimeout) {
        this.tableId = tableId;
        this.rowFilter = rowFilter;
        this.keyRanges = keyRanges;
        this.maxBufferElementCount = maxBufferElementCount;
        this.attemptTimeout = attemptTimeout;
        this.operationTimeout = operationTimeout;
        this.waitTimeout = waitTimeout;
    }

    @Override
    ValueProvider<String> getTableId() {
        return this.tableId;
    }

    @Override
    @Nullable ValueProvider<RowFilter> getRowFilter() {
        return this.rowFilter;
    }

    @Override
    @Nullable ValueProvider<List<ByteKeyRange>> getKeyRanges() {
        return this.keyRanges;
    }

    @Override
    @Nullable Integer getMaxBufferElementCount() {
        return this.maxBufferElementCount;
    }

    @Override
    @Nullable Duration getAttemptTimeout() {
        return this.attemptTimeout;
    }

    @Override
    @Nullable Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    @Nullable Duration getWaitTimeout() {
        return this.waitTimeout;
    }

    public String toString() {
        return "BigtableReadOptions{tableId=" + this.tableId + ", rowFilter=" + this.rowFilter + ", keyRanges=" + this.keyRanges + ", maxBufferElementCount=" + this.maxBufferElementCount + ", attemptTimeout=" + this.attemptTimeout + ", operationTimeout=" + this.operationTimeout + ", waitTimeout=" + this.waitTimeout + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigtableReadOptions) {
            BigtableReadOptions that = (BigtableReadOptions)o;
            return this.tableId.equals(that.getTableId()) && (this.rowFilter == null ? that.getRowFilter() == null : this.rowFilter.equals(that.getRowFilter())) && (this.keyRanges == null ? that.getKeyRanges() == null : this.keyRanges.equals(that.getKeyRanges())) && (this.maxBufferElementCount == null ? that.getMaxBufferElementCount() == null : this.maxBufferElementCount.equals(that.getMaxBufferElementCount())) && (this.attemptTimeout == null ? that.getAttemptTimeout() == null : this.attemptTimeout.equals((Object)that.getAttemptTimeout())) && (this.operationTimeout == null ? that.getOperationTimeout() == null : this.operationTimeout.equals((Object)that.getOperationTimeout())) && (this.waitTimeout == null ? that.getWaitTimeout() == null : this.waitTimeout.equals((Object)that.getWaitTimeout()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.tableId.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowFilter == null ? 0 : this.rowFilter.hashCode();
        h$ *= 1000003;
        h$ ^= this.keyRanges == null ? 0 : this.keyRanges.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxBufferElementCount == null ? 0 : this.maxBufferElementCount.hashCode();
        h$ *= 1000003;
        h$ ^= this.attemptTimeout == null ? 0 : this.attemptTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.operationTimeout == null ? 0 : this.operationTimeout.hashCode();
        h$ *= 1000003;
        return h$ ^= this.waitTimeout == null ? 0 : this.waitTimeout.hashCode();
    }

    @Override
    BigtableReadOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends BigtableReadOptions.Builder {
        private ValueProvider<String> tableId;
        private @Nullable ValueProvider<RowFilter> rowFilter;
        private @Nullable ValueProvider<List<ByteKeyRange>> keyRanges;
        private @Nullable Integer maxBufferElementCount;
        private @Nullable Duration attemptTimeout;
        private @Nullable Duration operationTimeout;
        private @Nullable Duration waitTimeout;

        Builder() {
        }

        private Builder(BigtableReadOptions source) {
            this.tableId = source.getTableId();
            this.rowFilter = source.getRowFilter();
            this.keyRanges = source.getKeyRanges();
            this.maxBufferElementCount = source.getMaxBufferElementCount();
            this.attemptTimeout = source.getAttemptTimeout();
            this.operationTimeout = source.getOperationTimeout();
            this.waitTimeout = source.getWaitTimeout();
        }

        @Override
        BigtableReadOptions.Builder setTableId(ValueProvider<String> tableId) {
            if (tableId == null) {
                throw new NullPointerException("Null tableId");
            }
            this.tableId = tableId;
            return this;
        }

        @Override
        BigtableReadOptions.Builder setRowFilter(ValueProvider<RowFilter> rowFilter) {
            this.rowFilter = rowFilter;
            return this;
        }

        @Override
        BigtableReadOptions.Builder setKeyRanges(ValueProvider<List<ByteKeyRange>> keyRanges) {
            this.keyRanges = keyRanges;
            return this;
        }

        @Override
        BigtableReadOptions.Builder setMaxBufferElementCount(@Nullable Integer maxBufferElementCount) {
            this.maxBufferElementCount = maxBufferElementCount;
            return this;
        }

        @Override
        BigtableReadOptions.Builder setAttemptTimeout(Duration attemptTimeout) {
            this.attemptTimeout = attemptTimeout;
            return this;
        }

        @Override
        BigtableReadOptions.Builder setOperationTimeout(Duration operationTimeout) {
            this.operationTimeout = operationTimeout;
            return this;
        }

        @Override
        BigtableReadOptions.Builder setWaitTimeout(Duration waitTimeout) {
            this.waitTimeout = waitTimeout;
            return this;
        }

        @Override
        BigtableReadOptions build() {
            if (this.tableId == null) {
                String missing = " tableId";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigtableReadOptions(this.tableId, this.rowFilter, this.keyRanges, this.maxBufferElementCount, this.attemptTimeout, this.operationTimeout, this.waitTimeout);
        }
    }
}

