/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PartitionMetadataTableNames
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 8848098877671834584L;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized int MAX_NAME_LENGTH = 63;
    private static final @UnknownKeyFor @NonNull @Initialized String PARTITION_METADATA_TABLE_NAME_FORMAT = "Metadata_%s_%s";
    private static final @UnknownKeyFor @NonNull @Initialized String WATERMARK_INDEX_NAME_FORMAT = "WatermarkIdx_%s_%s";
    private static final @UnknownKeyFor @NonNull @Initialized String CREATED_AT_START_TIMESTAMP_INDEX_NAME_FORMAT = "CreatedAtIdx_%s_%s";
    private final @UnknownKeyFor @NonNull @Initialized String tableName;
    private final @UnknownKeyFor @NonNull @Initialized String watermarkIndexName;
    private final @UnknownKeyFor @NonNull @Initialized String createdAtIndexName;

    public static @UnknownKeyFor @NonNull @Initialized PartitionMetadataTableNames generateRandom(@UnknownKeyFor @NonNull @Initialized String databaseId) {
        UUID uuid = UUID.randomUUID();
        String table = PartitionMetadataTableNames.generateName(PARTITION_METADATA_TABLE_NAME_FORMAT, databaseId, uuid);
        String watermarkIndex = PartitionMetadataTableNames.generateName(WATERMARK_INDEX_NAME_FORMAT, databaseId, uuid);
        String createdAtIndex = PartitionMetadataTableNames.generateName(CREATED_AT_START_TIMESTAMP_INDEX_NAME_FORMAT, databaseId, uuid);
        return new PartitionMetadataTableNames(table, watermarkIndex, createdAtIndex);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionMetadataTableNames fromExistingTable(@UnknownKeyFor @NonNull @Initialized String databaseId, @UnknownKeyFor @NonNull @Initialized String table) {
        UUID uuid = UUID.randomUUID();
        String watermarkIndex = PartitionMetadataTableNames.generateName(WATERMARK_INDEX_NAME_FORMAT, databaseId, uuid);
        String createdAtIndex = PartitionMetadataTableNames.generateName(CREATED_AT_START_TIMESTAMP_INDEX_NAME_FORMAT, databaseId, uuid);
        return new PartitionMetadataTableNames(table, watermarkIndex, createdAtIndex);
    }

    private static @UnknownKeyFor @NonNull @Initialized String generateName(@UnknownKeyFor @NonNull @Initialized String template, @UnknownKeyFor @NonNull @Initialized String databaseId, @UnknownKeyFor @NonNull @Initialized UUID uuid) {
        String name = String.format(template, databaseId, uuid).replaceAll("-", "_");
        if (name.length() > 63) {
            return name.substring(0, 63);
        }
        return name;
    }

    public PartitionMetadataTableNames(@UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized String watermarkIndexName, @UnknownKeyFor @NonNull @Initialized String createdAtIndexName) {
        this.tableName = tableName;
        this.watermarkIndexName = watermarkIndexName;
        this.createdAtIndexName = createdAtIndexName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getTableName() {
        return this.tableName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getWatermarkIndexName() {
        return this.watermarkIndexName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getCreatedAtIndexName() {
        return this.createdAtIndexName;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionMetadataTableNames)) {
            return false;
        }
        PartitionMetadataTableNames that = (PartitionMetadataTableNames)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.watermarkIndexName, that.watermarkIndexName) && Objects.equals(this.createdAtIndexName, that.createdAtIndexName);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.tableName, this.watermarkIndexName, this.createdAtIndexName);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "PartitionMetadataTableNames{tableName='" + this.tableName + '\'' + ", watermarkIndexName='" + this.watermarkIndexName + '\'' + ", createdAtIndexName='" + this.createdAtIndexName + '\'' + '}';
    }
}

