/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.apache.hop.core.util.Utils;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;

public class HopMetadataBase
implements IHopMetadata {
    @HopMetadataProperty
    protected String name;
    @HopMetadataProperty
    protected String virtualPath;
    @JsonIgnore
    protected volatile String metadataProviderName;

    public HopMetadataBase() {
    }

    public HopMetadataBase(String name) {
        this();
        this.name = name;
        this.virtualPath = "";
    }

    public HopMetadataBase(String name, String virtualPath) {
        this();
        this.name = name;
        this.virtualPath = virtualPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.name == null || this.getClass() != o.getClass()) {
            return false;
        }
        HopMetadataBase that = (HopMetadataBase)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getMetadataProviderName() {
        return this.metadataProviderName;
    }

    @Override
    public void setMetadataProviderName(String metadataProviderName) {
        this.metadataProviderName = metadataProviderName;
    }

    @Override
    public String getVirtualPath() {
        return this.virtualPath;
    }

    @Override
    public void setVirtualPath(String virtualPath) {
        this.virtualPath = virtualPath;
    }

    @Override
    public String getFullName() {
        if (Utils.isEmpty(this.virtualPath)) {
            return this.name;
        }
        if (this.virtualPath.endsWith("/")) {
            return this.virtualPath + this.name;
        }
        return this.virtualPath + "/" + this.name;
    }
}

